/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.kvdt.common.Shdrg1Handler;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class F5028Handler
extends Shdrg1Handler {
    public F5028Handler(String sXPath) throws XPMException {
        super(sXPath);
    }

    @Override
    public void elementStart() throws XPMException {
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            sValue_ = this.m_Element.getValue();
            if (sValue_.length() > 0) {
                this.pruefeRegel365(sValue_);
                this.pruefeRegel390(sValue_);
            }
            m_s5028 = sValue_;
        }
        catch (Exception ex) {
            this.catchException(ex, "F5028Handler", "Pr\u00fcfung");
        }
    }

    public final void pruefeRegel365(String beginnDerLeistungDatum) throws Exception {
        try {
            if (value4125 != null && value4125.length() > 15) {
                Date dateBeginnLeistung = this.getDate(beginnDerLeistungDatum);
                Date dateVon = new Date();
                Date dateBis = new Date();
                if (!this.setDates(value4125, dateVon, dateBis)) {
                    m_MeldungPool.addMeldung("KVDT-FDATE", value4125, "G\u00fcltigkeitszeitraum von ... bis ... (Feld 4125)");
                    value4125 = "";
                } else if (dateBeginnLeistung.compareTo(dateVon) < 0 || dateBeginnLeistung.compareTo(dateBis) > 0) {
                    m_MeldungPool.addMeldung("KVDT-R365");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "F5028Handler", "Pr\u00fcfung (pruefeRegel365)");
        }
    }

    public final void pruefeRegel390(String beginnDerLeistungDatum) throws Exception {
        try {
            if (m_dateGeburt != null && !m_sGeburt.equals("0000.00.00") && beginnDerLeistungDatum.length() > 7 && this.dateIsValid(beginnDerLeistungDatum, DateTimeFormatter.BASIC_ISO_DATE)) {
                LocalDate dateGeburtPlus1Jahr;
                LocalDate dateBeginnLeistung = LocalDate.parse(beginnDerLeistungDatum, DateTimeFormatter.BASIC_ISO_DATE);
                String geburtsDatumIso = m_sGeburt.replace(".", "");
                if (this.dateIsValid(geburtsDatumIso, DateTimeFormatter.BASIC_ISO_DATE) && dateBeginnLeistung.compareTo(dateGeburtPlus1Jahr = LocalDate.parse(geburtsDatumIso, DateTimeFormatter.BASIC_ISO_DATE).plusYears(1L)) < 1 && m_s3111 == null) {
                    m_MeldungPool.addMeldung("KVDT-R390");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "F5028Handler", "Pr\u00fcfung (pruefeRegel390)");
        }
    }

    public boolean dateIsValid(String dateStr, DateTimeFormatter formatter) {
        try {
            LocalDate.parse(dateStr, formatter);
        }
        catch (DateTimeParseException e) {
            return false;
        }
        return true;
    }

    @Override
    public void init() throws XPMException {
    }
}

