/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.stamm.KTS.SatzKTS;
import de.kbv.xpm.modul.kvdt.common.AbstractScon0Handler;
import de.kbv.xpm.modul.kvdt.common.GNRInfo;
import de.kbv.xpm.modul.kvdt.common.SAFallInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Ssad0Handler
extends AbstractScon0Handler {
    protected static final TreeMap<String, SAFallInfo> m_mapFallStatistik = new TreeMap();
    protected static final SimpleDateFormat m_DateFormat6 = new SimpleDateFormat("yyMMdd", Locale.GERMAN);
    protected static final SimpleDateFormat m_DateFormat6_ddMMyy = new SimpleDateFormat("ddMMyy", Locale.GERMAN);
    protected static final Pattern m_FormatR048 = Pattern.compile("(0|1)\\d{2}(0|1)[0-9]\\d{2}\\d{13}[a-zA-Z0-9_-]{1,7}");
    protected static String m_s3005 = null;
    protected static boolean bSadxSatz_ = false;

    public Ssad0Handler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public final void addFallStatistik(boolean bAmbulant) throws Exception {
        try {
            SAFallInfo fall = m_mapFallStatistik.get(m_sVKNR);
            if (fall == null) {
                fall = new SAFallInfo();
                fall.m_sVKNR = m_sVKNR;
                m_mapFallStatistik.put(m_sVKNR, fall);
            }
            if (bAmbulant) {
                ++fall.m_nAmbulant;
            } else {
                ++fall.m_nStationaer;
            }
            if (m_bVorQuartal) {
                ++fall.m_nVorQuartal;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (addFallStatistik)");
        }
    }

    @Override
    public final void clearListen() throws Exception {
        try {
            super.clearListen();
            m_mapFallStatistik.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (clearListen)");
        }
    }

    @Override
    public final void initSatz() throws Exception {
        try {
            super.initSatz();
            m_s3005 = "";
            if (m_s0105.length() > 0) {
                m_sGruppe = FehlerListe.newGroup("SADT-Datenpaket, Pr\u00fcfnummer: ");
                m_sGruppe.append(m_s0105).append('|');
            } else {
                m_sGruppe = FehlerListe.newGroup("SADT-Datenpaket|");
            }
            if (!bSadxSatz_) {
                bSadxSatz_ = true;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (initSatz)");
        }
    }

    public final void pruefeRegel048() throws Exception {
        try {
            if (m_s3005.length() > 0) {
                if (!m_FormatR048.matcher(m_s3005).matches()) {
                    m_MeldungPool.addMeldung("KVDT-R048", m_s3005);
                }
                if (m_s3005.length() > 7) {
                    try {
                        m_DateFormat6_ddMMyy.parse(m_s3005.substring(1, 7));
                    }
                    catch (ParseException ignore2) {
                        m_MeldungPool.addMeldung("KVDT-R048a", m_s3005);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (pruefeRegel048)");
        }
    }

    public final void pruefeRegel324() throws Exception {
        try {
            if (m_sQuartal != null && !this.imQuartal(m_sQuartal, sValue_)) {
                m_MeldungPool.addMeldung("KVDT-R324");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (pruefeRegel324)");
        }
    }

    public final void pruefeRegel709() throws Exception {
        try {
            if (m_s3005.startsWith("0")) {
                m_MeldungPool.addMeldung("KVDT-R709");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (pruefeRegel709)");
        }
    }

    public final void pruefeRegel732() throws Exception {
        try {
            if (!m_setBSNr.contains(sValue_) && !m_bVorQuartal) {
                m_MeldungPool.addMeldung("KVDT-R732", sValue_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (pruefeRegel732)");
        }
    }

    public final void pruefeRegel733() throws Exception {
        try {
            if (!(m_setLANr.contains(m_s5099) || m_bVorQuartal || m_s5099.equals("999999900"))) {
                m_MeldungPool.addMeldung("KVDT-R733", m_s5099);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (pruefeRegel733)");
        }
    }

    public final void setFehlerGruppe() throws Exception {
        try {
            m_sGruppe.append(m_s3005).append(", VKNR/KTAB: ").append(m_sVKNR).append("/00").append(", ").append(m_ScheinQuartal.toString()).append(", ").append(this.getSatzBezeichnung(m_nSatzart, m_nSU));
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (setFehlerGruppe)");
        }
    }

    @Override
    public final void setValues() throws Exception {
        try {
            super.setValues();
            m_s3005 = this.m_Element.getChildValue("f3005");
            this.setFehlerGruppe();
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (setValues)");
        }
    }

    public final void writeFallStatistik() throws Exception {
        try {
            if (m_mapFallStatistik.isEmpty()) {
                return;
            }
            this.setReportParameter(SADT_FallListe, "KBV-Pr\u00fcfmodul Fallstatistik (KVDT/SADT, " + cVERSION + "-Version)");
            for (SAFallInfo fall : m_mapFallStatistik.values()) {
                String sName;
                SatzKTS kt = KTStamm.getKTSSatz(fall.m_sVKNR);
                if (kt == null || (sName = kt.getKTABNameNachFusion("00")) == null) {
                    sName = "Fehlerhafter Kostentr\u00e4ger";
                }
                SADT_FallListe.addData(fall.m_sVKNR, sName, new Integer(fall.m_nAmbulant), new Integer(fall.m_nStationaer), new Integer(fall.m_nAmbulant + fall.m_nStationaer), new Integer(fall.m_nVorQuartal));
            }
            SADT_FallListe.write();
            m_mapFallAmbulant.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (writeFallStatistik)");
        }
    }

    public final void writeGNRStatistik() throws Exception {
        try {
            if (m_mapLANR.isEmpty() || !SADT_GNRListe.getValid()) {
                return;
            }
            progress_.setText("Generiere GNR-Statistikliste...");
            this.setReportParameter(SADT_GNRListe, "KBV-Pr\u00fcfmodul GNR-Statistik (KVDT/SADT, " + cVERSION + "-Version)");
            for (TreeMap map : m_mapLANR.values()) {
                for (GNRInfo m_gnrInfo : map.values()) {
                    int nSumme = Ssad0Handler.m_gnrInfo.m_nSatz0101 + Ssad0Handler.m_gnrInfo.m_nSatz0102 + Ssad0Handler.m_gnrInfo.m_nSatz0103 + Ssad0Handler.m_gnrInfo.m_nSatz0104;
                    SADT_GNRListe.addData(Ssad0Handler.m_gnrInfo.m_sLANR, Ssad0Handler.m_gnrInfo.m_sGNR, new Integer(nSumme), new Integer(nSumme - Ssad0Handler.m_gnrInfo.m_nVorQuartal), new Integer(Ssad0Handler.m_gnrInfo.m_nVorQuartal), new Integer(Ssad0Handler.m_gnrInfo.m_nSatz0101), new Integer(Ssad0Handler.m_gnrInfo.m_nSatz0102), new Integer(Ssad0Handler.m_gnrInfo.m_nSatz0103), null);
                }
            }
            SADT_GNRListe.write();
            m_mapLANR.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung (writeGNRStatistik)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        try {
            this.setDatenpaket(6);
            m_DateFormat6.setLenient(false);
            this.clearListen();
            m_nScheine = 0;
            m_nFaelle = 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Initialisierung");
        }
    }

    public void elementEnde() throws XPMException {
        try {
            progress_.setText("Generiere SADT Listen...");
            this.writeGNRStatistik();
            this.writeFallStatistik();
            if (!bSadxSatz_) {
                m_MeldungPool.addMeldung("KVDT-FSATZ", "SADT", "SADT-ambulante Behandlung (Satzart sad1), SADT-\u00dcberweisung (Satzart sad2) oder SADT-beleg\u00e4rztliche Behandlung (Satzart sad3)");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Ssad0Handler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        m_s3005 = null;
        bSadxSatz_ = false;
    }
}

