/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.format.Profile;
import de.kbv.xpm.core.meldung.Meldung;
import de.kbv.xpm.core.meldung.MeldungContainer;
import de.kbv.xpm.core.pruefung.PruefEventHandler;
import de.kbv.xpm.core.stamm.EhdHeader;
import de.kbv.xpm.core.stamm.KV.StammDaten;
import de.kbv.xpm.core.util.XPMStringBuffer;
import de.kbv.xpm.modul.kvdt.common.AbstractXPMFehlerListe;
import de.kbv.xpm.modul.kvdt.common.AbstractXPMKDT_SortierListe;
import de.kbv.xpm.modul.kvdt.common.XPMDokuAbgabeListe;
import de.kbv.xpm.modul.kvdt.common.XPMFallListe;
import de.kbv.xpm.modul.kvdt.common.XPMGNRListe;
import de.kbv.xpm.modul.kvdt.common.XPMKDT_FallListe;
import de.kbv.xpm.modul.kvdt.common.XPMKDT_GNRListe;
import de.kbv.xpm.modul.kvdt.common.XPMKlammerListe;
import de.kbv.xpm.modul.kvdt.common.XPMKommunikationsSatz;
import de.kbv.xpm.modul.kvdt.common.XPMPDTListe;
import de.kbv.xpm.modul.kvdt.common.XPMSADT_FallListe;
import de.kbv.xpm.modul.kvdt.common.XPMSADT_GNRListe;
import de.kbv.xpm.modul.kvdt.common.XPMSADT_SortierListe;
import de.kbv.xpm.modul.kvdt.common.XPMScheinAbgabeListe;
import de.kbv.xpm.modul.kvdt.common.XPMSortierListe;
import de.kbv.xpm.modul.kvdt.common.XPMStatistikListe;
import de.kbv.xpm.modul.kvdt.common.XPMUeScheinAbgabeListe;
import de.kbv.xpm.modul.kvdt.common.XPMUeScheinPlusAbgabeListe;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMAnbieterStamm;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMGOStamm;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMHDRGStamm;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMHGNCStamm;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMICDStamm2025;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMICDStamm2026;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKRWStamm;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKTStamm;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm01;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm02;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm03;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm17;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm20;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm38;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm46;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm51;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm52;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm71;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm72;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm73;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm78;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm83;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm88;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm93;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm98;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMKVStamm99;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMOPSStamm;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMPLZStamm;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMRVZTabelle;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMWBOTabelle;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;

public abstract class AbstractXPMEventHandler
extends PruefEventHandler {
    protected static Boolean writeKomuSatz = true;
    protected static XPMKTStamm KTStamm;
    protected static XPMPLZStamm PLZStamm;
    protected static XPMICDStamm2026 ICDStamm2026;
    protected static XPMICDStamm2025 ICDStamm2025;
    protected static XPMAnbieterStamm AnbieterStamm;
    protected static XPMKVStamm01 KVStamm01;
    protected static XPMKVStamm02 KVStamm02;
    protected static XPMKVStamm03 KVStamm03;
    protected static XPMKVStamm17 KVStamm17;
    protected static XPMKVStamm20 KVStamm20;
    protected static XPMKVStamm38 KVStamm38;
    protected static XPMKVStamm46 KVStamm46;
    protected static XPMKVStamm51 KVStamm51;
    protected static XPMKVStamm52 KVStamm52;
    protected static XPMKVStamm71 KVStamm71;
    protected static XPMKVStamm72 KVStamm72;
    protected static XPMKVStamm73 KVStamm73;
    protected static XPMKVStamm78 KVStamm78;
    protected static XPMKVStamm83 KVStamm83;
    protected static XPMKVStamm88 KVStamm88;
    protected static XPMKVStamm93 KVStamm93;
    protected static XPMKVStamm98 KVStamm98;
    protected static XPMKVStamm99 KVStamm99;
    protected static XPMHDRGStamm HDRGStamm;
    protected static XPMHGNCStamm HGNCStamm;
    protected static XPMGOStamm GOStamm;
    protected static XPMOPSStamm OPSStamm;
    protected static XPMKRWStamm KRWStamm;
    protected static XPMWBOTabelle WBOTabelle;
    protected static XPMRVZTabelle RVZTabelle;
    protected static String dateiName;
    protected static XPMPDTListe PDTListe;
    protected static XPMKommunikationsSatz KommunikationsSatz;
    protected static AbstractXPMFehlerListe FehlerListe;
    protected static XPMStatistikListe StatistikListe;
    protected static XPMScheinAbgabeListe ScheinAbgabeListe;
    protected static XPMUeScheinAbgabeListe UeScheinAbgabeListe;
    protected static XPMUeScheinPlusAbgabeListe UeScheinPlusAbgabeListe;
    protected static XPMDokuAbgabeListe DokuAbgabeListe;
    protected static XPMSortierListe SortierListe;
    protected static AbstractXPMKDT_SortierListe KDT_SortierListe;
    protected static XPMSADT_SortierListe SADT_SortierListe;
    protected static XPMFallListe FallListe;
    protected static XPMKDT_FallListe KDT_FallListe;
    protected static XPMSADT_FallListe SADT_FallListe;
    protected static XPMGNRListe GNRListe;
    protected static XPMKDT_GNRListe KDT_GNRListe;
    protected static XPMSADT_GNRListe SADT_GNRListe;
    protected static XPMKlammerListe KlammerListe;
    protected static final int cPAKET_CON = 0;
    protected static final int cPAKET_ADT = 1;
    protected static final int cPAKET_AODT = 2;
    protected static final int cPAKET_KDT = 3;
    protected static final int cPAKET_AOHDT = 4;
    protected static final int cPAKET_STDT = 5;
    protected static final int cPAKET_SADT = 6;
    protected static final int cPAKET_CON9 = 7;
    protected static final int cPAKET_HDRG = 8;
    protected static final int cSATZ_CON = 0;
    protected static final int cSATZ_0101 = 1;
    protected static final int cSATZ_0102 = 2;
    protected static final int cSATZ_0103 = 3;
    protected static final int cSATZ_0104 = 4;
    protected static final int cSATZ_KDT = 6;
    protected static final int cSATZ_STDT = 7;
    protected static final int cSATZ_ADT = 8;
    protected static final int cSATZ_0109 = 9;
    protected static final int cSATZ_BESA = 10;
    protected static final int cSATZ_SADT1 = 11;
    protected static final int cSATZ_SADT2 = 12;
    protected static final int cSATZ_SADT3 = 13;
    protected static final int cSATZ_CON9 = 14;
    protected static final int cSATZ_HDRG0 = 15;
    protected static final int cSATZ_HDRG1 = 16;
    protected static final int cSATZ_HDRG9 = 17;
    protected static final int DatenpaketFehlt = -1;
    protected static final int DatenpaketNichtErlaubt = -2;
    protected static int[] m_Datenpakete;
    protected static final String[] m_Paketparameter;
    protected static final String cFEHLER_KT = "Fehlerhafter Kostentr\u00e4ger";
    protected static final String cDAUER_DIAGNOSE = "Dauerdiagnose (ICD-Code, Feld 3673)";
    protected static final String cMAENNLICH = "m\u00e4nnliche";
    protected static final String cWEIBLICH = "weibliche";
    protected static final String cTAGE = "Tage";
    protected static final String cJAHREN = "Jahren";
    protected static final String cJA = "ja";
    protected static final Calendar m_Calendar;
    protected static final Pattern m_FilePattern;
    protected static final SimpleDateFormat m_FileDateFormat;
    protected static final Pattern m_GNRPattern;
    protected static String cFEHLER_TEXT;
    protected static String cOK_TEXT;
    protected static String cVERSION;
    protected static MeldungContainer m_MeldungContainer;
    protected static int m_nDatenpaket;
    protected static final String[] m_Ergebnistext;
    protected static final SimpleDateFormat m_DateFormat4;
    protected static final SimpleDateFormat m_DateFormat;
    protected static final SimpleDateFormat m_DateFormat_yyyyMMdd;
    protected static final SimpleDateFormat m_DateFormat10;
    protected static final SimpleDateFormat m_TimeFormat;
    protected static final DecimalFormat m_FormatInt3;
    protected static final XPMStringBuffer m_sBuffer;
    protected static final XPMStringBuffer m_sBuffer2;
    protected static StringBuffer m_sGruppe;
    protected static Date m_dateJetzt;
    protected static StammDaten m_KVStamm;
    protected static boolean bKRWPruefung_;
    protected static final HashMap<String, HashSet<String>> mapWBO_;
    protected static String sValue_;
    protected static Profile m_Profile;

    public AbstractXPMEventHandler(String sXPath) {
        super(sXPath);
    }

    public final void fillStatisticReport() throws XPMException {
        try {
            StatistikListe.addParameter("TITEL", "Fehlerstatistik KVDT " + cVERSION + "-Version");
            StatistikListe.addParameter("DATEIEN", m_DatenPool.getString("XPM_FILES"));
            StatistikListe.addParameter("DATUM", m_DatenPool.getString("XPM_DATE"));
            StatistikListe.addParameter("ZEIT", m_DatenPool.getString("XPM_TIME"));
            StatistikListe.addParameter("XPM_VERSION", m_DatenPool.getString("XPM_VERSION"));
            StatistikListe.addParameter("KBV_TAB_VERSION", m_Profile.getPaketInformation());
            StatistikListe.addParameter("INFOS", String.valueOf(m_MeldungPool.getRunInfoCounts()));
            StatistikListe.addParameter("WARNUNGEN", String.valueOf(m_MeldungPool.getRunWarningCounts()));
            StatistikListe.addParameter("FEHLER", String.valueOf(m_MeldungPool.getRunErrorCounts()));
            StatistikListe.addParameter("ABBRUCH", String.valueOf(m_MeldungPool.getRunCancelErrorCounts()));
            String sStatus = String.valueOf(m_MeldungPool.getOkFilesCounts()) + "/" + m_MeldungPool.getWarningFilesCounts() + "/" + m_MeldungPool.getErrorFilesCounts() + "/" + m_MeldungPool.getCancelFilesCounts();
            StatistikListe.addParameter("STATUS", sStatus);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (fillStatisticReport)");
        }
    }

    public String formatDate(String sDate) throws Exception {
        try {
            if (sDate != null && sDate.length() == 8) {
                m_sBuffer.replace(sDate.substring(0, 2)).append('.').append(sDate.substring(2, 4)).append('.').append(sDate.substring(4));
                return m_sBuffer.toString();
            }
            return "??.??.????";
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (formatDate)");
            return null;
        }
    }

    public Date getDate(String sDate) throws Exception {
        try {
            if (sDate != null && sDate.length() > 4) {
                try {
                    return m_DateFormat.parse(sDate);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getDate)");
            return null;
        }
    }

    public final Date getDateEnd4(String sDate) throws Exception {
        try {
            if (sDate != null && sDate.length() > 0) {
                try {
                    m_Calendar.setTime(m_DateFormat4.parse(sDate));
                    m_Calendar.add(2, 1);
                    m_Calendar.add(5, -1);
                    return m_Calendar.getTime();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getDateEnd4)");
            return null;
        }
    }

    public final boolean setDates(String sDate, Date date1, Date date2) throws Exception {
        try {
            boolean bRet = true;
            try {
                m_DateFormat.setLenient(false);
                Date datum = this.getDate(sDate.substring(0, 8));
                if (datum != null) {
                    date1.setTime(datum.getTime());
                } else {
                    bRet = false;
                }
                datum = this.getDate(sDate.substring(8));
                if (datum != null) {
                    date2.setTime(datum.getTime());
                } else {
                    bRet = false;
                }
                m_DateFormat.setLenient(true);
            }
            catch (ParseException ignore) {
                return false;
            }
            return bRet;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (setDates)");
            return false;
        }
    }

    public final int getInt(String sValue) throws Exception {
        try {
            try {
                if (sValue != null && sValue.length() > 0) {
                    return Integer.parseInt(sValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getInt)");
            return 0;
        }
    }

    public final Date getQuartalBeginn(String sQuartal) throws Exception {
        try {
            if (sQuartal != null && sQuartal.length() > 4) {
                int nQuartal = Integer.parseInt(sQuartal.substring(0, 1));
                m_sBuffer.replace("01.").append(String.valueOf(nQuartal * 3 - 2)).append('.').append(sQuartal.substring(1, 5));
                return m_DateFormat10.parse(m_sBuffer.toString());
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getQuartalBeginn)");
            return null;
        }
    }

    public final Date getQuartalEnde(String sQuartal) throws Exception {
        try {
            if (sQuartal != null && sQuartal.length() > 4) {
                int nQuartal = Integer.parseInt(sQuartal.substring(0, 1));
                m_sBuffer.replace("01.").append(String.valueOf(nQuartal * 3)).append('.').append(sQuartal.substring(1, 5));
                m_Calendar.setTime(m_DateFormat10.parse(m_sBuffer.toString()));
                m_Calendar.add(2, 1);
                m_Calendar.add(5, -1);
                return m_Calendar.getTime();
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getQuartalEnde)");
            return null;
        }
    }

    public final String getPaketBezeichnung(int nPaket) throws Exception {
        try {
            switch (nPaket) {
                case 0: {
                    return "Container-Header";
                }
                case 1: {
                    return "ADT Datenpaket";
                }
                case 3: {
                    return "Kur\u00e4rztliches Datenpaket";
                }
                case 5: {
                    return "Statistik Datenpaket";
                }
                case 6: {
                    return "Schwangerschaftsabbruch Datenpaket";
                }
                case 7: {
                    return "Container-Abschlu\u00df";
                }
                case 8: {
                    return "Hybrid-DRG Datenpaket";
                }
            }
            return "Datenpaket " + String.valueOf(nPaket);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getPaketBezeichnung)");
            return null;
        }
    }

    public final String getSatzBezeichnung(int nSatzart) throws Exception {
        try {
            switch (nSatzart) {
                case 0: {
                    return "KVDT-Container";
                }
                case 10: {
                    return "Betriebsst\u00e4ttendaten";
                }
                case 8: {
                    return "ADT Datenpaket";
                }
                case 1: {
                    return "Ambulante Behandlung";
                }
                case 2: {
                    return "Mit-/Weiterbehandlung";
                }
                case 3: {
                    return "Beleg\u00e4rztliche Behandlung";
                }
                case 4: {
                    return "Notfall";
                }
                case 9: {
                    return "Kur\u00e4rztliche Behandlung";
                }
                case 7: {
                    return "Statistik Satz";
                }
                case 11: {
                    return "SADT-ambulante Behandlung";
                }
                case 12: {
                    return "SADT-\u00dcberweisung";
                }
                case 13: {
                    return "SADT-beleg\u00e4rztliche Behandlung";
                }
                case 14: {
                    return "KVDT-Abschlu\u00df";
                }
                case 15: {
                    return "Hybrid-DRG Datenpaket-Header";
                }
                case 16: {
                    return "Hybrid-DRG Datenpaket";
                }
                case 17: {
                    return "Hybrid-DRG Datenpaket Abschluss";
                }
            }
            return "";
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getSatzBezeichnung)");
            return null;
        }
    }

    public final String getSatzBezeichnung(int nSatzart, int nSU) throws Exception {
        try {
            switch (nSatzart * 100 + nSU) {
                case 100: {
                    return "Ambulante Behandlung";
                }
                case 220: {
                    return "Selbstausstellung";
                }
                case 221: {
                    return "Auftragsleistungen";
                }
                case 223: {
                    return "Konsiliaruntersuchung";
                }
                case 224: {
                    return "Mit-/Weiterbehandlung";
                }
                case 226: {
                    return "Station\u00e4re Mitbehandlung";
                }
                case 227: {
                    return "Laborauftrag";
                }
                case 330: {
                    return "Beleg\u00e4rztliche Behandlung";
                }
                case 331: {
                    return "Beleg\u00e4rztliche Mitbehandlung";
                }
                case 332: {
                    return "Beleg\u00e4rztliche Vertretung";
                }
                case 441: {
                    return "Notfalldienst";
                }
                case 442: {
                    return "Vertretung";
                }
                case 443: {
                    return "Notfall";
                }
                case 444: {
                    return "Notfalldienst mit Taxi";
                }
                case 445: {
                    return "Rettungsdienst";
                }
                case 446: {
                    return "Zentraler Notfalldienst";
                }
                case 900: {
                    return "Kur\u00e4rztliche Behandlung";
                }
                case 1100: {
                    return "SADT-ambulante Behandlung";
                }
                case 1200: {
                    return "SADT-\u00dcberweisung";
                }
                case 1300: {
                    return "SADT-beleg\u00e4rztliche Behandlung";
                }
            }
            return this.getSatzBezeichnung(nSatzart);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getSatzBezeichnung)");
            return null;
        }
    }

    public final String getSatzart(int nSatzart) throws Exception {
        try {
            switch (nSatzart) {
                case 0: {
                    return "con0";
                }
                case 10: {
                    return "besa";
                }
                case 8: {
                    return "adt0";
                }
                case 1: {
                    return "0101";
                }
                case 2: {
                    return "0102";
                }
                case 3: {
                    return "0103";
                }
                case 4: {
                    return "0104";
                }
                case 9: {
                    return "0109";
                }
                case 7: {
                    return "st13";
                }
                case 11: {
                    return "sad1";
                }
                case 12: {
                    return "sad2";
                }
                case 13: {
                    return "sad3";
                }
                case 14: {
                    return "con9";
                }
                case 15: {
                    return "hdrg0";
                }
                case 16: {
                    return "hdrg1";
                }
                case 17: {
                    return "hdrg9";
                }
            }
            return "";
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getSatzart)");
            return null;
        }
    }

    public final String getStatus(String sStatus) throws Exception {
        try {
            if (sStatus.isEmpty()) {
                return "";
            }
            switch (sStatus.charAt(0)) {
                case '1': {
                    return "M";
                }
                case '3': {
                    return "F";
                }
            }
            return "R";
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getStatus)");
            return null;
        }
    }

    public final Date getTime(String sTime) throws Exception {
        try {
            if (sTime != null && sTime.length() > 0) {
                return m_TimeFormat.parse(sTime);
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getTime)");
            return null;
        }
    }

    public final String getXDTLine(String sFK, String sInhalt) throws Exception {
        try {
            if (sInhalt == null) {
                return "";
            }
            if (sInhalt.length() > 990) {
                sInhalt = sInhalt.substring(0, 990);
            }
            m_sBuffer.replace(m_FormatInt3.format(sInhalt.length() + 9)).append(sFK).append(sInhalt).append("\r\n");
            return m_sBuffer.toString();
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getXDTLine)");
            return null;
        }
    }

    public final void initProtokoll() throws Exception {
        try {
            FehlerListe.addParameter("PAKET_VERSION", m_Profile.getPaketVersion());
            FehlerListe.addParameter("XPM_QUARTAL_PARAM", m_Profile.getXPMQuartal() + "/" + m_Profile.getXPMJahr());
            FehlerListe.addParameter("XPM_VERSION", m_DatenPool.getString("XPM_VERSION"));
            FehlerListe.addParameter("KBV_TAB_VERSION", m_Profile.getPaketInformation());
            FehlerListe.addParameter("ERGEBNIS", m_Ergebnistext[3]);
            FehlerListe.addParameter("ERGEBNIS_TEXT", cFEHLER_TEXT);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (initProtokoll)");
        }
    }

    public final boolean imQuartal(String sQuartal, String sDatum) throws Exception {
        try {
            Date quartalBeginn = this.getQuartalBeginn(sQuartal);
            Date quartalEnde = this.getQuartalEnde(sQuartal);
            Date datum = this.getDate(sDatum);
            return datum != null && datum.compareTo(quartalBeginn) >= 0 && datum.compareTo(quartalEnde) <= 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (imQuartal)");
            return false;
        }
    }

    public final void setDatenpaket(int nPaket) throws Exception {
        try {
            m_nDatenpaket = nPaket;
            if (m_Datenpakete[nPaket] < 0) {
                if (nPaket != 8 && m_Datenpakete[nPaket] == -2) {
                    m_MeldungPool.addMeldung("KVDT-RDP1", this.getPaketBezeichnung(nPaket));
                }
                AbstractXPMEventHandler.m_Datenpakete[nPaket] = 0;
                m_sGruppe = FehlerListe.newGroup(this.getPaketBezeichnung(nPaket));
                m_sGruppe.append('|');
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (setDatenpaket)");
        }
    }

    public final void writeErgebnisUndKommuSatz() throws Exception {
        try {
            EhdHeader header;
            if (writeKomuSatz.booleanValue()) {
                KommunikationsSatz.write(this.getXDTLine("8000", "KOMU"));
                KommunikationsSatz.write(this.getXDTLine("9230", m_DatenPool.getString("XPM_VERSION")));
                KommunikationsSatz.write(this.getXDTLine("9231", m_Profile.getPaketInformation()));
            }
            if (GOStamm != null && GOStamm.isValid() && (header = GOStamm.getHeader()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append("SDGO").append(header.getInterfaceVersion()).append('/').append(header.getQuartal().toString().replaceFirst("/", "")).append('/').append(header.getProvider()).append('/').append(header.getDatum());
                FehlerListe.addParameter("GO_VERSION", m_sBuffer.toString());
                if (writeKomuSatz.booleanValue()) {
                    KommunikationsSatz.write(this.getXDTLine("9213", m_sBuffer.toString()));
                }
            }
            if (ICDStamm2026.isValid() && (header = ICDStamm2026.getHeader()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append(header.getDokumentTyp()).append(header.getInterfaceVersion()).append('/').append(header.getQuartal().toString().replaceFirst("/", "")).append('/').append(header.getProvider()).append('/').append(header.getDatum());
                FehlerListe.addParameter("ICD_VERSION", m_sBuffer.toString());
                if (writeKomuSatz.booleanValue()) {
                    KommunikationsSatz.write(this.getXDTLine("9213", m_sBuffer.toString()));
                }
            }
            if (ICDStamm2025.isValid() && (header = ICDStamm2025.getHeader()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append(header.getDokumentTyp()).append(header.getInterfaceVersion()).append('/').append(header.getQuartal().toString().replaceFirst("/", "")).append('/').append(header.getProvider()).append('/').append(header.getDatum());
                FehlerListe.addParameter("ICD_VERSION_LASTYEAR", m_sBuffer.toString());
            }
            if (OPSStamm.isValid() && (header = OPSStamm.getHeader()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append(header.getDokumentTyp()).append(header.getInterfaceVersion()).append('/').append(header.getQuartal().toString().replaceFirst("/", "")).append('/').append(header.getProvider()).append('/').append(header.getDatum());
                FehlerListe.addParameter("OPS_VERSION", m_sBuffer.toString());
            }
            if (HDRGStamm != null && HDRGStamm.isValid() && (header = HDRGStamm.getHeader()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append(header.getDokumentTyp()).append(header.getInterfaceVersion()).append('/').append(header.getQuartal().toString().replaceFirst("/", "")).append('/').append(header.getProvider()).append('/').append(header.getDatum());
                FehlerListe.addParameter("HDRG_VERSION", m_sBuffer.toString());
            }
            if (HGNCStamm != null && HGNCStamm.isValid()) {
                Object HGNCVersion = HGNCStamm.getVersion();
                if (((String)HGNCVersion).length() > 3) {
                    HGNCVersion = ((String)HGNCVersion).substring(0, 3) + "." + ((String)HGNCVersion).substring(3);
                }
                FehlerListe.addParameter("HGNC_VERSION", "SDHGNC" + (String)HGNCVersion);
            }
            if (KTStamm.isValid() && (header = KTStamm.getHeader()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append(header.getDokumentTyp()).append(header.getInterfaceVersion()).append('/').append(header.getQuartal().toString().replaceFirst("/", "")).append('/').append(header.getProvider()).append('/').append(header.getDatum());
                FehlerListe.addParameter("KT_VERSION", m_sBuffer.toString());
                if (writeKomuSatz.booleanValue()) {
                    KommunikationsSatz.write(this.getXDTLine("9213", m_sBuffer.toString()));
                }
            }
            if (KRWStamm.isValid()) {
                header = KRWStamm.getHeader();
                if (header != null) {
                    m_sBuffer.delete();
                    m_sBuffer.append(header.getDokumentTyp()).append(header.getInterfaceVersion()).append('/').append(header.getQuartal().toString().replaceFirst("/", "")).append('/').append(header.getProvider()).append('/').append(header.getDatum());
                    FehlerListe.addParameter("KRW_VERSION", m_sBuffer.toString());
                    if (writeKomuSatz.booleanValue()) {
                        KommunikationsSatz.write(this.getXDTLine("9213", m_sBuffer.toString()));
                    }
                }
            } else {
                FehlerListe.addParameter("KRW_VERSION", "Nicht eingebunden");
            }
            if (PLZStamm.isValid() && (header = PLZStamm.getSatzPLZ0()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append(header.getFeld9212()).append('/').append(header.getFeld9111()).append("/74/01");
                FehlerListe.addParameter("PLZ_VERSION", m_sBuffer.toString());
                if (writeKomuSatz.booleanValue()) {
                    KommunikationsSatz.write(this.getXDTLine("9213", m_sBuffer.toString()));
                }
            }
            if (AnbieterStamm.isValid() && (header = AnbieterStamm.getHeader()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append(header.getDokumentTyp()).append(header.getInterfaceVersion()).append('/').append(header.getQuartal().toString().replaceFirst("/", "")).append("/74/").append(header.getDatum());
                FehlerListe.addParameter("ANB_VERSION", m_sBuffer.toString());
                if (writeKomuSatz.booleanValue()) {
                    KommunikationsSatz.write(this.getXDTLine("9213", m_sBuffer.toString()));
                }
            }
            if (m_KVStamm != null && m_KVStamm.isValid() && (header = m_KVStamm.getSatzkvx0()) != null) {
                m_sBuffer.delete();
                m_sBuffer.append(header.getFeld9212()).append('/').append(header.getFeld9111()).append('/').append(header.getFeld9113()).append("/01");
                FehlerListe.addParameter("KV_VERSION", m_sBuffer.toString());
                if (writeKomuSatz.booleanValue()) {
                    KommunikationsSatz.write(this.getXDTLine("9213", m_sBuffer.toString()));
                }
            }
            int nReturnCode = Integer.parseInt(m_DatenPool.getString("XPM_RETURN_CODE"));
            block6: for (int i = 0; i < m_Datenpakete.length; ++i) {
                switch (m_Datenpakete[i]) {
                    case -1: {
                        int nTyp = m_MeldungPool.getMeldung("KVDT-RDP2").getTyp();
                        if (m_Datenpakete[0] >= 0 && m_Datenpakete[0] < nTyp) {
                            FehlerListe.addParameter(m_Paketparameter[i], m_Ergebnistext[nTyp]);
                        }
                        if (nReturnCode >= 3) continue block6;
                        m_MeldungPool.addMeldung("KVDT-RDP2", this.getPaketBezeichnung(i));
                        continue block6;
                    }
                    case -2: {
                        FehlerListe.addParameter(m_Paketparameter[i], "-");
                        continue block6;
                    }
                    default: {
                        FehlerListe.addParameter(m_Paketparameter[i], m_Ergebnistext[m_Datenpakete[i]]);
                        if (!writeKomuSatz.booleanValue()) continue block6;
                        if (i == 7) {
                            KommunikationsSatz.write(this.getXDTLine("9237", "9"));
                            continue block6;
                        }
                        KommunikationsSatz.write(this.getXDTLine("9237", String.valueOf(i)));
                    }
                }
            }
            FehlerListe.addParameter("ERGEBNIS", m_Ergebnistext[nReturnCode]);
            if (nReturnCode > 1) {
                FehlerListe.addParameter("ERGEBNIS_TEXT", cFEHLER_TEXT);
            } else {
                FehlerListe.addParameter("ERGEBNIS_TEXT", cOK_TEXT);
            }
            FehlerListe.addParameter("INFOS", String.valueOf(m_MeldungPool.getInfoCounts()));
            FehlerListe.addParameter("WARNUNGEN", String.valueOf(m_MeldungPool.getWarningCounts()));
            FehlerListe.addParameter("FEHLER", String.valueOf(m_MeldungPool.getErrorCounts()));
            FehlerListe.addParameter("ABBRUCH", String.valueOf(m_MeldungPool.getCancelErrorCounts()));
            if (writeKomuSatz.booleanValue()) {
                KommunikationsSatz.write(this.getXDTLine("9232", m_DatenPool.getString("XPM_RETURN_CODE")));
                KommunikationsSatz.write(this.getXDTLine("9234", m_DateFormat_yyyyMMdd.format(m_dateJetzt)));
                KommunikationsSatz.write(this.getXDTLine("9235", m_TimeFormat.format(m_dateJetzt)));
                KommunikationsSatz.write(this.getXDTLine("9236", m_DatenPool.getString("XPM_FILE")));
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (writeErgebnisUndKommuSatz)");
        }
    }

    public final void writePDTFoot() throws Exception {
        try {
            PDTListe.write(this.getXDTLine("8000", "pro9"));
            PDTListe.write(this.getXDTLine("9230", m_DatenPool.getString("XPM_VERSION")));
            PDTListe.write(this.getXDTLine("9232", m_DatenPool.getString("XPM_RETURN_CODE")));
            PDTListe.write(this.getXDTLine("9234", m_DateFormat.format(m_dateJetzt)));
            PDTListe.write(this.getXDTLine("9235", m_TimeFormat.format(m_dateJetzt)));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (writePDTFoot)");
        }
    }

    public void init(Meldung meldung) throws XPMException {
        try {
            if (m_Datenpakete[m_nDatenpaket] < meldung.getTyp()) {
                AbstractXPMEventHandler.m_Datenpakete[AbstractXPMEventHandler.m_nDatenpaket] = meldung.getTyp();
            }
            if (meldung.getTyp() < 1 || !PDTListe.getValid()) {
                return;
            }
            PDTListe.write(this.getXDTLine("8000", "prot"));
            PDTListe.write(this.getXDTLine("9420", meldung.getNummer()));
            PDTListe.write(this.getXDTLine("9421", String.valueOf(meldung.getTyp())));
            PDTListe.write(this.getXDTLine("9423", meldung.getText().replace('\n', ' ')));
            PDTListe.write(this.getXDTLine("9424", this.getSatzart(0)));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Meldungspr\u00fcfung");
        }
    }

    public void init() throws XPMException {
        AbstractXPMEventHandler.m_Datenpakete[0] = -1;
        AbstractXPMEventHandler.m_Datenpakete[1] = -2;
        AbstractXPMEventHandler.m_Datenpakete[2] = -2;
        AbstractXPMEventHandler.m_Datenpakete[3] = -2;
        AbstractXPMEventHandler.m_Datenpakete[4] = -2;
        AbstractXPMEventHandler.m_Datenpakete[5] = -2;
        AbstractXPMEventHandler.m_Datenpakete[6] = -2;
        AbstractXPMEventHandler.m_Datenpakete[7] = -1;
        AbstractXPMEventHandler.m_Datenpakete[8] = -2;
        cFEHLER_TEXT = "Die gepr\u00fcfte Datei darf der KV nicht \u00fcbergeben werden.";
        cOK_TEXT = "Die gepr\u00fcfte Datei kann verschl\u00fcsselt und der KV \u00fcbergeben werden.";
        cVERSION = "Praxis";
        m_MeldungContainer = null;
        m_nDatenpaket = 0;
        m_sGruppe = new StringBuffer();
        m_dateJetzt = Calendar.getInstance().getTime();
        m_KVStamm = null;
        bKRWPruefung_ = false;
        sValue_ = null;
        writeKomuSatz = true;
    }

    static {
        m_Datenpakete = new int[]{-1, -2, -2, -2, -2, -2, -2, -1, -2};
        m_Paketparameter = new String[]{"CON_STATUS", "ADT_STATUS", "", "KADT_STATUS", "", "STDT_STATUS", "SADT_STATUS", "CON9_STATUS", "HDRG_STATUS"};
        m_Calendar = Calendar.getInstance();
        m_FilePattern = Pattern.compile("Z[0-3][0|1|4|5]\\d{9}");
        m_FileDateFormat = new SimpleDateFormat("dd.MM.yyyy_HH.mm", Locale.GERMAN);
        m_GNRPattern = Pattern.compile("(([A-Z][0-9]{0,4})|([A-Z]{0,1}[0-9]{1,4}))([A-Za-d][A-Z1-4]{0,1}){0,1}(/\\d|/[A-Z]|/#|/\\$|/\\*|/<|/>|/k){0,1}");
        cFEHLER_TEXT = "Die gepr\u00fcfte Datei darf der KV nicht \u00fcbergeben werden.";
        cOK_TEXT = "Die gepr\u00fcfte Datei kann verschl\u00fcsselt und der KV \u00fcbergeben werden.";
        cVERSION = "Praxis";
        m_MeldungContainer = null;
        m_nDatenpaket = 0;
        m_Ergebnistext = new String[]{"Ok", "Warnung", "Fehlerhaft", "Abbruch"};
        m_DateFormat4 = new SimpleDateFormat("MMyy", Locale.GERMAN);
        m_DateFormat = new SimpleDateFormat("ddMMyyyy", Locale.GERMAN);
        m_DateFormat_yyyyMMdd = new SimpleDateFormat("yyyyMMdd", Locale.GERMAN);
        m_DateFormat10 = new SimpleDateFormat("dd.MM.yyyy", Locale.GERMAN);
        m_TimeFormat = new SimpleDateFormat("HHmm", Locale.GERMAN);
        m_FormatInt3 = new DecimalFormat("000");
        m_sBuffer = new XPMStringBuffer();
        m_sBuffer2 = new XPMStringBuffer();
        m_sGruppe = new StringBuffer();
        m_dateJetzt = Calendar.getInstance().getTime();
        m_KVStamm = null;
        bKRWPruefung_ = false;
        mapWBO_ = new HashMap();
        sValue_ = null;
    }
}

