/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.converter.ISO8859_15Encoder;
import de.kbv.xpm.core.meldung.Meldung;
import de.kbv.xpm.core.stamm.ICD.SatzICD;
import de.kbv.xpm.modul.kvdt.common.Shdrg0Handler;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMICDStamm2025;
import de.kbv.xpm.modul.kvdt.common.stamm.XPMICDStamm2026;
import java.util.Date;
import java.util.regex.Pattern;

public class Shdrg1Handler
extends Shdrg0Handler {
    protected static final Pattern datumJJJJMMTT = Pattern.compile("(((((1[89](\\d{2}))|([2-9](\\d{3})))(((0[13578]|10|12)(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)(0[1-9]|[12][0-9]|30))|((02)(0[1-9]|1[0-9]|2[0-8])))))|(((1[89]0[48])|(1[89][2468][048])|(1[89][13579][26])|([2468][048]00)|([2-9][0-9]0[48])|([2-9][0-9][2468][048])|([2-9][0-9][13579][26])|([3579][26]00))(02)(29)))");
    protected static String m_s3111 = null;
    protected static String value4125 = null;
    protected static String m_s5029 = null;
    protected static String m_s6009 = null;
    protected static String m_s6011 = null;

    public Shdrg1Handler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    @Override
    public void elementStart() throws XPMException {
        try {
            m_bPrimaerICD = false;
            m_s6011 = null;
            m_s6009 = null;
            m_s3111 = null;
            m_s5028 = null;
            m_s5029 = null;
            value4125 = null;
            if (schalterDatenpakete.toLowerCase().equals("adt")) {
                String text = "Das Pr\u00fcfmodul ist derzeit nur f\u00fcr die Pr\u00fcfung von ADT-Datenpaketen konfiguriert. In der Datei ist ein HDRG1-Satz vorhaben, welcher nur bei Hybrid-DRG \u00fcbertragen werden darf. Die Pr\u00fcfung wird deshalb abgebrochen.";
                m_MeldungPool.addMeldung("XPM-Abbruch", text);
                this.writePDTMeldung(new Meldung("XPM-Abbruch", 3, text));
                return;
            }
            this.init();
            writeKomuSatz = false;
            this.setDatenpaket(8);
            m_nSatzart = 16;
            ++m_nScheine;
            this.initSatz();
            m_bWritePDT = false;
            hdrg1Exists = true;
            f3010 = "";
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Initialisierung");
        }
    }

    public final void pruefeRegel764(String lanr) throws Exception {
        try {
            if (lanr.equals("888888800")) {
                m_MeldungPool.addMeldung("KVDT-R764");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeRegel764)");
        }
    }

    public final void pruefeRegel498(char inhalt, String icdCode) throws Exception {
        try {
            if (inhalt == 'N' || inhalt == 'n') {
                m_MeldungPool.addMeldung("KVDT-R498", icdCode);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeRegel498)");
        }
    }

    public final void pruefeRegel737(char geschlecht, char fehlerArt) throws Exception {
        try {
            if (m_sGeschlecht != null) {
                if (fehlerArt == 'k' && !m_bICDZusatzPruefung) {
                    return;
                }
                if (geschlecht == 'M' || geschlecht == 'm') {
                    if (m_sGeschlecht.equals("W") && fehlerArt == 'k') {
                        m_MeldungPool.addMeldung("KVDT-R737", sValue_, "m\u00e4nnliche");
                    }
                } else if (m_sGeschlecht.equals("M") && fehlerArt == 'k') {
                    m_MeldungPool.addMeldung("KVDT-R737", sValue_, "weibliche");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeRegel737)");
        }
    }

    public final void pruefeICD(String icdCode) throws Exception {
        try {
            SatzICD icd = null;
            if (m_s5028 != null && m_s5028.startsWith("2025")) {
                XPMICDStamm2025 icdStamm = ICDStamm2025;
                if (!icdStamm.isValid()) {
                    m_bPrimaerICD = true;
                    return;
                }
                icd = icdStamm.getICDSatz(icdCode);
            } else {
                XPMICDStamm2026 icdStamm = ICDStamm2026;
                if (!icdStamm.isValid()) {
                    m_bPrimaerICD = true;
                    return;
                }
                icd = icdStamm.getICDSatz(icdCode);
            }
            if (icd == null) {
                m_MeldungPool.addMeldung("KVDT-R499", sValue_);
            } else {
                this.pruefeRegel498(icd.getMitInhalt(), icdCode);
                if (!m_bPrimaerICD && icd.isPrimaerCode()) {
                    m_bPrimaerICD = true;
                }
                if (icd.getGeschlecht() != '\u0000') {
                    this.pruefeRegel737(icd.getGeschlecht(), icd.getGeschlechtFehlerArt());
                }
                if (icd.getUntereAltersGrenze() != null) {
                    this.pruefeIcdAltersgrenze(icdCode, icd.getUntereAltersGrenze().floatValue(), icd.getObereAltersGrenze().floatValue(), icd.getAlterFehlerArt());
                }
                this.pruefeRegel494(icd.getSelten(), icdCode);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeICD)");
        }
    }

    @Override
    public void pruefeRegel307() throws Exception {
        try {
            if (this.m_Element.getChild("f4109") != null && this.m_Element.getChild("f3119") != null && this.m_Element.getChild("f3006") == null) {
                m_MeldungPool.addMeldung("KVDT-R307", "");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeRegel307)");
        }
    }

    public final void pruefeRegel494(String sSelten, String icdCode) throws Exception {
        try {
            if (sSelten == null || !m_bICDZusatzPruefung) {
                return;
            }
            if (sSelten.toUpperCase().equals("J")) {
                m_MeldungPool.addMeldung("KVDT-R494", icdCode);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeRegel494)");
        }
    }

    public final void pruefeRegel735() throws Exception {
        try {
            if (!(m_bPrimaerICD || m_s6009 == null && m_s6011 == null)) {
                m_MeldungPool.addMeldung("KVDT-R735");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefePrimaerICD)");
        }
    }

    public final void pruefeIcdAltersgrenze(String icdCode, float fUntereGrenze, float fObereGrenze, char fehlerArt) throws Exception {
        try {
            if (fehlerArt == 'k' && !m_bICDZusatzPruefung || m_dateGeburt == null) {
                return;
            }
            if (fObereGrenze >= 1.0f && fObereGrenze < 124.0f) {
                fObereGrenze += 1.0f;
            }
            m_Calendar.setTime(m_dateGeburt);
            if (fUntereGrenze < 1.0f) {
                m_Calendar.add(6, (int)(fUntereGrenze * 100.0f));
            } else {
                m_Calendar.add(1, (int)fUntereGrenze);
            }
            Date dateGrenze = m_Calendar.getTime();
            if (m_s5029 != null && dateGrenze.after(this.getDate(m_s5029))) {
                m_MeldungPool.addMeldung("KVDT-R493", icdCode, this.getAltersgruppe(fUntereGrenze, fObereGrenze));
            }
            m_Calendar.setTime(m_dateGeburt);
            if (fObereGrenze < 1.0f) {
                m_Calendar.add(6, (int)(fObereGrenze * 100.0f));
            } else {
                m_Calendar.add(1, (int)fObereGrenze);
            }
            dateGrenze = m_Calendar.getTime();
            if (m_s5028 != null && dateGrenze.before(this.getDate(m_s5028))) {
                m_MeldungPool.addMeldung("KVDT-R493", icdCode, this.getAltersgruppe(fUntereGrenze, fObereGrenze));
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeIcdAltersgrenze)");
        }
    }

    public final void pruefeRegel538() throws Exception {
        try {
            if (!this.m_Element.getChildValue("3110").matches("M|W|X|D|")) {
                m_MeldungPool.addMeldung("KVDT-R538", this.m_Element.getChildValue("3110"));
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeRegel538)");
        }
    }

    public final void pruefeRegel201_202_hdrg() throws Exception {
        try {
            if (!KTStamm.isValid()) {
                return;
            }
            if (m_KT == null) {
                if (m_sVKNR.length() > 0) {
                    m_MeldungPool.addMeldung("KVDT-R201", m_sVKNR + "/" + m_sKTAB);
                }
            } else if (m_sKTAB.length() > 0) {
                if (m_KT.getKTABName(m_sKTAB) == null) {
                    m_MeldungPool.addMeldung("KVDT-R201", m_sVKNR + "/" + m_sKTAB);
                }
                if (!KTStamm.existIK(this.m_Element.getChildValue("f4111"))) {
                    m_MeldungPool.addMeldung("KVDT-R202", this.m_Element.getChildValue("f4111"));
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeRegel201_202_hdrg)");
        }
    }

    public final void pruefeRegel536_534() throws Exception {
        try {
            String strgF4131 = this.m_Element.getChildValue("f4131");
            String strgF4132 = this.m_Element.getChildValue("f4132");
            if (!strgF4132.matches("00|01|02|03|04|05|06|07|08|09|10|11|12|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58")) {
                m_MeldungPool.addMeldung("KVDT-R536", strgF4132);
            }
            if (!strgF4131.matches("00|04|06|07|08|09|")) {
                m_MeldungPool.addMeldung("KVDT-R534", strgF4131);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung (pruefeRegel536_534)");
        }
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            String value3103;
            m_sMFR = this.m_Element.getChildValue("f3108");
            if (m_KVStamm != null) {
                m_kvx4 = m_KVStamm.getSatzkvx4();
                m_kvx7 = m_KVStamm.getSatzkvx7();
            }
            if (this.m_Element.getChild("f4109") == null && !datumJJJJMMTT.matcher(value3103 = this.m_Element.getChildValue("f3103")).matches()) {
                m_MeldungPool.addMeldung("KVDT-R023", value3103);
            }
            m_s3006 = this.m_Element.getChildValue("f3006");
            m_sName = ISO8859_15Encoder.toUnicode((String)this.m_Element.getChildValue("f3101"));
            m_sVorname = ISO8859_15Encoder.toUnicode((String)this.m_Element.getChildValue("f3102"));
            m_sKTAB = this.m_Element.getChildValue("f4106");
            m_sVKNR = this.m_Element.getChildValue("f4104");
            m_eGK = this.m_Element.getChild("f3119");
            this.setFehlerGruppe();
            this.pruefeRegel017();
            this.pruefeRegel212();
            m_KT = KTStamm.getKTSSatz(m_sVKNR);
            if (m_kvx7 != null) {
                m_sAbrA = m_kvx7.getAbrechnungsart(m_sVKNR, m_sKTAB);
            }
            this.pruefeRegel201_202_hdrg();
            this.pruefeRegel307();
            this.pruefeRegel308();
            this.pruefeRegel536_534();
            this.pruefeRegel538();
            this.pruefeRegel734();
            this.pruefeRegel775();
            this.pruefeRegel776();
            this.pruefeRegel827();
            int value4131 = this.getInt(this.m_Element.getChildValue("f4131"));
            this.pruefeRegel778(value4131);
            this.pruefeRegel779(value4131);
            this.pruefeRegel780(value4131);
            this.pruefeRegel784();
            this.pruefeRegel790();
            this.pruefeRegel735();
            this.pruefeRegel818(value4131);
            String f3119 = this.m_Element.getChildValue("f3119");
            String f4109 = this.m_Element.getChildValue("f4109");
            this.pruefeRegel876(f3010, f4109);
            this.pruefeRegel537(f3119);
            this.pruefeRegel895();
            if (m_kvx4 != null && m_kvx7 != null && this.addListenFall()) {
                this.addFallAmbulant();
                m_s0201 = m_currentBSNr;
            }
            m_nScheineGesamt = m_nScheine;
            this.writePDTMeldungen();
            m_bWritePDT = true;
            m_DatenPool.removeElements();
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg1Handler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        vsdmPruefNwFK3010CounterProSatzart = 0;
    }
}

