/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.io.AusgabeReport;
import de.kbv.xpm.core.io.CSVReportExporter;
import de.kbv.xpm.core.io.ReportExporter;
import de.kbv.xpm.core.io.XMLReportExporter;
import de.kbv.xpm.modul.kvdt.common.XPMScheinAbgabeListe;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.XPMPrint;
import net.sf.jasperreports.engine.fill.XPMBaseFiller;

public final class XPMDokuAbgabeListe
extends AusgabeReport {
    protected static XPMDokuAbgabeListe instance = null;
    static final long serialVersionUID = 207L;
    private ReportData m_Datum = new ReportData();
    private XPMBaseFiller m_Filler;
    private OutputStreamWriter m_Writer;
    private ReportExporter m_Exporter;
    private int m_nIndex = -1;
    private int m_nLen = 0;

    protected XPMDokuAbgabeListe() throws XPMException {
        super("DokuAbgabeListe", 0, 0, XPMScheinAbgabeListe.getInstance().m_Report);
    }

    public static XPMDokuAbgabeListe getInstance() throws XPMException {
        if (instance == null) {
            instance = new XPMDokuAbgabeListe();
        }
        return instance;
    }

    public void setInstance() throws XPMException {
        instance = this;
        this.m_bSerialize = true;
    }

    protected void addData(JRDataSource datum) throws XPMException {
        try {
            ++this.m_nLen;
            switch (this.m_nFormat) {
                case 2: {
                    if (this.m_Writer == null) {
                        this.m_Writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.m_sDatendatei)));
                        this.m_Exporter = new XMLReportExporter();
                        this.m_Exporter.exportHeader(this.m_Writer, this.m_Report.getFields(), this.m_Parameter);
                    }
                    this.m_Exporter.exportData(this.m_Writer, this.m_Report.getFields(), datum);
                    break;
                }
                case 7: {
                    if (this.m_Writer == null) {
                        this.m_Writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.m_sDatendatei)));
                        this.m_Exporter = new CSVReportExporter(this.m_sDelimiter);
                        this.m_Exporter.exportHeader(this.m_Writer, this.m_Report.getFields(), this.m_Parameter);
                    }
                    this.m_Exporter.exportData(this.m_Writer, this.m_Report.getFields(), datum);
                    break;
                }
                default: {
                    if (this.m_Filler == null) {
                        this.m_Filler = XPMBaseFiller.createFiller((JasperReport)this.m_Report);
                        this.m_Print = this.m_Filler.initFill((Map)this.m_Parameter, datum);
                        break;
                    }
                    this.m_Filler.dataFill(datum);
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw new XPMException("Eine Ausgabeliste konnte nicht erzeugt werden.\nBitte beheben Sie den gemeldeten Fehler und starten die Pr\u00fcfung erneut!\n" + ex.getMessage(), 51);
        }
        catch (JRException ex) {
            throw new XPMException("Eine Ausgabeliste konnte nicht erzeugt werden.\nBitte beheben Sie den gemeldeten Fehler und starten die Pr\u00fcfung erneut!\n" + ex.getMessage(), 51);
        }
    }

    public void addData(String VKNR_KTAB, String KT_NAME, Integer FALL_NR, String NAME, String GEBURTSDATUM, String QUARTAL, String STATUS, String SCHEINART, String KVK) throws XPMException {
        if (this.m_bValid) {
            this.addData(this.createReportData(VKNR_KTAB, KT_NAME, FALL_NR, NAME, GEBURTSDATUM, QUARTAL, STATUS, SCHEINART, KVK));
        }
    }

    protected JRDataSource createReportData() {
        return new ReportData();
    }

    protected JRDataSource createReportData(String VKNR_KTAB, String KT_NAME, Integer FALL_NR, String NAME, String GEBURTSDATUM, String QUARTAL, String STATUS, String SCHEINART, String KVK) {
        this.m_Datum.m_VKNR_KTAB = VKNR_KTAB;
        this.m_Datum.m_KT_NAME = KT_NAME;
        this.m_Datum.m_FALL_NR = FALL_NR;
        this.m_Datum.m_NAME = NAME;
        this.m_Datum.m_GEBURTSDATUM = GEBURTSDATUM;
        this.m_Datum.m_QUARTAL = QUARTAL;
        this.m_Datum.m_STATUS = STATUS;
        this.m_Datum.m_SCHEINART = SCHEINART;
        this.m_Datum.m_KVK = KVK;
        return this.m_Datum;
    }

    public void closeData() throws XPMException {
        if (this.m_bValid) {
            try {
                if (this.m_nFormat == 2 || this.m_nFormat == 7) {
                    this.m_Exporter.exportFooter(this.m_Writer);
                } else {
                    this.m_Filler.closeFill();
                }
            }
            catch (JRException ex) {
                throw new XPMException("Eine Ausgabeliste konnte nicht erzeugt werden.\nBitte beheben Sie den gemeldeten Fehler und starten die Pr\u00fcfung erneut!\n" + ex.getMessage(), 51);
            }
            catch (IOException ex) {
                throw new XPMException("Eine Ausgabeliste konnte nicht erzeugt werden.\nBitte beheben Sie den gemeldeten Fehler und starten die Pr\u00fcfung erneut!\n" + ex.getMessage(), 51);
            }
        }
    }

    public void close() {
        super.close();
        if (this.m_bValid && this.m_Print != null) {
            ((XPMPrint)this.m_Print).delete();
            this.m_Filler = null;
        }
        if (this.m_nFormat == 2 || this.m_nFormat == 7) {
            this.m_Writer = null;
            this.m_Exporter = null;
        }
        this.m_nLen = 0;
        this.m_nIndex = -1;
    }

    public int getDataSize() {
        return this.m_nLen;
    }

    public void unload(Field field) throws IllegalAccessException {
        field.set((Object)this, null);
    }

    protected final class ReportData
    implements JRDataSource,
    Serializable {
        static final long serialVersionUID = 207L;
        private String m_VKNR_KTAB;
        private String m_KT_NAME;
        private Integer m_FALL_NR;
        private String m_NAME;
        private String m_GEBURTSDATUM;
        private String m_QUARTAL;
        private String m_STATUS;
        private String m_SCHEINART;
        private String m_KVK;

        protected ReportData() {
            XPMDokuAbgabeListe.this.m_nIndex = -1;
        }

        protected ReportData(String VKNR_KTAB, String KT_NAME, Integer FALL_NR, String NAME, String GEBURTSDATUM, String QUARTAL, String STATUS, String SCHEINART, String KVK) {
            this.m_VKNR_KTAB = VKNR_KTAB;
            this.m_KT_NAME = KT_NAME;
            this.m_FALL_NR = FALL_NR;
            this.m_NAME = NAME;
            this.m_GEBURTSDATUM = GEBURTSDATUM;
            this.m_QUARTAL = QUARTAL;
            this.m_STATUS = STATUS;
            this.m_SCHEINART = SCHEINART;
            this.m_KVK = KVK;
        }

        public boolean next() throws JRException {
            return ++XPMDokuAbgabeListe.this.m_nIndex < XPMDokuAbgabeListe.this.m_nLen;
        }

        public Object getFieldValue(JRField field) throws JRException {
            switch (field.getName().hashCode()) {
                case -312019824: {
                    return this.m_VKNR_KTAB;
                }
                case 338271137: {
                    return this.m_KT_NAME;
                }
                case -365811448: {
                    return this.m_FALL_NR;
                }
                case 2388619: {
                    return this.m_NAME;
                }
                case -1396953777: {
                    return this.m_GEBURTSDATUM;
                }
                case 1369386506: {
                    return this.m_QUARTAL;
                }
                case -1839152142: {
                    return this.m_STATUS;
                }
                case -1664684079: {
                    return this.m_SCHEINART;
                }
                case 74816: {
                    return this.m_KVK;
                }
            }
            return null;
        }
    }
}

