/*
 * Decompiled with CFR 0.152.
 */
package de.kbv;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class VersionCheck {
    static Logger logger = Logger.getLogger("javaVersionCheckLogger");
    private static boolean silent = false;
    private String strVersion;
    private String meldung = "Auf Ihrem System ist noch eine \u00e4ltere Version \n der Java-Laufzeitumgebung installiert. \nDer offizielle Support Ihrer Java Version wurde eingestellt.\n Bitte veranlassen Sie daher durch Ihren Systembetreuer\n eine zeitnahe Aktualisierung auf die Version 17 oder h\u00f6her,\n da die Java Versionen kleiner 17 nicht mehr unterst\u00fctzt werden\n und die Funktionsf\u00e4higkeit der Anwendung nicht sichergestellt ist.";

    public static void main(String[] args) {
        VersionCheck versionCheck;
        if (args != null && args.length > 0 && args[0].equals("-s")) {
            silent = true;
        }
        if ((versionCheck = new VersionCheck()).check()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static void errorBox(String infoMessage, String titleBar) {
        JOptionPane.showMessageDialog(null, infoMessage, titleBar, 0);
    }

    private boolean check() {
        double javaVersion = this.getVersion();
        logger.setLevel(Level.ALL);
        if (javaVersion < 17.0) {
            this.meldung = this.meldung + "\n Gefundene Version: " + this.strVersion;
            System.out.println(this.meldung);
            VersionCheck.errorBox(this.meldung, "Fehler: Java Version veraltet.");
            return false;
        }
        return true;
    }

    private double getVersion() {
        String version;
        this.strVersion = version = System.getProperty("java.version");
        if (version == null) {
            if (!silent) {
                VersionCheck.errorBox("No Java Installation Found.", "ERROR");
            }
            return 0.0;
        }
        int pos = version.indexOf(46);
        int intversion = 0;
        try {
            if (version.startsWith("1.")) {
                version = version.substring(2, 3);
            } else {
                int dot = version.indexOf(".");
                if (dot != -1) {
                    version = version.substring(0, dot);
                }
            }
            intversion = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            if (!silent) {
                VersionCheck.errorBox("Error parsing Java-Verison.", "ERROR");
            }
            return 0.0;
        }
        return intversion;
    }
}

