/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.kvdt.common.Sadt0Handler;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;

public class F5000Handler
extends Sadt0Handler {
    public F5000Handler(String sXPath) throws XPMException {
        super(sXPath);
    }

    @Override
    public void elementStart() throws XPMException {
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            sValue_ = this.m_Element.getValue();
            Date datum = this.getDate(sValue_);
            if (f5000oldestValue != null) {
                if (datum.before(f5000oldestValue)) {
                    f5000oldestValue = datum;
                }
            } else {
                f5000oldestValue = datum;
            }
            if (datum != null) {
                if (f4214 != null && m_nSatzart == 2) {
                    if (datum.before(f4214)) {
                        m_MeldungPool.addMeldung("KVDT-R899");
                    }
                    ZoneId defaultZoneId = ZoneId.systemDefault();
                    Instant datumInstant = datum.toInstant();
                    Instant f4214Instant = f4214.toInstant();
                    LocalDate localDateF5000 = datumInstant.atZone(defaultZoneId).toLocalDate();
                    LocalDate localDateF4214plus1Monat = f4214Instant.atZone(defaultZoneId).toLocalDate().plusMonths(1L);
                    if (localDateF4214plus1Monat.isBefore(localDateF5000)) {
                        m_MeldungPool.addMeldung("KVDT-R900");
                    }
                }
                if (m_dateLeistung == null || datum.after(m_dateLeistung)) {
                    m_dateLeistung = datum;
                } else if (datum.before(m_dateLeistung)) {
                    m_MeldungPool.addMeldung("KVDT-FSORT", m_DateFormat10.format(m_dateLeistung));
                }
                this.pruefeRegel304(datum, "Leistungstag (Feld 5000)");
                this.pruefeRegel313(datum, m_dateGeburt, "Geburtsdatum des Patienten");
            }
            this.pruefeRegel315();
            this.pruefeRegel324();
            if (m_nSatzart == 1 || m_nSatzart == 2 || m_nSatzart == 4) {
                this.pruefeRegel363();
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "F5000Handler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
    }
}

