/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.format.Util;
import de.kbv.xpm.core.stamm.EBM.Gnr;
import de.kbv.xpm.core.stamm.HGNC.HGNCKey;
import de.kbv.xpm.core.stamm.KRW.pruefung.ICD;
import de.kbv.xpm.core.stamm.KTS.SatzKTS;
import de.kbv.xpm.core.stamm.OPS.Opscode;
import de.kbv.xpm.core.stamm.keytab.Key;
import de.kbv.xpm.modul.kvdt.common.AbstractScon0Handler;
import de.kbv.xpm.modul.kvdt.common.FallInfo;
import de.kbv.xpm.modul.kvdt.common.GNRInfo;
import de.kbv.xpm.modul.kvdt.common.ScheinInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class Sadt0Handler
extends AbstractScon0Handler {
    protected static final Pattern opsPattern_ = Pattern.compile("[0-9]-[0-9]{2}[a-zA-Z0-9](\\.){0,1}[a-zA-Z0-9]{0,2}");
    protected static final SimpleDateFormat f4124DateFormat_ = new SimpleDateFormat("ddMMyy");
    protected static final Pattern f4124Pattern_ = Pattern.compile("-[a-zA-Z0-9]-[0-9]{5}");
    protected static final Pattern f4124Pattern2_ = Pattern.compile("[a-zA-Z0-9][0-9]{5}");
    protected static final TreeMap<String, ScheinInfo> m_mapSortierteListe = new TreeMap();
    protected static boolean m_bADTPatientenNr = false;
    protected static boolean m_bScheinNeu = true;
    protected static String m_s4125 = null;
    protected static String m_s4217 = null;
    protected static String m_s4218 = null;
    protected static String m_s4219 = null;
    protected static String m_s4241 = null;
    protected static String s4249 = null;
    protected static Date f4214 = null;
    protected static String s4226 = null;
    protected static String f5050 = "";
    protected static Integer f5077count = 0;
    protected static Integer f5079count = 0;
    protected static Integer f5050count = 0;
    protected static String f5051 = "";
    protected static String f5052 = "";
    protected static Key m_key = null;
    protected static final HashSet<String> setGNR_ = new HashSet();
    protected static final HashSet<ICD> setICD_ = new HashSet();
    protected static final HashSet<ICD> setICD6001_ = new HashSet();
    protected static final HashSet<String> setBAR_ = new HashSet();
    protected static ICD icd_ = null;
    protected static HashSet<String> setZusatzangabe_ = null;
    protected static TreeMap<String, String[]> mapRVZMeldungen_ = new TreeMap();
    protected static Gnr gnr_ = null;
    protected static boolean bPruefung703_ = false;
    protected static boolean bPruefung704_ = false;
    protected static boolean b010xSatz_ = false;
    protected static boolean regel828 = false;
    protected static boolean regel843 = false;
    protected static boolean regel854 = false;
    protected static boolean regel829 = false;
    protected static boolean regel830 = false;
    protected static HashSet<String> setFK4253 = new HashSet();
    protected static HashSet<String> setFK4256 = new HashSet();
    protected static HashSet<String> setFK5098 = new HashSet();
    protected static String fk5075value;
    protected static String fk5074value;
    protected static String f9102;
    protected static String f0132;

    public Sadt0Handler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public final void addListData(ScheinInfo schein, Integer count, String sVKNR_KTAB, String sKTName) throws Exception {
        try {
            String sSatzart = this.getSatzBezeichnung(schein.m_nSatzart, schein.m_nSU);
            if (schein.m_bScheinAbgabe) {
                if (m_bADTPatientenNr) {
                    ScheinAbgabeListe.addData(sVKNR_KTAB, sKTName, count, schein.m_sNr, schein.m_sGeburt, schein.m_sQuartal, schein.m_sMFR, sSatzart, schein.m_sEinlesetag);
                } else {
                    ScheinAbgabeListe.addData(sVKNR_KTAB, sKTName, count, schein.m_sName, schein.m_sGeburt, schein.m_sQuartal, schein.m_sMFR, sSatzart, schein.m_sEinlesetag);
                }
            }
            if (m_bUeScheinAbgabe && schein.m_bUeSchein) {
                UeScheinAbgabeListe.addData(sVKNR_KTAB, sKTName, count, schein.m_sName, schein.m_sGeburt, schein.m_sQuartal, schein.m_sMFR, sSatzart, schein.m_sEinlesetag);
            }
            if (m_bUeScheinPlusAbgabe && (schein.m_bScheinAbgabe || schein.m_bUeSchein)) {
                UeScheinPlusAbgabeListe.addData(sVKNR_KTAB, sKTName, count, schein.m_sName, schein.m_sGeburt, schein.m_sQuartal, schein.m_sMFR, sSatzart, schein.m_sEinlesetag);
            }
            if (schein.m_bDokuAbgabe) {
                if (m_bADTPatientenNr) {
                    DokuAbgabeListe.addData(sVKNR_KTAB, sKTName, count, schein.m_sNr, schein.m_sGeburt, schein.m_sQuartal, schein.m_sMFR, sSatzart, schein.m_sEinlesetag);
                } else {
                    DokuAbgabeListe.addData(sVKNR_KTAB, sKTName, count, schein.m_sName, schein.m_sGeburt, schein.m_sQuartal, schein.m_sMFR, sSatzart, schein.m_sEinlesetag);
                }
            }
            SortierListe.addData(sVKNR_KTAB, sKTName, count, schein.m_sName, schein.m_sGeburt, schein.m_sQuartal, schein.m_sMFR, sSatzart, schein.m_sEinlesetag);
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (addListData)");
        }
    }

    public final void addKlammerData(ScheinInfo schein2, Integer count, String sVKNR_KTAB, String sKTName) throws Exception {
        try {
            int nKlammerCount = 0;
            Iterator<ScheinInfo> iter = m_mapKlammerScheine.getIterator((Object)String.valueOf(schein2.m_nKlammerId));
            m_mapSortierteListe.clear();
            while (iter.hasNext()) {
                schein2 = (ScheinInfo)iter.next();
                m_sBuffer.replace(m_kvx6.getKlammerFolge(String.valueOf(schein2.m_nSU), schein2.m_sAbrG)).append(++nKlammerCount);
                m_mapSortierteListe.put(m_sBuffer.toString(), schein2);
            }
            String sKlammerCount = String.valueOf(nKlammerCount);
            for (ScheinInfo schein2 : m_mapSortierteListe.values()) {
                KlammerListe.addData(String.valueOf(schein2.m_nKlammerId), sVKNR_KTAB, sKTName, count, schein2.m_sName, schein2.m_sGeburt, schein2.m_sQuartal, schein2.m_sMFR, this.getSatzBezeichnung(schein2.m_nSatzart, schein2.m_nSU), sKlammerCount);
            }
            iter = m_mapKlammerScheine.getIterator((Object)String.valueOf(schein2.m_nKlammerId));
            m_mapSortierteListe.clear();
            while (iter.hasNext()) {
                schein2 = (ScheinInfo)iter.next();
                m_mapSortierteListe.put(schein2.m_sSortKey, schein2);
            }
            iter = m_mapSortierteListe.values().iterator();
            while (iter.hasNext()) {
                this.addListData(iter.next(), count, sVKNR_KTAB, sKTName);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (addKlammerData)");
        }
    }

    public final void fillFallStatistik(TreeMap<String, FallInfo> faelle, String sFlag) throws Exception {
        try {
            if (faelle.isEmpty()) {
                return;
            }
            for (FallInfo fall : faelle.values()) {
                String sName;
                SatzKTS kt = KTStamm.getKTSSatz(fall.m_sVKNR);
                if (kt == null || (sName = kt.getKTABNameNachFusion(fall.m_sKTAB)) == null) {
                    sName = "Fehlerhafter Kostentr\u00e4ger";
                }
                m_sBuffer.replace(fall.m_sVKNR).append('/').append(fall.m_sKTAB);
                FallListe.addData(m_sBuffer.toString(), sName, new Integer(fall.m_nMStatus), new Integer(fall.m_nFStatus), new Integer(fall.m_nRStatus), new Integer(fall.m_nMStatus + fall.m_nFStatus + fall.m_nRStatus), new Integer(fall.m_nVorQuartal), sFlag);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (fillFallStatistik)");
        }
    }

    @Override
    public final void initSatz() throws Exception {
        try {
            super.initSatz();
            s4226 = "";
            s4249 = "";
            m_s4242 = "";
            m_s4241 = "";
            m_s4219 = "";
            m_s4218 = "";
            m_s4217 = "";
            m_s4125 = "";
            if (m_s0105.length() > 0) {
                m_sGruppe = FehlerListe.newGroup("ADT-Datenpaket, Pr\u00fcfnummer: ");
                m_sGruppe.append(m_s0105).append('|');
            } else {
                m_sGruppe = FehlerListe.newGroup("ADT-Datenpaket|");
            }
            if (!b010xSatz_) {
                b010xSatz_ = true;
            }
            if (bKRWPruefung_) {
                setGNR_.clear();
                setICD_.clear();
                setBAR_.clear();
            }
            setICD6001_.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (initSatz)");
        }
    }

    public final void pruefeOPSRegeln() throws Exception {
        try {
            if (m_nGO == 1 || m_nGO == 2) {
                this.pruefeRegel701();
                this.pruefeRegel702();
                this.m_sValue = m_sBuffer.replace("s010").append(m_nSatzart).append("f5035").toString();
                if (bPruefung703_ && sGNr_ != null && this.m_Element.getChild(this.m_sValue) != null) {
                    m_MeldungPool.addMeldung("KVDT-R703", sGNr_);
                }
                if (bPruefung704_ && sGNr_ != null && this.m_Element.getChild("f5036") != null) {
                    m_MeldungPool.addMeldung("KVDT-R704", sGNr_, sGNr_);
                }
            }
            this.pruefeRegel707();
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeOPSRegeln)");
        }
    }

    public final void pruefeRegel308() throws Exception {
        block5: {
            try {
                if (!m_ScheinQuartal.after(cQUARTAL_12012) || (m_sTmp = this.m_Element.getChildValue("f3006")).length() <= 0) break block5;
                try {
                    int value = Integer.parseInt(m_sTmp.replace(".", ""));
                    if (value < 520) {
                        m_MeldungPool.addMeldung("KVDT-R308");
                    }
                }
                catch (NumberFormatException value) {}
            }
            catch (Exception ex) {
                this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel308)");
            }
        }
    }

    public final void pruefeRegel319() throws Exception {
        try {
            if (m_s4218.length() > 1 && m_s4217.length() > 1 && m_s4218.equals(m_s4217) && m_s4218.length() > 0) {
                m_MeldungPool.addMeldung("KVDT-R319", m_s4217, m_s4218);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel319)");
        }
    }

    public final void pruefeRegel320() throws Exception {
        try {
            if (m_nSU != 27 && m_nSU != 28 && this.m_Element.getChild("f4220") == null) {
                m_MeldungPool.addMeldung("KVDT-R320");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel320)");
        }
    }

    public final void pruefeRegel324() throws Exception {
        try {
            if (m_sQuartal != null && !this.imQuartal(m_sQuartal, sValue_)) {
                m_MeldungPool.addMeldung("KVDT-R324");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel324)");
        }
    }

    public final void pruefeRegel328() throws Exception {
        try {
            if (m_s4218.isEmpty() ^ m_s4219.isEmpty() ^ this.m_Element.getChild("s0102f4226") == null || !m_s4218.isEmpty() && !m_s4219.isEmpty() && this.m_Element.getChild("s0102f4226") != null) {
                m_MeldungPool.addMeldung("KVDT-R328");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel328)");
        }
    }

    public final void pruefeRegel331() throws Exception {
        try {
            if (m_nSU != 0) {
                m_MeldungPool.addMeldung("KVDT-R331");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel331)");
        }
    }

    public final void pruefeRegel354() throws Exception {
        try {
            Date dateVon = new Date();
            Date dateBis = new Date();
            if (!(m_nSU != 30 || this.m_Element.getChild("f4233") != null && this.setDates(this.m_Element.getChildValue("f4233"), dateVon, dateBis))) {
                m_MeldungPool.addMeldung("KVDT-R354");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel354)");
        }
    }

    public final void pruefeRegel356() throws Exception {
        try {
            switch (m_nSU) {
                case 20: 
                case 21: 
                case 23: 
                case 24: 
                case 26: 
                case 27: 
                case 28: {
                    break;
                }
                default: {
                    m_MeldungPool.addMeldung("KVDT-R356");
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel356)");
        }
    }

    public final void pruefeRegel363() throws Exception {
        try {
            if (m_s4125.length() > 0) {
                Date date5000 = this.getDate(sValue_);
                Date dateVon = new Date();
                Date dateBis = new Date();
                if (!this.setDates(m_s4125, dateVon, dateBis)) {
                    m_MeldungPool.addMeldung("KVDT-FDATE", m_s4125, "G\u00fcltigkeitszeitraum von ... bis ... (Feld 4125)");
                    m_s4125 = "";
                } else if (date5000 != null && (date5000.compareTo(dateVon) < 0 || date5000.compareTo(dateBis) > 0)) {
                    m_MeldungPool.addMeldung("KVDT-R363");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel363)");
        }
    }

    public final void pruefeRegel404() throws Exception {
        try {
            if ((m_nSU == 27 || m_nSU == 28) ^ this.m_Element.getChild("f4221") != null) {
                m_MeldungPool.addMeldung("KVDT-R404");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel404)");
        }
    }

    public final void pruefeRegel405() throws Exception {
        try {
            if ((m_nSU == 27 || m_nSU == 28) && this.m_Element.getChild("f4102") == null) {
                m_MeldungPool.addMeldung("KVDT-R405");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel405)");
        }
    }

    public final void pruefeRegel406() throws Exception {
        try {
            String fk9103 = f9103;
            String fk4102 = this.m_Element.getChildValue("f4102");
            Date dateFk9103ErstelDat = null;
            try {
                if (fk9103 != null) {
                    dateFk9103ErstelDat = Util.m_DateFormat.parse(fk9103);
                }
                Date datefk4102AusstelDat = null;
                if (fk4102 != null) {
                    datefk4102AusstelDat = Util.m_DateFormatEN8.parse(fk4102);
                }
                if (datefk4102AusstelDat != null && !fk4102.isEmpty() && (dateFk9103ErstelDat == null || datefk4102AusstelDat.after(dateFk9103ErstelDat))) {
                    m_MeldungPool.addMeldung("KVDT-R406");
                }
            }
            catch (ParseException e) {
                logger_.debug((Object)e);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel406)");
        }
    }

    public final void pruefeRegel426() throws Exception {
        try {
            switch (m_nSU) {
                case 30: 
                case 31: 
                case 32: {
                    break;
                }
                default: {
                    m_MeldungPool.addMeldung("KVDT-R426");
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel426)");
        }
    }

    public final void pruefeRegel427() throws Exception {
        try {
            switch (m_nSU) {
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    break;
                }
                default: {
                    m_MeldungPool.addMeldung("KVDT-R427");
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel427)");
        }
    }

    public final void pruefeRegel431() throws Exception {
        try {
            if (m_nSU != 27 && (m_s4217.length() > 0 || this.m_Element.getChild("s0102f4225") != null)) {
                m_MeldungPool.addMeldung("KVDT-R431");
            }
            if (m_nSU == 27 && m_s4217.length() > 0 && this.m_Element.getChild("s0102f4225") != null) {
                m_MeldungPool.addMeldung("KVDT-R431");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel431)");
        }
    }

    public final void pruefeRegel432() throws Exception {
        try {
            if (m_nSU != 27 && m_nSU != 28 && this.m_Element.getChildValue("f4229").length() > 0) {
                m_MeldungPool.addMeldung("KVDT-R432");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel432)");
        }
    }

    public final void pruefeRegel480() throws Exception {
        try {
            if (m_sEinlesetag.length() > 0 && m_sQuartal != null && !this.imQuartal(m_sQuartal, m_sEinlesetag)) {
                m_MeldungPool.addMeldung("KVDT-R480");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel480)");
        }
    }

    public final void pruefeRegel482() throws Exception {
        try {
            if (m_sEinlesetag.length() > 0 && m_s4113.length() == 1) {
                switch (m_s4113.charAt(0)) {
                    case '1': 
                    case '4': 
                    case '9': 
                    case 'A': 
                    case 'C': 
                    case 'E': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'X': {
                        if (m_sKTAB.equals("00")) break;
                        m_MeldungPool.addMeldung("KVDT-R482");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel482)");
        }
    }

    public final void pruefeRegel486() throws Exception {
        try {
            switch (m_nSatzart) {
                case 1: {
                    if (this.m_Element.getChild("s0101f6001") != null || this.m_Element.getChild("s0101f3673") != null) break;
                    m_MeldungPool.addMeldung("KVDT-R486");
                    break;
                }
                case 2: {
                    if (this.m_Element.getChild("s0102f6001") != null || this.m_Element.getChild("s0102f3673") != null) break;
                    m_MeldungPool.addMeldung("KVDT-R486");
                    break;
                }
                case 3: {
                    if (this.m_Element.getChild("s0103f6001") != null || this.m_Element.getChild("s0103f3673") != null) break;
                    m_MeldungPool.addMeldung("KVDT-R486");
                    break;
                }
                case 4: {
                    if (this.m_Element.getChild("s0104f6001") != null || this.m_Element.getChild("s0104f3673") != null) break;
                    m_MeldungPool.addMeldung("KVDT-R486");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel486)");
        }
    }

    public final void pruefeRegel537(String f3119) throws Exception {
        try {
            if (f3119.equals("T555558879")) {
                m_MeldungPool.addMeldung("KVDT-R537");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Skad0Handler", "Pr\u00fcfung (pruefeRegel537)");
        }
    }

    public void pruefeRegel840() throws XPMException {
        try {
            if (f9102.matches("93|94|95|96") && !f0132.matches("(^.{1,23}$)|(^.{1,23}\\|([0-9][0-9][0-9][0-9])?([a-ku-x][a-z][1-9])*([a-ku-x][A-Z][1-9])*$)")) {
                m_MeldungPool.addMeldung("KVDT-R840", f0132);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel840)");
        }
    }

    public void pruefeRegel860() throws Exception {
        try {
            if ("Z01.7".equals(icd_.getCode())) {
                m_MeldungPool.addMeldung("KVDT-R860", icd_.getCode(), icd_.getDiagnoseSicherheit());
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel860)");
        }
    }

    public void pruefeRegel886() throws Exception {
        try {
            Date f4115plus60Days;
            if (date4115 != null && f5000oldestValue != null && (f4115plus60Days = DateUtils.addDays((Date)date4115, (int)60)).before(f5000oldestValue)) {
                m_MeldungPool.addMeldung("KVDT-R886");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel860)");
        }
    }

    public final void pruefeRegel888(String f5001, String f5050) throws Exception {
        try {
            if (m_nGO != 3 && (f5050 == null || f5050.isEmpty()) && GOStamm.getGnr(f5001) != null && GOStamm.getGnr(f5001).getZusatzangabe() != null && GOStamm.getGnr(f5001).getZusatzangabe().contains("5050")) {
                m_MeldungPool.addMeldung("KVDT-R888", f5001);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel888)");
        }
    }

    public final void pruefeRegel889(String f5001, String f5051) throws Exception {
        try {
            if (m_nGO != 3 && (f5051 == null || f5051.isEmpty()) && GOStamm.getGnr(f5001) != null && GOStamm.getGnr(f5001).getZusatzangabe() != null && GOStamm.getGnr(f5001).getZusatzangabe().contains("5051")) {
                m_MeldungPool.addMeldung("KVDT-R889", f5001);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel889)");
        }
    }

    public final void pruefeRegel890(String f5001, String f5052) throws Exception {
        try {
            if (m_nGO != 3 && (f5052 == null || f5052.isEmpty()) && GOStamm.getGnr(f5001) != null && GOStamm.getGnr(f5001).getZusatzangabe() != null && GOStamm.getGnr(f5001).getZusatzangabe().contains("5052")) {
                m_MeldungPool.addMeldung("KVDT-R890", f5001);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel890)");
        }
    }

    public final void pruefeRegel892(String f5001) throws Exception {
        try {
            if (GOStamm.getGnr(f5001) != null && GOStamm.getGnr(f5001).getZusatzangabe() != null && GOStamm.getGnr(f5001).getZusatzangabe().contains("5077") && f5077count < 1) {
                m_MeldungPool.addMeldung("KVDT-R892");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel892)");
        }
    }

    public void pruefeRegel856() throws Exception {
        try {
            if ("Z01.7".equals(icd_.getCode()) && !"G".equals(icd_.getDiagnoseSicherheit())) {
                m_MeldungPool.addMeldung("KVDT-R856", icd_.getCode(), icd_.getDiagnoseSicherheit());
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel856)");
        }
    }

    public void pruefeRegel022() throws Exception {
        try {
            if (!this.pruefeRegel022(icd_.getCode())) {
                m_MeldungPool.addMeldung("KVDT-R022", sValue_, "6001");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel022)");
        }
    }

    public final void pruefeRegel701() throws Exception {
        try {
            if (setZusatzangabe_ != null && setZusatzangabe_.contains("5034") && this.m_Element.getChild("f5034") == null) {
                m_MeldungPool.addMeldung("KVDT-R701", sGNr_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel701)");
        }
    }

    public final void pruefeRegel702() throws Exception {
        try {
            if (setZusatzangabe_ != null) {
                this.m_sValue = m_sBuffer.replace("s010").append(m_nSatzart).append("f5035").toString();
                if (setZusatzangabe_.contains("5035") && setZusatzangabe_.contains("5036")) {
                    if (this.m_Element.getChild(this.m_sValue) == null && this.m_Element.getChild("f5036") == null) {
                        m_MeldungPool.addMeldung("KVDT-R702", sGNr_, "OP-Schl\u00fcssel im Feld 5035 oder GNR als Begr\u00fcndung im Feld 5036");
                    }
                } else if (setZusatzangabe_.contains("5035") && this.m_Element.getChild(this.m_sValue) == null) {
                    m_MeldungPool.addMeldung("KVDT-R702", sGNr_, "OP-Schl\u00fcssel im Feld 5035");
                } else if (setZusatzangabe_.contains("5036") && this.m_Element.getChild("f5036") == null) {
                    m_MeldungPool.addMeldung("KVDT-R702", sGNr_, "GNR als Begr\u00fcndung im Feld 5036");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel702)");
        }
    }

    public final void pruefeRegel703(String f5035) throws Exception {
        try {
            if (gnr_.getOpsCodes() == null || gnr_.getOpsCode(f5035) || gnr_.getOpsCodes().size() < 1) {
                bPruefung703_ = false;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel703)");
        }
    }

    public final void pruefeRegel704() throws Exception {
        try {
            if (gnr_.getGNrCodes() == null || gnr_.getGNrCode(this.m_Element.getValue()) || gnr_.getGNrCodes().size() < 1) {
                bPruefung704_ = false;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel704)");
        }
    }

    public final void pruefeRegel222(String f5077) throws Exception {
        try {
            HGNCKey hgncCode;
            if (!f5077.equals("999999") && HGNCStamm.isValid() && (hgncCode = HGNCStamm.getKey(f5077)) == null) {
                m_MeldungPool.addMeldung("KVDT-R222", f5077);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel222)");
        }
    }

    public final void pruefeRegel223(String f5035) throws Exception {
        try {
            Opscode opsCode;
            if (OPSStamm.isValid() && (opsCode = OPSStamm.getOpsCode(f5035)) == null) {
                m_MeldungPool.addMeldung("KVDT-R223", f5035);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel223)");
        }
    }

    public final void pruefeRegel705(String f5035) throws Exception {
        try {
            Opscode opsCode;
            if ((m_nGO == 1 || m_nGO == 2) && f5035.length() > 0 && (opsCode = OPSStamm.getOpsCode(f5035)) != null && opsCode.getKzseite().equals("J") && this.m_Element.getChild("f5041") == null) {
                m_MeldungPool.addMeldung("KVDT-R705", f5035);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel705)");
        }
    }

    public final void pruefeRegel707() throws Exception {
        try {
            this.m_sValue = m_sBuffer.replace("s010").append(m_nSatzart).append("f5042").toString();
            if (this.m_Element.getChild(this.m_sValue) != null && this.m_Element.getChild("f5005") != null) {
                m_MeldungPool.addMeldung("KVDT-R707");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel707)");
        }
    }

    public final void pruefeRegel715_723() throws Exception {
        try {
            if (!m_setLANr.contains(m_s5099) && !m_s5099.equals("999999900")) {
                if (m_nSU == 28) {
                    m_MeldungPool.addMeldung("KVDT-R723", m_s5099);
                } else if (!m_bVorQuartal) {
                    m_MeldungPool.addMeldung("KVDT-R715", m_s5099);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel715_723)");
        }
    }

    public final void pruefeRegel716_724() throws Exception {
        try {
            if (!m_setBSNr.contains(sValue_) && m_ScheinQuartal.isValid() && !m_bVorQuartal) {
                if (m_nSU == 28) {
                    m_MeldungPool.addMeldung("KVDT-R724", sValue_);
                } else if (!m_bVorQuartal) {
                    m_MeldungPool.addMeldung("KVDT-R716", sValue_);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel716_724)");
        }
    }

    public final void pruefeRegel789() throws Exception {
        try {
            if (!m_setASVTeamNr.contains(sValue_) && m_ScheinQuartal.isValid() && !m_bVorQuartal) {
                m_MeldungPool.addMeldung("KVDT-R789", sValue_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel789)");
        }
    }

    public final void pruefeRegel839() throws Exception {
        try {
            String value5101 = this.m_Element.getChildValue("f5101");
            if (value5101 != null && !value5101.isEmpty() && !m_setPseudoLANR.contains(value5101) && m_ScheinQuartal.isValid() && !m_bVorQuartal) {
                m_MeldungPool.addMeldung("KVDT-R839", sValue_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel839)");
        }
    }

    public final void pruefeRegel720() throws Exception {
        try {
            if (m_nSU == 28 && !m_s4218.equals("") && !m_s4218.equals(sValue_)) {
                m_MeldungPool.addMeldung("KVDT-R720", m_s4218, sValue_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel720)");
        }
    }

    public final void pruefeRegel721() throws Exception {
        try {
            if (m_nSU == 28 && !m_s4242.isEmpty() && !m_s4242.equals(m_s5099)) {
                m_MeldungPool.addMeldung("KVDT-R721", m_s4242, m_s5099);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel721)");
        }
    }

    public final void pruefeRegel725() throws Exception {
        try {
            if (m_nSU == 28) {
                this.pruefeRegel050(m_s5099, "KVDT-R056", "LANR des Vertragsarztes/ Vertragspsychotherapeuten (Feld 5099)");
            } else {
                this.pruefeRegel050(m_s5099, "KVDT-R050", "LANR des Vertragsarztes/ Vertragspsychotherapeuten (Feld 5099)");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel725)");
        }
    }

    public final void pruefeRegel734() throws Exception {
        block6: {
            try {
                if (m_KT == null || !m_KT.getKTGruppe().equals("75")) break block6;
                sValue_ = this.m_Element.getChildValue("f4124");
                if (sValue_.length() > 7) {
                    m_sTmp = sValue_.substring(6);
                    try {
                        if (f4124DateFormat_.parse(sValue_.substring(0, 6)) == null || !f4124Pattern2_.matcher(m_sTmp).matches()) {
                            m_MeldungPool.addMeldung("KVDT-R734", this.getRegel734Text());
                        }
                        break block6;
                    }
                    catch (ParseException e) {
                        m_MeldungPool.addMeldung("KVDT-R734", this.getRegel734Text());
                    }
                    break block6;
                }
                m_MeldungPool.addMeldung("KVDT-R734", this.getRegel734Text());
            }
            catch (Exception ex) {
                this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel734)");
            }
        }
    }

    public final String getRegel734Text() throws Exception {
        try {
            if (!sValue_.isEmpty()) {
                m_sBuffer.replace("Die Personenkennziffer '").append(sValue_);
                m_sBuffer.append("' entspricht nicht dem erwarterten Format 'TTMMJJannnnn'.");
                return m_sBuffer.toString();
            }
            return "Die SKT-Zusatzangabe (Feld 4124) ist leer.";
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (getRegel734Text)");
            return null;
        }
    }

    public final void pruefeRegel744() throws Exception {
        try {
            if (m_nSU == 21 && this.m_Element.getChild("f4205") == null) {
                m_MeldungPool.addMeldung("KVDT-R744");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel744)");
        }
    }

    public final void pruefeRegel754() throws Exception {
        try {
            if (m_nSU == 28 && (sValue_ = this.m_Element.getChildValue("f4221")) != null && sValue_.equals("3")) {
                m_MeldungPool.addMeldung("KVDT-R754");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel754)");
        }
    }

    public final void pruefeRegel755() throws Exception {
        try {
            if (m_nSU == 27 && this.m_Element.getChild("f4205") == null) {
                m_MeldungPool.addMeldung("KVDT-R755");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel755)");
        }
    }

    public final void pruefeRegel756() throws Exception {
        try {
            if (m_nSU != 28 && this.m_Element.getChild("f4209") != null) {
                m_MeldungPool.addMeldung("KVDT-R756");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel756)");
        }
    }

    public final void pruefeRegel746() throws Exception {
        try {
            if (m_nSU == 31 && (m_s4218.isEmpty() || this.m_Element.getChild("f4205") == null && this.m_Element.getChild("f4207") == null && this.m_Element.getChild("f4208") == null)) {
                m_MeldungPool.addMeldung("KVDT-R746");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel746)");
        }
    }

    public final void pruefeRegel749() throws Exception {
        try {
            if (bRVSA_ && mapRVZ_.containsKey((Object)sGNr_)) {
                boolean bFound = false;
                Iterator iter = mapRVZ_.getIterator((Object)sGNr_);
                HashSet<String> setMaterialien = new HashSet<String>();
                HashSet<String> setAnalytId = new HashSet<String>();
                while (iter.hasNext()) {
                    Key key = (Key)iter.next();
                    String s0305 = (String)mapAnalytID_.get(key.getId());
                    if (s0305 != null && (s0305.equals("1") || s0305.equals("2"))) {
                        bFound = true;
                        break;
                    }
                    setMaterialien.add(key.getForeignValue());
                    setAnalytId.add(key.getValue());
                }
                if (!bFound) {
                    String[] param = new String[]{sGNr_, setMaterialien.toString(), setAnalytId.toString()};
                    mapRVZMeldungen_.put(sGNr_, param);
                    mapRVZ_.remove((Object)sGNr_);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel749)");
        }
    }

    public final void pruefe5098_5099() throws Exception {
        try {
            if (!m_a5000er.contains("f5099") && !m_a5000er.contains("f5101")) {
                m_MeldungPool.addMeldung("KVDT-FEHL", sGNr_, "Lebenslange Arztnummer (LANR) des Vertragsarztes/ Vertragspsychotherapeuten (Feld 5099) bzw. Pseudo-LANR (f\u00fcr Krankenhaus\u00e4rzte im Rahmen der ASV-Abrechnung) des LE (Feld 5101)");
            }
            if (!m_a5000er.contains("f5098") && !m_a5000er.contains("f5102")) {
                m_MeldungPool.addMeldung("KVDT-FEHL", sGNr_, "(N)BSNR des Ortes der Leistungserbringung (Feld 5098)");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefe5098_5099)");
        }
    }

    public final void pruefeRegel770_828_829() throws Exception {
        try {
            if ((sGNr_.matches("11511[A-Z]?") || sGNr_.matches("11512[A-Z]?") || sGNr_.matches("11516[A-Z]?") || sGNr_.matches("11517[A-Z]?") || sGNr_.matches("11518[A-Z]?") || sGNr_.matches("11521[A-Z]?")) && (f5077count != 1 || f5079count != 1)) {
                m_MeldungPool.addMeldung("KVDT-R770");
            }
            if (sGNr_.matches("11302[A-Z]?") || sGNr_.matches("11303[A-Z]?") || sGNr_.matches("19402[A-Z]?")) {
                regel828 = true;
                if (f5077count > 0 || f5079count > 0) {
                    m_MeldungPool.addMeldung("KVDT-R828");
                    regel828 = false;
                }
            }
            if ((sGNr_.matches("11513[A-Z]?") || sGNr_.matches("11522[A-Z]?")) && (f5077count < 1 || f5079count < 1)) {
                m_MeldungPool.addMeldung("KVDT-R834");
            }
            if (sGNr_.matches("19424[A-Z]?") || sGNr_.matches("19453[A-Z]?") || sGNr_.matches("19456[A-Z]?")) {
                regel830 = true;
                if (f5077count < 1) {
                    m_MeldungPool.addMeldung("KVDT-R830");
                    regel830 = false;
                }
                if (f5079count < 1) {
                    m_MeldungPool.addMeldung("KVDT-R848");
                }
            }
            if (sGNr_.matches("19421[A-Z]?") || sGNr_.matches("19451[A-Z]?") || sGNr_.matches("19452[A-Z]?")) {
                regel829 = true;
                if (f5077count != 1) {
                    m_MeldungPool.addMeldung("KVDT-R829");
                    regel829 = false;
                }
                if (f5079count != 1) {
                    m_MeldungPool.addMeldung("KVDT-R847");
                }
            }
            if (sGNr_.matches("32901[A-Z]?") || sGNr_.matches("32902[A-Z]?") || sGNr_.matches("32904[A-Z]?") || sGNr_.matches("32906[A-Z]?") || sGNr_.matches("32908[A-Z]?") || sGNr_.matches("32910[A-Z]?") || sGNr_.matches("32911[A-Z]?")) {
                regel843 = true;
                if (f5077count > 0 || f5079count > 0) {
                    m_MeldungPool.addMeldung("KVDT-R843");
                    regel843 = false;
                }
            }
            if (sGNr_.matches("32915[A-Z]?") || sGNr_.matches("32916[A-Z]?") || sGNr_.matches("32917[A-Z]?") || sGNr_.matches("32918[A-Z]?")) {
                regel854 = true;
                if (f5077count > 0 || f5079count > 0) {
                    m_MeldungPool.addMeldung("KVDT-R854");
                    regel854 = false;
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel770_828_829)");
        }
    }

    public final void pruefeRegel816() throws Exception {
        try {
            String sTemp5078;
            if (sGNr_.matches("11233[A-Z]?") && (this.m_Element.getChild(sTemp5078 = m_sBuffer.replace("s010").append(m_nSatzart).append("f5078").toString()) != null || f5079count < 1 || f5077count > 0)) {
                m_MeldungPool.addMeldung("KVDT-R816");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel816)");
        }
    }

    public final void pruefeRegel868(String f5001, String f5010) throws Exception {
        try {
            if ((f5010 == null || f5010.isEmpty()) && GOStamm.getGnr(f5001) != null && GOStamm.getGnr(f5001).getZusatzangabe() != null && GOStamm.getGnr(f5001).getZusatzangabe().contains("5010")) {
                m_MeldungPool.addMeldung("KVDT-R868", f5001);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel868)");
        }
    }

    public final void pruefeRegel869() throws Exception {
        try {
            String sf3010 = this.m_Element.findChildValue("s010" + m_nSatzart + "f3010/f3010");
            if (!sf3010.isEmpty() && !m_bVorQuartal) {
                boolean hasKonnektorVersion = false;
                for (String bsnr : setFK5098) {
                    String KNV = (String)m_BSN_KNV.get(bsnr);
                    if (KNV == null || KNV.isEmpty() || "0".equals(KNV)) continue;
                    hasKonnektorVersion = true;
                }
                if (!hasKonnektorVersion) {
                    m_MeldungPool.addMeldung("KVDT-R869");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel869)");
        }
    }

    public final void pruefeRegel876() throws Exception {
        try {
            String f4109 = this.m_Element.findChildValue("f4109");
            if (!StringUtils.isEmpty((CharSequence)f3010) && StringUtils.isEmpty((CharSequence)f4109)) {
                m_MeldungPool.addMeldung("KVDT-R876");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel876)");
        }
    }

    public final void pruefeRegel894() throws Exception {
        try {
            if (!StringUtils.isEmpty((CharSequence)f5050) && !StringUtils.isEmpty((CharSequence)f5005) && f5050count != Integer.parseInt(f5005)) {
                m_MeldungPool.addMeldung("KVDT-R894");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel894)");
        }
    }

    public final void checkICDSetForZ01_7(String meldungNr) throws Exception {
        try {
            if (setICD6001_.isEmpty()) {
                m_MeldungPool.addMeldung(meldungNr);
            } else {
                boolean icdOhneZ017gefunden = false;
                for (ICD icd : setICD6001_) {
                    if (icd.getCode().matches("Z01.7")) continue;
                    icdOhneZ017gefunden = true;
                    break;
                }
                if (!icdOhneZ017gefunden) {
                    m_MeldungPool.addMeldung(meldungNr);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (checkICDSetForZ01_7)");
        }
    }

    public final void pruefeRegel828_829_830_843_854() throws Exception {
        try {
            if (regel828) {
                this.checkICDSetForZ01_7("KVDT-R828");
            }
            if (regel829) {
                this.checkICDSetForZ01_7("KVDT-R829");
            }
            if (regel830) {
                this.checkICDSetForZ01_7("KVDT-R830");
            }
            if (regel843) {
                this.checkICDSetForZ01_7("KVDT-R843");
            }
            if (regel854) {
                this.checkICDSetForZ01_7("KVDT-R854");
            }
            regel828 = false;
            regel830 = false;
            regel829 = false;
            regel843 = false;
            regel854 = false;
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (pruefeRegel828_829_830_843_854)");
        }
    }

    public final void rvzAusgabe() throws Exception {
        try {
            if (mapRVZMeldungen_.size() > 0) {
                if (m_s0105.length() > 0) {
                    m_sGruppe = FehlerListe.newGroup("ADT-Datenpaket, Pr\u00fcfnummer: ");
                    m_sGruppe.append(m_s0105).append('|');
                } else {
                    m_sGruppe = FehlerListe.newGroup("ADT-Datenpaket|");
                }
                m_sGruppe.append("Meldungen zu Ringversuchs-Zertifikaten");
                m_sGeburt = null;
                m_s3000 = null;
                m_s3003 = null;
                m_sAbrG = null;
                m_sGO = null;
                m_sKTAB = null;
                m_sMFR = new String();
                m_sName = null;
                m_sVorname = null;
                m_sQuartal = null;
                m_sSU = null;
                m_sVKNR = null;
                m_sAbrA = null;
                Iterator<String[]> iter = mapRVZMeldungen_.values().iterator();
                while (iter.hasNext()) {
                    m_MeldungPool.addMeldung("KVDT-R749", iter.next());
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (rvzAusgabe)");
        }
    }

    public final void setFehlerGruppe() throws Exception {
        try {
            m_sGruppe.append(m_sName).append(", ").append(m_sVorname);
            if (m_sGeburt != null) {
                m_sGruppe.append(", ").append(m_sGeburt);
            }
            m_sGruppe.append(", VKNR/KTAB: ").append(m_sVKNR).append('/').append(m_sKTAB).append(", ").append(m_ScheinQuartal.toString()).append(", ").append(this.getSatzBezeichnung(m_nSatzart, m_nSU)).append(", Status: ").append(this.getStatus(m_sMFR));
            if (m_s3000 != null) {
                m_sGruppe.append(", Int.: ").append(m_s3000);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (setFehlerGruppe)");
        }
    }

    public final void writeGNRStatistik() throws Exception {
        try {
            if (m_mapLANR.isEmpty() || !GNRListe.getValid()) {
                return;
            }
            progress_.setText("Generiere GNR-Statistikliste...");
            this.setReportParameter(GNRListe, "KBV-Pr\u00fcfmodul GNR-Statistik (KVDT/ADT, " + cVERSION + "-Version)");
            for (TreeMap map : m_mapLANR.values()) {
                for (GNRInfo m_gnrInfo : map.values()) {
                    int nSumme = Sadt0Handler.m_gnrInfo.m_nSatz0101 + Sadt0Handler.m_gnrInfo.m_nSatz0102 + Sadt0Handler.m_gnrInfo.m_nSatz0103 + Sadt0Handler.m_gnrInfo.m_nSatz0104;
                    GNRListe.addData(Sadt0Handler.m_gnrInfo.m_sLANR, Sadt0Handler.m_gnrInfo.m_sGNR, new Integer(nSumme), new Integer(nSumme - Sadt0Handler.m_gnrInfo.m_nVorQuartal), new Integer(Sadt0Handler.m_gnrInfo.m_nVorQuartal), new Integer(Sadt0Handler.m_gnrInfo.m_nSatz0101), new Integer(Sadt0Handler.m_gnrInfo.m_nSatz0102), new Integer(Sadt0Handler.m_gnrInfo.m_nSatz0103), new Integer(Sadt0Handler.m_gnrInfo.m_nSatz0104));
                }
            }
            GNRListe.write();
            m_mapLANR.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (writeGNRStatistik)");
        }
    }

    @Override
    public final void setValues() throws Exception {
        try {
            super.setValues();
            m_sBuffer.replace("s010").append(m_nSatzart).append("f4217/f4217");
            m_s4217 = this.m_Element.findChildValue(m_sBuffer.toString());
            m_sBuffer.replace("s010").append(m_nSatzart).append("f4218/f4218");
            m_s4218 = this.m_Element.findChildValue(m_sBuffer.toString());
            m_s4219 = this.m_Element.getChildValue("f4219");
            this.setFehlerGruppe();
            if (m_nSU == 27) {
                if (m_s4218.length() != 0) {
                    ++m_nSU27_4218;
                } else if (m_s4219.length() != 0) {
                    ++m_nSU27_4219;
                }
            }
            if (m_nSatzart == 2) {
                if (m_s4218.length() != 0) {
                    ++m_nUe_4218;
                } else if (m_s4219.length() != 0) {
                    ++m_nUe_4219;
                }
            }
            m_bScheinNeu = true;
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (setValues)");
        }
    }

    public final void writeKlammerListe() throws Exception {
        try {
            if (m_mapKlammerScheine.isEmpty()) {
                return;
            }
            progress_.setText("Generiere Klammerliste...");
            KlammerListe.write();
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (writeKlammerListe)");
        }
    }

    public final void writeFallStatistik() throws Exception {
        try {
            if (!(!FallListe.getValid() || m_bInterrupt || m_mapFallAmbulant.isEmpty() && m_mapFallStationaer.isEmpty())) {
                progress_.setText("Generiere Fallstatistikliste...");
                this.setReportParameter(FallListe, "KBV-Pr\u00fcfmodul Fallstatistik (KVDT, " + cVERSION + "-Version)");
                this.fillFallStatistik(m_mapFallAmbulant, "Ambulant");
                this.fillFallStatistik(m_mapFallStationaer, "Station\u00e4r");
                FallListe.write();
                m_mapFallAmbulant.clear();
                m_mapFallStationaer.clear();
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (writeFallStatistik)");
        }
    }

    public final void writeListen() throws Exception {
        try {
            if (m_mapSortierListe.getMap().isEmpty() || m_bInterrupt) {
                return;
            }
            String sLastKey = "";
            int nCount = 0;
            int nGroupLength = m_kvx4.getSortKeyGroupLength();
            m_mapScheine.clear();
            this.setReportParameter(ScheinAbgabeListe, "KBV-Pr\u00fcfmodul Abgabe Behandlungsscheine (KVDT, " + cVERSION + "-Version)");
            this.setReportParameter(UeScheinAbgabeListe, "KBV-Pr\u00fcfmodul Abgabe \u00dcberweisungsscheine (KVDT, " + cVERSION + "-Version)");
            this.setReportParameter(UeScheinPlusAbgabeListe, "KBV-Pr\u00fcfmodul Abgabe \u00dcberweisung- und Behandlungs-Scheine (KVDT, " + cVERSION + "-Version)");
            this.setReportParameter(DokuAbgabeListe, "KBV-Pr\u00fcfmodul Abgabe Dokumentationsb\u00f6gen (KVDT, " + cVERSION + "-Version)");
            this.setReportParameter(SortierListe, "KBV-Pr\u00fcfmodul Sortierliste (KVDT, " + cVERSION + "-Version)");
            if (m_bKlammern && KlammerListe.getValid()) {
                this.setReportParameter(KlammerListe);
            }
            Iterator iter = m_mapSortierListe.values().iterator();
            while (iter.hasNext()) {
                String sKTName;
                ScheinInfo schein = (ScheinInfo)m_mapSortierListe.get((Long)iter.next());
                SatzKTS kt = KTStamm.getKTSSatz(schein.m_sVKNR);
                if (kt == null || (sKTName = kt.getKTABNameNachFusion(schein.m_sKTAB)) == null) {
                    sKTName = "Fehlerhafter Kostentr\u00e4ger";
                }
                if (sLastKey.equals(schein.m_sSortKey.substring(0, nGroupLength))) {
                    schein.m_nFallNr = ++nCount;
                } else {
                    schein.m_nFallNr = 1;
                    nCount = 1;
                    sLastKey = schein.m_sSortKey.substring(0, nGroupLength);
                }
                ++m_nFaelle;
                String sVKNR_KTAB = m_sBuffer.replace(schein.m_sVKNR).append('/').append(schein.m_sKTAB).toString();
                if (m_bKlammern && schein.m_nKlammerId > 0) {
                    this.addKlammerData(schein, new Integer(schein.m_nFallNr), sVKNR_KTAB, sKTName);
                    continue;
                }
                this.addListData(schein, new Integer(schein.m_nFallNr), sVKNR_KTAB, sKTName);
            }
            iter = null;
            if (ScheinAbgabeListe.getDataSize() > 0 && !m_bInterrupt) {
                progress_.setText("Generiere Scheinabgabeliste...");
                ScheinAbgabeListe.write();
            }
            if (m_bUeScheinAbgabe && UeScheinAbgabeListe.getDataSize() > 0 && !m_bInterrupt) {
                progress_.setText("Generiere Ue-Scheinliste...");
                UeScheinAbgabeListe.write();
            }
            if (m_bUeScheinPlusAbgabe && UeScheinPlusAbgabeListe.getDataSize() > 0 && !m_bInterrupt) {
                progress_.setText("Generiere Ue-Schein- und Abgabeliste...");
                UeScheinPlusAbgabeListe.write();
            }
            if (DokuAbgabeListe.getDataSize() > 0 && !m_bInterrupt) {
                progress_.setText("Generiere Dokumentationsabgabeliste...");
                DokuAbgabeListe.write();
            }
            if (SortierListe.getDataSize() > 0 && !m_bInterrupt) {
                progress_.setText("Generiere Sortierliste...");
                SortierListe.write();
            }
            if (m_bKlammern && KlammerListe.getValid() && !m_bInterrupt) {
                this.writeKlammerListe();
            }
            m_mapSortierListe.close();
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung (writeListen)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        try {
            if (!this.pruefeKVSpezifika()) {
                return;
            }
            this.setDatenpaket(1);
            m_bUeScheinAbgabe = !m_KVStamm.getSatzkvx5().getFeld9473().equals("0") && UeScheinAbgabeListe.getValid();
            m_bUeScheinPlusAbgabe = !m_KVStamm.getSatzkvx5().getFeld9474().equals("0") && UeScheinPlusAbgabeListe.getValid();
            sValue_ = m_DatenPool.getString("adt_interne_patientennummer");
            m_bADTPatientenNr = sValue_ != null && sValue_.equalsIgnoreCase("ja");
            f4124DateFormat_.setLenient(false);
            m_nFaelle = 0;
            this.clearListen();
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Initialisierung");
        }
    }

    public void elementEnde() throws XPMException {
        try {
            this.pruefeRegel840();
            this.rvzAusgabe();
            progress_.setText("Generiere ADT Listen...");
            this.writeGNRStatistik();
            this.writeListen();
            this.writeFallStatistik();
            if (!b010xSatz_) {
                m_MeldungPool.addMeldung("KVDT-FSATZ", "ADT", "Ambulante Behandlung (Satzart 0101), \u00dcberweisung (Satzart 0102), Beleg\u00e4rztliche Behandlung (Satzart 0103) oder Notfalldienst/Vertretung/Notfall (Satzart 0104)");
            }
            m_nFaelleGesamt += m_nFaelle;
            m_nScheineGesamt += m_nScheine;
        }
        catch (Exception ex) {
            this.catchException(ex, "Sadt0Handler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        m_bADTPatientenNr = false;
        m_bScheinNeu = true;
        m_s4125 = null;
        m_s4217 = null;
        m_s4218 = null;
        m_s4219 = null;
        m_s4241 = null;
        s4249 = null;
        s4226 = null;
        f0132 = "";
        f9102 = "";
        m_key = null;
        icd_ = null;
        setZusatzangabe_ = null;
        mapRVZMeldungen_ = new TreeMap();
        gnr_ = null;
        bPruefung703_ = false;
        bPruefung704_ = false;
        b010xSatz_ = false;
        setFK5098 = new HashSet();
        regel828 = false;
        regel843 = false;
        regel829 = false;
        regel830 = false;
        regel854 = false;
        f5050 = "";
        f5051 = "";
        f5052 = "";
        f5005 = "";
    }

    static {
        f9102 = "";
        f0132 = "";
    }
}

