/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.common.zip;

import de.kbv.common.zip.KbvZipFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class KbvZipOutputStream
extends OutputStream {
    static final int BUFFERSIZE = 256;
    protected OutputStream outputStream;
    protected KbvZipFormat vdxZipFormat;
    protected ZipOutputStream zos = null;
    protected FileOutputStream fos = null;
    protected byte[] bBuffered = new byte[256];
    protected int nBuffered = 0;
    protected static boolean bAutoSuffix = true;

    public static void setAutoSuffix(boolean bAutoSuffix) {
        KbvZipOutputStream.bAutoSuffix = bAutoSuffix;
    }

    public KbvZipOutputStream(String sZipFilename, String sCompressedFilename, KbvZipFormat vdxZipFormat) throws FileNotFoundException, IOException {
        if (vdxZipFormat == KbvZipFormat.GZIP) {
            if (bAutoSuffix && !((String)sZipFilename).toLowerCase().endsWith(".gz")) {
                sZipFilename = (String)sZipFilename + ".gz";
            }
            this.fos = new FileOutputStream((String)sZipFilename);
            this.outputStream = new GZIPOutputStream(this.fos);
        } else if (vdxZipFormat == KbvZipFormat.ZIP) {
            if (bAutoSuffix && !((String)sZipFilename).toLowerCase().endsWith(".zip")) {
                sZipFilename = (String)sZipFilename + ".zip";
            }
            File zipFile = new File((String)sZipFilename);
            this.fos = new FileOutputStream((String)sZipFilename);
            this.zos = new ZipOutputStream(new FileOutputStream(zipFile));
            this.zos.putNextEntry(new ZipEntry(sCompressedFilename));
            this.outputStream = this.zos;
        }
        this.vdxZipFormat = vdxZipFormat;
    }

    @Override
    public void close() throws IOException {
        if (this.nBuffered != 0) {
            this.outputStream.write(this.bBuffered, 0, this.nBuffered);
            this.nBuffered = 0;
        }
        if (this.zos != null && this.vdxZipFormat == KbvZipFormat.ZIP) {
            this.zos.closeEntry();
        }
        this.outputStream.close();
        if (this.fos != null) {
            this.fos.close();
        }
    }

    @Override
    public void write(int arg0) throws IOException {
        if (this.nBuffered == 256) {
            this.outputStream.write(this.bBuffered);
            this.nBuffered = 0;
        }
        this.bBuffered[this.nBuffered] = (byte)arg0;
        ++this.nBuffered;
    }
}

