/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.splitmodul;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileConcat {
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    protected String m_sZiel;
    protected String m_sQuelle;
    protected boolean m_bDeleteSource;
    protected long m_nHeaderSize;
    protected long m_nTrailerSize;
    protected int m_nFileCounter;
    protected int m_nMaxFiles;
    protected String m_sFileMask;

    public FileConcat(String sQuelle, String sFileMask, int nMaxFiles, String sZiel, boolean bDeleteSource) {
        this(sQuelle, sFileMask, nMaxFiles, sZiel, bDeleteSource, 0L, 0L);
    }

    public FileConcat(String sQuelle, String sFileMask, int nMaxFiles, String sZiel, boolean bDeleteSource, long nHeaderSize, long nTrailerSize) {
        this.m_sZiel = sZiel;
        this.m_sFileMask = sFileMask;
        this.m_nMaxFiles = nMaxFiles;
        this.m_sQuelle = sQuelle;
        this.m_bDeleteSource = bDeleteSource;
        this.m_nHeaderSize = nHeaderSize;
        this.m_nTrailerSize = nTrailerSize;
        if (!this.isDirectory(this.m_sQuelle) && new File(this.m_sQuelle).isDirectory()) {
            this.m_sQuelle = this.m_sQuelle + "/";
        }
        if (!this.isDirectory(this.m_sZiel) && new File(this.m_sZiel).isDirectory()) {
            this.m_sZiel = this.m_sZiel + "/";
        }
    }

    private boolean isDirectory(String sFileOderDir) {
        return sFileOderDir.endsWith("\\") || sFileOderDir.endsWith("/");
    }

    private String getFirstFile(File verzeichnis) throws IOException {
        String sReturn = this.m_sQuelle + this.m_sFileMask + ".001";
        if (!new File(sReturn).isFile()) {
            return null;
        }
        return sReturn;
    }

    private String getNextFile(File verzeichnis) throws IOException {
        Object sSuffix = "000" + (this.m_nFileCounter + 1);
        String sReturn = this.m_sQuelle + this.m_sFileMask + "." + (String)(sSuffix = ((String)sSuffix).substring(((String)sSuffix).length() - 3, ((String)sSuffix).length()));
        if (!new File(sReturn).isFile()) {
            return null;
        }
        return sReturn;
    }

    protected void afterOpen(BufferedInputStream to) {
    }

    protected void beforeClose(BufferedInputStream to) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int perform() {
        File zielDatei = new File(this.m_sZiel);
        File fQuelle = new File(this.m_sQuelle);
        if (!this.isDirectory(this.m_sQuelle)) {
            return 1;
        }
        if (fQuelle.isDirectory() && !fQuelle.exists()) {
            LOG.error("Das Verzeichnis " + fQuelle + " existiert nicht");
            return 2;
        }
        if (this.isDirectory(this.m_sZiel) && !zielDatei.isDirectory()) {
            LOG.error("Das Verzeichnis " + this.m_sZiel + " existiert nicht");
            return 2;
        }
        FilterOutputStream to = null;
        BufferedInputStream from = null;
        try {
            String sFile = this.getFirstFile(fQuelle);
            if (sFile != null) {
                this.m_nFileCounter = 0;
                zielDatei = new File(this.m_sZiel);
                if (zielDatei.exists()) {
                    zielDatei.delete();
                }
                if (!zielDatei.createNewFile()) {
                    LOG.error("Fehler beim Erstellen der Datei " + zielDatei);
                    int n = 3;
                    return n;
                }
                to = new BufferedOutputStream(new FileOutputStream(zielDatei, true));
                while (sFile != null && this.m_nFileCounter < this.m_nMaxFiles) {
                    int c;
                    from = new BufferedInputStream(new FileInputStream(sFile));
                    this.afterOpen(from);
                    from.skip(this.m_nHeaderSize);
                    for (long nToCopy = new File(sFile).length() - (this.m_nHeaderSize + this.m_nTrailerSize); (c = from.read()) != -1 && nToCopy > 0L; --nToCopy) {
                        ((BufferedOutputStream)to).write(c);
                    }
                    this.beforeClose(from);
                    from.close();
                    from = null;
                    if (this.m_bDeleteSource) {
                        new File(sFile).delete();
                    }
                    ++this.m_nFileCounter;
                    sFile = this.getNextFile(fQuelle);
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            int n = 4;
            return n;
        }
        finally {
            try {
                if (to != null) {
                    to.close();
                }
                if (from != null) {
                    from.close();
                }
            }
            catch (IOException iOException) {}
        }
        return 0;
    }
}

