/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.protokoll;

import de.kbv.xkm.protokoll.Format;
import java.util.ArrayList;

public class AusgabeFormat {
    static final int cFORMATTEXT = 1;
    static final int cFORMATPDF = 2;
    static final int cFORMATHTML = 3;
    static final int cFORMATXLS = 4;
    static final int cFORMATXML = 5;
    static final int cFORMATJRPRINT = 6;
    static final int cFORMATCSV = 7;
    static final int cFORMATRTF = 8;
    static final int cFORMATPRINTER = 9;
    static final int cFORMATPRINTER_DIALOG = 10;
    static final int cFORMATKEIN = 11;
    private static ArrayList arrlistFormate;
    private static AusgabeFormat ausgabeformat;

    public static AusgabeFormat getInstance() {
        if (ausgabeformat == null) {
            ausgabeformat = new AusgabeFormat();
            ausgabeformat.init();
        }
        return ausgabeformat;
    }

    private AusgabeFormat() {
    }

    private Format getFormat(int nKennung) {
        for (int i = 0; i < arrlistFormate.size(); ++i) {
            Format format = (Format)arrlistFormate.get(i);
            if (format.m_nKennung != nKennung) continue;
            return format;
        }
        return null;
    }

    private void resetFormate() {
        for (int i = 0; i < arrlistFormate.size(); ++i) {
            Format format = (Format)arrlistFormate.get(i);
            format.m_bActive = false;
        }
    }

    private void init() {
        if (arrlistFormate == null) {
            arrlistFormate = new ArrayList();
            arrlistFormate.add(new Format(1, false, "TEXT", ".txt"));
            arrlistFormate.add(new Format(2, false, "PDF", ".pdf"));
            arrlistFormate.add(new Format(3, false, "HTML", ".html"));
            arrlistFormate.add(new Format(4, false, "XLS", ".xls"));
            arrlistFormate.add(new Format(5, false, "XML", ".xml"));
            arrlistFormate.add(new Format(6, false, "JRPRINT", ".jrprint"));
            arrlistFormate.add(new Format(7, false, "CSV", ".csv"));
            arrlistFormate.add(new Format(8, false, "RTF", ".rtf"));
            arrlistFormate.add(new Format(9, false, "PRINTER", "prn"));
            arrlistFormate.add(new Format(10, false, "PRINTER_DIALOG", "prndlg"));
            arrlistFormate.add(new Format(11, false, "KEIN", ""));
        }
    }

    public void setFormatTXT(boolean b) {
        this.resetFormate();
        this.getFormat((int)1).m_bActive = true;
    }

    public void setFormatPDF(boolean b) {
        this.resetFormate();
        this.getFormat((int)2).m_bActive = true;
    }

    public void setFormatHTML(boolean b) {
        this.resetFormate();
        this.getFormat((int)3).m_bActive = true;
    }

    public void setFormatXLS(boolean b) {
        this.resetFormate();
        this.getFormat((int)4).m_bActive = true;
    }

    public void setFormatXML(boolean b) {
        this.resetFormate();
        this.getFormat((int)5).m_bActive = true;
    }

    public void setFormatJRPRINT(boolean b) {
        this.resetFormate();
        this.getFormat((int)6).m_bActive = true;
    }

    public void setFormatCSV(boolean b) {
        this.resetFormate();
        this.getFormat((int)7).m_bActive = true;
    }

    public void setFormatRTF(boolean b) {
        this.resetFormate();
        this.getFormat((int)8).m_bActive = true;
    }

    public void setFormatPRINTER(boolean b) {
        this.resetFormate();
        this.getFormat((int)9).m_bActive = true;
    }

    public void setFormatPRINTERDIALOG(boolean b) {
        this.resetFormate();
        this.getFormat((int)10).m_bActive = true;
    }

    public void setFormatKEIN(boolean b) {
        this.resetFormate();
        this.getFormat((int)11).m_bActive = true;
    }

    public String getDateiEndung(int nFormat) {
        Format format = this.getFormat(nFormat);
        return format.m_sSuffix;
    }

    public boolean istGueltigesFormat(String sName) {
        for (int i = 0; i < arrlistFormate.size(); ++i) {
            Format format = (Format)arrlistFormate.get(i);
            if (!format.m_sName.equalsIgnoreCase(sName)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getAktiveFormate() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < arrlistFormate.size(); ++i) {
            Format format = (Format)arrlistFormate.get(i);
            if (!format.m_bActive) continue;
            arrayList.add(new Integer(format.m_nKennung));
        }
        return arrayList;
    }

    public String getZulaessigeFormate() {
        Object sList = "";
        for (int i = 0; i < arrlistFormate.size(); ++i) {
            Format format = (Format)arrlistFormate.get(i);
            if (i > 0) {
                sList = (String)sList + ", ";
            }
            sList = (String)sList + format.m_sName;
        }
        return sList;
    }
}

