/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.xml;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfigFile
extends DefaultHandler {
    private final HashMap m_xmlProperties = new HashMap();
    private StringBuffer m_sBuffer;
    private static Logger LOG = LogManager.getLogger((String)"xkm");

    public boolean load(String sFile) {
        this.m_xmlProperties.clear();
        XMLConfigFile handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            FileInputStream fis = new FileInputStream(sFile);
            saxParser.parse((InputStream)fis, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            LOG.error((Object)t);
            return false;
        }
        return true;
    }

    public String getSchalter(String sKey) {
        return (String)this.m_xmlProperties.get(sKey.toLowerCase());
    }

    public void setSchalter(String sKey, String sValue) {
        this.m_xmlProperties.put(sKey.toLowerCase(), sValue);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.m_sBuffer = new StringBuffer(256);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String s = this.m_sBuffer.toString().trim();
        if (!s.equals("")) {
            this.m_xmlProperties.put(qName.toLowerCase(), s);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.m_sBuffer.append(buf, offset, len);
    }

    private void saveOblSchalter(FileWriter fw, String sSchalter) throws IOException {
        fw.write(" <" + sSchalter + ">" + this.getSchalter(sSchalter) + "</" + sSchalter + ">\n");
    }

    private void saveOptSchalter(FileWriter fw, String sSchalter) throws IOException {
        String sValue = this.getSchalter(sSchalter);
        if (sValue != null && sValue.trim().length() > 0) {
            this.saveOblSchalter(fw, sSchalter);
        } else {
            fw.write(" <!-- <" + sSchalter + "/>-->\n");
        }
    }

    private void saveOptSchalter(FileWriter fw, String sSchalter, String sSchalterName) throws IOException {
        String sValue = this.getSchalter(sSchalter);
        if (sValue != null && sValue.trim().length() > 0) {
            this.saveOblSchalter(fw, sSchalter);
        } else {
            fw.write(" <!-- <" + sSchalter + "/>-->\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(String sFile) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(sFile);
            fw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fw.write("<!-- automatisch erstellte Konfigurationsdatei -->\n");
            fw.write("<Konfiguration>\n\n");
            this.saveOblSchalter(fw, "quelle");
            this.saveOblSchalter(fw, "ausschuss");
            this.saveOblSchalter(fw, "entschluesselt");
            this.saveOblSchalter(fw, "verschluesselt");
            this.saveOblSchalter(fw, "arbeitsmodus");
            this.saveOptSchalter(fw, "bearbeitetentschluesselt");
            this.saveOptSchalter(fw, "bearbeitetverschluesselt");
            this.saveOptSchalter(fw, "temp");
            this.saveOptSchalter(fw, "protokolldatei");
            this.saveOptSchalter(fw, "system");
            this.saveOptSchalter(fw, "schluesselpfad");
            this.saveOptSchalter(fw, "schluesseldatei");
            this.saveOptSchalter(fw, "protokollformat");
            this.saveOptSchalter(fw, "paketgroesse");
            this.saveOptSchalter(fw, "pruefinfo");
            this.saveOptSchalter(fw, "konfigdialog");
            this.saveOptSchalter(fw, "abrechnungskomprimierung");
            fw.write("\n</Konfiguration>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

