/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.xml;

import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.InternerArbeitsmodus;
import de.kbv.xkm.krypto.KryptTyp;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLInterneArbeitsmodi
extends DefaultHandler {
    public ArrayList m_xmlProperties = new ArrayList();
    private InternerArbeitsmodus m_internerArbeitsmodus;
    private String m_sException;
    private StringBuffer m_sBuffer;
    private String m_sFile;

    public void load(InputStream fis) throws XKMException {
        this.m_xmlProperties.clear();
        this.m_sException = null;
        XMLInterneArbeitsmodi handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(fis, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            throw new XKMException(3, "Fehler beim Parsen der Datei schluesselintern.xml");
        }
        if (this.m_sException != null) {
            throw new XKMException(3, this.m_sException);
        }
    }

    public void load(String sFile) throws XKMException {
        this.m_sFile = sFile;
        try {
            this.load(new FileInputStream(sFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.m_sBuffer = new StringBuffer(256);
        if (qName.toLowerCase().equals("arbeitsmodus")) {
            this.m_internerArbeitsmodus = new InternerArbeitsmodus();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String s;
        if (qName.toLowerCase().equals("arbeitsmodus")) {
            this.m_xmlProperties.add(this.m_internerArbeitsmodus);
        } else if (!qName.toLowerCase().equals("arbeitsmodi") && !(s = this.m_sBuffer.toString().trim()).equals("")) {
            if (qName.toLowerCase().equals("name")) {
                this.m_internerArbeitsmodus.sName = s;
                for (int i = 0; i < this.m_xmlProperties.size(); ++i) {
                    InternerArbeitsmodus ia = (InternerArbeitsmodus)this.m_xmlProperties.get(i);
                    if (!ia.sName.toLowerCase().equals(s.toLowerCase())) continue;
                    this.m_sException = "Doppelte bezeichnete Arbeitsmodi in Datei 'schluesselintern.xml'";
                }
            } else if (qName.toLowerCase().equals("typ")) {
                if (!s.toLowerCase().equals("verschluesselung") && !s.toLowerCase().equals("entschluesselung")) {
                    this.m_sException = "Ung\u00fcltiger Wert zu Element 'typ'";
                } else {
                    this.m_internerArbeitsmodus.nTyp = s.equals("verschluesselung") ? KryptTyp.Verschluesselung : KryptTyp.Entschluesselung;
                }
            } else if (qName.toLowerCase().equals("schluessel")) {
                if (this.m_internerArbeitsmodus.sSchluessel == null && this.m_internerArbeitsmodus.schluesselBund == null) {
                    this.m_internerArbeitsmodus.sSchluessel = s;
                } else {
                    if (this.m_internerArbeitsmodus.schluesselBund == null) {
                        this.m_internerArbeitsmodus.schluesselBund = new ArrayList();
                        this.m_internerArbeitsmodus.schluesselBund.add(this.m_internerArbeitsmodus.sSchluessel);
                        this.m_internerArbeitsmodus.sSchluessel = null;
                    }
                    this.m_internerArbeitsmodus.schluesselBund.add(s);
                }
            } else if (qName.toLowerCase().equals("index")) {
                this.m_internerArbeitsmodus.nLfdNr = Integer.parseInt(s);
            } else if (qName.toLowerCase().equals("partnerindex")) {
                this.m_internerArbeitsmodus.nPartnerIndex = Integer.parseInt(s);
            } else if (qName.toLowerCase().equals("suffix")) {
                this.m_internerArbeitsmodus.sSuffix = !s.equals("null") ? s : null;
            } else if (qName.toLowerCase().equals("systempfad")) {
                if (!s.toLowerCase().equals("true") && !s.toLowerCase().equals("false")) {
                    this.m_sException = "Ung\u00fcltiger Wert zu Element 'systempfad'";
                } else {
                    this.m_internerArbeitsmodus.bSystempfad = s.equals("true");
                }
            } else if (qName.toLowerCase().equals("benutzermodus")) {
                this.m_internerArbeitsmodus.bBenutzermodus = s.equals("true");
            } else {
                this.m_sException = "Unbekanntes Element '" + s + "'in Datei 'schluesselintern.xml'";
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        this.m_sBuffer.append(buf, offset, len);
    }

    public boolean memberOf(int nIndex) {
        for (int i = 0; i < this.m_xmlProperties.size(); ++i) {
            InternerArbeitsmodus ia = (InternerArbeitsmodus)this.m_xmlProperties.get(i);
            if (ia.nLfdNr != nIndex) continue;
            return true;
        }
        return false;
    }

    public boolean enthaeltBenutzermodus() {
        for (int i = 0; i < this.m_xmlProperties.size(); ++i) {
            InternerArbeitsmodus ia = (InternerArbeitsmodus)this.m_xmlProperties.get(i);
            if (!ia.bBenutzermodus) continue;
            return true;
        }
        return false;
    }

    private void saveModus(FileWriter fw, InternerArbeitsmodus ia) throws IOException {
        fw.write("   <arbeitsmodus>\n");
        fw.write("      <index>");
        fw.write(Integer.toString(ia.nLfdNr));
        fw.write("</index>\n");
        fw.write("      <partnerindex>");
        fw.write(Integer.toString(ia.nPartnerIndex));
        fw.write("</partnerindex>\n");
        fw.write("      <typ>");
        if (ia.nTyp == KryptTyp.Verschluesselung) {
            fw.write("verschluesselung");
        } else if (ia.nTyp == KryptTyp.Entschluesselung) {
            fw.write("entschluesselung");
        }
        fw.write("</typ>\n");
        fw.write("      <name>");
        fw.write(ia.sName);
        fw.write("</name>\n");
        if (ia.sSchluessel != null) {
            fw.write("      <schluessel>");
            fw.write(ia.sSchluessel);
            fw.write("</schluessel>\n");
        } else if (ia.schluesselBund != null) {
            for (String s : ia.schluesselBund) {
                fw.write("      <schluessel>");
                fw.write(s);
                fw.write("</schluessel>\n");
            }
        }
        fw.write("      <suffix>");
        fw.write(ia.sSuffix == null ? "null" : ia.sSuffix);
        fw.write("</suffix>\n");
        fw.write("      <systempfad>");
        fw.write(ia.bSystempfad ? "true" : "false");
        fw.write("</systempfad>\n");
        fw.write("      <benutzermodus>");
        fw.write(ia.bBenutzermodus ? "true" : "false");
        fw.write("</benutzermodus>\n");
        fw.write("   </arbeitsmodus>\n\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this.m_sFile);
            fw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fw.write("<arbeitsmodi>\n\n");
            for (int i = 0; i < this.m_xmlProperties.size(); ++i) {
                InternerArbeitsmodus ia = (InternerArbeitsmodus)this.m_xmlProperties.get(i);
                this.saveModus(fw, ia);
            }
            fw.write("</arbeitsmodi>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

