/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.zip;

import de.kbv.xkm.zip.KbvZipFormat;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class KbvZipInputStream
extends InputStream {
    protected InputStream inputStream;

    public KbvZipInputStream(String sFilename) throws FileNotFoundException, ZipException {
        KbvZipFormat kbvZipFormat = KbvZipFormat.ZIP;
        try {
            this.inputStream = new GZIPInputStream(new FileInputStream(sFilename));
            kbvZipFormat = KbvZipFormat.GZIP;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (kbvZipFormat != KbvZipFormat.GZIP) {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(sFilename));
            try {
                ZipEntry thisEntry = zis.getNextEntry();
                if (thisEntry != null) {
                    this.inputStream = zis;
                    kbvZipFormat = KbvZipFormat.ZIP;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (kbvZipFormat == KbvZipFormat.NOZIP) {
            throw new ZipException("Unbekanntes Zip-Format");
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }
}

