/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm;

import de.kbv.xkm.KeyAlgorithm;
import de.kbv.xkm.exception.UnsupportedAlgorithmException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Crypto {
    public static final String XKM_ASYM_ALGO = "RSA";
    public static final String XKM_ASYM_ALGO_EXTRA = "/ECB/PKCS1PADDING";
    public static final int XKM_ASYM_KEYSIZE = 256;
    public static final String XKM_SYM_ALGO = "AES";
    public static final String XKM_SYM_ALGO_EXTRA = "AES/CBC/PKCS5PADDING";
    public static final int XKM_SYM_KEYSIZE = 256;
    public static final int CRYPTO_NOERROR = 0;
    public static final int CRYPTO_INIT_EXCEPTION = 1;
    public static final int CRYPTO_INIT_NOSUCHALGO = 2;
    public static final int CRYPTO_INIT_NOSUCHPROVIDER = 3;
    public static final int CRYPTO_ENCRYPT_EXCEPTION = 4;
    public static final int CRYPTO_ENCRYPT_IOEXCEPTION = 5;
    public static final int CRYPTO_ENCRYPT_GENERALEXCEPTION = 6;
    public static final int CRYPTO_ENCRYPT_CLASSNOTFOUND = 7;
    public static final int CRYPTO_ENCRYPT_NOSUCHALGO = 8;
    public static final int CRYPTO_ENCRYPT_NOSUCHPROVIDER = 9;
    public static final int CRYPTO_DECRYPT_EXCEPTION = 10;
    public static final int CRYPTO_DECRYPT_IOEXCEPTION = 11;
    public static final int CRYPTO_DECRYPT_GENERALEXCEPTION = 12;
    public static final int CRYPTO_DECRYPT_CLASSNOTFOUND = 13;
    public static final int CRYPTO_DECRYPT_NOSUCHALGO = 14;
    public static final int CRYPTO_DECRYPT_NOSUCHPROVIDER = 15;
    public static final int CRYPTO_DECRYPT_INVALIDKEY = 16;
    public static final int CRYPTO_DECRYPT_SECURITYEXCEPTION = 17;
    public static final int CRYPTO_DECRYPT_MEMORY = 18;
    public static final int CRYPTO_DECRYPT_MESSAGEDIGEST = 19;
    public static final int CRYPTO_GENKEY_FILENOTFOUND = 20;
    public static final int CRYPTO_GENKEY_IOEXCEPTION = 21;
    public String sErrorMessage = null;
    private static boolean isInitialized = false;
    private static Logger LOG = LogManager.getLogger((String)"xkm");

    public static int initBouncyCastle() {
        if (!isInitialized) {
            try {
                Security.addProvider((Provider)new BouncyCastleProvider());
                Cipher.getInstance(XKM_ASYM_ALGO, "BC");
                isInitialized = true;
            }
            catch (NoSuchProviderException e) {
                return 3;
            }
            catch (NoSuchAlgorithmException e) {
                return 2;
            }
            catch (Exception e) {
                return 1;
            }
        }
        return 0;
    }

    private SecretKey generateSymkey() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator keygen = KeyGenerator.getInstance(XKM_SYM_ALGO, "BC");
        keygen.init(256, new SecureRandom());
        return keygen.generateKey();
    }

    private Key readKey(String sPublicKey) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream keyIn = new ObjectInputStream(new FileInputStream(sPublicKey));
        Key publicKey = (Key)keyIn.readObject();
        keyIn.close();
        return publicKey;
    }

    private byte[] wrapKey(Key publicKey, SecretKey secretKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, UnsupportedAlgorithmException {
        KeyAlgorithm algo = KeyAlgorithm.findByName(publicKey.getAlgorithm());
        if (algo == KeyAlgorithm.UNKNOWN) {
            throw new UnsupportedAlgorithmException("Schluessel Algorithmus nicht erlaubt fuer Algorithmus: " + algo.name());
        }
        Cipher cipher = Cipher.getInstance(algo.cipher, "BC");
        cipher.init(3, publicKey);
        return cipher.wrap(secretKey);
    }

    private Key unwrapKey(Key privateKey, byte[] wrappedKey) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, UnsupportedAlgorithmException {
        KeyAlgorithm algo = KeyAlgorithm.findByName(privateKey.getAlgorithm());
        if (algo == KeyAlgorithm.UNKNOWN) {
            throw new UnsupportedAlgorithmException("Schluessel Algorithmus nicht erlaubt fuer Algorithmus: " + algo.name());
        }
        Cipher cipher = Cipher.getInstance(algo.cipher, "BC");
        cipher.init(4, privateKey);
        return cipher.unwrap(wrappedKey, XKM_SYM_ALGO_EXTRA, 3);
    }

    private void writeWrapkey(DataOutputStream out, byte[] wrappedKey) throws IOException {
        out.writeInt(wrappedKey.length);
        out.write(wrappedKey);
    }

    private byte[] readWrapkey(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] wrappedKey = new byte[length];
        in.read(wrappedKey, 0, length);
        return wrappedKey;
    }

    private byte[] readMessageDigest(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] messageDigest = new byte[length];
        in.read(messageDigest, 0, length);
        return messageDigest;
    }

    private void writeMessageDigest(DataOutputStream out, byte[] messageDigest) throws IOException {
        out.writeInt(messageDigest.length);
        out.write(messageDigest);
    }

    private byte[] generateDigest(InputStream is) throws NoSuchAlgorithmException, IOException, NoSuchProviderException {
        MessageDigest md = MessageDigest.getInstance("SHA-256", "BC");
        int blockSize = 8192;
        byte[] inBytes = new byte[blockSize];
        int inLength = 0;
        while (true) {
            if ((inLength = is.read(inBytes)) != blockSize) break;
            md.update(inBytes);
        }
        md.update(inBytes, 0, inLength);
        return md.digest();
    }

    private byte[] readIV(DataInputStream in) throws IOException {
        int ivlen = in.readInt();
        byte[] iv = new byte[ivlen];
        in.read(iv, 0, ivlen);
        return iv;
    }

    private byte[] writeIV(DataOutputStream out) throws IOException {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        out.writeInt(iv.length);
        out.write(iv);
        return iv;
    }

    private byte[] readVerwaltungsinfo(DataInputStream in) throws IOException {
        int len = in.readInt();
        byte[] b = new byte[len];
        in.read(b);
        return b;
    }

    private byte[] writeVerwaltungsinfo(DataOutputStream out) throws IOException {
        int len = 128;
        byte[] b = new byte[128];
        out.writeInt(128);
        b[0] = 49;
        b[1] = 46;
        b[2] = 48;
        out.write(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Encrypt(String sPublicKey, String sQuelle, String sZiel) {
        this.sErrorMessage = null;
        InputStream in = null;
        FilterOutputStream out = null;
        int nRetCode = Crypto.initBouncyCastle();
        if (nRetCode != 0) {
            return nRetCode;
        }
        try {
            FileInputStream fin = new FileInputStream(sQuelle);
            in = new DataInputStream(fin);
            FileOutputStream fout = new FileOutputStream(sZiel);
            out = new DataOutputStream(fout);
            this.writeVerwaltungsinfo((DataOutputStream)out);
            long lPosition = fin.getChannel().position();
            byte[] messageDigest = this.generateDigest(in);
            this.writeMessageDigest((DataOutputStream)out, messageDigest);
            fin.getChannel().position(lPosition);
            SecretKey symKey = this.generateSymkey();
            Key publicKey = this.readKey(sPublicKey);
            byte[] wrappedKey = this.wrapKey(publicKey, symKey);
            this.writeWrapkey((DataOutputStream)out, wrappedKey);
            Cipher cipher = Cipher.getInstance(XKM_SYM_ALGO_EXTRA, "BC");
            byte[] iiv = this.writeIV((DataOutputStream)out);
            cipher.init(1, (Key)symKey, new IvParameterSpec(iiv));
            this.crypt(in, out, cipher, null);
        }
        catch (IOException exception) {
            int n = 5;
            return n;
        }
        catch (NoSuchAlgorithmException e) {
            int n = 8;
            return n;
        }
        catch (NoSuchProviderException e) {
            int n = 9;
            return n;
        }
        catch (GeneralSecurityException exception) {
            int n = 6;
            return n;
        }
        catch (Exception ex) {
            int n = 4;
            return n;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.error("Warnung: Fehler beim Schliessen eines Input/Output-Streams f\u00fcr die Verschl\u00fcsselung");
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Decrypt(String sPrivateKey, String sQuelle, String sZiel) {
        this.sErrorMessage = null;
        FilterInputStream in = null;
        OutputStream out = null;
        int nRetCode = Crypto.initBouncyCastle();
        if (nRetCode != 0) {
            return nRetCode;
        }
        try {
            in = new DataInputStream(new FileInputStream(sQuelle));
            out = new FileOutputStream(sZiel);
            this.readVerwaltungsinfo((DataInputStream)in);
            byte[] messageDigest = this.readMessageDigest((DataInputStream)in);
            byte[] wrappedKey = this.readWrapkey((DataInputStream)in);
            Key privateKey = this.readKey(sPrivateKey);
            Key key = this.unwrapKey(privateKey, wrappedKey);
            Cipher cipher = Cipher.getInstance(XKM_SYM_ALGO_EXTRA, "BC");
            byte[] ivv = this.readIV((DataInputStream)in);
            cipher.init(2, key, new IvParameterSpec(ivv));
            byte[] messageDigest2 = this.crypt(in, out, cipher, MessageDigest.getInstance("SHA-256"));
            if (!MessageDigest.isEqual(messageDigest, messageDigest2)) {
                int n = 19;
                return n;
            }
        }
        catch (IOException exception) {
            int n = 11;
            return n;
        }
        catch (InvalidKeyException exception) {
            this.sErrorMessage = "Unpassende Schl\u00fcssel";
            int n = 16;
            return n;
        }
        catch (SecurityException exception) {
            this.sErrorMessage = "Unpassende Schl\u00fcssel";
            int n = 17;
            return n;
        }
        catch (NoSuchAlgorithmException e) {
            int n = 14;
            return n;
        }
        catch (NoSuchProviderException e) {
            int n = 15;
            return n;
        }
        catch (GeneralSecurityException exception) {
            int n = 12;
            return n;
        }
        catch (OutOfMemoryError e) {
            int n = 18;
            return n;
        }
        catch (Exception ex) {
            int n = 10;
            return n;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.error("Warnung: Fehler beim Schliessen eines Input/Output-Streams f\u00fcr die Entschl\u00fcsselung");
            }
        }
        return 0;
    }

    private byte[] crypt(InputStream in, OutputStream out, Cipher cipher, MessageDigest md) throws IOException, GeneralSecurityException {
        this.sErrorMessage = null;
        int blockSize = cipher.getBlockSize();
        int outputSize = cipher.getOutputSize(blockSize);
        byte[] inBytes = new byte[blockSize];
        byte[] outBytes = new byte[outputSize];
        int inLength = 0;
        int outLength = 0;
        while ((inLength = in.read(inBytes)) == blockSize) {
            outLength = cipher.update(inBytes, 0, blockSize, outBytes);
            out.write(outBytes, 0, outLength);
            if (md == null) continue;
            md.update(outBytes, 0, outLength);
        }
        outBytes = inLength > 0 ? cipher.doFinal(inBytes, 0, inLength) : cipher.doFinal();
        out.write(outBytes);
        if (md != null) {
            md.update(outBytes);
            return md.digest();
        }
        return null;
    }

    public int generateKeys(String sVerzeichnis, String sPublicKeyName, String sPrivateKeyName) {
        return this.generateKeys(sVerzeichnis, sVerzeichnis, sPublicKeyName, sPrivateKeyName);
    }

    public int generateKeys(String sPublicVerzeichnis, String sPrivateVerzeichnis, String sPublicKeyName, String sPrivateKeyName) {
        int rc;
        this.sErrorMessage = null;
        if (!((String)sPublicVerzeichnis).endsWith("\\") && !((String)sPublicVerzeichnis).endsWith("/")) {
            sPublicVerzeichnis = (String)sPublicVerzeichnis + "/";
        }
        if (!((String)sPrivateVerzeichnis).endsWith("\\") && !((String)sPrivateVerzeichnis).endsWith("/")) {
            sPrivateVerzeichnis = (String)sPrivateVerzeichnis + "/";
        }
        if ((rc = Crypto.initBouncyCastle()) != 0) {
            return rc;
        }
        try {
            KeyPairGenerator pairgen = KeyPairGenerator.getInstance(KeyAlgorithm.EC.name(), "BC");
            pairgen.initialize(256, new SecureRandom());
            KeyPair keyPair = pairgen.generateKeyPair();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream((String)sPublicVerzeichnis + sPublicKeyName));
            out.writeObject(keyPair.getPublic());
            out.close();
            out = new ObjectOutputStream(new FileOutputStream((String)sPrivateVerzeichnis + sPrivateKeyName));
            out.writeObject(keyPair.getPrivate());
        }
        catch (NoSuchAlgorithmException e) {
            return 8;
        }
        catch (NoSuchProviderException e) {
            return 8;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return 20;
        }
        catch (IOException e) {
            return 21;
        }
        return 0;
    }

    public static void main(String[] args) {
        String sPublicKey = args[0];
        String sPrivateKey = args[1];
        String sQuelle = args[2];
        String sZiel = args[3];
        String sZiel2 = args[4];
        LOG.info("");
        Crypto.initBouncyCastle();
        long startTime = System.currentTimeMillis();
        Crypto crypto = new Crypto();
        for (int i = 0; i < 1; ++i) {
            int rc2;
            System.out.print(".");
            int rc1 = crypto.Encrypt(sPublicKey, sQuelle, sZiel);
            if (rc1 != 0) {
                LOG.info("Encrypten: " + rc1);
            }
            if ((rc2 = crypto.Decrypt(sPrivateKey, sZiel, sZiel2)) == 0) continue;
            LOG.info("Decrypten: " + rc2);
        }
        long stopTime = System.currentTimeMillis();
        long diffTime = stopTime - startTime;
        SimpleDateFormat formatter = new SimpleDateFormat("mm:ss.SSS");
        LOG.info("\nDiffTime: " + formatter.format(new Date(diffTime)));
    }
}

