/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm;

import de.kbv.xkm.Main;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.utils.Tool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jfree.util.Log;

public class Header {
    private static final String cHEADERTEMPFILE = "XKMHeader.tmp";
    private static final String cXKMSIGNATUR = "*XKM*";
    private static final int cHEADER_OFFSET_SIGNATUR = 128;
    private static final int cHEADER_OFFSET_PAKETVON = 143;
    private static final int cHEADER_OFFSET_PAKETBIS = 150;
    private static final int cHEADER_OFFSET_TESTMODUS = 167;
    public static final int cHEADER_OK = 0;
    public static final int cHEADER_LENGTH = 1;
    public static final int cHEADER_TEMP = 2;
    public static final int cHEADER_WRITE = 3;
    public static final int cHEADER_APPEND = 4;
    public static final int cHEADER_MOVE = 5;
    public static final int cHEADER_SIGNATUR = 6;
    public static final int cHEADER_CUT = 7;
    public static final int cHEADER_CLOSE = 8;
    public static final int cHEADER_READ = 9;
    private static String[] m_aErrorText = new String[]{"ok", "Fehlerhafte Headersize", "Tempor\u00e4re Datei nicht l\u00f6schbar", "Fehler beim Schreiben der Headerdatei", "Fehler beim Anh\u00e4ngen an Headerdatei", "Fehler beim Umkopieren der Headerdatei", "XKM-Signatur nicht gefunden", "Header konnte nicht abgetrennt werden", "Fehler beim Schliessen der Datei", "Fehler beim Lesen des Headers"};
    byte[] arrHeader = new byte[256];
    private String m_sException = null;
    private boolean m_bInfoGelesen = false;

    public String getMessage(int nErrorCode) {
        Object sErrString = m_aErrorText[nErrorCode];
        if (this.m_sException != null) {
            sErrString = (String)sErrString + ": " + this.m_sException;
            this.m_sException = null;
        }
        return sErrString;
    }

    private String FormatZeile(String sZeile, int Len) {
        if (sZeile.length() > Len) {
            sZeile = sZeile.substring(0, Len);
        }
        if (sZeile.length() < Len) {
            sZeile = Tool.PadRight(sZeile, Len, ' ');
        }
        return sZeile;
    }

    public int createHeader(String sDatei, String sArztnummer, int nPaketNr, int nPaketBis, int nArbeitsmodus, boolean bKompression, boolean bPruefinfo, boolean bTestmodus, String sTempHeader, String sSchluesseldateiName) {
        Object sZeile = "";
        Object sZeileHilf = "";
        if (nArbeitsmodus > 99 || nArbeitsmodus < 0) {
            nArbeitsmodus = 0;
        }
        if (sArztnummer != "") {
            sZeileHilf = "Arztnummer/BSNR: " + sArztnummer;
        }
        sZeile = (String)sZeile + this.FormatZeile((String)sZeileHilf, 40) + "\r\n";
        sZeileHilf = "Erstellungsdatum: " + Tool.getToday() + " " + Tool.getNow();
        sZeile = (String)sZeile + this.FormatZeile((String)sZeileHilf, 40) + "\r\n";
        sZeileHilf = "Paket " + nPaketNr + "/" + nPaketBis;
        sZeile = (String)sZeile + this.FormatZeile((String)sZeileHilf, 40) + "\r\n";
        sZeile = (String)sZeile + "\r\n";
        sZeile = (String)sZeile + "*XKM*\r\n";
        sZeile = (String)sZeile + this.FormatZeile(Main.cVERSION, 6) + "\r\n";
        sZeile = (String)sZeile + this.FormatZeile(Integer.toString(nPaketNr), 5) + "\r\n";
        sZeile = (String)sZeile + this.FormatZeile(Integer.toString(nPaketBis), 5) + "\r\n";
        sZeile = (String)sZeile + this.FormatZeile(Integer.toString(nArbeitsmodus), 2) + "\r\n";
        sZeile = bKompression ? (String)sZeile + "1\r\n" : (String)sZeile + "0\r\n";
        sZeile = bPruefinfo ? (String)sZeile + "1\r\n" : (String)sZeile + "0\r\n";
        sZeile = bTestmodus ? (String)sZeile + "TEST\r\n" : (String)sZeile + "    \r\n";
        String schluesselname = Header.getSchluesselname(sSchluesseldateiName);
        sZeile = (String)sZeile + schluesselname;
        sZeile = (String)sZeile + "\r\n";
        sZeile = (String)sZeile + Tool.PadRight("", 61, ' ');
        assert (((String)sZeile).length() == 256);
        if (((String)sZeile).length() > 256) {
            return 1;
        }
        if (!((String)sTempHeader).endsWith("\\") && !((String)sTempHeader).endsWith("/")) {
            sTempHeader = (String)sTempHeader + File.separatorChar;
        }
        sTempHeader = (String)sTempHeader + cHEADERTEMPFILE;
        File fTemp = new File((String)sTempHeader);
        fTemp.delete();
        if (fTemp.exists()) {
            return 2;
        }
        if (!Tool.FileWrite((String)sTempHeader, (String)sZeile)) {
            return 3;
        }
        if (!Tool.FileAppend((String)sTempHeader, sDatei)) {
            return 4;
        }
        if (!Tool.FileMove((String)sTempHeader, sDatei)) {
            return 5;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cutHeader(String sFrom, String sTo) {
        FileInputStream from = null;
        FileOutputStream to = null;
        int nMaxCopy = 262144;
        try {
            int nBytesRead;
            from = new FileInputStream(sFrom);
            to = new FileOutputStream(sTo);
            byte[] arrBytes = new byte[262144];
            from.read(arrBytes, 0, 256);
            String Signatur = new String(arrBytes, 128, 5);
            if (!Signatur.equals(cXKMSIGNATUR)) {
                int n = 6;
                return n;
            }
            while ((nBytesRead = from.read(arrBytes, 0, 262144)) != -1) {
                to.write(arrBytes, 0, nBytesRead);
            }
        }
        catch (IOException e) {
            this.m_sException = e.getMessage();
            int n = 7;
            return n;
        }
        finally {
            try {
                if (from != null) {
                    from.close();
                }
                if (to != null) {
                    to.close();
                }
            }
            catch (IOException e) {
                this.m_sException = e.getMessage();
                return 8;
            }
        }
        return 0;
    }

    public int readHeader(String fName) {
        return this.readHeader(new File(fName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readHeader(File fFile) {
        FileInputStream fIn = null;
        try {
            fIn = new FileInputStream(fFile.getAbsolutePath());
            fIn.read(this.arrHeader);
            String Signatur = new String(this.arrHeader, 128, 5);
            if (!Signatur.equals(cXKMSIGNATUR)) {
                int n = 6;
                return n;
            }
            this.m_bInfoGelesen = true;
        }
        catch (IOException e) {
            this.m_sException = e.getMessage();
            int n = 9;
            return n;
        }
        finally {
            try {
                if (fIn != null) {
                    fIn.close();
                }
            }
            catch (IOException e) {
                this.m_sException = e.getMessage();
                return 8;
            }
        }
        this.m_bInfoGelesen = true;
        return 0;
    }

    public int getHeaderPaketVon() {
        assert (this.m_bInfoGelesen);
        return Tool.atoi(this.arrHeader, 143);
    }

    public int getHeaderPaketBis() {
        assert (this.m_bInfoGelesen);
        return Tool.atoi(this.arrHeader, 150);
    }

    private static String getSchluesselname(String schluesselname) {
        int maxlen = 20;
        String[] fileNameWithPath = schluesselname.split("\\\\");
        if (fileNameWithPath.length > 0) {
            schluesselname = fileNameWithPath[fileNameWithPath.length - 1];
        }
        if ((fileNameWithPath = schluesselname.split("/")).length > 0) {
            schluesselname = fileNameWithPath[fileNameWithPath.length - 1];
        }
        String[] split = schluesselname.split("_");
        String returnstring = "";
        if (split.length == 3) {
            returnstring = split[1];
        }
        if (returnstring.length() > 20) {
            returnstring = returnstring.substring(0, 20);
        }
        if (returnstring.length() < 20) {
            returnstring = Tool.PadRight(returnstring, 20, ' ');
        }
        return returnstring;
    }

    public boolean isTestmodus() {
        String sTest = new String(this.arrHeader, 167, 4);
        return sTest.equals("TEST");
    }

    public String getHeaderXKMVersion() {
        return new String(this.arrHeader, 135, 6);
    }

    public int getHeaderArbeitsmodusIndex() throws XKMException {
        try {
            return Integer.parseInt(new String(this.arrHeader, 157, 2).trim());
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            Log.error((Object)e.getMessage(), (Exception)e);
            throw new XKMException(4, "Header-Angaben zum Arbeitsmodusindex fehlerhaft");
        }
    }
}

