/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm;

import java.util.Objects;

public enum KeyAlgorithm {
    RSA("1.2.840.113549.1.1.1", "RSA/ECB/PKCS1Padding"),
    EC("1.2.840.10045.2.1", "ECIES"),
    UNKNOWN("", "");

    public final String oid;
    public final String cipher;

    private KeyAlgorithm(String oid, String cipher) {
        this.oid = oid;
        this.cipher = cipher;
    }

    public static KeyAlgorithm valueOfOid(String oid) {
        for (KeyAlgorithm keyAlgorithm : KeyAlgorithm.values()) {
            if (!Objects.equals(keyAlgorithm.oid, oid)) continue;
            return keyAlgorithm;
        }
        return UNKNOWN;
    }

    public static KeyAlgorithm findByName(String name) {
        KeyAlgorithm result = UNKNOWN;
        for (KeyAlgorithm keyAlgorithm : KeyAlgorithm.values()) {
            if (!keyAlgorithm.name().equalsIgnoreCase(name)) continue;
            result = keyAlgorithm;
            break;
        }
        return result;
    }
}

