/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm;

import de.kbv.xkm.Schalter;
import de.kbv.xkm.Steuerung;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodi;
import de.kbv.xkm.protokoll.Protokoll;
import de.kbv.xkm.utils.Tool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    public static String cVERSION = "1.44.0";
    public static final String cPROGRAMM = "Kryptomodul";
    public static final String cDEFAULTCONFIG = "Konfig/config.xml";
    public static final String cDEFAULTEXTERNMODI = "Konfig/schluessel.xml";
    public static final String cINTERNESCHLUESSEL = "schluesselintern.xml";
    public static final String cDEFAULTPROTOKOLL = "Protokoll";
    public static final String cDEFAULTSYSTEM = "System";
    public static final int cHEADERSIZE = 256;
    public static final long cPAKETMINSIZE = 1000L;
    public static final int cFLOPPYSIZE = 1380000;
    public static final int cCDROMSIZE = 650000000;
    public static final String cPAKETCD = "CD";
    public static final String cPAKETUNBEGRENZT = "unbegrenzt";
    public static JFrame parentFrame;
    private static Logger LOG;

    private static void pruefeVerzeichnisOderDateiExistiert(String verzeichnisName) throws XKMException {
        try {
            File file = new File(verzeichnisName);
            if (!file.isDirectory() && !file.isFile()) {
                throw new XKMException(3, "Konfigurationsfehler. Verzeichnis oder Datei '" + Tool.shortenFilename(verzeichnisName, 32) + "' nicht gefunden");
            }
        }
        catch (Exception e) {
            throw new XKMException(3, "Konfigurationsfehler. Verzeichnis oder Datei '" + Tool.shortenFilename(verzeichnisName, 32) + "' nicht gefunden");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionQuietly(String defaultVersion) {
        InputStream propIn = Main.class.getResourceAsStream("/xkm.properties");
        if (propIn == null) {
            return defaultVersion;
        }
        Properties properties = new Properties();
        try {
            properties.load(propIn);
            String string = properties.getProperty("version");
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                propIn.close();
            }
            catch (IOException iOException) {}
        }
        return defaultVersion;
    }

    private static void pruefeVerzeichnisExistiert(String verzeichnisName) throws XKMException {
        if (Tool.isFloppy(verzeichnisName)) {
            return;
        }
        try {
            File file = new File(verzeichnisName);
            if (!file.isDirectory()) {
                throw new XKMException(3, "Konfigurationsfehler. Verzeichnis '" + Tool.shortenFilename(verzeichnisName, 32) + "' nicht gefunden");
            }
        }
        catch (Exception e) {
            throw new XKMException(3, "Konfigurationsfehler. Verzeichnis '" + Tool.shortenFilename(verzeichnisName, 32) + "' nicht gefunden");
        }
    }

    public static void initVerzeichnisStruktur(Schalter schalter) {
        Tool.initDirectory(schalter.getSystemWorkingDir());
        new File(schalter.getSystemTempVer()).delete();
        new File(schalter.getSystemTempEnt()).delete();
        new File(schalter.getSystemZipTempVer()).delete();
        new File(schalter.getSystemZipTempEnt()).delete();
        File f = new File(schalter.getSystemKeyDir());
        if (!f.isDirectory()) {
            f.mkdir();
        }
    }

    public static void initXKM(String[] args, Schalter schalter, Arbeitsmodi arbeitsmodi, boolean bAbfrageBenutzerkennung) throws XKMException {
        schalter.getParameters(args);
        arbeitsmodi.initIntern(cINTERNESCHLUESSEL, bAbfrageBenutzerkennung);
        arbeitsmodi.initExtern(schalter.getExternModiDatei());
        arbeitsmodi.checkConflict();
        schalter.checkParameters();
        Main.pruefeVerzeichnisOderDateiExistiert(schalter.getQuelle());
        Main.pruefeVerzeichnisExistiert(schalter.getVerschluesseltpfad());
        Main.pruefeVerzeichnisExistiert(schalter.getEntschluesseltpfad());
        Main.pruefeVerzeichnisExistiert(schalter.getAusschusspfad());
        Main.pruefeVerzeichnisExistiert(schalter.getSystempfad());
        Main.pruefeVerzeichnisExistiert(schalter.getSchluesselpfad());
        if (schalter.getTempDir() != null && !new File(schalter.getTempDir().toUpperCase()).getName().equals("TEMP")) {
            Main.pruefeVerzeichnisExistiert(schalter.getTempDir());
        }
        if (!Tool.fileAccessable(schalter.getProtokollDatei())) {
            throw new XKMException(3, "Auf Protokolldatei oder -pfad besteht kein Zugriff");
        }
        if (schalter.getPruefinfo() != null && schalter.getArbeitsModusN() == 7) {
            schalter.pruefeDateiExistiert(schalter.getPruefinfo());
        }
        if (schalter.getPaketgroesseN() > 0L && schalter.getPaketgroesseN() < 1000L) {
            throw new XKMException(3, "Minimalwert fuer Schalter 'Paketgroesse' in der Konfigurationsdatei ist 1000");
        }
        if (schalter.getEinzelLaufVerzeichnis() && !schalter.getServerModus()) {
            throw new XKMException(3, "Parameterfehler '-e': Einzellaufmodus nur in Verbindung mit Servermodus ('-s') moeglich");
        }
        if (schalter.getQuelle() != null && new File(schalter.getQuelle()).isFile() && schalter.getServerModus()) {
            throw new XKMException(3, "Servermodus ('-s') und die Angabe einer einzelnen Datei als Quelle schliessen sich aus");
        }
        Main.initVerzeichnisStruktur(schalter);
        arbeitsmodi.setArbeitsmodus(schalter.getArbeitsModusN());
        if (schalter.getSchluesselBund() == null) {
            if (!schalter.schluesseldateiExists()) {
                throw new XKMException(6, "Schluesseldatei '" + schalter.getSchluesseldateiName(arbeitsmodi.getModusIndex()) + "' nicht gefunden");
            }
        } else {
            boolean bFound = false;
            for (String array : schalter.getSchluesselBund()) {
                String sKeyFile = schalter.getSchluesseldateiName() + array;
                if (!new File(sKeyFile).exists()) continue;
                bFound = true;
                break;
            }
            if (!bFound) {
                throw new XKMException(6, "Keine definierte Schluesseldatei gefunden");
            }
        }
    }

    public static void main(String[] args) {
        int nRetCode = 0;
        cVERSION = Main.getVersionQuietly(cVERSION);
        Schalter schalter = new Schalter();
        Arbeitsmodi arbeitsmodi = new Arbeitsmodi(schalter);
        schalter.setArbeitsmodi(arbeitsmodi);
        Protokoll protokoll = new Protokoll(schalter, arbeitsmodi);
        try {
            int javaVersion = Runtime.version().version().get(0);
            if (javaVersion < 17) {
                LOG.warn("Auf Ihrem System ist eine Java Version kleiner 17 installiert. In der naechsten Version des Kryptomoduls wird diese Version nicht mehr unterstuetzt und das Kryptomodul wird dann nicht mehr starten.");
            }
        }
        catch (Exception javaVersion) {
            // empty catch block
        }
        try {
            Main.initXKM(args, schalter, arbeitsmodi, false);
            Steuerung steuerung = new Steuerung();
            nRetCode = steuerung.run(schalter, arbeitsmodi, protokoll);
            if (!schalter.getServerModus()) {
                protokoll.create(nRetCode, "Kryptomodul mit Returncode " + nRetCode + " beendet");
            }
            LOG.info("Kryptomodul mit Returncode " + nRetCode + " beendet");
        }
        catch (XKMException e) {
            nRetCode = e.getCode();
            String sMessage = e.getMessage();
            if (sMessage == null) {
                sMessage = "";
            }
            protokoll.setException(sMessage);
            if (!schalter.getServerModus()) {
                protokoll.create(nRetCode, "Kryptomodul mit Fehler " + nRetCode + " beendet\n" + sMessage);
            }
            LOG.error("Fehlercode: " + nRetCode + ". " + sMessage);
        }
        Main.systemExit(nRetCode);
    }

    public static void systemExit(final int status) {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(status);
                }
            }, 20000L);
            System.exit(status);
        }
        catch (Throwable ex) {
            Runtime.getRuntime().halt(status);
        }
        finally {
            Runtime.getRuntime().halt(status);
        }
    }

    static {
        LOG = LogManager.getLogger((String)"xkm");
    }
}

