/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm;

import de.kbv.xkm.KeyAlgorithm;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodi;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodus;
import de.kbv.xkm.protokoll.AusgabeFormat;
import de.kbv.xkm.utils.Tool;
import de.kbv.xkm.xml.XMLConfigFile;
import gnu.getopt.Getopt;
import java.io.File;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Schalter {
    public XMLConfigFile xcf = null;
    private Arbeitsmodi m_Arbeitsmodi;
    private final int m_nArbeitsModus = 0;
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    private String m_sQuellPfad;
    private String m_sVerschluesselt;
    private String m_sEntschluesselt;
    private String m_sAusschuss;
    private String m_sBearbeitetVerschluesselt;
    private String m_sBearbeitetEntschluesselt;
    private String m_sSystemPfad;
    private String m_sProtokollDatei;
    private String m_sSchluesselpfad;
    private String m_sExternModiDatei;
    private String m_sArbeitsModus;
    private String m_sKonfigDialog;
    private String m_sKonfigDatei;
    private String m_sProtokollFormat;
    private String m_sPruefinfo;
    private String m_sPaketgroesse;
    private boolean m_bServerModus;
    private boolean m_bEinzelLaufVerzeichnis;
    private boolean m_bLoeschModus;
    private String m_sTempDir;
    private String m_sAbrechnungsKomprimierung;
    private String m_sQuellpfadXML;
    private String m_sVerschluesseltXML;
    private String m_sEntschluesseltXML;
    private String m_sAusschussXML;
    private String m_sBearbeitetVerschluesseltXML;
    private String m_sBearbeitetEntschluesseltXML;
    private String m_sSystempfadXML;
    private String m_sProtokollDateiXML;
    private String m_sSchluesselpfadXML;
    private String m_sExternModiDateiXML;
    private String m_sArbeitsModusXML;
    private String m_sPruefinfoXML;
    private String m_sPaketgroesseXML;
    private String m_sKonfigDialogXML;
    private String m_sDisketteXML;
    private String m_sProtokollFormatXML;
    private String m_sTempDirXML;
    private String m_sAbrechnungsKomprimierungXML;
    private KeyAlgorithm keyAlgorithm;

    public void setKeyAlgorithm(KeyAlgorithm keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public KeyAlgorithm getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setArbeitsmodi(Arbeitsmodi arbeitsmodi) {
        this.m_Arbeitsmodi = arbeitsmodi;
    }

    private String addSlash(String sPfad) {
        if (sPfad == null) {
            return null;
        }
        return sPfad.endsWith("\\") || sPfad.endsWith("/") ? sPfad : sPfad + "/";
    }

    public int getParameters(String[] args) throws XKMException {
        if (args != null) {
            this.parseKommandozeile("Kryptomodul", args);
        }
        this.parseKonfigurationsXML(this.getKonfigDatei());
        this.abgleichMitUmgebungsvariablen();
        return 0;
    }

    public int checkParameters() throws XKMException {
        this.pruefeSchalterInhalte();
        return 0;
    }

    public void pruefeDateiExistiert(String dateiName) throws XKMException {
        try {
            File file = new File(dateiName);
            if (!file.isFile()) {
                throw new XKMException(3, "Konfigurationsfehler. Datei '" + Tool.shortenFilename(dateiName, 32) + "' nicht gefunden");
            }
        }
        catch (Exception e) {
            throw new XKMException(3, "Konfigurationsfehler. Datei '" + Tool.shortenFilename(dateiName, 32) + "' nicht gefunden");
        }
    }

    public boolean schluesseldateiExists(int index) {
        return new File(this.getSchluesseldateiName(index)).exists();
    }

    public boolean schluesseldateiExists() {
        assert (this.m_Arbeitsmodi.getModusIndex() != 0);
        return new File(this.getSchluesseldateiName(this.m_Arbeitsmodi.getModusIndex())).exists();
    }

    private void usage(String prog) {
        LOG.info("Aufruf:   " + prog + " [Optionen]");
        LOG.info("");
        LOG.info("      -c      Name der Konfigurationsdatei");
        LOG.info("      -m      Arbeitsmodus festlegen");
        LOG.info("      -s      Servermodus aktivieren");
        LOG.info("      -e      Einzellauf Verzeichnis aktivieren");
        LOG.info("      -l      Loeschmodus aktivieren");
        LOG.info("      -f      Name des Quellpfad");
        LOG.info("      -v      Name des Verschluesselungspfad");
        LOG.info("      -t      Name des Entschluesselungspfad");
        LOG.info("      -a      Name des Ausschusspfad");
        LOG.info("      -x      Name des Pfads fuer Bearbeitet-Verschluesselte Dateien");
        LOG.info("      -y      Name des Pfads fuer Bearbeitet-Entschluesselte Dateien");
        LOG.info("      -p      Name der Datei fuer Protokollausgabe");
        LOG.info("      -z      Name des Pfads fuer Systemverarbeitung");
        LOG.info("      -u      Name des Pfads fuer benutzerdefinierte Schluessel");
        LOG.info("      -k      Name der Datei fuer benutzerdefinierte Arbeitsmodi");
        LOG.info("      -o      Konfigurations-Dialog ein- bzw. ausschalten ('Ja', 'Nein')");
        LOG.info("      -j      Tempor\u00e4re Daten ('system/work') in anderem Pfad ablegen");
        LOG.info("      -r      Protokollformat setzen ('PDF', 'XLS', ...)");
        LOG.info("      -g      Paketgroesse setzen");
        LOG.info("      -i      Pruefinfo-Datei setzen");
        LOG.info("      -q      Abrechnungskomprimierung ein- bzw. ausschalten ('Ja', 'Nein')");
        LOG.info("      -h      Dieser Hilfetext");
    }

    private void parseKommandozeile(String prog, String[] args) throws XKMException {
        int opt;
        Getopt g = new Getopt(prog, args, ":hc:self:m:k:p:z:a:v:t:u:d:o:r:g:i:nq:j:x:y:");
        g.setOpterr(false);
        block25: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 63: {
                    this.usage(prog);
                    System.exit(0);
                    return;
                }
                case 104: {
                    this.usage(prog);
                    System.exit(0);
                    return;
                }
                case 99: {
                    this.setKonfigDatei(g.getOptarg());
                    continue block25;
                }
                case 115: {
                    this.setServerModus(true);
                    continue block25;
                }
                case 101: {
                    this.setEinzelLaufVerzeichnis(true);
                    continue block25;
                }
                case 108: {
                    this.setLoeschModus(true);
                    continue block25;
                }
                case 102: {
                    this.setQuellpfad(g.getOptarg());
                    continue block25;
                }
                case 118: {
                    this.setVerschluesseltpfad(g.getOptarg());
                    continue block25;
                }
                case 116: {
                    this.setEntschluesseltpfad(g.getOptarg());
                    continue block25;
                }
                case 97: {
                    this.setAusschusspfad(g.getOptarg());
                    continue block25;
                }
                case 109: {
                    this.setArbeitsModus(g.getOptarg());
                    continue block25;
                }
                case 117: {
                    this.setSchluesselpfad(g.getOptarg());
                    continue block25;
                }
                case 112: {
                    this.setProtokollDatei(g.getOptarg());
                    continue block25;
                }
                case 107: {
                    this.setExternArbeitsmodi(g.getOptarg());
                    continue block25;
                }
                case 122: {
                    this.setSystempfad(g.getOptarg());
                    continue block25;
                }
                case 111: {
                    this.setKonfigDialog(g.getOptarg());
                    continue block25;
                }
                case 114: {
                    this.setProtokollFormat(g.getOptarg());
                    continue block25;
                }
                case 103: {
                    this.setPaketgroesse(g.getOptarg());
                    continue block25;
                }
                case 105: {
                    this.setPruefinfo(g.getOptarg());
                    continue block25;
                }
                case 106: {
                    this.setTempDir(g.getOptarg());
                    continue block25;
                }
                case 113: {
                    this.setAbrechnungskomprimierung(g.getOptarg());
                    continue block25;
                }
                case 120: {
                    this.setBearbeitetVerschluesselung(g.getOptarg());
                    continue block25;
                }
                case 121: {
                    this.setBearbeitetEntschluesselung(g.getOptarg());
                    continue block25;
                }
            }
            LOG.error("\nFehlerhafte Kommandozeile: Unbekannte oder falsch verwendete Option \"-" + (char)g.getOptopt() + "\"\nEs konnte keine Verarbeitung durchgefuehrt werden!\n");
            this.usage(prog);
            System.exit(3);
            return;
        }
    }

    public void parseKonfigurationsXML(String sKonfigDatei) throws XKMException {
        this.xcf = new XMLConfigFile();
        this.pruefeDateiExistiert(sKonfigDatei);
        this.xcf.load(sKonfigDatei);
        this.setQuellpfadXML(this.xcf.getSchalter("Quelle"));
        this.setVerschluesseltpfadXML(this.xcf.getSchalter("Verschluesselt"));
        this.setEntschluesseltpfadXML(this.xcf.getSchalter("Entschluesselt"));
        this.setAusschusspfadXML(this.xcf.getSchalter("Ausschuss"));
        this.setBearbeitetVerschluesselungXML(this.xcf.getSchalter("Bearbeitet_Verschluesselung"));
        this.setBearbeitetEntschluesselungXML(this.xcf.getSchalter("Bearbeitet_Entschluesselung"));
        this.setSystemPfadXML(this.xcf.getSchalter("System"));
        this.setProtokollDateiXML(this.xcf.getSchalter("Protokolldatei"));
        this.setExternModiDateiXML(this.xcf.getSchalter("Schluesseldatei"));
        this.setArbeitsModusXML(this.xcf.getSchalter("Arbeitsmodus"));
        this.setPruefinfoXML(this.xcf.getSchalter("Pruefinfo"));
        this.setDisketteXML(this.xcf.getSchalter("Diskette"));
        this.setPaketgroesseXML(this.xcf.getSchalter("Paketgroesse"));
        this.setKonfigDialogXML(this.xcf.getSchalter("KonfigDialog"));
        this.setSchluesselpfadXML(this.xcf.getSchalter("Schluesselpfad"));
        this.setProtokollFormatXML(this.xcf.getSchalter("Protokollformat"));
        this.setAbrechnungskomprimierungXML(this.xcf.getSchalter("Abrechnungskomprimierung"));
        this.setTempDirXML(this.xcf.getSchalter("Temp"));
        if (this.getQuellpfadXML() == null) {
            throw new XKMException(3, "Konfigurationsfehler: Element 'Quelle' nicht gefunden.");
        }
        if (this.getVerschluesseltpfadXML() == null) {
            throw new XKMException(3, "Konfigurationsfehler: Element 'Verschluesselt' nicht gefunden.");
        }
        if (this.getEntschluesseltpfadXML() == null) {
            throw new XKMException(3, "Konfigurationsfehler: Element 'Entschluesselt' nicht gefunden.");
        }
        if (this.getAusschusspfadXML() == null) {
            throw new XKMException(3, "Konfigurationsfehler: Element 'Ausschuss' nicht gefunden.");
        }
        if (this.getArbeitsModusXML() == null) {
            throw new XKMException(3, "Konfigurationsfehler: Element 'Arbeitsmodus' nicht gefunden.");
        }
    }

    private void abgleichMitUmgebungsvariablen() throws XKMException {
        this.setQuellpfadXML(this.getUmgebungsvariable(this.getQuellpfadXML()));
        this.setVerschluesseltpfadXML(this.getUmgebungsvariable(this.getVerschluesseltpfadXML()));
        this.setEntschluesseltpfadXML(this.getUmgebungsvariable(this.getEntschluesseltpfadXML()));
        this.setAusschusspfadXML(this.getUmgebungsvariable(this.getAusschusspfadXML()));
        this.setSystemPfadXML(this.getUmgebungsvariable(this.getSystemPfadXML()));
        this.setProtokollDateiXML(this.getUmgebungsvariable(this.getProtokollDateiXML()));
        this.setExternModiDateiXML(this.getUmgebungsvariable(this.getExternModiDateiXML()));
        this.setArbeitsModusXML(this.getUmgebungsvariable(this.getArbeitsModusXML()));
        this.setPruefinfoXML(this.getUmgebungsvariable(this.getPruefinfoXML()));
        this.setDisketteXML(this.getUmgebungsvariable(this.getDisketteXML()));
        this.setPaketgroesseXML(this.getUmgebungsvariable(this.getPaketgroesseXML()));
        this.setKonfigDialogXML(this.getUmgebungsvariable(this.getKonfigDialogXML()));
        this.setSchluesselpfadXML(this.getUmgebungsvariable(this.getSchluesselpfadXML()));
        this.setProtokollFormatXML(this.getUmgebungsvariable(this.getProtokollFormatXML()));
        this.setBearbeitetVerschluesselungXML(this.getUmgebungsvariable(this.getBearbeitetVerschluesselungXML()));
        this.setBearbeitetEntschluesselungXML(this.getUmgebungsvariable(this.getBearbeitetEntschluesselungXML()));
        this.setTempDirXML(this.getUmgebungsvariable(this.getTempDirXML()));
    }

    private String getUmgebungsvariable(String sString) throws XKMException {
        if (sString == null) {
            return null;
        }
        int nBegin = sString.indexOf("%");
        if (nBegin == -1) {
            return sString;
        }
        int nEnd = sString.indexOf("%", nBegin + 1);
        if (nEnd == -1) {
            return sString;
        }
        String sSub = sString.substring(nBegin + 1, nEnd);
        String sValue = System.getProperty(sSub);
        if (sValue == null) {
            LOG.error("Warnung: Unbekannte Umgebungsvariable " + sSub);
            return sString;
        }
        String sPrefix = sString.substring(0, nBegin);
        String sSuffix = sString.substring(nEnd + 1);
        return sPrefix + sValue + sSuffix;
    }

    private void pruefeSchalterInhalte() throws XKMException {
        if (this.getProtokollDateiXML() != null && this.getProtokollDateiXML().trim().equals("")) {
            throw new XKMException(3, "Parameter oder Schalter 'Protokoll' definiert, aber ohne Wertzuweisung. Bitte Verzeichnis spezifizieren.");
        }
        if (!this.m_Arbeitsmodi.memberOf(this.getArbeitsModus())) {
            throw new XKMException(3, "Unbekannter Arbeitsmodus aktiviert");
        }
        if (this.getSystemPfadXML() != null && this.getSystemPfadXML().trim().equals("")) {
            throw new XKMException(3, "Parameter oder Schalter 'System' definiert, aber ohne Wertzuweisung. Bitte Verzeichnis spezifizieren.");
        }
        if (this.getPruefinfo() != null && this.getPruefinfo().trim().equals("")) {
            throw new XKMException(3, "Parameter oder Schalter 'Pruefinfo' definiert, aber ohne Wertzuweisung. Bitte Datei spezifizieren.");
        }
        if (this.getPaketgroesse() != null) {
            String sPaketgroesse = this.getPaketgroesse().trim();
            if (sPaketgroesse.equals("")) {
                throw new XKMException(3, "Parameter oder Schalter 'Paketgroesse' definiert, aber ohne Wertzuweisung. Bitte Paketgroesse spezifizieren.");
            }
            if (!(Tool.isParsableToInt(sPaketgroesse) || sPaketgroesse.equalsIgnoreCase("CD") || sPaketgroesse.equalsIgnoreCase("unbegrenzt"))) {
                throw new XKMException(3, "Ungueltiger Wert zum Parameter oder Schalter 'Paketgroesse'");
            }
        }
        if (this.m_sAbrechnungsKomprimierung != null && !this.m_sAbrechnungsKomprimierung.equalsIgnoreCase("ja") && !this.m_sAbrechnungsKomprimierung.equalsIgnoreCase("nein")) {
            throw new XKMException(3, "Schalter 'Abrechnungskomprimerung' kann nur mit 'ja' oder 'nein' bewertet werden.");
        }
        if (this.m_sAbrechnungsKomprimierungXML != null && !this.m_sAbrechnungsKomprimierungXML.equalsIgnoreCase("ja") && !this.m_sAbrechnungsKomprimierungXML.equalsIgnoreCase("nein")) {
            throw new XKMException(3, "Schalter 'Abrechnungskomprimerung' kann nur mit 'ja' oder 'nein' bewertet werden.");
        }
        if (this.getQuelle() == null) {
            throw new XKMException(3, "Fehlende Angabe zum Quellpfad");
        }
        if (this.getSchluesselpfad() == null) {
            throw new XKMException(3, "Fehlende Angabe zum Schluesselpfad");
        }
        if (this.getKonfigDialog() != null && !this.getKonfigDialog().equalsIgnoreCase("ja") && !this.getKonfigDialog().equalsIgnoreCase("nein")) {
            throw new XKMException(3, "Schalter 'KonfigDialog' kann nur mit 'ja' oder 'nein' bewertet werden.");
        }
        if (this.getProtokollFormat() != null) {
            if (this.getProtokollFormat().trim().equals("")) {
                throw new XKMException(3, "Parameter oder Schalter 'Protokollformat' definiert, aber ohne Wertzuweisung.");
            }
            if (!AusgabeFormat.getInstance().istGueltigesFormat(this.getProtokollFormat())) {
                throw new XKMException(3, "Folgende Protokollformate sind zulaessig: " + AusgabeFormat.getInstance().getZulaessigeFormate());
            }
        }
    }

    public void setSchluesselpfadXML(String sValue) {
        this.m_sSchluesselpfadXML = sValue;
    }

    public String getSchluesselpfadXML() {
        return this.addSlash(this.m_sSchluesselpfadXML);
    }

    public void setSchluesselpfad(String sValue) {
        this.m_sSchluesselpfad = sValue;
    }

    public String getSchluesselpfad() {
        return this.m_sSchluesselpfad != null ? this.addSlash(this.m_sSchluesselpfad) : this.getSchluesselpfadXML();
    }

    public void setProtokollFormat(String sValue) {
        this.m_sProtokollFormat = sValue;
    }

    public String getProtokollFormat() {
        return this.m_sProtokollFormat != null ? this.m_sProtokollFormat : this.m_sProtokollFormatXML;
    }

    private void setProtokollFormatXML(String sValue) {
        this.m_sProtokollFormatXML = sValue;
    }

    private String getProtokollFormatXML() {
        return this.m_sProtokollFormatXML;
    }

    public void setSystemPfadXML(String sValue) {
        this.m_sSystempfadXML = sValue;
    }

    public String getSystemPfadXML() {
        return this.m_sSystempfadXML;
    }

    private void setProtokollDateiXML(String sValue) {
        this.m_sProtokollDateiXML = sValue;
    }

    private String getProtokollDateiXML() {
        return this.m_sProtokollDateiXML;
    }

    private String getExternModiDateiXML() {
        return this.m_sExternModiDateiXML;
    }

    private void setArbeitsModusXML(String sValue) {
        this.m_sArbeitsModusXML = sValue;
    }

    private String getArbeitsModusXML() {
        return this.m_sArbeitsModusXML;
    }

    private void setQuellpfadXML(String sValue) {
        this.m_sQuellpfadXML = sValue;
    }

    private String getQuellpfadXML() {
        return this.m_sQuellpfadXML;
    }

    private void setPruefinfoXML(String sValue) {
        this.m_sPruefinfoXML = sValue;
    }

    private String getPruefinfoXML() {
        return this.m_sPruefinfoXML;
    }

    public void setPruefinfo(String sValue) {
        this.m_sPruefinfo = sValue;
    }

    public String getPruefinfo() {
        return this.m_sPruefinfo != null ? this.m_sPruefinfo : this.m_sPruefinfoXML;
    }

    private void setDisketteXML(String sValue) {
        this.m_sDisketteXML = sValue;
    }

    private String getDisketteXML() {
        return this.m_sDisketteXML;
    }

    public void setKonfigDialog(String sValue) {
        this.m_sKonfigDialog = sValue;
    }

    public String getKonfigDialog() {
        return this.m_sKonfigDialog != null ? this.m_sKonfigDialog : this.m_sKonfigDialogXML;
    }

    private void setKonfigDialogXML(String sValue) {
        this.m_sKonfigDialogXML = sValue;
    }

    private String getKonfigDialogXML() {
        return this.m_sKonfigDialogXML;
    }

    public boolean getKonfigDialogB() {
        if (this.getKonfigDialog() == null) {
            return true;
        }
        return !this.getKonfigDialog().equalsIgnoreCase("nein");
    }

    public void setPaketgroesse(String sValue) {
        this.m_sPaketgroesse = sValue;
    }

    public String getPaketgroesse() {
        return this.m_sPaketgroesse != null ? this.m_sPaketgroesse : this.m_sPaketgroesseXML;
    }

    private void setPaketgroesseXML(String sValue) {
        this.m_sPaketgroesseXML = sValue;
        if (this.m_sPaketgroesseXML != null) {
            this.m_sPaketgroesseXML.trim();
        }
    }

    private String getPaketgroesseXML() {
        return this.m_sPaketgroesseXML;
    }

    public long getPaketgroesseN() {
        if (this.getPaketgroesse() == null || this.getPaketgroesse().equals("")) {
            return -1L;
        }
        return this.getPaketgroesse().equalsIgnoreCase("CD") ? 650000000L : (this.getPaketgroesse().equalsIgnoreCase("unbegrenzt") ? 0L : Long.parseLong(this.getPaketgroesse()));
    }

    public String getAusschusspfadXML() {
        return this.addSlash(this.m_sAusschussXML);
    }

    public void setAusschusspfadXML(String sValue) {
        this.m_sAusschussXML = sValue;
    }

    public void setAusschusspfad(String sValue) {
        this.m_sAusschuss = sValue;
    }

    public String getAusschusspfad() {
        return this.m_sAusschuss != null ? this.addSlash(this.m_sAusschuss) : this.getAusschusspfadXML();
    }

    public void setBearbeitetVerschluesselung(String sValue) {
        this.m_sBearbeitetVerschluesselt = sValue;
    }

    public void setBearbeitetVerschluesselungXML(String sValue) {
        this.m_sBearbeitetVerschluesseltXML = sValue;
    }

    public String getBearbeitetVerschluesselung() {
        String sReturn = "Bearbeitet/Verschluesselung";
        if (this.m_sBearbeitetVerschluesseltXML != null) {
            sReturn = this.m_sBearbeitetVerschluesseltXML;
        }
        if (this.m_sBearbeitetVerschluesselt != null) {
            sReturn = this.m_sBearbeitetVerschluesselt;
        }
        return sReturn;
    }

    public String getBearbeitetVerschluesselungXML() {
        return this.m_sBearbeitetVerschluesseltXML;
    }

    public void setBearbeitetEntschluesselungXML(String sValue) {
        this.m_sBearbeitetEntschluesseltXML = sValue;
    }

    public void setBearbeitetEntschluesselung(String sValue) {
        this.m_sBearbeitetEntschluesselt = sValue;
    }

    public String getBearbeitetEntschluesselung() {
        String sReturn = "Bearbeitet/Entschluesselung";
        if (this.m_sBearbeitetEntschluesseltXML != null) {
            sReturn = this.m_sBearbeitetEntschluesseltXML;
        }
        if (this.m_sBearbeitetEntschluesselt != null) {
            sReturn = this.m_sBearbeitetEntschluesselt;
        }
        return sReturn;
    }

    public String getBearbeitetEntschluesselungXML() {
        return this.m_sBearbeitetEntschluesseltXML;
    }

    public String getEntschluesseltpfadXML() {
        return this.addSlash(this.m_sEntschluesseltXML);
    }

    public void setEntschluesseltpfadXML(String sValue) {
        this.m_sEntschluesseltXML = sValue;
    }

    public String getEntschluesseltpfad() {
        return this.m_sEntschluesselt != null ? this.addSlash(this.m_sEntschluesselt) : this.getEntschluesseltpfadXML();
    }

    public void setEntschluesseltpfad(String sValue) {
        this.m_sEntschluesselt = sValue;
    }

    public String getVerschluesseltpfadXML() {
        return this.addSlash(this.m_sVerschluesseltXML);
    }

    public void setVerschluesseltpfadXML(String sValue) {
        this.m_sVerschluesseltXML = sValue;
    }

    public String getVerschluesseltpfad() {
        return this.m_sVerschluesselt != null ? this.addSlash(this.m_sVerschluesselt) : this.getVerschluesseltpfadXML();
    }

    public void setVerschluesseltpfad(String sValue) {
        this.m_sVerschluesselt = sValue;
    }

    public String getQuelle() {
        if (this.m_sQuellPfad == null && this.m_sQuellpfadXML != null) {
            if (this.m_Arbeitsmodi.istCryptModus(this.getArbeitsModus())) {
                return this.m_sQuellpfadXML;
            }
            return this.getVerschluesseltpfad();
        }
        return this.m_sQuellPfad;
    }

    public String getZiel() {
        if (this.m_Arbeitsmodi.istCryptModus()) {
            return this.getVerschluesseltpfad();
        }
        return this.getEntschluesseltpfad();
    }

    public void setQuellpfad(String sQuellpfad) {
        this.m_sQuellPfad = sQuellpfad;
    }

    public boolean getServerModus() {
        return this.m_bServerModus;
    }

    public void setServerModus(boolean bValue) {
        this.m_bServerModus = bValue;
    }

    public boolean getEinzelLaufVerzeichnis() {
        return this.m_bEinzelLaufVerzeichnis;
    }

    public void setEinzelLaufVerzeichnis(boolean bValue) {
        this.m_bEinzelLaufVerzeichnis = bValue;
    }

    public void setAbrechnungskomprimierung(String sValue) {
        this.m_sAbrechnungsKomprimierung = sValue;
    }

    public String getTempDir() {
        return this.m_sTempDir != null ? this.addSlash(this.m_sTempDir) : this.getTempDirXML();
    }

    public void setTempDir(String string) {
        this.m_sTempDir = string;
    }

    public String getTempDirXML() {
        return this.m_sTempDirXML;
    }

    public void setTempDirXML(String string) {
        this.m_sTempDirXML = string;
    }

    public void setAbrechnungskomprimierungXML(String sValue) {
        this.m_sAbrechnungsKomprimierungXML = sValue;
    }

    public boolean getAbrechnungsKomprimierung() {
        if (this.m_sAbrechnungsKomprimierung != null) {
            if (this.m_sAbrechnungsKomprimierung.equalsIgnoreCase("ja")) {
                return true;
            }
            if (this.m_sAbrechnungsKomprimierung.equalsIgnoreCase("nein")) {
                return false;
            }
        }
        return this.m_sAbrechnungsKomprimierungXML != null && this.m_sAbrechnungsKomprimierungXML.equalsIgnoreCase("ja");
    }

    public boolean getLoeschModus() {
        return this.m_bLoeschModus;
    }

    public void setLoeschModus(boolean bValue) {
        this.m_bLoeschModus = bValue;
    }

    private String getArbeitsModus() {
        if (this.m_sArbeitsModus != null) {
            return this.m_sArbeitsModus;
        }
        return this.m_sArbeitsModusXML;
    }

    public void setArbeitsModus(String sValue) {
        this.m_sArbeitsModus = sValue;
    }

    public String getProtokollDatei() {
        if (this.m_sProtokollDatei != null) {
            return this.m_sProtokollDatei;
        }
        if (this.m_sProtokollDateiXML != null) {
            return this.m_sProtokollDateiXML;
        }
        return "Protokoll";
    }

    public void setProtokollDatei(String sValue) {
        this.m_sProtokollDatei = sValue;
    }

    public String getExternModiDatei() {
        if (this.m_sExternModiDatei != null) {
            return this.m_sExternModiDatei;
        }
        if (this.m_sExternModiDateiXML != null) {
            return this.m_sExternModiDateiXML;
        }
        return "Konfig/schluessel.xml";
    }

    public void setExternArbeitsmodi(String sValue) {
        this.m_sExternModiDatei = sValue;
    }

    public void setExternModiDateiXML(String sValue) {
        this.m_sExternModiDateiXML = sValue;
    }

    public String getSystempfad() {
        String sReturn = null;
        sReturn = this.m_sSystemPfad != null ? this.m_sSystemPfad : (this.m_sSystempfadXML != null ? this.m_sSystempfadXML : "System");
        return this.addSlash(sReturn);
    }

    public void setSystempfad(String sValue) {
        this.m_sSystemPfad = sValue;
    }

    public String getKonfigDatei() {
        return this.m_sKonfigDatei == null ? "Konfig/config.xml" : this.m_sKonfigDatei;
    }

    public void setKonfigDatei(String sValue) {
        this.m_sKonfigDatei = sValue;
    }

    public int getArbeitsModusN() {
        return this.m_Arbeitsmodi.getModusIndex(this.getArbeitsModus());
    }

    public String getSystemDir() {
        return this.getSystempfad();
    }

    public String getSystemWorkingDir() {
        if (this.getTempDir() != null) {
            Object sTempDir = this.getTempDir();
            if (new File(this.getTempDir().toUpperCase()).getName().equals("TEMP")) {
                sTempDir = System.getProperty("java.io.tmpdir");
                if (!new File((String)(sTempDir = (String)sTempDir + "KBV/XKM/Work")).exists()) {
                    new File((String)sTempDir).mkdirs();
                }
            }
            return sTempDir;
        }
        assert (this.getSystemDir().endsWith("/"));
        return this.getSystemDir() + "work";
    }

    public String getSystemDiskDir() {
        assert (this.getSystemDir().endsWith("/"));
        return this.getSystemDir() + "disk";
    }

    public String getSystemKeyDir() {
        assert (this.getSystemDir().endsWith("/"));
        return this.getSystemDir() + "keys";
    }

    public String getSystemTempVer() {
        assert (this.getSystemDir().endsWith("/"));
        return this.getSystemDir() + "kryptotemp.V";
    }

    public String getSystemTempEnt() {
        assert (this.getSystemDir().endsWith("/"));
        return this.getSystemDir() + "kryptotemp.E";
    }

    public String getSystemZipTempVer() {
        assert (this.getSystemDir().endsWith("/"));
        return this.getSystemDir() + "kryptozip.V";
    }

    public String getSystemZipTempEnt() {
        assert (this.getSystemDir().endsWith("/"));
        return this.getSystemDir() + "kryptozip.E";
    }

    public String getSchluesseldateiName(int index) {
        Object sKeyDatei = "";
        if (this.m_Arbeitsmodi.istInternerModus(index) && !((String)(sKeyDatei = this.m_Arbeitsmodi.istSystempfad(index) ? this.getSystemKeyDir() : this.getSchluesselpfad())).endsWith("\\") && !((String)sKeyDatei).endsWith("/")) {
            sKeyDatei = (String)sKeyDatei + "/";
        }
        if (this.m_Arbeitsmodi.getSchluesselname(index) != null) {
            sKeyDatei = (String)sKeyDatei + this.m_Arbeitsmodi.getSchluesselname(index);
        }
        return sKeyDatei;
    }

    public String getSchluesseldateiName() {
        assert (this.m_Arbeitsmodi.getModusIndex() != 0);
        return this.getSchluesseldateiName(this.m_Arbeitsmodi.getModusIndex());
    }

    public ArrayList<String> getSchluesselBund() {
        Arbeitsmodus arbeitsmodus = this.m_Arbeitsmodi.getAktuellerArbeitsmodus();
        return arbeitsmodus.m_schluesselBund;
    }
}

