/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.utils;

import de.kbv.xkm.KeyAlgorithm;
import de.kbv.xkm.exception.KeyParsingException;
import de.kbv.xkm.exception.UnsupportedAlgorithmException;
import java.io.IOException;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.io.pem.PemObject;

public class AlgorithmExtractor {
    private AlgorithmExtractor() {
    }

    public static String extractAlgorithm(PemObject pemObject, EncodedKeySpec keySpec) throws KeyParsingException, UnsupportedAlgorithmException, IOException {
        String oid = null;
        try (ASN1InputStream asn1InputStream = new ASN1InputStream(pemObject.getContent());){
            ASN1Primitive primitive = asn1InputStream.readObject();
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                oid = PrivateKeyInfo.getInstance((Object)primitive).getPrivateKeyAlgorithm().getAlgorithm().getId();
            } else if (keySpec instanceof X509EncodedKeySpec) {
                oid = SubjectPublicKeyInfo.getInstance((Object)primitive).getAlgorithm().getAlgorithm().getId();
            }
        }
        if (oid == null) {
            throw new KeyParsingException("Error gettings key information from keyspecs and Pem Object");
        }
        KeyAlgorithm algorithm = KeyAlgorithm.valueOfOid(oid);
        if (algorithm == KeyAlgorithm.UNKNOWN) {
            throw new UnsupportedAlgorithmException("Unsupported algorithm OID: " + oid);
        }
        return algorithm.name();
    }
}

