/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class XKMTestschluessel {
    public static final String XKM_ASYM_ALGO = "RSA";
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    private static byte[] arrbytesOeffentlicherTestschluessel = new byte[]{48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -68, 15, -70, 54, -101, -93, -58, -125, 43, 98, 25, 76, 33, -127, 110, 125, -32, -27, -29, 92, -60, 25, -117, -27, -72, -54, 45, -18, 72, 36, -101, 22, -44, 79, -96, 72, -8, -34, -120, -118, -88, -62, -16, -114, -122, -68, 40, -35, -30, 114, -1, 126, 48, 63, -1, 80, 86, 46, -83, -71, -107, 126, -95, 76, 24, 104, -125, -31, 54, 36, -73, 98, 16, 111, 110, -43, -98, 28, -42, -97, -4, 56, -48, 29, -112, -115, -89, -51, -68, -46, 71, -55, -94, -115, 67, 91, 102, -31, 16, -25, -20, -32, -98, -117, -89, 5, -46, -102, 46, 16, 36, 19, 98, -14, -30, 49, -41, -115, 4, -10, 96, 105, -17, 62, -41, -55, -122, -39, 65, -89, -31, 73, -64, -85, 21, 65, 65, -68, -46, 117, 90, 74, 68, -86, 91, -67, -60, -3, -4, 1, 80, 70, 14, -108, -59, 111, 10, 43, -104, 4, -20, 46, -13, -112, -88, 116, 54, -12, 85, -113, -51, 56, 69, -27, 5, -122, 50, -53, -101, -77, 67, -66, 18, 40, 16, 110, -15, 35, 56, -78, 82, -99, 67, -18, -43, 20, -26, -62, 79, 2, -124, 28, -99, 63, -35, -10, -44, 43, -27, -123, 127, 54, 58, 75, 56, -26, -85, -55, -40, 21, 75, 31, 102, 75, -112, -59, -3, -34, -15, -64, -43, 28, 110, 19, 121, 120, 5, -6, 111, -59, 50, 12, 8, 80, -103, -2, 21, -98, 69, 54, 65, -117, 122, -93, 69, 19, 2, 3, 1, 0, 1};
    private static byte[] arrbytesPrivaterTestschluessel = new byte[]{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};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key readKey(String sKey) {
        Key key = null;
        ObjectInputStream keyIn = null;
        try {
            keyIn = new ObjectInputStream(new FileInputStream(sKey));
            key = (Key)keyIn.readObject();
            keyIn.close();
        }
        catch (Exception e) {
            Key key2 = null;
            return key2;
        }
        finally {
            if (keyIn != null) {
                try {
                    keyIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        return key;
    }

    private static PublicKey readPublicKey(String sPublicKey) throws FileNotFoundException, IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeySpecException {
        PemReader pemReader = new PemReader((Reader)new InputStreamReader(new FileInputStream(sPublicKey)));
        PemObject pemObject = pemReader.readPemObject();
        pemReader.close();
        if (pemObject == null) {
            LOG.error("Falsche Schl\u00fcsselformat (PEM erwartet f\u00fcr Datei: " + sPublicKey);
            return null;
        }
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pemObject.getContent());
        KeyFactory k = KeyFactory.getInstance(XKM_ASYM_ALGO);
        return k.generatePublic(keySpec);
    }

    private static PrivateKey readPrivateKey(String sPrivateKey) throws FileNotFoundException, IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeySpecException {
        PemReader pemReader = new PemReader((Reader)new InputStreamReader(new FileInputStream(sPrivateKey)));
        PemObject pemObject = pemReader.readPemObject();
        pemReader.close();
        if (pemObject == null) {
            LOG.error("Falsche Schl\u00fcsselformat (PEM erwartet f\u00fcr Datei: " + sPrivateKey);
            return null;
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
        KeyFactory k = KeyFactory.getInstance(XKM_ASYM_ALGO);
        return k.generatePrivate(keySpec);
    }

    private static boolean equalKeys(Key k1, byte[] b2) {
        if (k1 == null || b2 == null) {
            return false;
        }
        return Arrays.equals(k1.getEncoded(), b2);
    }

    public static boolean istTestschluesselImpl(String keyFile) {
        PublicKey pubkey = null;
        PrivateKey privkey = null;
        try {
            pubkey = XKMTestschluessel.readPublicKey(keyFile);
            privkey = XKMTestschluessel.readPrivateKey(keyFile);
        }
        catch (IOException | ClassNotFoundException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            LOG.debug((Object)e);
        }
        return XKMTestschluessel.equalKeys(privkey, arrbytesPrivaterTestschluessel) || XKMTestschluessel.equalKeys(pubkey, arrbytesOeffentlicherTestschluessel);
    }

    public static boolean istTestschluessel(String sFile) {
        return XKMTestschluessel.istTestschluesselImpl(sFile);
    }

    public static void main(String[] args) {
        LOG.info((Object)XKMTestschluessel.istTestschluessel(args[0]));
        LOG.error((Object)XKMTestschluessel.istTestschluessel(args[1]));
        LOG.error((Object)XKMTestschluessel.istTestschluessel(args[2]));
        LOG.error((Object)XKMTestschluessel.istTestschluessel(args[3]));
    }
}

