/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.asthma;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.asthma.XPMEventHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final String cZIP_DIR = "Asthma_bronchiale/Dokumentation/";
    protected static String m_sGeschlecht_ = "";
    protected static int m_nArztNr = -1;
    protected static final String cVERTRAGSARZTNUMMER = "Vertragsarztnummer";
    protected static String m_sServiceTmr = "";
    protected static Date m_dateUnterschrift = null;
    protected static Date m_dateKopf = null;
    protected static int m_nPatientenAlter = -1;
    protected static SimpleDateFormat m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
    protected static final String cV = "V";
    protected static StringBuffer m_sFileName = new StringBuffer();
    protected static String m_sDokdatum = new String();
    protected static String m_sParameter = "";
    protected static boolean m_bErgebnis = false;
    protected static int m_nAbschnitt = 0;
    protected static String m_sAbschnitt = new String();
    protected static final int cABSCHNITT_ADMINISTRATIVEDATEN = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_EREIGNISSE = 4;
    protected static final int cABSCHNITT_MEDIKATION = 5;
    protected static final int cABSCHNITT_SCHULUNGEN = 6;
    protected static final int cABSCHNITT_BEHANDLUNGSPLAN = 7;
    protected static final String cADMINISTRATIVEDATEN = "Administrative Daten";
    protected static final String cANAMNESE = "Anamnese- und Befunddaten";
    protected static final String cEREIGNISSE = "Relevante Ereignisse";
    protected static final String cMEDIKATION = "Medikamente";
    protected static final String cSCHULUNGEN = "Schulung";
    protected static final String cBEHANDLUNGSPLAN = "Behandlungsplanung";
    protected static final String cKOERPERGROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPERGEWICHT = "K\u00f6rpergewicht";
    protected static final String cBLUTDRUCK_SYSTOLISCH = "Blutdruck systolisch";
    protected static final String cBLUTDRUCK_DIASTOLISCH = "Blutdruck diastolisch";
    protected static final String cSYMPTOMETAGS = "In den letzten 4 Wochen: H\u00e4ufigkeit von Asthma-Symptomen tags\u00fcber";
    protected static final String cSYMPTOMEMEDIKATION = "In den letzten 4 Wochen: H\u00e4ufigkeit des Einsatzes der Bedarfsmedikation";
    protected static final String cSYMPTOMEALLTAG = "In den letzten 4 Wochen: Einschr\u00e4nkung von Aktivit\u00e4ten im Alltag wegen Asthma bronchiale";
    protected static final String cSYMPTOMENACHTS = "In den letzten 4 Wochen: Asthmabedingte St\u00f6rung des Nachtschlafes";
    protected static boolean m_bDiagnoseBekanntSeit = false;
    protected static int m_nDiagnoseBekanntSeit = 0;
    protected static double m_dKoerpergroesse = 0.0;
    protected static String m_sKoerpergroesse = new String();
    protected static boolean m_bKoerpergroesse = false;
    protected static int m_nKoerpergewicht = 0;
    protected static boolean m_bKoerpergewicht = false;
    protected static String m_sKoerpergewicht = new String();
    protected static int m_nBlutdruckSystolisch = 0;
    protected static boolean m_bBlutdruckSystolisch = false;
    protected static String m_sBlutdruckSystolisch = new String();
    protected static int m_nBlutdruckDiastolisch = 0;
    protected static boolean m_bBlutdruckDiastolisch = false;
    protected static String m_sBlutdruckDiastolisch = new String();
    protected static int m_nRaucher = 0;
    protected static int m_nModulTeilnahme = 0;
    protected static int m_nEinschreibungWegen = 0;
    protected static int m_nSymptomeTags = 0;
    protected static int m_nSymptomeMedikation = 0;
    protected static int m_nSymptomeAlltag = 0;
    protected static int m_nSymptomeNachts = 0;
    protected static double m_dFEV1 = -1.0;
    protected static String m_sFEV1 = new String();
    protected static boolean m_bFEV1NichtDurchgefuehrt = false;
    protected static boolean m_bStationaereBehandlungen = false;
    protected static int m_nStationaereBehandlungen = 0;
    protected static String m_sStationaereBehandlungen = null;
    protected static int m_nInhalGluko = 0;
    protected static int m_nInhalLang = 0;
    protected static int m_nInhalKurz = 0;
    protected static int m_nSysGluko = 0;
    protected static int m_nSonstMedikation = 0;
    protected static int m_nTechnikUeberprueft = 0;
    protected static int m_nSchulungEmpfohlen = 0;
    protected static int m_nSchulungBereitsWahrgenommen = 0;
    protected static int m_nSchulungEmpfohlenWahrgenommen = 0;
    protected static int m_nBegleiterkrankungen = 0;
    protected static int m_nInformationsangebote = 0;
    protected static int m_nSelbstmanagement = 0;
    protected static int m_nTherapieanpassung = 0;
    protected static int m_nIntervall = 0;
    protected static String m_sDokuGeplant = null;
    protected static String m_sId = null;
    protected static String m_sSetId = null;
    protected static String m_sKrankenhausIK = null;
    protected static String m_sProviderIdLANR = null;
    protected static String m_sProviderIdBSNR = null;
    protected static String m_sPatientId = null;
    protected static String m_sPatientIdEX = null;
    protected static String m_sDokumentTyp = null;
    protected static String m_sLastXPath = "";
    protected static String m_sLastParameter = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public void pruefeDokumentation() throws Exception {
        try {
            FehlerListe.newGroup(cADMINISTRATIVEDATEN);
            this.pruefeDokumentTyp(m_sDokumentTyp, m_nEinschreibungWegen);
            if (m_nEinschreibungWegen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Einschreibung wegen'");
            }
            if (this.testBit(m_nEinschreibungWegen, 2) && this.testBit(m_nEinschreibungWegen, 4)) {
                m_MeldungPool.addMeldung("DMP-063", "Diabetes mellitus Typ 1", "Diabetes mellitus Typ 2");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && this.testBit(m_nEinschreibungWegen, 16)) {
                m_MeldungPool.addMeldung("DMP-063", "Asthma bronchiale", "COPD");
            }
            if (this.testBit(m_nEinschreibungWegen, 1) && this.testBit(m_nEinschreibungWegen, 64)) {
                m_MeldungPool.addMeldung("DMP-063", "KHK", "Chronische Herzinsuffizienz");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && m_nPatientenAlter != -1 && m_nPatientenAlter < 1) {
                m_MeldungPool.addMeldung("DMP-071");
            }
            if (this.testBit(m_nEinschreibungWegen, 16) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-112");
            }
            if (this.testBit(m_nEinschreibungWegen, 1024) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-113");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cANAMNESE);
            this.allgemeineAnamnese("ASTHMA", m_nPatientenAlter, m_bKoerpergroesse, m_bKoerpergewicht, m_dKoerpergroesse, m_nKoerpergewicht, m_sKoerpergroesse, m_bBlutdruckSystolisch, m_bBlutdruckDiastolisch, m_nBlutdruckSystolisch, m_nBlutdruckDiastolisch, m_sBlutdruckSystolisch, m_sBlutdruckDiastolisch, m_nRaucher, m_nBegleiterkrankungen);
            if (this.testBit(m_nEinschreibungWegen, 512)) {
                if (m_sGeschlecht_.equals("M") && m_nPatientenAlter < 60) {
                    m_MeldungPool.addMeldung("DMP-110");
                }
                if ((m_sGeschlecht_.equals("F") || m_sGeschlecht_.equals("UN") || m_sGeschlecht_.equals("X")) && m_nPatientenAlter < 50) {
                    m_MeldungPool.addMeldung("DMP-111");
                }
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 2) && !this.testBit(m_nEinschreibungWegen, 4) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-070");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 1) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-072");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 64) || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-073");
            }
            if (m_nSymptomeTags == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'In den letzten 4 Wochen: H\u00e4ufigkeit von Asthma-Symptomen tags\u00fcber'");
            }
            if (this.countBits(m_nSymptomeTags) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cSYMPTOMETAGS);
            }
            if (m_nSymptomeMedikation == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'In den letzten 4 Wochen: H\u00e4ufigkeit des Einsatzes der Bedarfsmedikation'");
            }
            if (this.countBits(m_nSymptomeMedikation) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cSYMPTOMEMEDIKATION);
            }
            if (m_nSymptomeAlltag == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'In den letzten 4 Wochen: Einschr\u00e4nkung von Aktivit\u00e4ten im Alltag wegen Asthma bronchiale'");
            }
            if (this.countBits(m_nSymptomeAlltag) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cSYMPTOMEALLTAG);
            }
            if (m_nSymptomeNachts == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'In den letzten 4 Wochen: Asthmabedingte St\u00f6rung des Nachtschlafes'");
            }
            if (this.countBits(m_nSymptomeNachts) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cSYMPTOMENACHTS);
            }
            if (!m_bFEV1NichtDurchgefuehrt) {
                if (m_sFEV1 == null) {
                    m_MeldungPool.addMeldung("DMP-002", "'Aktueller FEV1-Wert (mindestens alle 12 Monate)'");
                } else if (!Pattern.matches("...\\..", m_sFEV1)) {
                    m_MeldungPool.addMeldung("AB-007");
                } else if (m_dFEV1 < 10.0 || m_dFEV1 > 299.9) {
                    m_MeldungPool.addMeldung("AB-001");
                }
            } else if (m_dFEV1 != -1.0) {
                m_MeldungPool.addMeldung("AB-002");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cEREIGNISSE);
            if (m_bFolgeDoku) {
                if (!m_bStationaereBehandlungen) {
                    m_MeldungPool.addMeldung("DMP-002", "'Ungeplante, auch notfallm\u00e4\u00dfige (ambulant und station\u00e4r) \u00e4rztliche Behandlung wegen Asthma bronchiale seit der letzten Dokumentation'");
                }
                if (m_bStationaereBehandlungen && (m_nStationaereBehandlungen < 0 || m_nStationaereBehandlungen > 99)) {
                    m_MeldungPool.addMeldung("DMP-055", "Ungeplante, auch notfallm\u00e4\u00dfige (ambulant und station\u00e4r) \u00e4rztliche Behandlung wegen Asthma bronchiale seit der letzten Dokumentation", "0", "99");
                }
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cMEDIKATION);
            if (m_nInhalGluko == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Inhalative Glukokortikosteroide'");
            }
            if ((this.testBit(m_nInhalGluko, 4) || this.testBit(m_nInhalGluko, 8)) && (this.testBit(m_nInhalGluko, 1) || this.testBit(m_nInhalGluko, 2))) {
                m_MeldungPool.addMeldung("AB-003", "'Inhalative Glukokortikosteroide'");
            }
            if (m_nInhalLang == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Inhalative lang wirksame Beta-2-Sympathomimetika'");
            }
            if ((this.testBit(m_nInhalLang, 4) || this.testBit(m_nInhalLang, 8)) && (this.testBit(m_nInhalLang, 1) || this.testBit(m_nInhalLang, 2))) {
                m_MeldungPool.addMeldung("AB-003", "'Inhalative lang wirksame Beta-2-Sympathomimetika'");
            }
            if (m_nInhalKurz == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Kurz wirksame inhalative Beta-2-Sympathomimetika'");
            }
            if ((this.testBit(m_nInhalKurz, 4) || this.testBit(m_nInhalKurz, 8)) && this.testBit(m_nInhalKurz, 1) | this.testBit(m_nInhalKurz, 2)) {
                m_MeldungPool.addMeldung("AB-003", "'Kurz wirksame inhalative Beta-2-Sympathomimetika'");
            }
            if (m_nSysGluko == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Systemische Glukokortikosteroide'");
            }
            if ((this.testBit(m_nSysGluko, 4) || this.testBit(m_nSysGluko, 8)) && (this.testBit(m_nSysGluko, 1) || this.testBit(m_nSysGluko, 2))) {
                m_MeldungPool.addMeldung("AB-003", "'Systemische Glukokortikosteroide'");
            }
            if (m_nSonstMedikation == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Sonstige asthmaspezifische Medikation'");
            }
            if (this.testBit(m_nSonstMedikation, 1) && this.countBits(m_nSonstMedikation) > 1) {
                m_MeldungPool.addMeldung("DMP-019", "'Sonstige asthmaspezifische Medikation'");
            }
            if (m_nTechnikUeberprueft == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Inhalationstechnik \u00fcberpr\u00fcft'");
            }
            if (this.countBits(m_nTechnikUeberprueft) > 1) {
                m_MeldungPool.addMeldung("DMP-013", "'Inhalationstechnik \u00fcberpr\u00fcft'");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSCHULUNGEN);
            if (m_nSchulungEmpfohlen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Asthma-Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (this.countBits(m_nSchulungEmpfohlen) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Asthma-Schulung empfohlen (bei aktueller Dokumentation)");
            }
            if (m_bFolgeDoku) {
                if (m_nSchulungBereitsWahrgenommen > 0) {
                    m_MeldungPool.addMeldung("DMP-074a");
                }
            } else {
                if (m_nSchulungBereitsWahrgenommen == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Asthma-Schulung schon vor Einschreibung in DMP bereits wahrgenommen'");
                }
                if (this.countBits(m_nSchulungBereitsWahrgenommen) > 1) {
                    m_MeldungPool.addMeldung("DMP-012", "Asthma-Schulung schon vor Einschreibung in DMP bereits wahrgenommen");
                }
            }
            if (!m_bFolgeDoku) {
                if (m_nSchulungEmpfohlenWahrgenommen > 0) {
                    m_MeldungPool.addMeldung("DMP-074b");
                }
            } else {
                if (m_nSchulungEmpfohlenWahrgenommen == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Empfohlene Asthma-Schulung wahrgenommen'");
                }
                if (this.countBits(m_nSchulungEmpfohlenWahrgenommen) > 1) {
                    m_MeldungPool.addMeldung("DMP-012", "Empfohlene Asthma-Schulung wahrgenommen");
                }
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNGSPLAN);
            if (m_nSelbstmanagement == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Schriftlicher Selbstmanagementplan'");
            }
            if (this.countBits(m_nSelbstmanagement) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Schriftlicher Selbstmanagementplan");
            }
            if (m_nIntervall == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Dokumentationsintervall'");
            }
            if (this.countBits(m_nIntervall) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Dokumentationsintervall");
            }
            if (m_nTherapieanpassung == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Therapieanpassung'");
            }
            if (this.testBit(m_nTherapieanpassung, 1) && this.countBits(m_nTherapieanpassung) > 1) {
                m_MeldungPool.addMeldung("AB-004", "'Therapieanpassung'");
            }
            if (this.testBit(m_nTherapieanpassung, 2) && this.testBit(m_nTherapieanpassung, 8)) {
                m_MeldungPool.addMeldung("AB-006", "Therapieanpassung", "Steigerung der Medikation", "Reduktion der Medikation");
            }
            if (this.datumBevor(m_sDokuGeplant, m_sServiceTmr)) {
                m_MeldungPool.addMeldung("DMP-051");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefeDokumentation)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            FehlerListe.addParameter("BSNR", (Object)m_sProviderIdBSNR);
            FehlerListe.newGroup("Header");
            if (m_sProviderIdLANR == null && m_sProviderIdBSNR == null && m_sKrankenhausIK == null) {
                m_MeldungPool.addMeldung("DMP-061");
            }
            if (m_sProviderIdLANR != null && m_sProviderIdBSNR == null || m_sProviderIdLANR == null && m_sProviderIdBSNR != null) {
                m_MeldungPool.addMeldung("DMP-060");
            }
            if (m_sProviderIdLANR != null) {
                FehlerListe.addParameter("ARZT_NR", (Object)m_sProviderIdLANR);
            }
            if (m_sPatientId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/patient/person/id");
            }
            if (m_sId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/id");
            }
            if (m_sSetId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/set_id");
            }
            if (m_sPatientId != null && m_sId != null) {
                if (!m_sPatientId.equals(m_sId)) {
                    m_MeldungPool.addMeldung("DMP-004", m_sPatientId, m_sId);
                } else {
                    boolean bIdentisch = false;
                    if (m_sProviderIdBSNR != null && m_sId.equals(m_sProviderIdBSNR)) {
                        bIdentisch = true;
                    }
                    if (m_sKrankenhausIK != null && m_sId.equals(m_sKrankenhausIK)) {
                        bIdentisch = true;
                    }
                    if (!bIdentisch) {
                        m_MeldungPool.addMeldung("DMP-068");
                    }
                }
            }
            if (m_sProviderIdLANR != null && m_sProviderIdLANR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "LANR");
            }
            if (m_sKrankenhausIK != null && m_sKrankenhausIK.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "Krankenhaus-IK");
            }
            if (m_sProviderIdBSNR != null && m_sProviderIdBSNR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "BSNR");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Schemaname");
            this.pruefeXMLSchemaname();
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            boolean bPruefeLang = false;
            if (m_sKrankenhausIK != null && (m_sProviderIdLANR == null && m_sProviderIdLANR == null || m_sKrankenhausIK.equals(m_sPatientId))) {
                m_sFileName.append(m_sKrankenhausIK);
                m_sFileName.append("_");
                bPruefeLang = true;
            }
            m_sFileName.append(m_sPatientIdEX);
            m_sFileName.append("_");
            m_sFileName.append(m_sDokdatum.replaceAll("-", ""));
            if (m_bFolgeDoku) {
                if (m_bASatz) {
                    m_sFileName.append("_a.EVAB");
                } else {
                    m_sFileName.append(".EVAB");
                }
            } else if (m_bASatz) {
                m_sFileName.append("_a.EEAB");
            } else {
                m_sFileName.append(".EEAB");
            }
            this.m_sValue = m_DatenPool.getString("XPM_FILE");
            String sErwarteterName = m_sFileName.toString();
            String sPattern = m_bFolgeDoku ? (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EVAB" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EVAB") : (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EEAB" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EEAB");
            String sTemp = this.m_sValue.substring(0, 10);
            if (sTemp == null || sTemp.length() < 10 || sTemp.indexOf(95) != 9) {
                m_MeldungPool.addMeldung("DMP-059");
            } else if (bPruefeLang) {
                if (this.m_sValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-005", this.m_sValue, sPattern, sErwarteterName);
                }
            } else {
                String sSubValue = this.m_sValue.substring(10);
                if (sSubValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, this.m_sValue.substring(0, 10) + sErwarteterName);
                }
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_DIR");
            if (this.m_sValue != null && !this.m_sValue.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("DMP-025", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+AB_446\\.zip)")) {
                m_MeldungPool.addMeldung("DMP-080F", "AB_446.zip");
            }
            m_MeldungPool.reportMeldungen();
            this.pruefeDokumentation();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        m_sGeschlecht_ = "";
        m_nArztNr = -1;
        m_sServiceTmr = "";
        m_dateUnterschrift = null;
        m_dateKopf = null;
        m_nPatientenAlter = -1;
        m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        m_sFileName = new StringBuffer();
        m_sDokdatum = new String();
        m_sParameter = "";
        m_bErgebnis = false;
        m_nAbschnitt = 0;
        m_sAbschnitt = new String();
        m_bDiagnoseBekanntSeit = false;
        m_nDiagnoseBekanntSeit = 0;
        m_dKoerpergroesse = 0.0;
        m_sKoerpergroesse = new String();
        m_bKoerpergroesse = false;
        m_nKoerpergewicht = 0;
        m_bKoerpergewicht = false;
        m_sKoerpergewicht = new String();
        m_nBlutdruckSystolisch = 0;
        m_bBlutdruckSystolisch = false;
        m_sBlutdruckSystolisch = new String();
        m_nBlutdruckDiastolisch = 0;
        m_bBlutdruckDiastolisch = false;
        m_sBlutdruckDiastolisch = new String();
        m_nRaucher = 0;
        m_nModulTeilnahme = 0;
        m_nEinschreibungWegen = 0;
        m_nSymptomeTags = 0;
        m_nSymptomeMedikation = 0;
        m_nSymptomeAlltag = 0;
        m_nSymptomeNachts = 0;
        m_dFEV1 = -1.0;
        m_sFEV1 = new String();
        m_bFEV1NichtDurchgefuehrt = false;
        m_bStationaereBehandlungen = false;
        m_nStationaereBehandlungen = 0;
        m_sStationaereBehandlungen = null;
        m_nInhalGluko = 0;
        m_nInhalLang = 0;
        m_nInhalKurz = 0;
        m_nSysGluko = 0;
        m_nSonstMedikation = 0;
        m_nTechnikUeberprueft = 0;
        m_nSchulungEmpfohlen = 0;
        m_nSchulungBereitsWahrgenommen = 0;
        m_nSchulungEmpfohlenWahrgenommen = 0;
        m_nBegleiterkrankungen = 0;
        m_nInformationsangebote = 0;
        m_nSelbstmanagement = 0;
        m_nTherapieanpassung = 0;
        m_nIntervall = 0;
        m_sDokuGeplant = null;
        m_sId = null;
        m_sSetId = null;
        m_sKrankenhausIK = null;
        m_sProviderIdLANR = null;
        m_sProviderIdBSNR = null;
        m_sPatientId = null;
        m_sPatientIdEX = null;
        m_sDokumentTyp = null;
        m_sLastXPath = "";
        m_sLastParameter = "";
    }
}

