/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.bkr;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.pruefung.Element;
import de.kbv.xpm.modul.dmp.bkr.Clinical_document_headerHandler;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class PatientHandler
extends Clinical_document_headerHandler {
    protected PatientHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    @Override
    public void elementStart() throws XPMException {
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            Element person = this.m_Element.getChild("person");
            this.m_sValue = null;
            if (person != null) {
                this.m_sValue = person.getChildAttributeValue("id", "EX");
                FehlerListe.addParameter("DMP_NR", (Object)this.m_sValue);
                this.m_sValue = person.findChildAttributeValue("person_name/nm/FAM", "V") + ", " + person.findChildAttributeValue("person_name/nm/GIV", "V");
                if (this.m_sValue.length() > 0) {
                    FehlerListe.addParameter("NAME", (Object)this.m_sValue);
                }
            }
            this.m_sValue = this.m_Element.getChildAttributeValue("birth_dttm", "V");
            if (this.m_sValue != null && this.m_sValue.length() > 0) {
                try {
                    Object sGeburtOrg = this.m_sValue;
                    this.m_sValue = this.datumNullAnpassung(this.m_sValue);
                    Date dateGeburt = m_SciphoxFormat.parse(this.m_sValue);
                    Date now = Calendar.getInstance().getTime();
                    if (dateGeburt.after(now)) {
                        m_MeldungPool.addMeldung("DMP-005", "Geburtsdatum");
                    } else {
                        sGeburtOrg = ((String)sGeburtOrg).substring(8, 10) + "." + ((String)sGeburtOrg).substring(5, 7) + "." + ((String)sGeburtOrg).substring(0, 4);
                    }
                    FehlerListe.addParameter("GEB_AM", sGeburtOrg);
                }
                catch (ParseException ex) {
                    m_MeldungPool.addMeldung("BKA-061", "Geburtsdatum");
                }
            }
            this.m_sValue = this.m_Element.getChildAttributeValue("administrative_gender_cd", "V");
            if (this.m_sValue != null && this.m_sValue.equals("M")) {
                m_MeldungPool.addMeldung("BKA-068");
            }
            if (this.m_sValue != null && this.m_sValue.equals("UN")) {
                m_MeldungPool.addMeldung("BKA-078");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "PatientHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
    }
}

