/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.bkr;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.bkr.XPMEventHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final String cZIP_DIR = "Brustkrebs/Dokumentation/";
    protected static int m_nArztNr = -1;
    protected static final String cVERTRAGSARZTNUMMER = "Vertragsarztnummer";
    protected static String m_sServiceTmr = "";
    protected static Date m_dateUnterschrift = null;
    protected static Date m_dateKopf = null;
    protected static int m_nPatientenAlter = -1;
    protected static SimpleDateFormat m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
    protected static final String cV = "V";
    protected static StringBuffer m_sFileName = new StringBuffer();
    protected static String m_sDokdatum = new String();
    protected static String m_sParameter = "";
    protected static boolean m_bErgebnis = false;
    protected static int m_nAbschnitt = 0;
    protected static String m_sAbschnitt = new String();
    protected static boolean m_bPNPEinschreibung = true;
    protected static final int cABSCHNITT_EINSCHREIBUNG = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_BEFUNDEPRIMAER = 3;
    protected static final int cABSCHNITT_BEHANDLUNG = 4;
    protected static final int cABSCHNITT_BEFUNDREZIDIV = 5;
    protected static final int cABSCHNITT_BEFUNDFERN = 6;
    protected static final int cABSCHNITT_SONSTIGEBEFUNDE = 7;
    protected static final int cABSCHNITT_EINSCHREIBUNGWEGEN = 8;
    protected static final int cABSCHNITT_BEHANDLUNGSSTATUSNACHOP = 9;
    protected static final int cABSCHNITT_NEUEEREIGNISSE = 10;
    protected static final int cABSCHNITT_FORTGESCHRITTEN = 11;
    protected static final int cABSCHNITT_BEHANDLUNGSPLANUNG = 12;
    protected static final String cEINSCHREIBUNG = "Einschreibung";
    protected static final String cANAMNESE = "Anamnese und Behandlungsstatus des Prim\u00e4rtumors/kontralateralen Brustkrebses";
    protected static final String cBEFUNDPRIMAER = "Aktueller Befundstatus des Prim\u00e4rtumors/kontralateralen Brustkrebses";
    protected static final String cBEHANDLUNG = "Behandlung des Prim\u00e4rtumors/kontralateralen Brustkrebses";
    protected static final String cBEFUNDFERN = "Befunde und Therapie von Fernmetastasen";
    protected static final String cSONSTIGEBEFUNDE = "Sonstige Befunde";
    protected static final String cBEHANDLUNGSPLANUNG = "Behandlungsplanung";
    protected static final String cEINSCHREIBUNGWEGEN = "Einschreibung erfolgte wegen";
    protected static final String cBEHANDLUNGSSTATUSNACHOP = "Behandlungsstatus nach operativer Therapie des Prim\u00e4rtumors/kontralateralen Brustkrebses (adjuvante Therapie)";
    protected static final String cNEUEEREIGNISSE = "Seit der letzten Dokumentation neu aufgetretene Ereignisse";
    protected static final String cFORTGESCHRITTEN = "Behandlung bei fortgeschrittener Erkrankung (lokoregion\u00e4res Rezidiv/Fernmetastasen)";
    protected static final String cDATEPATTERN_JJJJ = "[0-9]{4}";
    protected static final String cDATEPATTERN_0000JJJJ = "[0-9]{4}-00-00";
    protected static final String cDATEPATTERN_00MMJJJJ = "[0-9]{4}-[0-9]{2}-00";
    protected static final String cDATEPATTERN_TTMMJJJJ = "[0-9]{4}-(0[1-9]|10|11|12)-(0[1-9]|1[0-9]|2[0-9]|3[0-1])";
    protected static final String cPRIMAERTUMORSICHERUNG = "Prim\u00e4rtumor Datum der histologischen Sicherung";
    protected static final String cKONTRALATERALERBRUSTKREBSDATUM = "Kontralateraler Brustkrebs Datum der histologischen Sicherung";
    protected static final String cKONTRALATERALERBRUSTKREBSDATUMFD = "Kontralateraler Brustkrebs (Datum der histologischen Sicherung)";
    protected static final String cLOKOREZDATUM = "Lokoregion\u00e4res Rezidiv Datum der histologischen Sicherung";
    protected static final String cLOKOREZDATUMFD = "Lokoregion\u00e4res Rezidiv (Datum der histologischen Sicherung)";
    protected static final String cFERNMETASTASENDATUM = "Fernmetastasen Datum der diagnostischen Sicherung von Fernmetastasen";
    protected static final String cFERNMETASTASENDATUMFD = "Lokalisation von Fernmetastasen (Datum der diagnostischen Sicherung)";
    protected static final String cFORTFUEHRUNGTHERAPIE = "Fortf\u00fchrung der adjuvanten endokrinen Therapie";
    protected static final String cFORTFUEHRUNGTHERAPIEFD = "Fortf\u00fchrung der adjuvanten endokrinen Therapie seit der letzten Dokumentation";
    protected static final String cDXABEFUND = "Bei Patientinnen unter adjuvanter Therapie mit Aromataseinhibitoren, sofern die Absicht f\u00fcr eine spezifische medikament\u00f6se Therapie einer Osteoporose besteht: DXA-Befund";
    protected static final String cTNMKlassifizierung = "TNM-Klassifizierung";
    protected static final String cKOERPERGROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPERGEWICHT = "K\u00f6rpergewicht";
    protected static Date m_datePrimaertumorSicherung = null;
    protected static String m_sPrimaertumorSicherung = null;
    protected static Date m_dateKontralateralSicherung = null;
    protected static String m_sKontralateralSicherung = null;
    protected static Date m_dateLokorezSicherung = null;
    protected static String m_sLokorezSicherung = null;
    protected static Date m_dateFernmetastasenSicherung = null;
    protected static String m_sFernmetastasenSicherung = null;
    protected static int m_nEinschreibung = 0;
    protected static int m_nOperativeTherapie = 0;
    protected static int m_nTNMKlassifizierung = 0;
    protected static int m_npT = 0;
    protected static int m_npN = 0;
    protected static int m_nM = 0;
    protected static int m_nRezeptorstatus = 0;
    protected static int m_nAktuelleAdjuvanteEndokrineTherapie = 0;
    protected static int m_nNebenwirkungAktuelleAdjuvanteTherapie = 0;
    protected static int m_nFortfuehrungAdjuvanteEndokrineTherapie = 0;
    protected static int m_nDXABefund = 0;
    protected static int m_nTherapieRezidiv = 0;
    protected static int m_nLokalisationFernmetastasen = 0;
    protected static int m_nBisphosphonate = 0;
    protected static int m_nDenosumab = 0;
    protected static int m_nLymphoedem = 0;
    protected static int m_nBioptischeSicherung = 0;
    protected static int m_nEmpfehlungTraining = 0;
    protected static int m_nKardiotoxischeTumortherapie = 0;
    protected static double m_dKoerpergroesse = 0.0;
    protected static boolean m_bKoerpergroesse = false;
    protected static String m_sKoerpergroesse = new String();
    protected static int m_nKoerpergewicht = 0;
    protected static boolean m_bKoerpergewicht = false;
    protected static String m_sKoerpergewicht = new String();
    protected static int m_nEinschreibungWegen = 0;
    protected static int m_nLokalregionaer = 0;
    protected static int m_nKontralateral = 0;
    protected static int m_nFernmetastasen = 0;
    protected static int m_nBehandlungsstatus = 0;
    protected static int m_nDokumentationsintervall = 0;
    protected static boolean m_nPNP = false;
    protected static String m_sId = null;
    protected static String m_sSetId = null;
    protected static String m_sKrankenhausIK = null;
    protected static String m_sProviderIdLANR = null;
    protected static String m_sProviderIdBSNR = null;
    protected static String m_sPatientId = null;
    protected static String m_sPatientIdEX = null;
    protected static String m_sLastXPath = "";
    protected static String m_sLastParameter = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public boolean juengerAls(Date date1, Date date2) throws Exception {
        try {
            return date2 == null || date1 != null && date2 != null && date1.after(date2);
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (juengerAls)");
            return false;
        }
    }

    public boolean gleichAlt(Date date1, Date date2) throws Exception {
        try {
            return date1 != null && date2 != null && date1.equals(date2);
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (gleichAlt)");
            return false;
        }
    }

    public boolean kleinerOderGleich(Date date1, Date date2) throws Exception {
        try {
            return date1.equals(date2) || date1.before(date2);
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (kleinerOderGleich)");
            return false;
        }
    }

    public boolean validDateString(String date) throws Exception {
        try {
            if (date == null) {
                return false;
            }
            if (date.matches(cDATEPATTERN_JJJJ) && date.matches("(19|20)\\d\\d")) {
                return true;
            }
            return (date.matches(cDATEPATTERN_0000JJJJ) || date.matches(cDATEPATTERN_00MMJJJJ) || date.matches(cDATEPATTERN_TTMMJJJJ)) && date.matches("(19|20)\\d\\d-(0[0-9]|1[0-2])-(([0-2][0-9])|([3][0-1]))");
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (validDateString)");
            return false;
        }
    }

    public String normalizeDate(String date) throws Exception {
        try {
            if (date.matches(cDATEPATTERN_JJJJ)) {
                return date.substring(0, 4) + "-01-01";
            }
            if (date.matches(cDATEPATTERN_0000JJJJ)) {
                return date.substring(0, 5) + "01-01";
            }
            if (date.matches(cDATEPATTERN_00MMJJJJ)) {
                return date.substring(0, 8) + "01";
            }
            if (date.matches(cDATEPATTERN_TTMMJJJJ)) {
                return date;
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (normalizeDate)");
            return null;
        }
    }

    public Date getDatum(String sValue, String sFeld) throws Exception {
        try {
            Date dateReturn = new Date();
            m_SciphoxFormat.setLenient(true);
            try {
                dateReturn = m_SciphoxFormat.parse(sValue);
            }
            catch (ParseException ex) {
                dateReturn = null;
            }
            m_SciphoxFormat.setLenient(false);
            return dateReturn;
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (getDatum)");
            return null;
        }
    }

    public Date getDatumNormalized(String sValue, String sFeld) throws Exception {
        try {
            return this.getDatum(this.normalizeDate(sValue), sFeld);
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (getDatumNormalized)");
            return null;
        }
    }

    public void pruefeED() throws Exception {
        try {
            FehlerListe.newGroup(cEINSCHREIBUNG);
            if (m_sKontralateralSicherung == null && m_sLokorezSicherung == null && m_sFernmetastasenSicherung == null && (m_datePrimaertumorSicherung != null && (m_sPrimaertumorSicherung.matches(cDATEPATTERN_JJJJ) || m_sPrimaertumorSicherung.matches(cDATEPATTERN_0000JJJJ)) || m_sPrimaertumorSicherung.matches(cDATEPATTERN_00MMJJJJ))) {
                m_MeldungPool.addMeldung("BKA-010", cPRIMAERTUMORSICHERUNG);
            }
            if (m_sPrimaertumorSicherung != null && m_sKontralateralSicherung != null && !this.kleinerOderGleich(m_datePrimaertumorSicherung, m_dateKontralateralSicherung)) {
                m_MeldungPool.addMeldung("BKA-082", cPRIMAERTUMORSICHERUNG, cKONTRALATERALERBRUSTKREBSDATUM);
            }
            if (m_sPrimaertumorSicherung != null && m_sLokorezSicherung != null && !this.kleinerOderGleich(m_datePrimaertumorSicherung, m_dateLokorezSicherung)) {
                m_MeldungPool.addMeldung("BKA-082", cPRIMAERTUMORSICHERUNG, cLOKOREZDATUM);
            }
            if (m_sPrimaertumorSicherung != null && m_sFernmetastasenSicherung != null && !this.kleinerOderGleich(m_datePrimaertumorSicherung, m_dateFernmetastasenSicherung)) {
                m_MeldungPool.addMeldung("BKA-082", cPRIMAERTUMORSICHERUNG, cFERNMETASTASENDATUM);
            }
            if (!(m_sPrimaertumorSicherung == null || m_sFernmetastasenSicherung == null || m_sPrimaertumorSicherung.matches(cDATEPATTERN_JJJJ) || m_sPrimaertumorSicherung.matches(cDATEPATTERN_0000JJJJ) || m_sPrimaertumorSicherung.matches(cDATEPATTERN_00MMJJJJ) || m_sPrimaertumorSicherung.matches(cDATEPATTERN_TTMMJJJJ))) {
                m_MeldungPool.addMeldung("BKA-081", cPRIMAERTUMORSICHERUNG);
            }
            if (m_sPrimaertumorSicherung == null && m_sLokorezSicherung == null && m_sFernmetastasenSicherung == null && (m_dateKontralateralSicherung != null && (m_sKontralateralSicherung.matches(cDATEPATTERN_JJJJ) || m_sKontralateralSicherung.matches(cDATEPATTERN_0000JJJJ)) || m_sKontralateralSicherung.matches(cDATEPATTERN_00MMJJJJ))) {
                m_MeldungPool.addMeldung("BKA-010", cKONTRALATERALERBRUSTKREBSDATUM);
            }
            if (m_sKontralateralSicherung != null && m_sLokorezSicherung != null && !this.kleinerOderGleich(m_dateKontralateralSicherung, m_dateLokorezSicherung)) {
                m_MeldungPool.addMeldung("BKA-082", cKONTRALATERALERBRUSTKREBSDATUM, cLOKOREZDATUM);
            }
            if (m_sKontralateralSicherung != null && m_sFernmetastasenSicherung != null && !this.kleinerOderGleich(m_dateKontralateralSicherung, m_dateFernmetastasenSicherung)) {
                m_MeldungPool.addMeldung("BKA-082", cKONTRALATERALERBRUSTKREBSDATUM, cFERNMETASTASENDATUM);
            }
            if (!(m_sKontralateralSicherung == null || m_sFernmetastasenSicherung == null || m_sKontralateralSicherung.matches(cDATEPATTERN_JJJJ) || m_sKontralateralSicherung.matches(cDATEPATTERN_0000JJJJ) || m_sKontralateralSicherung.matches(cDATEPATTERN_00MMJJJJ) || m_sKontralateralSicherung.matches(cDATEPATTERN_TTMMJJJJ))) {
                m_MeldungPool.addMeldung("BKA-081", cKONTRALATERALERBRUSTKREBSDATUM);
            }
            if (m_sPrimaertumorSicherung == null && m_sKontralateralSicherung == null && m_sFernmetastasenSicherung == null && (m_dateLokorezSicherung != null && (m_sLokorezSicherung.matches(cDATEPATTERN_JJJJ) || m_sLokorezSicherung.matches(cDATEPATTERN_0000JJJJ)) || m_sLokorezSicherung.matches(cDATEPATTERN_00MMJJJJ))) {
                m_MeldungPool.addMeldung("BKA-010", cLOKOREZDATUM);
            }
            if (m_sLokorezSicherung != null && m_sFernmetastasenSicherung != null && !this.kleinerOderGleich(m_dateLokorezSicherung, m_dateFernmetastasenSicherung)) {
                m_MeldungPool.addMeldung("BKA-082", cLOKOREZDATUM, cFERNMETASTASENDATUM);
            }
            if (!(m_sLokorezSicherung == null || m_sFernmetastasenSicherung == null || m_sLokorezSicherung.matches(cDATEPATTERN_JJJJ) || m_sLokorezSicherung.matches(cDATEPATTERN_0000JJJJ) || m_sLokorezSicherung.matches(cDATEPATTERN_00MMJJJJ) || m_sLokorezSicherung.matches(cDATEPATTERN_TTMMJJJJ))) {
                m_MeldungPool.addMeldung("BKA-081", cLOKOREZDATUM);
            }
            boolean bPruefeF13AufKomplettesDatum = true;
            if (m_sPrimaertumorSicherung != null && m_sPrimaertumorSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                bPruefeF13AufKomplettesDatum = false;
            }
            if (m_sKontralateralSicherung != null && m_sKontralateralSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                bPruefeF13AufKomplettesDatum = false;
            }
            if (m_sLokorezSicherung != null && m_sLokorezSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                bPruefeF13AufKomplettesDatum = false;
            }
            if (bPruefeF13AufKomplettesDatum && (m_sFernmetastasenSicherung == null || !m_sFernmetastasenSicherung.matches(cDATEPATTERN_TTMMJJJJ))) {
                m_MeldungPool.addMeldung("BKA-083");
            }
            boolean bF10ValidDate = false;
            boolean bF11ValidDate = false;
            boolean bF12ValidDate = false;
            if (m_sPrimaertumorSicherung != null && (m_sPrimaertumorSicherung.matches(cDATEPATTERN_JJJJ) || m_sPrimaertumorSicherung.matches(cDATEPATTERN_0000JJJJ) || m_sPrimaertumorSicherung.matches(cDATEPATTERN_00MMJJJJ) || m_sPrimaertumorSicherung.matches(cDATEPATTERN_TTMMJJJJ))) {
                bF10ValidDate = true;
            }
            if (m_sKontralateralSicherung != null && (m_sKontralateralSicherung.matches(cDATEPATTERN_JJJJ) || m_sKontralateralSicherung.matches(cDATEPATTERN_0000JJJJ) || m_sKontralateralSicherung.matches(cDATEPATTERN_00MMJJJJ) || m_sKontralateralSicherung.matches(cDATEPATTERN_TTMMJJJJ))) {
                bF11ValidDate = true;
            }
            if (m_sLokorezSicherung != null && (m_sLokorezSicherung.matches(cDATEPATTERN_JJJJ) || m_sLokorezSicherung.matches(cDATEPATTERN_0000JJJJ) || m_sLokorezSicherung.matches(cDATEPATTERN_00MMJJJJ) || m_sLokorezSicherung.matches(cDATEPATTERN_TTMMJJJJ))) {
                bF12ValidDate = true;
            }
            if (!(m_sFernmetastasenSicherung == null || bF10ValidDate || bF11ValidDate || bF12ValidDate)) {
                m_MeldungPool.addMeldung("BKA-085", cFERNMETASTASENDATUM);
            }
            GregorianCalendar gcErstellungsDatum = null;
            GregorianCalendar gcDatePrimaertumorSicherung = null;
            GregorianCalendar gcDateKontralateralSicherung = null;
            GregorianCalendar gcDateLokoregionaerSicherung = null;
            GregorianCalendar gcDateFernmetastasenSicherung = null;
            GregorianCalendar gcDatePrimaertumorSicherungPlus10Jahre = null;
            GregorianCalendar gcDateKontralateralSicherungPlus10Jahre = null;
            GregorianCalendar gcDateLokoregionaerSicherungPlus10Jahre = null;
            if (m_dateUnterschrift != null) {
                gcErstellungsDatum = new GregorianCalendar();
                gcErstellungsDatum.setTime(m_dateUnterschrift);
            }
            if (m_datePrimaertumorSicherung != null) {
                gcDatePrimaertumorSicherung = new GregorianCalendar();
                gcDatePrimaertumorSicherung.setTime(m_datePrimaertumorSicherung);
                gcDatePrimaertumorSicherungPlus10Jahre = new GregorianCalendar();
                gcDatePrimaertumorSicherungPlus10Jahre.setTime(m_datePrimaertumorSicherung);
                gcDatePrimaertumorSicherungPlus10Jahre.add(1, 10);
            }
            if (m_dateKontralateralSicherung != null) {
                gcDateKontralateralSicherung = new GregorianCalendar();
                gcDateKontralateralSicherung.setTime(m_dateKontralateralSicherung);
                gcDateKontralateralSicherungPlus10Jahre = new GregorianCalendar();
                gcDateKontralateralSicherungPlus10Jahre.setTime(m_dateKontralateralSicherung);
                gcDateKontralateralSicherungPlus10Jahre.add(1, 10);
            }
            if (m_dateLokorezSicherung != null) {
                gcDateLokoregionaerSicherung = new GregorianCalendar();
                gcDateLokoregionaerSicherung.setTime(m_dateLokorezSicherung);
                gcDateLokoregionaerSicherungPlus10Jahre = new GregorianCalendar();
                gcDateLokoregionaerSicherungPlus10Jahre.setTime(m_dateLokorezSicherung);
                gcDateLokoregionaerSicherungPlus10Jahre.add(1, 10);
            }
            if (m_dateFernmetastasenSicherung != null) {
                gcDateFernmetastasenSicherung = new GregorianCalendar();
                gcDateFernmetastasenSicherung.setTime(m_dateFernmetastasenSicherung);
            }
            if (m_dateUnterschrift != null && m_datePrimaertumorSicherung != null && !this.kleinerOderGleich(m_datePrimaertumorSicherung, m_dateUnterschrift)) {
                m_MeldungPool.addMeldung("BKA-080", cPRIMAERTUMORSICHERUNG);
            }
            if (m_dateUnterschrift != null && m_dateKontralateralSicherung != null && !this.kleinerOderGleich(m_dateKontralateralSicherung, m_dateUnterschrift)) {
                m_MeldungPool.addMeldung("BKA-080", cKONTRALATERALERBRUSTKREBSDATUM);
            }
            if (m_dateUnterschrift != null && m_dateLokorezSicherung != null && !this.kleinerOderGleich(m_dateLokorezSicherung, m_dateUnterschrift)) {
                m_MeldungPool.addMeldung("BKA-080", cLOKOREZDATUM);
            }
            if (m_dateUnterschrift != null && m_dateFernmetastasenSicherung != null && !this.kleinerOderGleich(m_dateFernmetastasenSicherung, m_dateUnterschrift)) {
                m_MeldungPool.addMeldung("BKA-080", cFERNMETASTASENDATUM);
            }
            boolean einschreibungGueltigPrimaer = false;
            boolean einschreibungGueltigKontralateral = false;
            boolean einschreibungGueltigLokoregionaer = false;
            boolean einschreibungGueltigFernmetastasen = false;
            if (gcErstellungsDatum != null && gcDatePrimaertumorSicherungPlus10Jahre != null && !gcDatePrimaertumorSicherungPlus10Jahre.before(gcErstellungsDatum) && m_sPrimaertumorSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                einschreibungGueltigPrimaer = true;
            }
            if (gcErstellungsDatum != null && gcDateKontralateralSicherungPlus10Jahre != null && !gcDateKontralateralSicherungPlus10Jahre.before(gcErstellungsDatum) && m_sKontralateralSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                einschreibungGueltigKontralateral = true;
            }
            if (gcErstellungsDatum != null && gcDateLokoregionaerSicherungPlus10Jahre != null && !gcDateLokoregionaerSicherungPlus10Jahre.before(gcErstellungsDatum) && m_sLokorezSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                einschreibungGueltigLokoregionaer = true;
            }
            if (gcErstellungsDatum != null && gcDateFernmetastasenSicherung != null && (this.validDateString(m_sPrimaertumorSicherung) || this.validDateString(m_sKontralateralSicherung) || this.validDateString(m_sLokorezSicherung))) {
                einschreibungGueltigFernmetastasen = true;
            }
            if (!(einschreibungGueltigPrimaer || einschreibungGueltigKontralateral || einschreibungGueltigLokoregionaer || einschreibungGueltigFernmetastasen)) {
                m_MeldungPool.addMeldung("BKA-084");
            }
            m_MeldungPool.reportMeldungen();
            this.pruefe14bis23();
            this.pruefe24bis25(einschreibungGueltigFernmetastasen);
            FehlerListe.newGroup(cSONSTIGEBEFUNDE);
            if (m_nLymphoedem == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Symptomatisches Lymph\u00f6dem");
            }
            if (this.countBits(m_nLymphoedem) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Symptomatisches Lymph\u00f6dem");
            }
            if (m_nEmpfehlungTraining == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Empfehlung zu regelm\u00e4\u00dfigem k\u00f6rperlichen Training abgegeben");
            }
            if (this.countBits(m_nEmpfehlungTraining) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Empfehlung zu regelm\u00e4\u00dfigem k\u00f6rperlichen Training abgegeben");
            }
            if (m_nKardiotoxischeTumortherapie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Z. n. besonders kardiotoxischer Tumortherapie");
            }
            if (this.testBit(m_nKardiotoxischeTumortherapie, 8) && this.countBits(m_nKardiotoxischeTumortherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-098", "Z. n. besonders kardiotoxischer Tumortherapie", "Unbekannt");
            }
            if (this.testBit(m_nKardiotoxischeTumortherapie, 16) && this.countBits(m_nKardiotoxischeTumortherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-098", "Z. n. besonders kardiotoxischer Tumortherapie", "Nein");
            }
            if (!m_bKoerpergroesse) {
                m_MeldungPool.addMeldung("DMP-002", cKOERPERGROESSE);
            }
            if (m_dKoerpergroesse < 0.0 || m_dKoerpergroesse > 2.5) {
                m_MeldungPool.addMeldung("DMP-021");
            }
            if (!m_bKoerpergewicht) {
                m_MeldungPool.addMeldung("DMP-002", cKOERPERGEWICHT);
            }
            if (m_nKoerpergewicht < 0 || m_nKoerpergewicht > 300) {
                m_MeldungPool.addMeldung("DMP-023");
            }
            FehlerListe.newGroup(cBEHANDLUNGSPLANUNG);
            if (m_nDokumentationsintervall == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Dokumentationsintervall");
            }
            if (this.countBits(m_nDokumentationsintervall) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Dokumentationsintervall");
            }
            Date now = Calendar.getInstance().getTime();
            if (m_dateKopf != null && m_dateKopf.after(now) && !isDateTestDeactivated) {
                m_MeldungPool.addMeldung("BKA-016", "Kopfdatum (origination_dttm)", "Systemdatum");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefeED)");
        }
    }

    public void pruefe14bis23() throws Exception {
        try {
            FehlerListe.newGroup(cANAMNESE);
            if ((m_sPrimaertumorSicherung != null && m_sPrimaertumorSicherung.matches(cDATEPATTERN_TTMMJJJJ) || m_sKontralateralSicherung != null && m_sKontralateralSicherung.matches(cDATEPATTERN_TTMMJJJJ)) && m_sLokorezSicherung == null && m_sFernmetastasenSicherung == null && m_nOperativeTherapie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Operative Therapie");
            }
            if ((m_sLokorezSicherung != null || m_sFernmetastasenSicherung != null) && m_nOperativeTherapie > 0) {
                m_MeldungPool.addMeldung("BKA-085", "Operative Therapie");
            }
            if (this.testBit(m_nOperativeTherapie, 32) && this.countBits(m_nOperativeTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-017", "OP geplant", "Operative Therapie");
            }
            if (this.testBit(m_nOperativeTherapie, 64) && this.countBits(m_nOperativeTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-017", "OP nicht geplant", "Operative Therapie");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEFUNDPRIMAER);
            if (m_nOperativeTherapie > 0 && m_nTNMKlassifizierung == 0) {
                m_MeldungPool.addMeldung("DMP-002", cTNMKlassifizierung);
            }
            if (m_nOperativeTherapie == 0 && m_nTNMKlassifizierung > 0) {
                m_MeldungPool.addMeldung("BKA-086", cTNMKlassifizierung, "Operative Therapie");
            }
            if ((this.testBit(m_nOperativeTherapie, 32) || this.testBit(m_nOperativeTherapie, 64)) && !this.testBit(m_nTNMKlassifizierung, 2)) {
                m_MeldungPool.addMeldung("BKA-088");
            }
            if (this.countBits(m_nTNMKlassifizierung) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cTNMKlassifizierung);
            }
            if (m_nOperativeTherapie > 0 && m_nTNMKlassifizierung == 0) {
                m_MeldungPool.addMeldung("BKA-089", cTNMKlassifizierung, "Operative Therapie");
            }
            if (this.countBits(m_npT) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "T");
            }
            if (m_nOperativeTherapie > 0 && m_npT == 0) {
                m_MeldungPool.addMeldung("BKA-089", "T", "Operative Therapie");
            }
            if (this.countBits(m_npN) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "N");
            }
            if (m_nOperativeTherapie > 0 && m_npN == 0) {
                m_MeldungPool.addMeldung("BKA-089", "N", "Operative Therapie");
            }
            if (this.countBits(m_nM) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "M");
            }
            if (m_nOperativeTherapie > 0 && m_nM == 0) {
                m_MeldungPool.addMeldung("BKA-089", "M", "Operative Therapie");
            }
            if (this.testBit(m_nM, 2) && (m_nRezeptorstatus > 0 || m_nAktuelleAdjuvanteEndokrineTherapie > 0 || m_nNebenwirkungAktuelleAdjuvanteTherapie > 0 || m_nFortfuehrungAdjuvanteEndokrineTherapie > 0 || m_nDXABefund > 0)) {
                m_MeldungPool.addMeldung("BKA-087");
            }
            if (m_nOperativeTherapie > 0 && this.testBit(m_nM, 1) && m_nRezeptorstatus == 0) {
                m_MeldungPool.addMeldung("BKA-101");
            }
            if (m_nOperativeTherapie > 0 && this.testBit(m_nM, 2) && m_nRezeptorstatus > 0) {
                m_MeldungPool.addMeldung("BKA-102");
            }
            if (m_nRezeptorstatus == 0 && m_nOperativeTherapie > 0 && this.testBit(m_nM, 1)) {
                m_MeldungPool.addMeldung("DMP-002", "Hormonrezeptorstatus");
            }
            if (m_nRezeptorstatus > 0 && this.testBit(m_nM, 2)) {
                m_MeldungPool.addMeldung("BKA-090");
            }
            if (this.countBits(m_nRezeptorstatus) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Hormonrezeptorstatus");
            }
            if (this.testBit(m_nRezeptorstatus, 1) && (m_nAktuelleAdjuvanteEndokrineTherapie == 0 || m_nFortfuehrungAdjuvanteEndokrineTherapie == 0)) {
                m_MeldungPool.addMeldung("BKA-091");
            }
            if (this.testBit(m_nRezeptorstatus, 2) && (m_nAktuelleAdjuvanteEndokrineTherapie != 0 || m_nNebenwirkungAktuelleAdjuvanteTherapie != 0 || m_nFortfuehrungAdjuvanteEndokrineTherapie != 0)) {
                m_MeldungPool.addMeldung("BKA-092");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNG);
            if (m_nRezeptorstatus == 0 && m_nAktuelleAdjuvanteEndokrineTherapie > 0) {
                m_MeldungPool.addMeldung("BKA-085", "Aktuelle adjuvante endokrine Therapie");
            }
            if (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 1) && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 2) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 8) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 16))) {
                m_MeldungPool.addMeldung("BKA-094");
            }
            if (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 2) && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 8) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 16))) {
                m_MeldungPool.addMeldung("BKA-063");
            }
            if (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 4) && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 8) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 16))) {
                m_MeldungPool.addMeldung("BKA-096");
            }
            if (this.countBits(m_nNebenwirkungAktuelleAdjuvanteTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (m_nNebenwirkungAktuelleAdjuvanteTherapie == 0 && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 1) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 2) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 4))) {
                m_MeldungPool.addMeldung("DMP-002", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (m_nNebenwirkungAktuelleAdjuvanteTherapie != 0 && m_nAktuelleAdjuvanteEndokrineTherapie == 0) {
                m_MeldungPool.addMeldung("BKA-085", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (m_nNebenwirkungAktuelleAdjuvanteTherapie > 0 && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 8) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 16))) {
                m_MeldungPool.addMeldung("BKA-085", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (this.countBits(m_nFortfuehrungAdjuvanteEndokrineTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cFORTFUEHRUNGTHERAPIE);
            }
            if (m_nFortfuehrungAdjuvanteEndokrineTherapie > 0 && m_nRezeptorstatus == 0) {
                m_MeldungPool.addMeldung("BKA-085", cFORTFUEHRUNGTHERAPIE);
            }
            if (this.countBits(m_nDXABefund) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cDXABEFUND);
            }
            if (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 1) && m_nDXABefund == 0) {
                m_MeldungPool.addMeldung("DMP-002", cDXABEFUND);
            }
            if (!this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 1) && this.countBits(m_nDXABefund) > 0) {
                m_MeldungPool.addMeldung("BKA-093");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefe14bis23)");
        }
    }

    public void pruefe24bis25(boolean bEinschreibungGueltig) throws Exception {
        try {
            FehlerListe.newGroup(cBEFUNDFERN);
            if (!(this.testBit(m_nLokalisationFernmetastasen, 1) || m_nBisphosphonate <= 0 && m_nDenosumab <= 0)) {
                m_MeldungPool.addMeldung("BKA-012");
            }
            if (!bEinschreibungGueltig) {
                if (m_nLokalisationFernmetastasen > 0 && (m_sPrimaertumorSicherung != null || m_sKontralateralSicherung != null || m_sLokorezSicherung != null) && m_sFernmetastasenSicherung == null) {
                    m_MeldungPool.addMeldung("BKA-085", "Lokalisation von Fernmetastasen");
                }
            } else {
                if (m_nLokalisationFernmetastasen == 0 && m_sFernmetastasenSicherung != null) {
                    m_MeldungPool.addMeldung("DMP-002", "Lokalisation von Fernmetastasen");
                }
                if (this.testBit(m_nLokalisationFernmetastasen, 1) && m_nBisphosphonate == 0) {
                    m_MeldungPool.addMeldung("BKA-099", "Bisphosphonate");
                }
                if (this.testBit(m_nLokalisationFernmetastasen, 1) && m_nDenosumab == 0) {
                    m_MeldungPool.addMeldung("BKA-099", "Denosumab");
                }
                if (this.testBit(m_nLokalisationFernmetastasen, 1) && m_nBisphosphonate == 0 && m_nDenosumab == 0) {
                    m_MeldungPool.addMeldung("BKA-011");
                }
                if (this.testBit(m_nBisphosphonate, 1) && this.testBit(m_nBisphosphonate, 2)) {
                    m_MeldungPool.addMeldung("BKA-022", "Bisphosphonate", "Ja", "Nein");
                }
                if (this.testBit(m_nBisphosphonate, 1) && this.testBit(m_nBisphosphonate, 4)) {
                    m_MeldungPool.addMeldung("BKA-022", "Bisphosphonate", "Ja", "Kontraindikation");
                }
                if (this.testBit(m_nDenosumab, 1) && this.testBit(m_nDenosumab, 2)) {
                    m_MeldungPool.addMeldung("BKA-022", "Denosumab", "Ja", "Nein");
                }
                if (this.testBit(m_nDenosumab, 1) && this.testBit(m_nDenosumab, 4)) {
                    m_MeldungPool.addMeldung("BKA-022", "Denosumab", "Ja", "Kontraindikation");
                }
                m_MeldungPool.reportMeldungen();
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefe24bis25)");
        }
    }

    public void pruefePostoperativ() throws Exception {
        try {
            FehlerListe.newGroup(cANAMNESE);
            if (m_nOperativeTherapie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Operative Therapie");
            }
            if (this.testBit(m_nOperativeTherapie, 32)) {
                m_MeldungPool.addMeldung("DMP-100", "OP geplant", "Operative Therapie");
            }
            if (this.testBit(m_nOperativeTherapie, 64) && this.countBits(m_nOperativeTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-017", "OP nicht geplant", "Operative Therapie");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEFUNDPRIMAER);
            if (m_nTNMKlassifizierung == 0) {
                m_MeldungPool.addMeldung("DMP-002", cTNMKlassifizierung);
            }
            if (this.countBits(m_nTNMKlassifizierung) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cTNMKlassifizierung);
            }
            if ((this.testBit(m_nOperativeTherapie, 1) || this.testBit(m_nOperativeTherapie, 2) || this.testBit(m_nOperativeTherapie, 4) || this.testBit(m_nOperativeTherapie, 8) || this.testBit(m_nOperativeTherapie, 16)) && this.testBit(m_nTNMKlassifizierung, 2)) {
                m_MeldungPool.addMeldung("BKA-100");
            }
            if (this.testBit(m_nOperativeTherapie, 64) && (this.testBit(m_nTNMKlassifizierung, 1) || this.testBit(m_nTNMKlassifizierung, 4))) {
                m_MeldungPool.addMeldung("BKA-097");
            }
            if (m_npT == 0) {
                m_MeldungPool.addMeldung("DMP-002", "T");
            }
            if (this.countBits(m_npT) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "T");
            }
            if (m_npN == 0) {
                m_MeldungPool.addMeldung("DMP-002", "N");
            }
            if (this.countBits(m_npN) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "N");
            }
            if (m_nM == 0) {
                m_MeldungPool.addMeldung("DMP-002", "M");
            }
            if (this.countBits(m_nM) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "M");
            }
            if (this.countBits(m_nRezeptorstatus) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Hormonrezeptorstatus");
            }
            if (m_nRezeptorstatus > 0 && this.testBit(m_nM, 2)) {
                m_MeldungPool.addMeldung("BKA-090");
            }
            if (m_nRezeptorstatus == 0 && this.testBit(m_nM, 1)) {
                m_MeldungPool.addMeldung("DMP-002", "Hormonrezeptorstatus");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNG);
            if (this.countBits(m_nNebenwirkungAktuelleAdjuvanteTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (this.countBits(m_nFortfuehrungAdjuvanteEndokrineTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cFORTFUEHRUNGTHERAPIE);
            }
            if (this.countBits(m_nDXABefund) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cDXABEFUND);
            }
            FehlerListe.newGroup(cBEFUNDFERN);
            if (this.testBit(m_nBisphosphonate, 1) && (this.testBit(m_nBisphosphonate, 2) || this.testBit(m_nBisphosphonate, 4))) {
                m_MeldungPool.addMeldung("BKA-014", "Bisphosphonat-Therapie bei Knochenmetastasen");
            }
            if (this.testBit(m_nDenosumab, 1) && (this.testBit(m_nDenosumab, 2) || this.testBit(m_nDenosumab, 4))) {
                m_MeldungPool.addMeldung("BKA-014", "Denosumab-Therapie bei Knochenmetastasen");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSONSTIGEBEFUNDE);
            if (this.countBits(m_nLymphoedem) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Symptomatisches Lymph\u00f6dem");
            }
            if (this.countBits(m_nEmpfehlungTraining) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Empfehlung zu regelm\u00e4\u00dfigem k\u00f6rperlichen Training abgegeben");
            }
            if (this.testBit(m_nKardiotoxischeTumortherapie, 16) && this.countBits(m_nKardiotoxischeTumortherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-017", "Nein", "Z. n. besonders kardiotoxischer Tumortherapie");
            }
            if (m_bKoerpergroesse && m_dKoerpergroesse < 0.0 || m_dKoerpergroesse > 2.5) {
                m_MeldungPool.addMeldung("DMP-021");
            }
            if (m_bKoerpergewicht && m_nKoerpergewicht < 0 || m_nKoerpergewicht > 300) {
                m_MeldungPool.addMeldung("DMP-023");
            }
            FehlerListe.newGroup(cBEHANDLUNGSPLANUNG);
            if (m_nDokumentationsintervall != 0) {
                m_MeldungPool.addMeldung("BKA-103");
            }
            Date now = Calendar.getInstance().getTime();
            if (m_dateKopf != null && m_dateKopf.after(now) && !isDateTestDeactivated) {
                m_MeldungPool.addMeldung("BKA-016", "Kopfdatum (origination_dttm)", "Systemdatum");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefePostoperativ)");
        }
    }

    public void pruefeFD() throws Exception {
        try {
            FehlerListe.newGroup(cEINSCHREIBUNGWEGEN);
            if (this.countBits(m_nEinschreibungWegen) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cEINSCHREIBUNGWEGEN);
            } else if (m_nEinschreibungWegen == 0) {
                m_MeldungPool.addMeldung("BKA-004", cEINSCHREIBUNGWEGEN);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNGSSTATUSNACHOP);
            if (m_nAktuelleAdjuvanteEndokrineTherapie == 0 && (this.testBit(m_nEinschreibungWegen, 1) || this.testBit(m_nEinschreibungWegen, 2))) {
                m_MeldungPool.addMeldung("BKA-004", "Aktuelle adjuvante endokrine Therapie");
            }
            if (m_nAktuelleAdjuvanteEndokrineTherapie > 0 && (this.testBit(m_nEinschreibungWegen, 4) || this.testBit(m_nEinschreibungWegen, 8))) {
                m_MeldungPool.addMeldung("BKA-085", "Aktuelle adjuvante endokrine Therapie");
            }
            if (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 1) && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 2) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 8) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 16))) {
                m_MeldungPool.addMeldung("BKA-062");
            }
            if (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 2) && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 8) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 16))) {
                m_MeldungPool.addMeldung("BKA-063");
            }
            if (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 4) && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 8) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 16))) {
                m_MeldungPool.addMeldung("BKA-064");
            }
            if (this.countBits(m_nNebenwirkungAktuelleAdjuvanteTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (m_nNebenwirkungAktuelleAdjuvanteTherapie == 0 && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 1) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 2) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 4))) {
                m_MeldungPool.addMeldung("DMP-002", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (m_nNebenwirkungAktuelleAdjuvanteTherapie > 0 && (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 8) || this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 16))) {
                m_MeldungPool.addMeldung("BKA-085", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (m_nNebenwirkungAktuelleAdjuvanteTherapie != 0 && m_nAktuelleAdjuvanteEndokrineTherapie == 0) {
                m_MeldungPool.addMeldung("BKA-085", "Nebenwirkungen der aktuellen adjuvanten endokrinen Therapie");
            }
            if (this.countBits(m_nFortfuehrungAdjuvanteEndokrineTherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cFORTFUEHRUNGTHERAPIEFD);
            }
            if (m_nFortfuehrungAdjuvanteEndokrineTherapie == 0 && (this.testBit(m_nEinschreibungWegen, 1) || this.testBit(m_nEinschreibungWegen, 2))) {
                m_MeldungPool.addMeldung("DMP-002", cFORTFUEHRUNGTHERAPIEFD);
            }
            if (m_nFortfuehrungAdjuvanteEndokrineTherapie > 0 && (this.testBit(m_nEinschreibungWegen, 4) || this.testBit(m_nEinschreibungWegen, 8))) {
                m_MeldungPool.addMeldung("BKA-085", cFORTFUEHRUNGTHERAPIEFD);
            }
            if (this.countBits(m_nDXABefund) > 1) {
                m_MeldungPool.addMeldung("BKA-001", cDXABEFUND);
            }
            if (this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 1) && m_nDXABefund == 0) {
                m_MeldungPool.addMeldung("DMP-002", cDXABEFUND);
            }
            if (!this.testBit(m_nAktuelleAdjuvanteEndokrineTherapie, 1) && m_nDXABefund > 0) {
                m_MeldungPool.addMeldung("BKA-085", cDXABEFUND);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cNEUEEREIGNISSE);
            if (m_sLokorezSicherung == null && m_nLokalregionaer == 0) {
                m_MeldungPool.addMeldung("DMP-002", cLOKOREZDATUMFD);
            }
            if (m_sLokorezSicherung != null && m_nLokalregionaer > 0) {
                m_MeldungPool.addMeldung("BKA-075", cLOKOREZDATUMFD);
            }
            if (m_sLokorezSicherung != null && !m_sLokorezSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                m_MeldungPool.addMeldung("BKA-044", cLOKOREZDATUMFD);
            }
            if (m_sLokorezSicherung != null && m_dateLokorezSicherung != null && m_dateUnterschrift != null && m_dateLokorezSicherung.after(m_dateUnterschrift)) {
                m_MeldungPool.addMeldung("BKA-015", cLOKOREZDATUMFD);
            }
            if (m_sKontralateralSicherung == null && m_nKontralateral == 0) {
                m_MeldungPool.addMeldung("DMP-002", cKONTRALATERALERBRUSTKREBSDATUMFD);
            }
            if (m_sKontralateralSicherung != null && m_nKontralateral > 0) {
                m_MeldungPool.addMeldung("BKA-075", cKONTRALATERALERBRUSTKREBSDATUMFD);
            }
            if (m_sKontralateralSicherung != null && !m_sKontralateralSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                m_MeldungPool.addMeldung("BKA-044", cKONTRALATERALERBRUSTKREBSDATUMFD);
            }
            if (m_sKontralateralSicherung != null && m_dateKontralateralSicherung != null && m_dateUnterschrift != null && m_dateKontralateralSicherung.after(m_dateUnterschrift)) {
                m_MeldungPool.addMeldung("BKA-015", cKONTRALATERALERBRUSTKREBSDATUMFD);
            }
            if (m_sFernmetastasenSicherung == null && m_nFernmetastasen == 0) {
                m_MeldungPool.addMeldung("DMP-002", cFERNMETASTASENDATUMFD);
            }
            if (m_sFernmetastasenSicherung != null && !m_sFernmetastasenSicherung.matches(cDATEPATTERN_TTMMJJJJ)) {
                m_MeldungPool.addMeldung("BKA-044", cFERNMETASTASENDATUMFD);
            }
            if (m_sFernmetastasenSicherung != null && m_dateFernmetastasenSicherung != null && m_dateUnterschrift != null && m_dateFernmetastasenSicherung.after(m_dateUnterschrift)) {
                m_MeldungPool.addMeldung("BKA-015", cFERNMETASTASENDATUMFD);
            }
            if (m_sFernmetastasenSicherung != null && m_sFernmetastasenSicherung.matches(cDATEPATTERN_TTMMJJJJ) && m_nFernmetastasen == 0) {
                m_MeldungPool.addMeldung("BKA-076", cFERNMETASTASENDATUMFD);
            }
            if (this.testBit(m_nFernmetastasen, 16) && (this.countBits(m_nFernmetastasen) > 1 || m_sFernmetastasenSicherung != null)) {
                m_MeldungPool.addMeldung("BKA-027", cFERNMETASTASENDATUMFD);
            }
            if (m_nBioptischeSicherung == 0 && this.testBit(m_nFernmetastasen, 2)) {
                m_MeldungPool.addMeldung("DMP-002", "Bioptische Sicherung der viszeralen Metastasen");
            }
            if (m_nBioptischeSicherung > 0 && !this.testBit(m_nFernmetastasen, 2)) {
                m_MeldungPool.addMeldung("BKA-085", "Bioptische Sicherung der viszeralen Metastasen");
            }
            if (this.countBits(m_nBioptischeSicherung) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Bioptische Sicherung der viszeralen Metastasen");
            }
            if (this.testBit(m_nBioptischeSicherung, 2) && this.countBits(m_nBioptischeSicherung) > 1) {
                m_MeldungPool.addMeldung("BKA-027", "Bioptische Sicherung der viszeralen Metastasen");
            }
            if (m_nLymphoedem == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Symptomatisches Lymph\u00f6dem");
            }
            if (this.countBits(m_nLymphoedem) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Symptomatisches Lymph\u00f6dem");
            }
            m_MeldungPool.reportMeldungen();
            if (this.countBits(m_nLymphoedem) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Symptomatisches Lymph\u00f6dem");
            }
            FehlerListe.newGroup(cSONSTIGEBEFUNDE);
            if (m_nEmpfehlungTraining == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Empfehlung zu regelm\u00e4\u00dfigem k\u00f6rperlichen Training abgegeben");
            }
            if (this.countBits(m_nEmpfehlungTraining) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Empfehlung zu regelm\u00e4\u00dfigem k\u00f6rperlichen Training abgegeben");
            }
            if (m_nKardiotoxischeTumortherapie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Z. n. besonders kardiotoxischer Tumortherapie");
            }
            if (this.testBit(m_nKardiotoxischeTumortherapie, 8) && this.countBits(m_nKardiotoxischeTumortherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-098", "Z. n. besonders kardiotoxischer Tumortherapie", "Unbekannt");
            }
            if (this.testBit(m_nKardiotoxischeTumortherapie, 16) && this.countBits(m_nKardiotoxischeTumortherapie) > 1) {
                m_MeldungPool.addMeldung("BKA-098", "Z. n. besonders kardiotoxischer Tumortherapie", "Nein");
            }
            if (!m_bKoerpergroesse) {
                m_MeldungPool.addMeldung("DMP-002", cKOERPERGROESSE);
            }
            if (m_dKoerpergroesse < 0.0 || m_dKoerpergroesse > 2.5) {
                m_MeldungPool.addMeldung("DMP-021");
            }
            if (!m_bKoerpergewicht) {
                m_MeldungPool.addMeldung("DMP-002", cKOERPERGEWICHT);
            }
            if (m_nKoerpergewicht < 0 || m_nKoerpergewicht > 300) {
                m_MeldungPool.addMeldung("DMP-023");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cFORTGESCHRITTEN);
            if (this.testBit(m_nFernmetastasen, 1) && m_nBisphosphonate == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Bisphoponate");
            }
            if (this.testBit(m_nFernmetastasen, 1) && m_nDenosumab == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Denosumab");
            }
            if (m_nBisphosphonate > 0 && m_nDenosumab == 0) {
                m_MeldungPool.addMeldung("BKA-003", "Bisphosphonate", "Denosumab");
            } else if (m_nDenosumab > 0 && m_nBisphosphonate == 0) {
                m_MeldungPool.addMeldung("BKA-003", "Denosumab", "Bisphosphonate");
            }
            if (this.testBit(m_nBisphosphonate, 1) && this.testBit(m_nBisphosphonate, 2)) {
                m_MeldungPool.addMeldung("BKA-022", "Bisphosphonate", "Ja", "Nein");
            }
            if (this.testBit(m_nBisphosphonate, 1) && this.testBit(m_nBisphosphonate, 4)) {
                m_MeldungPool.addMeldung("BKA-022", "Bisphosphonate", "Ja", "Kontraindikation");
            }
            if (this.testBit(m_nDenosumab, 1) && this.testBit(m_nDenosumab, 2)) {
                m_MeldungPool.addMeldung("BKA-022", "Denosumab", "Ja", "Nein");
            }
            if (this.testBit(m_nDenosumab, 1) && this.testBit(m_nDenosumab, 4)) {
                m_MeldungPool.addMeldung("BKA-022", "Denosumab", "Ja", "Kontraindikation");
            }
            FehlerListe.newGroup(cBEHANDLUNGSPLANUNG);
            if (m_nDokumentationsintervall == 0) {
                m_MeldungPool.addMeldung("DMP-002", "Dokumentationsintervall");
            }
            if (this.countBits(m_nDokumentationsintervall) > 1) {
                m_MeldungPool.addMeldung("BKA-001", "Dokumentationsintervall");
            }
            Date now = Calendar.getInstance().getTime();
            if (m_dateKopf != null && m_dateKopf.after(now) && !isDateTestDeactivated) {
                m_MeldungPool.addMeldung("BKA-016", "Kopfdatum (origination_dttm)", "Systemdatum");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefeFD)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.addParameter("BSNR", (Object)m_sProviderIdBSNR);
            FehlerListe.newGroup("Header");
            if (m_sProviderIdLANR == null && m_sProviderIdBSNR == null && m_sKrankenhausIK == null) {
                m_MeldungPool.addMeldung("DMP-061");
            }
            if (m_sProviderIdLANR != null && m_sProviderIdBSNR == null || m_sProviderIdLANR == null && m_sProviderIdBSNR != null) {
                m_MeldungPool.addMeldung("DMP-060");
            }
            if (m_sProviderIdLANR != null) {
                FehlerListe.addParameter("ARZT_NR", (Object)m_sProviderIdLANR);
            }
            if (m_sPatientId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/patient/person/id");
            }
            if (m_sId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/id");
            }
            if (m_sSetId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/set_id");
            }
            if (m_sPatientId != null && m_sId != null) {
                if (!m_sPatientId.equals(m_sId)) {
                    m_MeldungPool.addMeldung("DMP-004", m_sPatientId, m_sId);
                } else {
                    boolean bIdentisch = false;
                    if (m_sProviderIdBSNR != null && m_sId.equals(m_sProviderIdBSNR)) {
                        bIdentisch = true;
                    }
                    if (m_sKrankenhausIK != null && m_sId.equals(m_sKrankenhausIK)) {
                        bIdentisch = true;
                    }
                    if (!bIdentisch) {
                        m_MeldungPool.addMeldung("DMP-068");
                    }
                }
            }
            if (m_sProviderIdLANR != null && m_sProviderIdLANR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "LANR");
            }
            if (m_sKrankenhausIK != null && m_sKrankenhausIK.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "Krankenhaus-IK");
            }
            if (m_sProviderIdBSNR != null && m_sProviderIdBSNR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "BSNR");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Schemaname");
            this.pruefeXMLSchemaname();
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            boolean bPruefeLang = false;
            if (m_sKrankenhausIK != null && (m_sProviderIdLANR == null && m_sProviderIdLANR == null || m_sKrankenhausIK.equals(m_sPatientId))) {
                m_sFileName.append(m_sKrankenhausIK);
                m_sFileName.append("_");
                bPruefeLang = true;
            }
            m_sFileName.append(m_sPatientIdEX);
            m_sFileName.append("_");
            m_sFileName.append(m_sDokdatum.replaceAll("-", ""));
            if (m_bFolgeDoku) {
                if (m_b4a) {
                    m_sFileName.append("_4a.FBK");
                } else {
                    m_sFileName.append(".FBK");
                }
            } else if (m_b4a) {
                m_sFileName.append("_4a.EBK");
            } else {
                m_sFileName.append(".EBK");
            }
            this.m_sValue = m_DatenPool.getString("XPM_FILE");
            String sErwarteterName = m_sFileName.toString();
            String sPattern = m_bFolgeDoku ? (m_b4a ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_4a.FBK" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.FBK") : (m_b4a ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_4a.EBK" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EBK");
            String sTemp = this.m_sValue.substring(0, 10);
            if (sTemp == null || sTemp.length() < 10 || sTemp.indexOf(95) != 9) {
                m_MeldungPool.addMeldung("DMP-059");
            } else if (bPruefeLang) {
                if (this.m_sValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, sErwarteterName);
                }
            } else {
                String sSubValue = this.m_sValue.substring(10);
                if (sSubValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, this.m_sValue.substring(0, 10) + sErwarteterName);
                }
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_DIR");
            if (this.m_sValue != null && !this.m_sValue.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("BKA-039", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+BK_425\\.zip)")) {
                if (this.m_sValue.matches("(?i:.+BK\\.zip)")) {
                    m_MeldungPool.addMeldung("BKA-079W", "BK_425.zip");
                } else {
                    m_MeldungPool.addMeldung("BKA-079F", "BK_425.zip");
                }
            }
            m_MeldungPool.reportMeldungen();
            if (!m_bFolgeDoku) {
                if (m_bPNPEinschreibung) {
                    System.out.println("Pruefe Pnp-Einschreibung");
                    m_MeldungPool.addMeldung("BKA-005");
                    this.pruefePostoperativ();
                } else {
                    this.pruefeED();
                }
            } else {
                this.pruefeFD();
            }
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        m_nArztNr = -1;
        m_sServiceTmr = "";
        m_dateUnterschrift = null;
        m_dateKopf = null;
        m_nPatientenAlter = -1;
        m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        m_sFileName = new StringBuffer();
        m_sDokdatum = new String();
        m_sParameter = "";
        m_bErgebnis = false;
        m_nAbschnitt = 0;
        m_sAbschnitt = new String();
        m_bPNPEinschreibung = true;
        m_datePrimaertumorSicherung = null;
        m_sPrimaertumorSicherung = null;
        m_dateKontralateralSicherung = null;
        m_sKontralateralSicherung = null;
        m_dateLokorezSicherung = null;
        m_sLokorezSicherung = null;
        m_dateFernmetastasenSicherung = null;
        m_sFernmetastasenSicherung = null;
        m_nEinschreibung = 0;
        m_nOperativeTherapie = 0;
        m_nTNMKlassifizierung = 0;
        m_npT = 0;
        m_npN = 0;
        m_nM = 0;
        m_nRezeptorstatus = 0;
        m_nAktuelleAdjuvanteEndokrineTherapie = 0;
        m_nNebenwirkungAktuelleAdjuvanteTherapie = 0;
        m_nFortfuehrungAdjuvanteEndokrineTherapie = 0;
        m_nDXABefund = 0;
        m_nTherapieRezidiv = 0;
        m_nLokalisationFernmetastasen = 0;
        m_nBisphosphonate = 0;
        m_nDenosumab = 0;
        m_nLymphoedem = 0;
        m_nBioptischeSicherung = 0;
        m_nEmpfehlungTraining = 0;
        m_nKardiotoxischeTumortherapie = 0;
        m_dKoerpergroesse = 0.0;
        m_bKoerpergroesse = false;
        m_sKoerpergroesse = new String();
        m_nKoerpergewicht = 0;
        m_bKoerpergewicht = false;
        m_sKoerpergewicht = new String();
        m_nEinschreibungWegen = 0;
        m_nLokalregionaer = 0;
        m_nKontralateral = 0;
        m_nFernmetastasen = 0;
        m_nBehandlungsstatus = 0;
        m_nDokumentationsintervall = 0;
        m_nPNP = false;
        m_sId = null;
        m_sSetId = null;
        m_sKrankenhausIK = null;
        m_sProviderIdLANR = null;
        m_sProviderIdBSNR = null;
        m_sPatientId = null;
        m_sPatientIdEX = null;
        m_sLastXPath = "";
        m_sLastParameter = "";
    }
}

