/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.dm2;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.format.Profile;
import de.kbv.xpm.core.io.AusgabeReport;
import de.kbv.xpm.core.pruefung.PruefEventHandler;
import de.kbv.xpm.core.stamm.EhdHeader;
import de.kbv.xpm.modul.dmp.dm2.XPMFehlerListe;
import de.kbv.xpm.modul.dmp.dm2.XPMFehlerListeAsatz;
import de.kbv.xpm.modul.dmp.dm2.XPMStatistikListe;
import de.kbv.xpm.modul.dmp.dm2.stamm.XPMDMPTabelle;
import de.kbv.xpm.modul.dmp.dm2.stamm.XPMKTStamm;
import de.kbv.xpm.modul.dmp.dm2.stamm.XPMPersonenGruppeTabelle;
import de.kbv.xpm.modul.dmp.dm2.stamm.XPMWOPTabelle;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class XPMEventHandler
extends PruefEventHandler {
    protected static XPMKTStamm KTStamm;
    protected static XPMDMPTabelle DMPTabelle;
    protected static XPMPersonenGruppeTabelle PersonenGruppeTabelle;
    protected static XPMWOPTabelle WOPTabelle;
    protected static AusgabeReport FehlerListe;
    protected static XPMStatistikListe StatistikListe;
    protected static final String cNEIN = "Nein";
    protected static final String cJA = "Ja";
    protected static final String cKEINE = "Keine";
    protected static final String cV = "V";
    protected static final String cDN = "DN";
    protected static final String cRT = "RT";
    protected static final String cEX = "EX";
    protected static final String cAUFFAELLIG = "Auff\u00e4llig";
    protected static final String cUNAUFFAELLIG = "Unauff\u00e4llig";
    protected static final String cNICHT_ERHOBEN = "Nicht erhoben";
    protected static final String cNICHT_UNTERSUCHT = "Nicht untersucht";
    protected static final String cNICHT_BESTIMMT = "Nicht bestimmt";
    protected static final String cDURCHGEFUEHRT = "Durchgef\u00fchrt";
    protected static final String cNICHT_DURCHGEFUEHRT = "Nicht durchgef\u00fchrt";
    protected static final String cVERANLASST = "Veranlasst";
    protected static final String cZIELWER = "Zielwert erreicht";
    protected static final String cZIELWERTNICHT = "Zielwert noch nicht erreicht";
    protected static final String cANHEBEN = "Anheben";
    protected static final String cMMHG = "mmHg";
    protected static final String cANZAHL = "Anzahl";
    protected static final String[] aErgebnistext_;
    protected static final SimpleDateFormat bisDatumParse_;
    protected static final SimpleDateFormat sciphoxParse_;
    protected static final SimpleDateFormat sciphoxFormat_;
    protected static Date dateNow_;
    protected static boolean bASatz_;
    protected static boolean bVerlaufsDoku_;
    protected static String sValue_;
    protected static Profile m_Profile;

    protected XPMEventHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    protected XPMEventHandler(String sXPath, Profile profile) throws XPMException {
        super(sXPath);
        m_Profile = profile;
        KTStamm = XPMKTStamm.getInstance();
        DMPTabelle = XPMDMPTabelle.getInstance();
        PersonenGruppeTabelle = XPMPersonenGruppeTabelle.getInstance();
        WOPTabelle = XPMWOPTabelle.getInstance();
        FehlerListe = bASatz_ ? XPMFehlerListeAsatz.getInstance() : XPMFehlerListe.getInstance();
        StatistikListe = XPMStatistikListe.getInstance();
    }

    public final void fillErrorReport() throws Exception {
        try {
            EhdHeader header;
            FehlerListe.newGroup("Dokumentationsbogen");
            StringBuffer sTitel = bVerlaufsDoku_ ? new StringBuffer("Pr\u00fcfprotokoll Verlaufsdokumentation Diabetes mellitus Typ 2") : new StringBuffer("Pr\u00fcfprotokoll erstmalige Dokumentation Diabetes mellitus Typ 2");
            if (bASatz_) {
                sTitel.append(" (A Satz)");
                FehlerListe.addParameter("PAKET_VERSION", (Object)(m_Profile.getPaketVersion() + "  - A-Version"));
            } else {
                FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            }
            FehlerListe.addParameter("TITEL", (Object)sTitel.toString());
            FehlerListe.addParameter("DATEI", (Object)m_DatenPool.getString("XPM_FILE"));
            FehlerListe.addParameter("DATUM", (Object)m_DatenPool.getString("XPM_DATE"));
            FehlerListe.addParameter("ZEIT", (Object)m_DatenPool.getString("XPM_TIME"));
            FehlerListe.addParameter("DATEI_DATUM", (Object)m_DatenPool.getString("XPM_FILE_DATE"));
            FehlerListe.addParameter("XPM_VERSION", (Object)m_DatenPool.getString("XPM_VERSION"));
            FehlerListe.addParameter("KBV_TAB_VERSION", (Object)m_Profile.getPaketInformation());
            if (KTStamm.isValid() && (header = KTStamm.getHeader()) != null) {
                sValue_ = header.getDokumentTyp() + header.getInterfaceVersion() + "/" + header.getQuartal().toString().replaceFirst("/", "") + "/" + header.getProvider() + "/" + header.getDatum();
                FehlerListe.addParameter("KT_VERSION", (Object)sValue_);
            }
            int nReturnCode = Integer.parseInt(m_DatenPool.getString("XPM_RETURN_CODE"));
            FehlerListe.addParameter("ERGEBNIS_TEXT", (Object)aErgebnistext_[nReturnCode]);
            FehlerListe.addParameter("RETURN_CODE", (Object)new Integer(nReturnCode));
            FehlerListe.addParameter("INFOS", (Object)String.valueOf(m_MeldungPool.getInfoCounts()));
            FehlerListe.addParameter("WARNUNGEN", (Object)String.valueOf(m_MeldungPool.getWarningCounts()));
            FehlerListe.addParameter("FEHLER", (Object)String.valueOf(m_MeldungPool.getErrorCounts()));
            FehlerListe.addParameter("ABBRUCH", (Object)String.valueOf(m_MeldungPool.getCancelErrorCounts()));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (fillErrorReport)");
        }
    }

    public final void fillStatisticReport() throws XPMException {
        try {
            StringBuffer sTitel = new StringBuffer("Fehlerstatistik Dokumentation Diabetes mellitus Typ 2");
            if (bASatz_) {
                sTitel.append(" (A Satz)");
            }
            StatistikListe.addParameter("TITEL", sTitel.toString());
            StatistikListe.addParameter("DATEIEN", m_DatenPool.getString("XPM_FILES"));
            StatistikListe.addParameter("DATUM", m_DatenPool.getString("XPM_DATE"));
            StatistikListe.addParameter("ZEIT", m_DatenPool.getString("XPM_TIME"));
            StatistikListe.addParameter("XPM_VERSION", m_DatenPool.getString("XPM_VERSION"));
            StatistikListe.addParameter("KBV_TAB_VERSION", m_Profile.getPaketVersion());
            StatistikListe.addParameter("INFOS", String.valueOf(m_MeldungPool.getRunInfoCounts()));
            StatistikListe.addParameter("WARNUNGEN", String.valueOf(m_MeldungPool.getRunWarningCounts()));
            StatistikListe.addParameter("FEHLER", String.valueOf(m_MeldungPool.getRunErrorCounts()));
            StatistikListe.addParameter("ABBRUCH", String.valueOf(m_MeldungPool.getRunCancelErrorCounts()));
            String sStatus = String.valueOf(m_MeldungPool.getOkFilesCounts()) + "/" + m_MeldungPool.getWarningFilesCounts() + "/" + m_MeldungPool.getErrorFilesCounts() + "/" + m_MeldungPool.getCancelFilesCounts();
            StatistikListe.addParameter("STATUS", sStatus);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (fillStatisticReport)");
        }
    }

    public final String formatDatum(Date datum) throws Exception {
        try {
            return sciphoxFormat_.format(datum);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (formatDatum)");
            return null;
        }
    }

    public final Date getBisDatum(String sDatum, String sFeld) throws Exception {
        try {
            try {
                if (sDatum.length() > 0) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(bisDatumParse_.parse(sDatum));
                    cal.add(2, 1);
                    cal.add(5, -1);
                    return cal.getTime();
                }
            }
            catch (ParseException ex) {
                m_MeldungPool.addMeldung("DM2-FRMT", sDatum, sFeld);
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getBisDatum)");
            return null;
        }
    }

    public final Date getDatum(String sDatum, String sFeld) throws Exception {
        try {
            try {
                if (sDatum.length() > 0) {
                    return sciphoxParse_.parse(sDatum);
                }
            }
            catch (ParseException ex) {
                m_MeldungPool.addMeldung("DM2-FRMT", sDatum, sFeld);
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getDatum)");
            return null;
        }
    }

    public final float getFloat(String sValue, String sFeld) throws Exception {
        try {
            try {
                if (sValue.length() > 0) {
                    return Float.parseFloat(sValue);
                }
            }
            catch (NumberFormatException ex) {
                m_MeldungPool.addMeldung("DM2-FRMT", sValue, sFeld);
            }
            return 0.0f;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getFloat)");
            return 0.0f;
        }
    }

    public final int getInt(String sValue, String sFeld) throws Exception {
        try {
            try {
                if (sValue.length() > 0) {
                    return Integer.parseInt(sValue);
                }
            }
            catch (NumberFormatException ex) {
                m_MeldungPool.addMeldung("DM2-FRMT", sValue, sFeld);
            }
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getInt)");
            return 0;
        }
    }

    public final Date pruefeDatum(String sDatum, String sFeld, boolean bWarnung) throws Exception {
        try {
            Date datum = null;
            try {
                if (sDatum.length() > 0) {
                    datum = sciphoxParse_.parse(sDatum);
                    if ((m_DatenPool.getString("deactivateSystemDateCheck") == null || m_DatenPool.getString("deactivateSystemDateCheck").equals("false")) && datum.after(dateNow_)) {
                        if (bWarnung) {
                            m_MeldungPool.addMeldung("DM2-ZEITw", sFeld);
                        } else {
                            m_MeldungPool.addMeldung("DM2-ZEIT", sFeld);
                        }
                    }
                }
            }
            catch (ParseException ex) {
                m_MeldungPool.addMeldung("DM2-FRMT", sDatum, sFeld);
            }
            return datum;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeDatum)");
            return null;
        }
    }

    public int codiereJaNein(String sValue, String sFeld) throws Exception {
        try {
            switch (sValue.hashCode()) {
                case 2424124: {
                    return 1;
                }
                case 2391: {
                    return 2;
                }
            }
            m_MeldungPool.addMeldung("DM2-ZUL", sValue, sFeld);
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (codiereJaNein)");
            return 0;
        }
    }

    public int codiereJaNeinKontra(String sValue, String sFeld) throws Exception {
        try {
            switch (sValue.hashCode()) {
                case 2424124: {
                    return 1;
                }
                case 2391: {
                    return 2;
                }
                case -295913203: {
                    return 4;
                }
            }
            m_MeldungPool.addMeldung("DM2-ZUL", sValue, sFeld);
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (codiereJaNeinKontra)");
            return 0;
        }
    }

    public int codiereJaNeinKontraAntiko(String sValue, String sFeld) throws Exception {
        try {
            switch (sValue.hashCode()) {
                case 2424124: {
                    return 1;
                }
                case 2391: {
                    return 2;
                }
                case -295913203: {
                    return 4;
                }
                case -1576754967: {
                    return 8;
                }
            }
            m_MeldungPool.addMeldung("DM2-ZUL", sValue, sFeld);
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (codiereJaNeinKontraAntiko)");
            return 0;
        }
    }

    public int codiereJaNeinKontraAT1(String sValue, String sFeld) throws Exception {
        try {
            switch (sValue.hashCode()) {
                case 2424124: {
                    return 1;
                }
                case 2391: {
                    return 2;
                }
                case -295913203: {
                    return 4;
                }
                case 65073: {
                    return 8;
                }
            }
            m_MeldungPool.addMeldung("DM2-ZUL", sValue, sFeld);
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (codiereJaNeinKontraAT1)");
            return 0;
        }
    }

    public int codiereSchulung(String sValue, String sFeld) throws Exception {
        try {
            switch (sValue.hashCode()) {
                case 2424124: {
                    return 1;
                }
                case 2391: {
                    return 2;
                }
                case -731414634: {
                    return 4;
                }
                case 745917837: {
                    return 8;
                }
            }
            m_MeldungPool.addMeldung("DM2-ZUL", sValue, sFeld);
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (codiereSchulung)");
            return 0;
        }
    }

    public void pruefeJaNein(int nValue, String sFeld) throws Exception {
        try {
            if (nValue == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", sFeld);
            } else if (nValue > 2) {
                m_MeldungPool.addMeldung("DM2-WDSP", sFeld);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeJaNein)");
        }
    }

    public void pruefeJaNeinKontra(int nValue, String sFeld) throws Exception {
        try {
            if (nValue == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", sFeld);
            } else if ((nValue & 2) == 2 && ((nValue & 1) == 1 || (nValue & 4) == 4)) {
                m_MeldungPool.addMeldung("DM2-WDSP", sFeld);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeJaNeinKontra)");
        }
    }

    public void pruefeJaNeinKontraAntiko(int nValue, String sFeld) throws Exception {
        try {
            if (nValue == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", sFeld);
            } else if ((nValue & 2) == 2 && ((nValue & 1) == 1 || (nValue & 4) == 4) || (nValue & 8) == 8 && (nValue & 2) == 2 && (nValue & 1) == 1) {
                m_MeldungPool.addMeldung("DM2-WDSP", sFeld);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeJaNeinKontraAntiko)");
        }
    }

    public void pruefeSchulung(int nValue, String sFeld) throws Exception {
        try {
            switch (nValue) {
                case 0: {
                    m_MeldungPool.addMeldung("DM2-FEHL", sFeld);
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    m_MeldungPool.addMeldung("DM2-WDSP", sFeld);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeSchulung)");
        }
    }

    public void pruefeNachkommastellen(String sValue, String sFeld, int nStellen) throws Exception {
        try {
            int nPos;
            if (sValue != null && ((nPos = sValue.indexOf(46)) == -1 && nStellen != 0 || nPos + nStellen + 1 != sValue.length())) {
                m_MeldungPool.addMeldung("DM2-NKST", sValue, sFeld, String.valueOf(nStellen));
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeNachkommastellen)");
        }
    }

    public void elementStart() throws XPMException {
        this.init();
    }

    public void elementEnde() throws XPMException {
    }

    public void init() throws XPMException {
        dateNow_ = Calendar.getInstance().getTime();
        bVerlaufsDoku_ = false;
    }

    public static void setIsAsatz(boolean b) {
        bASatz_ = b;
    }

    public static void setIsVerlaufsdoku(boolean b) {
        bVerlaufsDoku_ = b;
    }

    static {
        aErgebnistext_ = new String[]{"Ok", "Warnung", "Fehlerhaft", "Abbruch"};
        bisDatumParse_ = new SimpleDateFormat("yyyy-MM", Locale.GERMAN);
        sciphoxParse_ = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        sciphoxFormat_ = new SimpleDateFormat("dd.MM.yyyy", Locale.GERMAN);
        dateNow_ = Calendar.getInstance().getTime();
        bASatz_ = false;
        bVerlaufsDoku_ = false;
        sValue_ = null;
    }
}

