/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.his;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.stamm.KTS.IK;
import de.kbv.xpm.core.stamm.KTS.SatzKTS;
import de.kbv.xpm.core.util.Quartal;
import de.kbv.xpm.modul.dmp.his.PatientHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class GesetzlicheKrankenversicherungHandler
extends PatientHandler {
    protected GesetzlicheKrankenversicherungHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    public void checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat(String sGueltigBis, String sEinlesedatum, String versSchutzbeginn) throws Exception {
        try {
            if (!(m_bAnlageA || sGueltigBis.isEmpty() || sEinlesedatum.isEmpty() || versSchutzbeginn.isEmpty())) {
                Date dateVersEnde = this.getDatum(sGueltigBis, "VersicherungsschutzEnde");
                Date dateEinleseDatum = this.getDatum(sEinlesedatum, "Einlesedatum");
                Date dateVersBeginn = this.getDatum(versSchutzbeginn, "Versicherungsschutzbeginn");
                if (dateEinleseDatum != null && dateVersEnde != null && dateVersEnde.before(dateEinleseDatum)) {
                    m_MeldungPool.addMeldung("DMP-077");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung (checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat)");
        }
    }

    public void pruefeVknrBeiKVKFallUndFallNach414(String sEinlesedatum, String versNR, String vknr) throws Exception {
        try {
            boolean kVKFall = false;
            boolean fallNach414 = false;
            if (versNR != null && versNR.length() > 1 && versNR.substring(0, 1).matches("[0-9]")) {
                kVKFall = true;
            }
            Date dateEinleseDatum = null;
            if (sEinlesedatum != null && !sEinlesedatum.isEmpty()) {
                dateEinleseDatum = this.getDatum(sEinlesedatum, "Einlesedatum");
            }
            if (dateEinleseDatum != null && dateEinleseDatum.after(new SimpleDateFormat("yyyy-MM-dd").parse("2014-12-31"))) {
                fallNach414 = true;
            }
            if (vknr != null && vknr.length() >= 5) {
                int vknrInt = 0;
                vknrInt = this.getInt(vknr.substring(2, 5), "AbrechnungsVKNR");
                if (kVKFall && fallNach414 && vknrInt < 800) {
                    m_MeldungPool.addMeldung("DMP-078");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung (pruefeVknrBeiKVKFallUndFallNach414)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            String wop;
            Date einlesedatum;
            String sBezeichnung = this.m_Element.getChildAttributeValue("Kostentraegerbezeichnung", "V");
            String sIK = this.m_Element.getChildAttributeValue("Kostentraegerkennung", "V");
            String sVKNR = this.m_Element.getChildAttributeValue("AbrechnungsVKNR", "V");
            String sKTAB = this.m_Element.getChildAttributeValue("KostentraegerAbrechnungsbereich", "V");
            String sGueltigBis = this.m_Element.getChildAttributeValue("VersicherungsschutzEnde", "V");
            String sVersichertennummer = this.m_Element.getChildAttributeValue("Versichertennummer", "V");
            String sEinlesedatum = this.m_Element.getChildAttributeValue("Einlesedatum", "V");
            String versSchutzbeginn = this.m_Element.getChildAttributeValue("VersicherungsschutzBeginn", "V");
            String versNR = this.m_Element.getChildAttributeValue("Versichertennummer", "V");
            String vknr = this.m_Element.getChildAttributeValue("AbrechnungsVKNR", "V");
            this.pruefeVknrBeiKVKFallUndFallNach414(sEinlesedatum, versNR, vknr);
            this.checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat(sGueltigBis, sEinlesedatum, versSchutzbeginn);
            if (this.DatumLiegtInZukunft(sEinlesedatum) && !isDateTestDeactivated) {
                m_MeldungPool.addMeldung("HIS-046", "Einlesedatum");
            }
            if (sEinlesedatum != null && !sEinlesedatum.equals("") && (einlesedatum = this.getDatum(sEinlesedatum, "Einlesedatum")) != null && m_dateUnterschrift != null && einlesedatum.after(m_dateUnterschrift)) {
                m_MeldungPool.addMeldung("HIS-047");
            }
            if (!m_bAnlageA && sVersichertennummer.length() > 1) {
                for (int i = 1; i < sVersichertennummer.length(); ++i) {
                    if ("0123456789".indexOf(sVersichertennummer.charAt(i)) != -1) continue;
                    m_MeldungPool.addMeldung("DMP-057");
                    break;
                }
            }
            FehlerListe.addParameter("KASSE_NR", (Object)sIK);
            SatzKTS kt = KTStamm.getKTSSatz(sIK);
            if (kt == null) {
                m_MeldungPool.addMeldung("DMP-039", sIK);
            } else {
                if (!m_bAnlageA && kt.getKTABNameNachFusion(sKTAB) == null) {
                    m_MeldungPool.addMeldung("DMP-008", sKTAB, sIK);
                }
                IK ik = null;
                if (kt != null) {
                    ik = kt.getIK(sIK);
                }
                if (ik != null && m_dateKopf != null) {
                    Quartal von = ik.getGueltigkeitsBeginn();
                    Quartal bis = ik.getGueltigkeitsEnde();
                    Quartal ktEnde = kt.getGueltigkeitsEnde();
                    SatzKTS Aufnehmeder_kt = kt.getAufnehmenderKT();
                    if (von != null && von.compareTo(m_dateKopf) == 1 || bis != null && bis.compareTo(m_dateKopf) == -1 || von == null && bis == null && ktEnde != null && ktEnde.compareTo(m_dateKopf) < 0 && Aufnehmeder_kt == null) {
                        m_MeldungPool.addMeldung("DMP-011", sIK);
                    }
                }
            }
            if (!m_bAnlageA) {
                String dmp = this.m_Element.getChildAttributeValue("DMP_Kennzeichnung", "V");
                if (dmp == null || dmp.isEmpty()) {
                    m_MeldungPool.addMeldung("DMP-002", "DMP_Kennzeichnung");
                } else if (dmp.length() != 2) {
                    m_MeldungPool.addMeldung("DMP-082", "DMP_Kennzeichnung");
                } else if (DMPTabelle.getKey(dmp) == null) {
                    m_MeldungPool.addMeldung("DMP-100", dmp, "DMP_Kennzeichnung");
                }
                String pg = this.m_Element.getChildAttributeValue("BesonderePersonengruppe", "V");
                if (pg == null || pg.isEmpty()) {
                    m_MeldungPool.addMeldung("DMP-002", "BesonderePersonengruppe");
                } else if (pg.length() != 2) {
                    m_MeldungPool.addMeldung("DMP-082", "BesonderePersonengruppe");
                } else if (PersonenGruppeTabelle.getKey(pg) == null) {
                    m_MeldungPool.addMeldung("DMP-100", pg, "BesonderePersonengruppe");
                }
            }
            if (!(wop = this.m_Element.getChildAttributeValue("WOP", "V")).isEmpty() && WOPTabelle.getKey(wop) == null) {
                m_MeldungPool.addMeldung("DMP-100", wop, "WOP");
            }
            if (sGueltigBis != null && !sGueltigBis.equals("") && m_dateUnterschrift != null) {
                Date dateVersEnde = this.getDatum(sGueltigBis, "VersicherungsschutzEnde");
                GregorianCalendar startCalendar = new GregorianCalendar();
                startCalendar.setTime(m_dateUnterschrift);
                GregorianCalendar endCalendar = new GregorianCalendar();
                endCalendar.setTime(dateVersEnde);
                int diffYear = endCalendar.get(1) - startCalendar.get(1);
                int diffMonth = diffYear * 12 + endCalendar.get(2) - startCalendar.get(2);
                if (dateVersEnde.before(m_dateUnterschrift)) {
                    if (diffMonth <= -4) {
                        m_MeldungPool.addMeldung("HIS-072", sGueltigBis);
                    } else {
                        m_MeldungPool.addMeldung("HIS-071", sGueltigBis);
                    }
                }
            }
            if (m_sKrankenhausIK != null && m_sProviderIdBSNR != null && m_sProviderIdLANR != null) {
                m_MeldungPool.addMeldung("DMP-074");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
    }
}

