/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.khk;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.stamm.KTS.IK;
import de.kbv.xpm.core.stamm.KTS.SatzKTS;
import de.kbv.xpm.core.util.Quartal;
import de.kbv.xpm.modul.dmp.khk.PatientHandler;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GesetzlicheKrankenversicherungHandler
extends PatientHandler {
    protected GesetzlicheKrankenversicherungHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    public void checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat(String sGueltigBis, String sEinlesedatum, String versSchutzbeginn) throws Exception {
        try {
            if (!(m_bASatz || sGueltigBis.isEmpty() || sEinlesedatum.isEmpty() || versSchutzbeginn.isEmpty())) {
                Date dateVersEnde = this.getDatum(sGueltigBis, "VersicherungsschutzEnde");
                Date dateEinleseDatum = this.getDatum(sEinlesedatum, "Einlesedatum");
                Date dateVersBeginn = this.getDatum(versSchutzbeginn, "Versicherungsschutzbeginn");
                if (dateEinleseDatum != null && dateVersEnde != null && dateVersEnde.before(dateEinleseDatum)) {
                    m_MeldungPool.addMeldung("DMP-077");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung (checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat)");
        }
    }

    public void pruefeVknrBeiKVKFallUndFallNach414(String sEinlesedatum, String versNR, String vknr) throws Exception {
        try {
            boolean kVKFall = false;
            boolean fallNach414 = false;
            if (versNR != null && versNR.length() > 1 && versNR.substring(0, 1).matches("[0-9]")) {
                kVKFall = true;
            }
            Date dateEinleseDatum = null;
            if (sEinlesedatum != null && !sEinlesedatum.isEmpty()) {
                dateEinleseDatum = this.getDatum(sEinlesedatum, "Einlesedatum");
            }
            if (dateEinleseDatum != null && dateEinleseDatum.after(new SimpleDateFormat("yyyy-MM-dd").parse("2014-12-31"))) {
                fallNach414 = true;
            }
            if (vknr != null && vknr.length() >= 5) {
                int vknrInt = 0;
                vknrInt = this.getInt(vknr.substring(2, 5), "AbrechnungsVKNR");
                if (kVKFall && fallNach414 && vknrInt < 800) {
                    m_MeldungPool.addMeldung("DMP-078");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung (pruefeVknrBeiKVKFallUndFallNach414)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            String wop;
            String sIK = this.m_Element.getChildAttributeValue("Kostentraegerkennung", "V");
            String sKTAB = this.m_Element.getChildAttributeValue("KostentraegerAbrechnungsbereich", "V");
            String sGueltigBis = this.m_Element.getChildAttributeValue("VersicherungsschutzEnde", "V");
            String sVersichertennummer = this.m_Element.getChildAttributeValue("Versichertennummer", "V");
            String sEinlesedatum = this.m_Element.getChildAttributeValue("Einlesedatum", "V");
            String versSchutzbeginn = this.m_Element.getChildAttributeValue("VersicherungsschutzBeginn", "V");
            String versNR = this.m_Element.getChildAttributeValue("Versichertennummer", "V");
            String vknr = this.m_Element.getChildAttributeValue("AbrechnungsVKNR", "V");
            this.pruefeVknrBeiKVKFallUndFallNach414(sEinlesedatum, versNR, vknr);
            this.checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat(sGueltigBis, sEinlesedatum, versSchutzbeginn);
            if (this.DatumLiegtInZukunft(sEinlesedatum) && !isDateTestDeactivated) {
                m_MeldungPool.addMeldung("DMP-001", "Einlesedatum");
            }
            if (!m_bASatz && sVersichertennummer.length() > 1) {
                for (int i = 1; i < sVersichertennummer.length(); ++i) {
                    if ("0123456789".indexOf(sVersichertennummer.charAt(i)) != -1) continue;
                    m_MeldungPool.addMeldung("DMP-057");
                    break;
                }
            }
            FehlerListe.addParameter("KASSE_NR", (Object)sIK);
            SatzKTS kt = KTStamm.getKTSSatz(sIK);
            if (kt == null) {
                m_MeldungPool.addMeldung("DMP-039", sIK);
            } else {
                if (!m_bASatz && kt.getKTABNameNachFusion(sKTAB) == null) {
                    m_MeldungPool.addMeldung("DMP-048", sKTAB, sIK);
                }
                IK ik = null;
                if (kt != null) {
                    ik = kt.getIK(sIK);
                }
                if (ik != null && m_dateKopf != null) {
                    Quartal von = ik.getGueltigkeitsBeginn();
                    Quartal bis = ik.getGueltigkeitsEnde();
                    Quartal ktEnde = kt.getGueltigkeitsEnde();
                    SatzKTS Aufnehmeder_kt = kt.getAufnehmenderKT();
                    if (von != null && von.compareTo(m_dateKopf) == 1 || bis != null && bis.compareTo(m_dateKopf) == -1 || von == null && bis == null && ktEnde != null && ktEnde.compareTo(m_dateKopf) < 0 && Aufnehmeder_kt == null) {
                        m_MeldungPool.addMeldung("DMP-040", sIK);
                    }
                }
            }
            if (!sGueltigBis.equals("") && !m_sServiceTmr.equals("")) {
                try {
                    int nGueltigBisMonate = Integer.parseInt(sGueltigBis.substring(0, 4)) * 12 + Integer.parseInt(sGueltigBis.substring(5, 7));
                    int nErstellungsdatumMonate = Integer.parseInt(m_sServiceTmr.substring(0, 4)) * 12 + Integer.parseInt(m_sServiceTmr.substring(5, 7));
                    int nDifferenz = nGueltigBisMonate - nErstellungsdatumMonate;
                    if (nDifferenz < -3) {
                        m_MeldungPool.addMeldung("DMP-053");
                    } else if (nDifferenz < 0) {
                        m_MeldungPool.addMeldung("DMP-052");
                    }
                }
                catch (NumberFormatException nGueltigBisMonate) {
                    // empty catch block
                }
            }
            if (!sEinlesedatum.equals("") && !m_sServiceTmr.equals("") && this.datumBevor(m_sServiceTmr, sEinlesedatum)) {
                m_MeldungPool.addMeldung("DMP-054");
            }
            if (!m_bASatz) {
                String dmp = this.m_Element.getChildAttributeValue("DMP_Kennzeichnung", "V");
                if (dmp == null || dmp.isEmpty()) {
                    m_MeldungPool.addMeldung("DMP-002", "DMP_Kennzeichnung");
                } else if (dmp.length() != 2) {
                    m_MeldungPool.addMeldung("DMP-082", "DMP_Kennzeichnung");
                } else if (DMPTabelle.getKey(dmp) == null) {
                    m_MeldungPool.addMeldung("DMP-101", dmp, "DMP_Kennzeichnung");
                }
                String pg = this.m_Element.getChildAttributeValue("BesonderePersonengruppe", "V");
                if (pg == null || pg.isEmpty()) {
                    m_MeldungPool.addMeldung("DMP-002", "BesonderePersonengruppe");
                } else if (pg.length() != 2) {
                    m_MeldungPool.addMeldung("DMP-082", "BesonderePersonengruppe");
                } else if (PersonenGruppeTabelle.getKey(pg) == null) {
                    m_MeldungPool.addMeldung("DMP-101", pg, "BesonderePersonengruppe");
                }
            }
            if (!(wop = this.m_Element.getChildAttributeValue("WOP", "V")).isEmpty() && WOPTabelle.getKey(wop) == null) {
                m_MeldungPool.addMeldung("DMP-100", wop, "WOP");
            }
            if (m_sKrankenhausIK != null && m_sProviderIdBSNR != null && m_sProviderIdLANR != null) {
                m_MeldungPool.addMeldung("DMP-075");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
    }
}

