/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.khk;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.khk.XPMEventHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final String cZIP_DIR = "Koronare_Herzkrankheit/Dokumentation/";
    protected static String m_sGeschlecht_ = "";
    protected static int m_nArztNr = -1;
    protected static final String cVERTRAGSARZTNUMMER = "Vertragsarztnummer";
    protected static String m_sServiceTmr = "";
    protected static Date m_dateUnterschrift = null;
    protected static Date m_dateKopf = null;
    protected static final String cHERZINFARKT_12MONATE = "Herzinfarkt innerhalb der letzten 12 Monate";
    protected static final String cSTATIONAERE_BEHANDLUNG = "Ungeplante station\u00e4re Behandlung wegen KHK seit der letzten Dokumentation";
    protected static final String cSCHULUNG_VORDMP = "Schulung bereits vor Einschreibung in DMP wahrgenommen";
    protected static final String cSCHULUNG_EMPFOHLEN = "Schulung empfohlen (bei aktueller Dokumentation)";
    protected static final String cSCHULUNG_WAHRGENOMMEN = "Empfohlene Schulung(en) wahrgenommen";
    protected static final String cKOERPERGROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPERGEWICHT = "K\u00f6rpergewicht";
    protected static final String cLDL_CHOLESTERIN = "LDL-Cholesterin";
    protected static final String cBLUTDRUCK_SYSTOLISCH = "Blutdruck systolisch";
    protected static final String cBLUTDRUCK_DIASTOLISCH = "Blutdruck diastolisch";
    protected static int m_nPatientenAlter = -1;
    protected static SimpleDateFormat m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
    protected static final String cV = "V";
    protected static StringBuffer m_sFileName = new StringBuffer();
    protected static String m_sDokdatum = new String();
    protected static String m_sParameter = "";
    protected static boolean m_bErgebnis = false;
    protected static int m_nAbschnitt = 0;
    protected static String m_sAbschnitt = new String();
    protected static final int cABSCHNITT_ADMINISTRATIVEDATEN = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_EREIGNISSE = 4;
    protected static final int cABSCHNITT_MEDIKATION = 5;
    protected static final int cABSCHNITT_SCHULUNGEN = 6;
    protected static final int cABSCHNITT_BEHANDLUNGSPLAN = 7;
    protected static final String cADMINISTRATIVEDATEN = "Administrative Daten";
    protected static final String cANAMNESE = "Anamnese- und Befunddaten";
    protected static final String cEREIGNISSE = "Relevante Ereignisse";
    protected static final String cMEDIKATION = "Medikamente";
    protected static final String cSCHULUNGEN = "Schulung";
    protected static final String cBEHANDLUNGSPLAN = "Behandlungsplanung";
    protected static boolean m_bDiagnoseBekanntSeit = false;
    protected static int m_nDiagnoseBekanntSeit = 0;
    protected static double m_dKoerpergroesse = 0.0;
    protected static String m_sKoerpergroesse = new String();
    protected static boolean m_bKoerpergroesse = false;
    protected static int m_nKoerpergewicht = 0;
    protected static boolean m_bKoerpergewicht = false;
    protected static String m_sKoerpergewicht = new String();
    protected static int m_nBlutdruckSystolisch = 0;
    protected static boolean m_bBlutdruckSystolisch = false;
    protected static String m_sBlutdruckSystolisch = new String();
    protected static int m_nBlutdruckDiastolisch = 0;
    protected static boolean m_bBlutdruckDiastolisch = false;
    protected static String m_sBlutdruckDiastolisch = new String();
    protected static int m_nRaucher = 0;
    protected static int m_nModulTeilnahme = 0;
    protected static int m_nEinschreibungWegen = 0;
    protected static int m_nAnginaPectoris = 0;
    protected static int m_nLDLCholesterin = 0;
    protected static int m_nRelevanteEreignisse = 0;
    protected static int m_nHerzinfarkt = 0;
    protected static boolean m_bStationaereBehandlungen = false;
    protected static int m_nStationaereBehandlungen = 0;
    protected static int m_nThromboHemmer = 0;
    protected static int m_nBetablocker = 0;
    protected static int m_nACEHemmer = 0;
    protected static int m_nStatinDosis = 0;
    protected static int m_nStatinStrategie = 0;
    protected static int m_nGrundStatinDosis = 0;
    protected static int m_nSchulungVorDmpWahrgenommen = 0;
    protected static int m_nEmpfohleneSchulungWahrgenommen = 0;
    protected static int m_nSchulungEmpfohlen = 0;
    protected static int m_nBegleiterkrankungen = 0;
    protected static int m_nInformationsangebote = 0;
    protected static int m_nGewichtskontrolle = 0;
    protected static int m_nIntervall = 0;
    protected static int m_nSportTraining = 0;
    protected static String m_sId = null;
    protected static String m_sSetId = null;
    protected static String m_sKrankenhausIK = null;
    protected static String m_sProviderIdLANR = null;
    protected static String m_sProviderIdBSNR = null;
    protected static String m_sPatientId = null;
    protected static String m_sPatientIdEX = null;
    protected static String m_sDokumentTyp = null;
    protected static String m_sLastXPath = "";
    protected static String m_sLastParameter = "";
    protected static String sFirstParameter_ = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public void pruefeDokumentation() throws Exception {
        try {
            FehlerListe.newGroup(cADMINISTRATIVEDATEN);
            if (m_sDokumentTyp != null && !this.pruefeDokumentTyp(m_sDokumentTyp, m_nEinschreibungWegen)) {
                m_MeldungPool.addMeldung("DMP-067");
            }
            if (m_nEinschreibungWegen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Einschreibung wegen'");
            }
            if (this.testBit(m_nEinschreibungWegen, 2) && this.testBit(m_nEinschreibungWegen, 4)) {
                m_MeldungPool.addMeldung("DMP-063", "Diabetes mellitus Typ 1", "Diabetes mellitus Typ 2");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && this.testBit(m_nEinschreibungWegen, 16)) {
                m_MeldungPool.addMeldung("DMP-063", "Asthma bronchiale", "COPD");
            }
            if (this.testBit(m_nEinschreibungWegen, 1) && this.testBit(m_nEinschreibungWegen, 64)) {
                m_MeldungPool.addMeldung("DMP-063", "KHK", "Chronische Herzinsuffizienz");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && m_nPatientenAlter != -1 && m_nPatientenAlter < 1) {
                m_MeldungPool.addMeldung("DMP-071");
            }
            if (this.testBit(m_nEinschreibungWegen, 16) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-112");
            }
            if (this.testBit(m_nEinschreibungWegen, 1024) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-113");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cANAMNESE);
            this.allgemeineAnamnese("KHK", m_nPatientenAlter, m_bKoerpergroesse, m_bKoerpergewicht, m_dKoerpergroesse, m_nKoerpergewicht, m_sKoerpergroesse, m_bBlutdruckSystolisch, m_bBlutdruckDiastolisch, m_nBlutdruckSystolisch, m_nBlutdruckDiastolisch, m_sBlutdruckSystolisch, m_sBlutdruckDiastolisch, m_nRaucher, m_nBegleiterkrankungen);
            if (this.testBit(m_nEinschreibungWegen, 512)) {
                if (m_sGeschlecht_.equals("M") && m_nPatientenAlter < 60) {
                    m_MeldungPool.addMeldung("DMP-110");
                }
                if ((m_sGeschlecht_.equals("F") || m_sGeschlecht_.equals("UN") || m_sGeschlecht_.equals("X")) && m_nPatientenAlter < 50) {
                    m_MeldungPool.addMeldung("DMP-111");
                }
            }
            if (m_nAnginaPectoris == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Angina pectoris'");
            }
            if (this.countBits(m_nAnginaPectoris) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Angina pectoris");
            }
            if (m_nLDLCholesterin == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'LDL-Cholesterin'");
            }
            if (this.countBits(m_nLDLCholesterin) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cLDL_CHOLESTERIN);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cEREIGNISSE);
            if (m_nRelevanteEreignisse == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Relevante Ereignisse'");
            } else if (m_nRelevanteEreignisse > 8) {
                m_MeldungPool.addMeldung("DMP-WDSP", "'Relevante Ereignisse'");
            }
            if (m_nHerzinfarkt == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Herzinfarkt innerhalb der letzten 12 Monate'");
            }
            if (this.countBits(m_nHerzinfarkt) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cHERZINFARKT_12MONATE);
            }
            if (m_bFolgeDoku) {
                if (!m_bStationaereBehandlungen) {
                    m_MeldungPool.addMeldung("DMP-002", "'Ungeplante station\u00e4re Behandlung wegen KHK seit der letzten Dokumentation'");
                }
                if (m_bStationaereBehandlungen && (m_nStationaereBehandlungen < 0 || m_nStationaereBehandlungen > 99)) {
                    m_MeldungPool.addMeldung("DMP-055", "'Ungeplante station\u00e4re Behandlung wegen KHK seit der letzten Dokumentation'", "0", "99");
                }
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cMEDIKATION);
            if (m_nThromboHemmer == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Thrombozytenaggregationshemmer'");
            }
            if (this.testBit(m_nThromboHemmer, 1) && (this.testBit(m_nThromboHemmer, 2) || this.testBit(m_nThromboHemmer, 4))) {
                m_MeldungPool.addMeldung("DMP-WDSP", "'Thrombozytenaggregationshemmer'");
            }
            if (m_nBetablocker == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Betablocker'");
            }
            if (this.testBit(m_nBetablocker, 1) && this.countBits(m_nBetablocker) > 1) {
                m_MeldungPool.addMeldung("DMP-041", "'Betablocker'");
            }
            if (m_nACEHemmer == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'ACE-Hemmer'");
            }
            if (this.testBit(m_nACEHemmer, 1) && (this.testBit(m_nACEHemmer, 2) || this.testBit(m_nACEHemmer, 4))) {
                m_MeldungPool.addMeldung("DMP-WDSP", "'ACE-Hemmer'");
            }
            if (m_nStatinDosis == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle Statin-Dosis'");
            }
            if ((this.testBit(m_nStatinDosis, 1) || this.testBit(m_nStatinDosis, 2) || this.testBit(m_nStatinDosis, 4)) && this.countBits(m_nStatinDosis) > 1) {
                m_MeldungPool.addMeldung("KHK-STATINDOSIS");
            }
            if ((this.testBit(m_nStatinDosis, 1) || this.testBit(m_nStatinDosis, 2) || this.testBit(m_nStatinDosis, 4)) && m_nStatinStrategie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle Therapiestrategie Statin'");
            }
            if (this.countBits(m_nStatinStrategie) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Aktuelle Therapiestrategie Statin");
            }
            if ((this.testBit(m_nStatinDosis, 8) || this.testBit(m_nStatinDosis, 16)) && m_nStatinStrategie != 0) {
                m_MeldungPool.addMeldung("KHK-STATINTHERAPIE");
            }
            if ((this.testBit(m_nStatinDosis, 2) || this.testBit(m_nStatinDosis, 4)) && m_nGrundStatinDosis == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Grund f\u00fcr moderate oder niedrige Statin-Dosis'");
            }
            if (this.countBits(m_nGrundStatinDosis) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Grund f\u00fcr moderate oder niedrige Statin-Dosis");
            }
            if ((this.testBit(m_nStatinDosis, 1) || this.testBit(m_nStatinDosis, 8) || this.testBit(m_nStatinDosis, 16)) && m_nGrundStatinDosis != 0) {
                m_MeldungPool.addMeldung("KHK-STATINGRUND");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSCHULUNGEN);
            if (!m_bFolgeDoku) {
                if (m_nSchulungVorDmpWahrgenommen == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Schulung bereits vor Einschreibung in DMP wahrgenommen'");
                }
                if (this.countBits(m_nSchulungVorDmpWahrgenommen) > 1) {
                    m_MeldungPool.addMeldung("DMP-012", cSCHULUNG_VORDMP);
                }
            }
            if (this.testBit(m_nSchulungEmpfohlen, 1) && this.testBit(m_nSchulungEmpfohlen, 2)) {
                m_MeldungPool.addMeldung("DMP-013", "'Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (m_nSchulungEmpfohlen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (m_bFolgeDoku) {
                if (m_nEmpfohleneSchulungWahrgenommen == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Empfohlene Schulung wahrgenommen'");
                }
                if (this.countBits(m_nEmpfohleneSchulungWahrgenommen) > 1) {
                    m_MeldungPool.addMeldung("DMP-012", "Empfohlene Schulung wahrgenommen");
                }
            } else if (m_nEmpfohleneSchulungWahrgenommen != 0) {
                m_MeldungPool.addMeldung("DMP-038", "Empfohlene Schulung wahrgenommen");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNGSPLAN);
            if (m_nGewichtskontrolle == 0 && m_nModulTeilnahme == 1) {
                m_MeldungPool.addMeldung("DMP-002", "'Regelm\u00e4\u00dfige Gewichtskontrolle empfohlen?'");
            }
            if (this.testBit(m_nGewichtskontrolle, 1) && this.countBits(m_nGewichtskontrolle) > 1) {
                m_MeldungPool.addMeldung("DMP-041", "'Regelm\u00e4\u00dfige Gewichtskontrolle empfohlen?'");
            }
            if (m_nIntervall == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Dokumentationsintervall'");
            }
            if (this.countBits(m_nIntervall) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Dokumentationsintervall");
            }
            if (m_nSportTraining == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Regelm\u00e4\u00dfiges sportliches Training'");
            }
            if (this.testBit(m_nSportTraining, 1) && this.countBits(m_nSportTraining) > 1) {
                m_MeldungPool.addMeldung("DMP-041", "Regelm\u00e4\u00dfiges sportliches Training");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefeDokumentation)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.addParameter("BSNR", (Object)m_sProviderIdBSNR);
            FehlerListe.newGroup("Header");
            if (m_sProviderIdLANR == null && m_sProviderIdBSNR == null && m_sKrankenhausIK == null) {
                m_MeldungPool.addMeldung("DMP-061");
            }
            if (m_sProviderIdLANR != null && m_sProviderIdBSNR == null || m_sProviderIdLANR == null && m_sProviderIdBSNR != null) {
                m_MeldungPool.addMeldung("DMP-060");
            }
            if (m_sProviderIdLANR != null) {
                FehlerListe.addParameter("ARZT_NR", (Object)m_sProviderIdLANR);
            }
            if (m_sPatientId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/patient/person/id");
            }
            if (m_sId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/id");
            }
            if (m_sSetId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/set_id");
            }
            if (m_sPatientId != null && m_sId != null) {
                if (!m_sPatientId.equals(m_sId)) {
                    m_MeldungPool.addMeldung("DMP-004", m_sPatientId, m_sId);
                } else {
                    boolean bIdentisch = false;
                    if (m_sProviderIdBSNR != null && m_sId.equals(m_sProviderIdBSNR)) {
                        bIdentisch = true;
                    }
                    if (m_sKrankenhausIK != null && m_sId.equals(m_sKrankenhausIK)) {
                        bIdentisch = true;
                    }
                    if (!bIdentisch) {
                        m_MeldungPool.addMeldung("DMP-068");
                    }
                }
            }
            if (m_sProviderIdLANR != null && m_sProviderIdLANR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "LANR");
            }
            if (m_sKrankenhausIK != null && m_sKrankenhausIK.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "Krankenhaus-IK");
            }
            if (m_sProviderIdBSNR != null && m_sProviderIdBSNR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "BSNR");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Schemaname");
            this.pruefeXMLSchemaname();
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            boolean bPruefeLang = false;
            if (m_sKrankenhausIK != null && (m_sProviderIdLANR == null && m_sProviderIdLANR == null || m_sKrankenhausIK.equals(m_sPatientId))) {
                m_sFileName.append(m_sKrankenhausIK);
                m_sFileName.append("_");
                bPruefeLang = true;
            }
            m_sFileName.append(m_sPatientIdEX);
            m_sFileName.append("_");
            m_sFileName.append(m_sDokdatum.replaceAll("-", ""));
            if (m_bFolgeDoku) {
                if (m_bASatz) {
                    m_sFileName.append("_a.EVKHK");
                } else {
                    m_sFileName.append(".EVKHK");
                }
            } else if (m_bASatz) {
                m_sFileName.append("_a.EEKHK");
            } else {
                m_sFileName.append(".EEKHK");
            }
            this.m_sValue = m_DatenPool.getString("XPM_FILE");
            String sErwarteterName = m_sFileName.toString();
            String sPattern = m_bFolgeDoku ? (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EVKHK" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EVKHK") : (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EEKHK" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EEKHK");
            String sTemp = this.m_sValue.substring(0, 10);
            if (sTemp == null || sTemp.length() < 10 || sTemp.indexOf(95) != 9) {
                m_MeldungPool.addMeldung("DMP-059");
            } else if (bPruefeLang) {
                if (this.m_sValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-005", this.m_sValue, sPattern, sErwarteterName);
                }
            } else {
                String sSubValue = this.m_sValue.substring(10);
                if (sSubValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, this.m_sValue.substring(0, 10) + sErwarteterName);
                }
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_DIR");
            if (this.m_sValue != null && !this.m_sValue.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("DMP-025", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+KHK_416\\.zip)")) {
                m_MeldungPool.addMeldung("DMP-080F", "KHK_416.zip");
            }
            m_MeldungPool.reportMeldungen();
            this.pruefeDokumentation();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        m_sGeschlecht_ = "";
        m_nArztNr = -1;
        m_sServiceTmr = "";
        m_dateUnterschrift = null;
        m_dateKopf = null;
        m_nPatientenAlter = -1;
        m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        m_sFileName = new StringBuffer();
        m_sDokdatum = new String();
        m_sParameter = "";
        m_bErgebnis = false;
        m_nAbschnitt = 0;
        m_sAbschnitt = new String();
        m_bDiagnoseBekanntSeit = false;
        m_nDiagnoseBekanntSeit = 0;
        m_dKoerpergroesse = 0.0;
        m_sKoerpergroesse = new String();
        m_bKoerpergroesse = false;
        m_nKoerpergewicht = 0;
        m_bKoerpergewicht = false;
        m_sKoerpergewicht = new String();
        m_nBlutdruckSystolisch = 0;
        m_bBlutdruckSystolisch = false;
        m_sBlutdruckSystolisch = new String();
        m_nBlutdruckDiastolisch = 0;
        m_bBlutdruckDiastolisch = false;
        m_sBlutdruckDiastolisch = new String();
        m_nRaucher = 0;
        m_nModulTeilnahme = 0;
        m_nEinschreibungWegen = 0;
        m_nAnginaPectoris = 0;
        m_nLDLCholesterin = 0;
        m_nRelevanteEreignisse = 0;
        m_nHerzinfarkt = 0;
        m_bStationaereBehandlungen = false;
        m_nStationaereBehandlungen = 0;
        m_nThromboHemmer = 0;
        m_nBetablocker = 0;
        m_nACEHemmer = 0;
        m_nStatinDosis = 0;
        m_nStatinStrategie = 0;
        m_nGrundStatinDosis = 0;
        m_nSchulungVorDmpWahrgenommen = 0;
        m_nEmpfohleneSchulungWahrgenommen = 0;
        m_nSchulungEmpfohlen = 0;
        m_nBegleiterkrankungen = 0;
        m_nInformationsangebote = 0;
        m_nGewichtskontrolle = 0;
        m_nIntervall = 0;
        m_nSportTraining = 0;
        m_sId = null;
        m_sSetId = null;
        m_sKrankenhausIK = null;
        m_sProviderIdLANR = null;
        m_sProviderIdBSNR = null;
        m_sPatientId = null;
        m_sPatientIdEX = null;
        m_sDokumentTyp = null;
        m_sLastXPath = "";
        m_sLastParameter = "";
        sFirstParameter_ = "";
    }
}

