/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.osteoporose;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.osteoporose.XPMEventHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final String cZIP_DIR = "Osteoporose/Dokumentation/";
    protected static String m_sGeschlecht_ = "";
    protected static int m_nArztNr = -1;
    protected static String m_sServiceTmr = "";
    protected static Date m_dateUnterschrift = null;
    protected static Date m_dateKopf = null;
    protected static int m_nPatientenAlter = -1;
    protected static SimpleDateFormat m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
    protected static final String cV = "V";
    protected static StringBuffer m_sFileName = new StringBuffer();
    protected static String m_sDokdatum = new String();
    protected static String m_sParameter = "";
    protected static boolean m_bErgebnis = false;
    protected static int m_nAbschnitt = 0;
    protected static String m_sAbschnitt = new String();
    protected static final int cABSCHNITT_ADMINISTRATIVEDATEN = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_BEHANDLUNG = 3;
    protected static final int cABSCHNITT_BEHANDLUNG_MEDIKAMENTOES = 4;
    protected static final int cABSCHNITT_SCHULUNGEN = 5;
    protected static final int cABSCHNITT_BEHANDLUNGSPLAN = 6;
    protected static final String cADMINISTRATIVEDATEN = "Administrative Daten";
    protected static final String cANAMNESE = "Anamnese- und Befunddaten";
    protected static final String cBEHANDLUNG = "Sonstige Befunde und nichtmedikament\u00f6se Behandlung";
    protected static final String cBEHANDLUNG_MEDIKAMENTOES = "Medikament\u00f6se Behandlung";
    protected static final String cSCHULUNGEN = "Schulungen";
    protected static final String cBEHANDLUNGSPLAN = "Behandlungsplanung";
    protected static final String cKOERPERGROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPERGEWICHT = "K\u00f6rpergewicht";
    protected static final String cBLUTDRUCK_SYSTOLISCH = "Blutdruck systolisch";
    protected static final String cBLUTDRUCK_DIASTOLISCH = "Blutdruck diastolisch";
    protected static final String cOSTEOFRAKTUR = "Osteoporosebedingte Fraktur in den letzten 12 Monaten";
    protected static final String cNEUFRAKTUR = "Neu aufgetretene osteoporosebedingte Fraktur seit der letzten Dokumentation";
    protected static final String cFRAKTURLoKAL = "Lokalisation der osteoporosebedingten Fraktur";
    protected static final String cSTUERZE_6MONATE = "St\u00fcrze in den letzten 6 Monaten";
    protected static final String cSTUERZE_DOKU = "St\u00fcrze seit der letzten Dokumentation";
    protected static final String cERHOEHTES_STURZRISIKOAB70 = "Teilnehmerinnen und Teilnehmer ab 70 Jahre: erh\u00f6htes Sturzrisiko";
    protected static final String cSTURZPROPHYLAXE = "Bei Teilnehmerinnen und Teilnehmern mit erh\u00f6htem Sturzrisiko oder St\u00fcrzen: Sturzprophylaxema\u00dfnahme empfohlen";
    protected static final String cTRAINING = "Regelm\u00e4\u00dfiges k\u00f6rperliches Training";
    protected static final String cAKTUELLEMEDIKATION = "Aktuelle osteoporosespezifische Medikation";
    protected static final String cDAUERMEDIKATION = "Dauer der osteoporosespezifischen Medikation";
    protected static final String cSCHULUNG_VOR_EINSCHREIBUNG_WAHRGENOMMEN = "Schulung bereits vor Einschreibung in das DMP wahrgenommen";
    protected static final String cSCHULUNG_EMPFOHLEN = "Schulung empfohlen (bei aktueller Dokumentation)";
    protected static final String cSCHULUNG_WAHRGENOMMEN = "Empfohlene Schulung wahrgenommen";
    protected static double m_dKoerpergroesse = 0.0;
    protected static String m_sKoerpergroesse = new String();
    protected static boolean m_bKoerpergroesse = false;
    protected static int m_nKoerpergewicht = 0;
    protected static boolean m_bKoerpergewicht = false;
    protected static String m_sKoerpergewicht = new String();
    protected static int m_nBlutdruckSystolisch = 0;
    protected static boolean m_bBlutdruckSystolisch = false;
    protected static String m_sBlutdruckSystolisch = new String();
    protected static int m_nBlutdruckDiastolisch = 0;
    protected static boolean m_bBlutdruckDiastolisch = false;
    protected static String m_sBlutdruckDiastolisch = new String();
    protected static int m_nRaucher = 0;
    protected static int m_nEinschreibungWegen = 0;
    protected static int m_nBegleiterkrankungen = 0;
    protected static int m_nFraktur = 0;
    protected static int m_nNeuFraktur = 0;
    protected static int m_nFrakturLokal = 0;
    protected static boolean m_bStuerze6Monate = false;
    protected static int m_nStuerze6Monate = 0;
    protected static boolean m_bStuerzeDoku = false;
    protected static int m_nStuerzeDoku = 0;
    protected static int m_nRisikoAb70 = 0;
    protected static int m_nSturzprophylaxe = 0;
    protected static int m_nTraining = 0;
    protected static int m_nAktuelleMedikation = 0;
    protected static int m_nMedikationsdauer = 0;
    protected static int m_nSchulungVorDMPWahrgenommen = 0;
    protected static int m_nSchulungEmpfohlen = 0;
    protected static int m_nSchulungWahrgenommen = 0;
    protected static int m_nInformationsangebote = 0;
    protected static int m_nIntervall = 0;
    protected static String m_sId = null;
    protected static String m_sSetId = null;
    protected static String m_sKrankenhausIK = null;
    protected static String m_sProviderIdLANR = null;
    protected static String m_sProviderIdBSNR = null;
    protected static String m_sPatientId = null;
    protected static String m_sPatientIdEX = null;
    protected static String m_sDokumentTyp = null;
    protected static String m_sLastXPath = "";
    protected static String m_sLastParameter = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public void pruefeDokumentation() throws Exception {
        try {
            FehlerListe.newGroup(cADMINISTRATIVEDATEN);
            this.pruefeDokumentTyp(m_sDokumentTyp, m_nEinschreibungWegen, m_sFileName.toString());
            if (m_nEinschreibungWegen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Einschreibung wegen'");
            }
            if (this.testBit(m_nEinschreibungWegen, 2) && this.testBit(m_nEinschreibungWegen, 4)) {
                m_MeldungPool.addMeldung("DMP-063", "Diabetes mellitus Typ 1", "Diabetes mellitus Typ 2");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && this.testBit(m_nEinschreibungWegen, 16)) {
                m_MeldungPool.addMeldung("DMP-063", "Asthma bronchiale", "COPD");
            }
            if (this.testBit(m_nEinschreibungWegen, 1) && this.testBit(m_nEinschreibungWegen, 64)) {
                m_MeldungPool.addMeldung("DMP-063", "KHK", "Chronische Herzinsuffizienz");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && m_nPatientenAlter != -1 && m_nPatientenAlter < 1) {
                m_MeldungPool.addMeldung("DMP-071");
            }
            if (this.testBit(m_nEinschreibungWegen, 16) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-112");
            }
            if (this.testBit(m_nEinschreibungWegen, 1024) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-114");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cANAMNESE);
            this.allgemeineAnamnese("OSTEOPOROSE", m_nPatientenAlter, m_bKoerpergroesse, m_bKoerpergewicht, m_dKoerpergroesse, m_nKoerpergewicht, m_sKoerpergroesse, m_bBlutdruckSystolisch, m_bBlutdruckDiastolisch, m_nBlutdruckSystolisch, m_nBlutdruckDiastolisch, m_sBlutdruckSystolisch, m_sBlutdruckDiastolisch, m_nRaucher, m_nBegleiterkrankungen);
            if (this.testBit(m_nEinschreibungWegen, 512)) {
                if (m_sGeschlecht_.equals("M") && m_nPatientenAlter < 60) {
                    m_MeldungPool.addMeldung("DMP-110");
                }
                if ((m_sGeschlecht_.equals("F") || m_sGeschlecht_.equals("UN") || m_sGeschlecht_.equals("X")) && m_nPatientenAlter < 50) {
                    m_MeldungPool.addMeldung("DMP-111");
                }
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 2) && !this.testBit(m_nEinschreibungWegen, 4) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-070");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 1) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-072");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 64) || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-073");
            }
            if (!m_bFolgeDoku) {
                if (m_nFraktur == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Osteoporosebedingte Fraktur in den letzten 12 Monaten'");
                }
                if (this.countBits(m_nFraktur) > 1) {
                    m_MeldungPool.addMeldung("DMP-013", "'Osteoporosebedingte Fraktur in den letzten 12 Monaten'");
                }
            } else if (m_nFraktur != 0) {
                m_MeldungPool.addMeldung("DMP-090", cOSTEOFRAKTUR, "Folgedokumentation");
            }
            if (m_bFolgeDoku) {
                if (m_nNeuFraktur == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Neu aufgetretene osteoporosebedingte Fraktur seit der letzten Dokumentation'");
                }
                if (this.countBits(m_nNeuFraktur) > 1) {
                    m_MeldungPool.addMeldung("DMP-013", "'Neu aufgetretene osteoporosebedingte Fraktur seit der letzten Dokumentation'");
                }
            } else if (m_nNeuFraktur != 0) {
                m_MeldungPool.addMeldung("DMP-090", cNEUFRAKTUR, "Erstdokumentation");
            }
            if (!m_bFolgeDoku) {
                if (this.testBit(m_nFraktur, 1) && m_nFrakturLokal == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Lokalisation der osteoporosebedingten Fraktur'");
                } else if (this.testBit(m_nFraktur, 2) && m_nFrakturLokal != 0) {
                    m_MeldungPool.addMeldung("DMP-101", cFRAKTURLoKAL);
                }
            } else if (this.testBit(m_nNeuFraktur, 1) && m_nFrakturLokal == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Lokalisation der osteoporosebedingten Fraktur'");
            } else if (this.testBit(m_nNeuFraktur, 2) && m_nFrakturLokal != 0) {
                m_MeldungPool.addMeldung("DMP-101", cFRAKTURLoKAL);
            }
            if (!m_bFolgeDoku) {
                if (!m_bStuerze6Monate) {
                    m_MeldungPool.addMeldung("DMP-002", "'St\u00fcrze in den letzten 6 Monaten'");
                }
                if (m_bStuerze6Monate && (m_nStuerze6Monate < 0 || m_nStuerze6Monate > 99)) {
                    m_MeldungPool.addMeldung("DMP-113", cSTUERZE_6MONATE);
                }
            } else if (m_bStuerze6Monate) {
                m_MeldungPool.addMeldung("DMP-101", cSTUERZE_6MONATE);
            }
            if (!m_bFolgeDoku) {
                if (m_bStuerzeDoku) {
                    m_MeldungPool.addMeldung("DMP-101", cSTUERZE_DOKU);
                }
            } else {
                if (!m_bStuerzeDoku) {
                    m_MeldungPool.addMeldung("DMP-002", "'St\u00fcrze seit der letzten Dokumentation'");
                }
                if (m_bStuerzeDoku && (m_nStuerzeDoku < 0 || m_nStuerzeDoku > 99)) {
                    m_MeldungPool.addMeldung("DMP-113", cSTUERZE_DOKU);
                }
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNG);
            if (m_nPatientenAlter >= 70 && m_nRisikoAb70 == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Teilnehmerinnen und Teilnehmer ab 70 Jahre: erh\u00f6htes Sturzrisiko'");
            } else if (m_nPatientenAlter < 70 && m_nRisikoAb70 != 0) {
                m_MeldungPool.addMeldung("DMP-101", cERHOEHTES_STURZRISIKOAB70);
            }
            if (m_nRisikoAb70 > 2) {
                m_MeldungPool.addMeldung("DMP-013", "'Teilnehmerinnen und Teilnehmer ab 70 Jahre: erh\u00f6htes Sturzrisiko'");
            }
            if (m_nSturzprophylaxe > 2) {
                m_MeldungPool.addMeldung("DMP-013", "'Bei Teilnehmerinnen und Teilnehmern mit erh\u00f6htem Sturzrisiko oder St\u00fcrzen: Sturzprophylaxema\u00dfnahme empfohlen'");
            }
            if (m_nSturzprophylaxe == 0 && !m_bFolgeDoku && (m_nStuerze6Monate > 0 || this.testBit(m_nRisikoAb70, 1))) {
                m_MeldungPool.addMeldung("DMP-002", "'Bei Teilnehmerinnen und Teilnehmern mit erh\u00f6htem Sturzrisiko oder St\u00fcrzen: Sturzprophylaxema\u00dfnahme empfohlen'");
            }
            if (m_nSturzprophylaxe == 0 && m_bFolgeDoku && (m_nStuerzeDoku > 0 || this.testBit(m_nRisikoAb70, 1))) {
                m_MeldungPool.addMeldung("DMP-002", "'Bei Teilnehmerinnen und Teilnehmern mit erh\u00f6htem Sturzrisiko oder St\u00fcrzen: Sturzprophylaxema\u00dfnahme empfohlen'");
            }
            if (m_nSturzprophylaxe != 0 && !m_bFolgeDoku && m_nStuerze6Monate == 0 && this.testBit(m_nRisikoAb70, 2)) {
                m_MeldungPool.addMeldung("DMP-101", cSTURZPROPHYLAXE);
            }
            if (m_nSturzprophylaxe != 0 && m_bFolgeDoku && m_nStuerzeDoku == 0 && this.testBit(m_nRisikoAb70, 2)) {
                m_MeldungPool.addMeldung("DMP-101", cSTURZPROPHYLAXE);
            }
            if (m_nTraining == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Regelm\u00e4\u00dfiges k\u00f6rperliches Training'");
            }
            if (this.testBit(m_nTraining, 1) && this.countBits(m_nTraining) > 1) {
                m_MeldungPool.addMeldung("DMP-105", cTRAINING);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNG_MEDIKAMENTOES);
            if (m_nAktuelleMedikation == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle osteoporosespezifische Medikation'");
            }
            if (this.countBits(m_nAktuelleMedikation) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Aktuelle osteoporosespezifische Medikation'");
            }
            if (m_nMedikationsdauer == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Dauer der osteoporosespezifischen Medikation'");
            }
            if (this.countBits(m_nMedikationsdauer) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Dauer der osteoporosespezifischen Medikation'");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSCHULUNGEN);
            if (!m_bFolgeDoku && m_nSchulungVorDMPWahrgenommen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Schulung bereits vor Einschreibung in das DMP wahrgenommen'");
            }
            if (this.countBits(m_nSchulungVorDMPWahrgenommen) > 1) {
                m_MeldungPool.addMeldung("DMP-013", "'Schulung bereits vor Einschreibung in das DMP wahrgenommen'");
            }
            if (m_bFolgeDoku && m_nSchulungVorDMPWahrgenommen != 0) {
                m_MeldungPool.addMeldung("DMP-090", cSCHULUNG_VOR_EINSCHREIBUNG_WAHRGENOMMEN, "Folgedokumentation");
            }
            if (m_nSchulungEmpfohlen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (this.countBits(m_nSchulungEmpfohlen) > 1) {
                m_MeldungPool.addMeldung("DMP-013", "'Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (m_bFolgeDoku && m_nSchulungWahrgenommen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Empfohlene Schulung wahrgenommen'");
            }
            if (this.countBits(m_nSchulungWahrgenommen) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cSCHULUNG_WAHRGENOMMEN);
            }
            if (!m_bFolgeDoku && m_nSchulungWahrgenommen != 0) {
                m_MeldungPool.addMeldung("DMP-090", cSCHULUNG_WAHRGENOMMEN, "Erstdokumentation");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNGSPLAN);
            if (m_nIntervall == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Dokumentationsintervall'");
            }
            if (this.countBits(m_nIntervall) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Dokumentationsintervall");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefeDokumentation)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            FehlerListe.addParameter("BSNR", (Object)m_sProviderIdBSNR);
            FehlerListe.newGroup("Header");
            if (m_sProviderIdLANR == null && m_sProviderIdBSNR == null && m_sKrankenhausIK == null) {
                m_MeldungPool.addMeldung("DMP-061");
            }
            if (m_sProviderIdLANR != null && m_sProviderIdBSNR == null || m_sProviderIdLANR == null && m_sProviderIdBSNR != null) {
                m_MeldungPool.addMeldung("DMP-060");
            }
            if (m_sProviderIdLANR != null) {
                FehlerListe.addParameter("ARZT_NR", (Object)m_sProviderIdLANR);
            }
            if (m_sPatientId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/patient/person/id");
            }
            if (m_sId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/id");
            }
            if (m_sSetId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/set_id");
            }
            if (m_sPatientId != null && m_sId != null) {
                if (!m_sPatientId.equals(m_sId)) {
                    m_MeldungPool.addMeldung("DMP-004", m_sPatientId, m_sId);
                } else {
                    boolean bIdentisch = false;
                    if (m_sProviderIdBSNR != null && m_sId.equals(m_sProviderIdBSNR)) {
                        bIdentisch = true;
                    }
                    if (m_sKrankenhausIK != null && m_sId.equals(m_sKrankenhausIK)) {
                        bIdentisch = true;
                    }
                    if (!bIdentisch) {
                        m_MeldungPool.addMeldung("DMP-068");
                    }
                }
            }
            if (m_sProviderIdLANR != null && m_sProviderIdLANR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "LANR");
            }
            if (m_sKrankenhausIK != null && m_sKrankenhausIK.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "Krankenhaus-IK");
            }
            if (m_sProviderIdBSNR != null && m_sProviderIdBSNR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "BSNR");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Schemaname");
            this.pruefeXMLSchemaname();
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            boolean bPruefeLang = false;
            if (m_sKrankenhausIK != null && (m_sProviderIdLANR == null && m_sProviderIdLANR == null || m_sKrankenhausIK.equals(m_sPatientId))) {
                m_sFileName.append(m_sKrankenhausIK);
                m_sFileName.append("_");
                bPruefeLang = true;
            }
            m_sFileName.append(m_sPatientIdEX);
            m_sFileName.append("_");
            m_sFileName.append(m_sDokdatum.replaceAll("-", ""));
            if (m_bFolgeDoku) {
                if (m_bASatz) {
                    m_sFileName.append("_a.EVOST");
                } else {
                    m_sFileName.append(".EVOST");
                }
            } else if (m_bASatz) {
                m_sFileName.append("_a.EEOST");
            } else {
                m_sFileName.append(".EEOST");
            }
            this.m_sValue = m_DatenPool.getString("XPM_FILE");
            String sErwarteterName = m_sFileName.toString();
            String sPattern = m_bFolgeDoku ? (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EVOST" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EVOST") : (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EEOST" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EEOST");
            String sTemp = this.m_sValue.substring(0, 10);
            if (sTemp == null || sTemp.length() < 10 || sTemp.indexOf(95) != 9) {
                m_MeldungPool.addMeldung("DMP-059");
            } else if (bPruefeLang) {
                if (this.m_sValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-005", this.m_sValue, sPattern, sErwarteterName);
                }
            } else {
                String sSubValue = this.m_sValue.substring(10);
                if (sSubValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, this.m_sValue.substring(0, 10) + sErwarteterName);
                }
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_DIR");
            if (this.m_sValue != null && !this.m_sValue.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("DMP-025", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+OST_101\\.zip)")) {
                m_MeldungPool.addMeldung("DMP-080F", "OST_101.zip");
            }
            m_MeldungPool.reportMeldungen();
            this.pruefeDokumentation();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        String m_sGeschlecht_ = "";
        m_nArztNr = -1;
        m_sServiceTmr = "";
        m_dateUnterschrift = null;
        m_dateKopf = null;
        m_nPatientenAlter = -1;
        m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        m_sFileName = new StringBuffer();
        m_sDokdatum = new String();
        m_sParameter = "";
        m_bErgebnis = false;
        m_nAbschnitt = 0;
        m_sAbschnitt = new String();
        m_dKoerpergroesse = 0.0;
        m_sKoerpergroesse = new String();
        m_bKoerpergroesse = false;
        m_nKoerpergewicht = 0;
        m_bKoerpergewicht = false;
        m_sKoerpergewicht = new String();
        m_nBlutdruckSystolisch = 0;
        m_bBlutdruckSystolisch = false;
        m_sBlutdruckSystolisch = new String();
        m_nBlutdruckDiastolisch = 0;
        m_bBlutdruckDiastolisch = false;
        m_sBlutdruckDiastolisch = new String();
        m_nRaucher = 0;
        m_nEinschreibungWegen = 0;
        m_nFraktur = 0;
        m_nNeuFraktur = 0;
        m_nFrakturLokal = 0;
        m_bStuerze6Monate = false;
        m_bStuerzeDoku = false;
        m_nStuerze6Monate = 0;
        m_nStuerzeDoku = 0;
        m_nRisikoAb70 = 0;
        m_nSturzprophylaxe = 0;
        m_nTraining = 0;
        m_nSchulungVorDMPWahrgenommen = 0;
        m_nSchulungEmpfohlen = 0;
        m_nSchulungWahrgenommen = 0;
        m_nInformationsangebote = 0;
        m_nIntervall = 0;
        m_nBegleiterkrankungen = 0;
        m_nSturzprophylaxe = 0;
        m_nAktuelleMedikation = 0;
        m_nMedikationsdauer = 0;
        m_sId = null;
        m_sSetId = null;
        m_sKrankenhausIK = null;
        m_sProviderIdLANR = null;
        m_sProviderIdBSNR = null;
        m_sPatientId = null;
        m_sPatientIdEX = null;
        m_sDokumentTyp = null;
        m_sLastXPath = "";
        m_sLastParameter = "";
    }
}

