/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.depression;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.depression.XPMEventHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final String cZIP_DIR = "Depression/Dokumentation/";
    protected static String m_sGeschlecht_ = "";
    protected static int m_nArztNr = -1;
    protected static String m_sServiceTmr = "";
    protected static Date m_dateUnterschrift = null;
    protected static Date m_dateKopf = null;
    protected static int m_nPatientenAlter = -1;
    protected static SimpleDateFormat m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
    protected static final String cV = "V";
    protected static StringBuffer m_sFileName = new StringBuffer();
    protected static String m_sDokdatum = new String();
    protected static String m_sParameter = "";
    protected static boolean m_bErgebnis = false;
    protected static int m_nAbschnitt = 0;
    protected static String m_sAbschnitt = new String();
    protected static final int cABSCHNITT_ADMINISTRATIVEDATEN = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_BEHANDLUNG = 3;
    protected static final int cABSCHNITT_SCHULUNGEN = 4;
    protected static final int cABSCHNITT_BEHANDLUNGSPLAN = 5;
    protected static final String cADMINISTRATIVEDATEN = "Administrative Daten";
    protected static final String cANAMNESE = "Anamnese- und Befunddaten";
    protected static final String cBEHANDLUNG = "Nicht-medikament\u00f6se und medikament\u00f6se Behandlung";
    protected static final String cSCHULUNGEN = "Schulung";
    protected static final String cBEHANDLUNGSPLAN = "Behandlungsplanung";
    protected static final String cKOERPERGROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPERGEWICHT = "K\u00f6rpergewicht";
    protected static final String cBLUTDRUCK_SYSTOLISCH = "Blutdruck systolisch";
    protected static final String cBLUTDRUCK_DIASTOLISCH = "Blutdruck diastolisch";
    protected static final String cPHQ_SUMMENWERT = "Aktuelle Symptomatik - PHQ-9 Summenwert";
    protected static final String cSCHWEREGRAD_EPISODE = "Schweregrad zu Beginn der aktuellen depressiven Episode";
    protected static final String cDAUER_EPISODE = "Dauer der aktuellen depressiven Episode";
    protected static final String cSUIZIDALITAET_EINGESCHAETZT = "Suizidalit\u00e4t eingesch\u00e4tzt";
    protected static final String cAKTUELLE_PSYCHOTHERAPIE = "Aktuelle Psychotherapie";
    protected static final String cMEDIKAMENTOESE_THERAPIE = "Aktuelle medikament\u00f6se Therapie mit Antidepressiva";
    protected static double m_dKoerpergroesse = 0.0;
    protected static String m_sKoerpergroesse = new String();
    protected static boolean m_bKoerpergroesse = false;
    protected static int m_nKoerpergewicht = 0;
    protected static boolean m_bKoerpergewicht = false;
    protected static String m_sKoerpergewicht = new String();
    protected static int m_nBlutdruckSystolisch = 0;
    protected static boolean m_bBlutdruckSystolisch = false;
    protected static String m_sBlutdruckSystolisch = new String();
    protected static int m_nBlutdruckDiastolisch = 0;
    protected static boolean m_bBlutdruckDiastolisch = false;
    protected static String m_sBlutdruckDiastolisch = new String();
    protected static int m_nRaucher = 0;
    protected static int m_nEinschreibungWegen = 0;
    protected static int m_nSchulungVorDMPWahrgenommen = 0;
    protected static int m_nSchulungEmpfohlen = 0;
    protected static int m_nSchulungWahrgenommen = 0;
    protected static int m_nBegleiterkrankungen = 0;
    protected static int m_nPHQ9Summenwert = 0;
    protected static boolean m_bPHQ9Summenwert = false;
    protected static String m_sPHQ9Summenwert = new String();
    protected static int m_nSchweregradEpisode = 0;
    protected static int m_nSuizidalitaetEingeschaetzt = 0;
    protected static int m_nDauerAktuelleEpisode = 0;
    protected static int m_nAktuellePsychotherapie = 0;
    protected static int m_nMedikamentoeseTherapie = 0;
    protected static int m_nInformationsangebote = 0;
    protected static int m_nIntervall = 0;
    protected static String m_sId = null;
    protected static String m_sSetId = null;
    protected static String m_sKrankenhausIK = null;
    protected static String m_sProviderIdLANR = null;
    protected static String m_sProviderIdBSNR = null;
    protected static String m_sPatientId = null;
    protected static String m_sPatientIdEX = null;
    protected static String m_sDokumentTyp = null;
    protected static String m_sLastXPath = "";
    protected static String m_sLastParameter = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public void pruefeDokumentation() throws Exception {
        try {
            FehlerListe.newGroup(cADMINISTRATIVEDATEN);
            this.pruefeDokumentTyp(m_sDokumentTyp, m_nEinschreibungWegen, m_sFileName.toString());
            if (m_nEinschreibungWegen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Einschreibung wegen'");
            }
            if (this.testBit(m_nEinschreibungWegen, 2) && this.testBit(m_nEinschreibungWegen, 4)) {
                m_MeldungPool.addMeldung("DMP-063", "Diabetes mellitus Typ 1", "Diabetes mellitus Typ 2");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && this.testBit(m_nEinschreibungWegen, 16)) {
                m_MeldungPool.addMeldung("DMP-063", "Asthma bronchiale", "COPD");
            }
            if (this.testBit(m_nEinschreibungWegen, 1) && this.testBit(m_nEinschreibungWegen, 64)) {
                m_MeldungPool.addMeldung("DMP-063", "KHK", "Chronische Herzinsuffizienz");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && m_nPatientenAlter != -1 && m_nPatientenAlter < 1) {
                m_MeldungPool.addMeldung("DMP-071");
            }
            if (this.testBit(m_nEinschreibungWegen, 16) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-112");
            }
            if (this.testBit(m_nEinschreibungWegen, 1024) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-113");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cANAMNESE);
            this.allgemeineAnamnese("DEPRESSION", m_nPatientenAlter, m_bKoerpergroesse, m_bKoerpergewicht, m_dKoerpergroesse, m_nKoerpergewicht, m_sKoerpergroesse, m_bBlutdruckSystolisch, m_bBlutdruckDiastolisch, m_nBlutdruckSystolisch, m_nBlutdruckDiastolisch, m_sBlutdruckSystolisch, m_sBlutdruckDiastolisch, m_nRaucher, m_nBegleiterkrankungen);
            if (this.testBit(m_nEinschreibungWegen, 512)) {
                if (m_sGeschlecht_.equals("M") && m_nPatientenAlter < 60) {
                    m_MeldungPool.addMeldung("DMP-110");
                }
                if ((m_sGeschlecht_.equals("F") || m_sGeschlecht_.equals("UN") || m_sGeschlecht_.equals("X")) && m_nPatientenAlter < 50) {
                    m_MeldungPool.addMeldung("DMP-111");
                }
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 2) && !this.testBit(m_nEinschreibungWegen, 4) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-070");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 1) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-072");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 64) || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-073");
            }
            if (!m_bPHQ9Summenwert) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle Symptomatik - PHQ-9 Summenwert'");
            } else if (m_nPHQ9Summenwert < 0 || m_nPHQ9Summenwert > 27) {
                m_MeldungPool.addMeldung("DMP-107", cPHQ_SUMMENWERT);
            }
            if (m_nSchweregradEpisode == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Schweregrad zu Beginn der aktuellen depressiven Episode'");
            }
            if (this.countBits(m_nSchweregradEpisode) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Schweregrad zu Beginn der aktuellen depressiven Episode'");
            }
            if (!m_bFolgeDoku) {
                if (m_nDauerAktuelleEpisode == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Dauer der aktuellen depressiven Episode'");
                }
            } else if (this.testBit(m_nSchweregradEpisode, 8)) {
                if (m_nDauerAktuelleEpisode != 0) {
                    m_MeldungPool.addMeldung("DMP-091", cDAUER_EPISODE);
                }
            } else if (m_nDauerAktuelleEpisode == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Dauer der aktuellen depressiven Episode'");
            }
            if (this.countBits(m_nDauerAktuelleEpisode) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Dauer der aktuellen depressiven Episode'");
            }
            if (m_nSuizidalitaetEingeschaetzt == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Suizidalit\u00e4t eingesch\u00e4tzt'");
            }
            if (this.countBits(m_nSuizidalitaetEingeschaetzt) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Suizidalit\u00e4t eingesch\u00e4tzt'");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNG);
            if (m_nAktuellePsychotherapie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle Psychotherapie'");
            }
            if (this.countBits(m_nAktuellePsychotherapie) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Aktuelle Psychotherapie'");
            }
            if (m_nMedikamentoeseTherapie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle medikament\u00f6se Therapie mit Antidepressiva'");
            }
            if (this.countBits(m_nMedikamentoeseTherapie) > 1) {
                m_MeldungPool.addMeldung("DMP-013b", "'Aktuelle medikament\u00f6se Therapie mit Antidepressiva'");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSCHULUNGEN);
            if (!m_bFolgeDoku && m_nSchulungVorDMPWahrgenommen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Bereits vor Einschreibung in das DMP an einer depressionsspezifischen Schulung teilgenommen'");
            }
            if (this.countBits(m_nSchulungVorDMPWahrgenommen) > 1) {
                m_MeldungPool.addMeldung("DMP-013", "'Bereits vor Einschreibung in das DMP an einer depressionsspezifischen teilgenommen'");
            }
            if (m_bFolgeDoku && m_nSchulungVorDMPWahrgenommen != 0) {
                m_MeldungPool.addMeldung("DMP-090", "Bereits vor Einschreibung in das DMP an einer depressionsspezifischen Schulung teilgenommen", "Folgedokumentation");
            }
            if (m_nSchulungEmpfohlen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Depressionsspezifische Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (this.countBits(m_nSchulungEmpfohlen) > 1) {
                m_MeldungPool.addMeldung("DMP-013", "'Depressionsspezifische Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (m_bFolgeDoku && m_nSchulungWahrgenommen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Depressionsspezifische Schulung wahrgenommen'");
            }
            if (this.countBits(m_nSchulungWahrgenommen) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Depressionsspezifische Schulung wahrgenommen");
            }
            if (!m_bFolgeDoku && m_nSchulungWahrgenommen != 0) {
                m_MeldungPool.addMeldung("DMP-090", "Depressionsspezifische Schulung wahrgenommen", "Erstdokumentation");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNGSPLAN);
            if (m_nIntervall == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Dokumentationsintervall'");
            }
            if (this.countBits(m_nIntervall) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Dokumentationsintervall");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefeDokumentation)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            FehlerListe.addParameter("BSNR", (Object)m_sProviderIdBSNR);
            FehlerListe.newGroup("Header");
            if (m_sProviderIdLANR == null && m_sProviderIdBSNR == null && m_sKrankenhausIK == null) {
                m_MeldungPool.addMeldung("DMP-061");
            }
            if (m_sProviderIdLANR != null && m_sProviderIdBSNR == null || m_sProviderIdLANR == null && m_sProviderIdBSNR != null) {
                m_MeldungPool.addMeldung("DMP-060");
            }
            if (m_sProviderIdLANR != null) {
                FehlerListe.addParameter("ARZT_NR", (Object)m_sProviderIdLANR);
            }
            if (m_sPatientId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/patient/person/id");
            }
            if (m_sId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/id");
            }
            if (m_sSetId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/set_id");
            }
            if (m_sPatientId != null && m_sId != null) {
                if (!m_sPatientId.equals(m_sId)) {
                    m_MeldungPool.addMeldung("DMP-004", m_sPatientId, m_sId);
                } else {
                    boolean bIdentisch = false;
                    if (m_sProviderIdBSNR != null && m_sId.equals(m_sProviderIdBSNR)) {
                        bIdentisch = true;
                    }
                    if (m_sKrankenhausIK != null && m_sId.equals(m_sKrankenhausIK)) {
                        bIdentisch = true;
                    }
                    if (!bIdentisch) {
                        m_MeldungPool.addMeldung("DMP-068");
                    }
                }
            }
            if (m_sProviderIdLANR != null && m_sProviderIdLANR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "LANR");
            }
            if (m_sKrankenhausIK != null && m_sKrankenhausIK.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "Krankenhaus-IK");
            }
            if (m_sProviderIdBSNR != null && m_sProviderIdBSNR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "BSNR");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Schemaname");
            this.pruefeXMLSchemaname();
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            boolean bPruefeLang = false;
            if (m_sKrankenhausIK != null && (m_sProviderIdLANR == null && m_sProviderIdLANR == null || m_sKrankenhausIK.equals(m_sPatientId))) {
                m_sFileName.append(m_sKrankenhausIK);
                m_sFileName.append("_");
                bPruefeLang = true;
            }
            m_sFileName.append(m_sPatientIdEX);
            m_sFileName.append("_");
            m_sFileName.append(m_sDokdatum.replaceAll("-", ""));
            if (m_bFolgeDoku) {
                if (m_bASatz) {
                    m_sFileName.append("_a.EVDE");
                } else {
                    m_sFileName.append(".EVDE");
                }
            } else if (m_bASatz) {
                m_sFileName.append("_a.EEDE");
            } else {
                m_sFileName.append(".EEDE");
            }
            this.m_sValue = m_DatenPool.getString("XPM_FILE");
            String sErwarteterName = m_sFileName.toString();
            String sPattern = m_bFolgeDoku ? (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EVDE" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EVDE") : (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EEDE" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EEDE");
            String sTemp = this.m_sValue.substring(0, 10);
            if (sTemp == null || sTemp.length() < 10 || sTemp.indexOf(95) != 9) {
                m_MeldungPool.addMeldung("DMP-059");
            } else if (bPruefeLang) {
                if (this.m_sValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-005", this.m_sValue, sPattern, sErwarteterName);
                }
            } else {
                String sSubValue = this.m_sValue.substring(10);
                if (sSubValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, this.m_sValue.substring(0, 10) + sErwarteterName);
                }
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_DIR");
            if (this.m_sValue != null && !this.m_sValue.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("DMP-025", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+DE_102\\.zip)")) {
                m_MeldungPool.addMeldung("DMP-080F", "DE_102.zip");
            }
            m_MeldungPool.reportMeldungen();
            this.pruefeDokumentation();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        String m_sGeschlecht_ = "";
        m_nArztNr = -1;
        m_sServiceTmr = "";
        m_dateUnterschrift = null;
        m_dateKopf = null;
        m_nPatientenAlter = -1;
        m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        m_sFileName = new StringBuffer();
        m_sDokdatum = new String();
        m_sParameter = "";
        m_bErgebnis = false;
        m_nAbschnitt = 0;
        m_sAbschnitt = new String();
        m_dKoerpergroesse = 0.0;
        m_sKoerpergroesse = new String();
        m_bKoerpergroesse = false;
        m_nKoerpergewicht = 0;
        m_bKoerpergewicht = false;
        m_sKoerpergewicht = new String();
        m_nBlutdruckSystolisch = 0;
        m_bBlutdruckSystolisch = false;
        m_sBlutdruckSystolisch = new String();
        m_nBlutdruckDiastolisch = 0;
        m_bBlutdruckDiastolisch = false;
        m_sBlutdruckDiastolisch = new String();
        m_nRaucher = 0;
        m_nEinschreibungWegen = 0;
        m_nSchulungVorDMPWahrgenommen = 0;
        m_nSchulungEmpfohlen = 0;
        m_nSchulungWahrgenommen = 0;
        m_nBegleiterkrankungen = 0;
        m_nPHQ9Summenwert = 0;
        m_bPHQ9Summenwert = false;
        m_sPHQ9Summenwert = new String();
        m_nSchweregradEpisode = 0;
        m_nDauerAktuelleEpisode = 0;
        m_nSuizidalitaetEingeschaetzt = 0;
        m_nAktuellePsychotherapie = 0;
        m_nMedikamentoeseTherapie = 0;
        m_nInformationsangebote = 0;
        m_nIntervall = 0;
        m_sId = null;
        m_sSetId = null;
        m_sKrankenhausIK = null;
        m_sProviderIdLANR = null;
        m_sProviderIdBSNR = null;
        m_sPatientId = null;
        m_sPatientIdEX = null;
        m_sDokumentTyp = null;
        m_sLastXPath = "";
        m_sLastParameter = "";
    }
}

