/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.dm2;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.stamm.KTS.IK;
import de.kbv.xpm.core.stamm.KTS.SatzKTS;
import de.kbv.xpm.core.util.Quartal;
import de.kbv.xpm.modul.dmp.dm2.Clinical_document_headerHandler;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class GesetzlicheKrankenversicherungHandler
extends Clinical_document_headerHandler {
    protected GesetzlicheKrankenversicherungHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    public void checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat(String sGueltigBis, String sEinlesedatum, String versSchutzbeginn) throws Exception {
        try {
            if (!bASatz_) {
                Date dateVersEnde = this.getDatum(sGueltigBis, "VersicherungsschutzEnde");
                Date dateEinleseDatum = this.getDatum(sEinlesedatum, "Einlesedatum");
                Date dateVersBeginn = this.getDatum(versSchutzbeginn, "Versicherungsschutzbeginn");
                if (dateEinleseDatum != null && dateVersEnde != null && dateVersEnde.before(dateEinleseDatum)) {
                    m_MeldungPool.addMeldung("DMP-077");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung (checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat)");
        }
    }

    public void pruefeVknrBeiKVKFallUndFallNach414(String sEinlesedatum, String versNR, String vknr) throws Exception {
        try {
            boolean kVKFall = false;
            boolean fallNach414 = false;
            if (versNR != null && versNR.length() > 1 && versNR.substring(0, 1).matches("[0-9]")) {
                kVKFall = true;
            }
            Date dateEinleseDatum = null;
            if (sEinlesedatum != null && !sEinlesedatum.isEmpty()) {
                dateEinleseDatum = this.getDatum(sEinlesedatum, "Einlesedatum");
            }
            if (dateEinleseDatum != null && dateEinleseDatum.after(new SimpleDateFormat("yyyy-MM-dd").parse("2014-12-31"))) {
                fallNach414 = true;
            }
            if (vknr != null && vknr.length() >= 5) {
                int vknrInt = 0;
                vknrInt = this.getInt(vknr.substring(2, 5), "AbrechnungsVKNR");
                if (kVKFall && fallNach414 && vknrInt < 800) {
                    m_MeldungPool.addMeldung("DMP-078");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung (pruefeVknrBeiKVKFallUndFallNach414)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            String wop;
            Date dateEGK;
            sValue_ = this.m_Element.getChildAttributeValue("Kostentraegerbezeichnung", "V");
            if (sValue_.trim().length() == 0 && sValue_.length() > 0) {
                m_MeldungPool.addMeldung("DM2-A04", sValue_);
            }
            String sIK = this.m_Element.getChildAttributeValue("Kostentraegerkennung", "V");
            FehlerListe.addParameter("KASSE_NR", (Object)sIK);
            String sKTAB = this.m_Element.getChildAttributeValue("KostentraegerAbrechnungsbereich", "V");
            if (KTStamm.isValid()) {
                SatzKTS kt = KTStamm.getKTSSatz(sIK);
                if (kt == null) {
                    m_MeldungPool.addMeldung("DM2-IK", sIK);
                } else {
                    IK ik;
                    String sVKNR = this.m_Element.getChildAttributeValue("AbrechnungsVKNR", "V");
                    if (kt.getKTNr() != null && sVKNR.length() > 0 && !sVKNR.equals(kt.getKTNr())) {
                        m_MeldungPool.addMeldung("DM2-VKNR", sVKNR, kt.getKTNr());
                    }
                    if ((ik = kt.getIK(sIK)) != null && dateDoku_ != null) {
                        Quartal von = ik.getGueltigkeitsBeginn();
                        Quartal bis = ik.getGueltigkeitsEnde();
                        Quartal ktEnde = kt.getGueltigkeitsEnde();
                        SatzKTS Aufnehmeder_kt = kt.getAufnehmenderKT();
                        if (von != null && von.compareTo(dateDoku_) == 1 || bis != null && bis.compareTo(dateDoku_) == -1 || von == null && bis == null && ktEnde != null && ktEnde.compareTo(dateDoku_) < 0 && Aufnehmeder_kt == null) {
                            m_MeldungPool.addMeldung("DM2-IKQ", sIK);
                        }
                    }
                    if (kt.getKTABNameNachFusion(sKTAB) == null) {
                        m_MeldungPool.addMeldung("DM2-KTAB", sKTAB, sIK);
                    }
                }
            }
            sValue_ = this.m_Element.getChildAttributeValue("VersicherungsschutzEnde", "V");
            Date dateGueltigBis = this.getBisDatum(sValue_, "Versicherungsschutzendedatum der eGK");
            if (dateDoku_ != null && dateGueltigBis != null && dateDoku_.after(dateGueltigBis)) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(dateGueltigBis);
                cal.add(2, 3);
                Date dateAfter3Month = cal.getTime();
                if (dateDoku_.after(dateAfter3Month)) {
                    m_MeldungPool.addMeldung("DM2-EGKG");
                } else {
                    m_MeldungPool.addMeldung("DM2-EGKGw");
                }
            }
            if ((dateEGK = this.pruefeDatum(sValue_ = this.m_Element.getChildAttributeValue("Einlesedatum", "V"), "Einlesedatum", false)) != null && dateDoku_ != null && dateEGK.after(dateDoku_)) {
                m_MeldungPool.addMeldung("DM2-EGK");
            }
            String versSchutzbeginn = this.m_Element.getChildAttributeValue("VersicherungsschutzBeginn", "V");
            String sGueltigBis = this.m_Element.getChildAttributeValue("VersicherungsschutzEnde", "V");
            String versNR = this.m_Element.getChildAttributeValue("Versichertennummer", "V");
            String vknr = this.m_Element.getChildAttributeValue("AbrechnungsVKNR", "V");
            this.pruefeVknrBeiKVKFallUndFallNach414(sValue_, versNR, vknr);
            this.checkVersBeginnVorEinleseDatundVersEndeNachEinleseDat(sGueltigBis, sValue_, versSchutzbeginn);
            sValue_ = this.m_Element.getChildAttributeValue("Versichertennummer", "V");
            if (sValue_.length() > 12) {
                m_MeldungPool.addMeldung("DM2-A06", sValue_);
            }
            for (int i = 1; i < sValue_.length(); ++i) {
                char ch = sValue_.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                m_MeldungPool.addMeldung("DM2-A06a", sValue_);
                break;
            }
            if (!bASatz_) {
                String dmp = this.m_Element.getChildAttributeValue("DMP_Kennzeichnung", "V");
                if (dmp == null || dmp.isEmpty()) {
                    m_MeldungPool.addMeldung("DMP-002", "DMP_Kennzeichnung");
                } else if (dmp.length() != 2) {
                    m_MeldungPool.addMeldung("DMP-082", "DMP_Kennzeichnung");
                } else if (DMPTabelle.getKey(dmp) == null) {
                    m_MeldungPool.addMeldung("DMP-101", dmp, "DMP_Kennzeichnung");
                }
                String pg = this.m_Element.getChildAttributeValue("BesonderePersonengruppe", "V");
                if (pg == null || pg.isEmpty()) {
                    m_MeldungPool.addMeldung("DMP-002", "BesonderePersonengruppe");
                } else if (pg.length() != 2) {
                    m_MeldungPool.addMeldung("DMP-082", "BesonderePersonengruppe");
                } else if (PersonenGruppeTabelle.getKey(pg) == null) {
                    m_MeldungPool.addMeldung("DMP-101", pg, "BesonderePersonengruppe");
                }
            }
            if (!(wop = this.m_Element.getChildAttributeValue("WOP", "V")).isEmpty() && WOPTabelle.getKey(wop) == null) {
                m_MeldungPool.addMeldung("DM2-ZUL2", wop, "WOP");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "GesetzlicheKrankenversicherungHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
    }
}

