/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.dm2;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.io.ConfigFile;
import de.kbv.xpm.core.util.XPMStringBuffer;
import de.kbv.xpm.modul.dmp.dm2.XPMEventHandler;
import java.io.File;
import java.util.Date;
import java.util.regex.Pattern;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final int cABSCHNITT_ADMIN_DATEN = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_REL_EREIGNISSE = 3;
    protected static final int cABSCHNITT_MEDIKAMENTE = 4;
    protected static final int cABSCHNITT_SCHULUNG = 5;
    protected static final int cABSCHNITT_BEHANDLUNG = 6;
    protected static final String cADMIN_DATEN = "Administrative Daten";
    protected static final String cANAMNESE = "Anamnese- und Befunddaten";
    protected static final String cREL_EREIGNISSE = "Relevante Ereignisse";
    protected static final String cMEDIKAMENTE = "Medikamente";
    protected static final String cSCHULUNG = "Schulung";
    protected static final String cBEHANDLUNG = "Behandlungsplanung";
    protected static final String cZIP_DIR = "Diabetes_Mellitus_Typ_2/Dokumentation/";
    protected static final String cEINSCHREIBUNG = "Einschreibung wegen";
    protected static final String cMODUL_TEILNAHME = "Modul-Teilnahme Chronische Herzinsuffizienz";
    protected static final String cINSULIN_ANALOGA = "Insulin oder Insulin-Analoga";
    protected static final String cMETFORMIN = "Metformin";
    protected static final String cRAUCHER = "Raucher";
    protected static final String cKOERPER_GROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPER_GEWICHT = "K\u00f6rpergewicht";
    protected static final String cPULSSTATUS = "Pulsstatus";
    protected static final String cSENSIBILITAET = "Sensibilit\u00e4tspr\u00fcfung";
    protected static final String cWRULCUS = "Weiteres Risiko f\u00fcr Ulcus";
    protected static final String cULKUS = "Ulkus";
    protected static final String cWUNDINFEKTION = "(Wund)Infektion";
    protected static final String cINTERVALLFUSSINSPEKTION = "Intervall f\u00fcr k\u00fcnftige Fu\u00dfinspektionen (bei Patientinnen und Patienten ab dem vollendeten 18. Lebensjahr)";
    protected static final String cSPAETFOLGEN = "Sp\u00e4tfolgen";
    protected static final String cINJEKTIONSSTELLEN = "Injektionsstellen (bei Insulintherapie)";
    protected static final String cBLUTDRUCK_SYS = "Blutdruck systolisch";
    protected static final String cBLUTDRUCK_DIAS = "Blutdruck diastolisch";
    protected static final String cHBA1C = "HbA1c";
    protected static final String cBEGLEIT_ERKRANKUNGEN = "Begleiterkrankungen";
    protected static final String cHYPOGLYKAEMIEN = "Schwere Hypoglyk\u00e4mien seit der letzten Dokumentation";
    protected static final String cOAD_MEDIKATION = "Sonstige antidiabetische Medikation";
    protected static final String cDIABETES_AUFENTHALTE = "Station\u00e4re notfallm\u00e4\u00dfige Behandlung wegen Diabetes mellitus seit der letzten Dokumentation";
    protected static final String cSGLT2_INHIBITOR = "SGLT2-Inhibitor";
    protected static final String cGLP1_REZEPTORAGONIST = "GLP-1-Rezeptoragonist";
    protected static final String cTA_HEMMER = "Thrombozytenaggregationshemmer";
    protected static final String cSCHULUNG_WAHRGENOMMEN = "Empfohlene Schulung(en) wahrgenommen";
    protected static final String cSCHULUNG_EMPFOHLEN = "Schulung empfohlen (bei aktueller Dokumentation)";
    protected static final String cSCHULUNG_VOR_EINSCHREIBUNG_WAHRGENOMMEN = "Schulung schon vor Einschreibung ins DMP bereits wahrgenommen";
    protected static final String cDIABETES_SCHULUNG = "Diabetes-Schulung";
    protected static final String cHYPERTONIE_SCHULUNG = "Hypertonie-Schulung";
    protected static final String cGEWUENSCHTE_INFO = "Vom Patienten gew\u00fcnschte Informationsangebote der Krankenkasse";
    protected static final String cNICHT_MOEGLICH = "War aktuell nicht m\u00f6glich";
    protected static final String cZIELWERT_HBA1C = "HbA1c-Zielwert";
    protected static final String cVEREINBARUNG_BLUTDRUCK = "Zielvereinbarung Blutdruck";
    protected static final String cNETZHAUT_UNTERSUCHUNG = "Ophthalmologische Netzhautuntersuchung seit letzter Dokumentation";
    protected static final String cDIABETES_FUSSSYNDROM = "Behandlung/Mitbehandlung in einer f\u00fcr das Diabetische Fu\u00dfsyndrom qualifizierten Einrichtung";
    protected static final String cDIABETES_STAT_UEBERWEISUNG = "Diabetesbezogene station\u00e4re Einweisung";
    protected static final String cINTERVALL = "Dokumentationsintervall";
    protected static final String cEGFR = "eGFR";
    protected static int nAbschnitt_ = 0;
    protected static Date dateDoku_ = null;
    protected static Date dateGeburt_ = null;
    protected static String m_sServiceTmr = null;
    protected static int m_nPatientenAlter = -1;
    protected static String m_sGeschlecht_ = "";
    protected static boolean[] m_aAbschnitte = new boolean[7];
    protected static final XPMStringBuffer sFileName_ = new XPMStringBuffer();
    protected static String sLANr_ = "";
    protected static String sBSNr_ = "";
    protected static String sKrankenhausIK_ = "";
    protected static String sPatientenIdRT_ = "";
    protected static int nBegleitErkrankungen_ = 0;
    protected static int nEinschreibung_ = 0;
    protected static int nModulTeilnahme_ = 0;
    protected static int nRaucher_ = 0;
    protected static float fKoerperGroesse_ = -1.0f;
    protected static int nKoerperGewicht_ = -1;
    protected static String m_sKoerpergewicht = new String();
    protected static boolean bVollJaehrig_ = true;
    protected static boolean b12JahreOderAelter_ = false;
    protected static int nPulsstatus_ = 0;
    protected static int nSensibilitaet_ = 0;
    protected static int nWRUlcus = 0;
    protected static int nUlkus = 0;
    protected static int nWInfekt = 0;
    protected static int nIntervallFu\u00dfinspektion = 0;
    protected static int nIntervallFu\u00dfinspektionCounter = 0;
    protected static int nSpaetfolgen_ = 0;
    protected static int nBlutdruckSys_ = -1;
    protected static int nBlutdruckDias_ = -1;
    protected static float fHbA1C_ = -1.0f;
    protected static int hba1cCounter = 0;
    protected static int hba1cMmolCounter = 0;
    protected static int hba1cProzentCounter = 0;
    protected static int pulsstatusCounter = 0;
    protected static int sensibilitaetspruefungCounter = 0;
    protected static int ulkusCounter = 0;
    protected static int wInfektionCounter = 0;
    protected static int wrUlcusCounter = 0;
    protected static int sglt2Inhibitor_ = 0;
    protected static int glp1Rezeptoragonist_ = 0;
    protected static int nTAHemmer_ = 0;
    protected static int nHypoglykaemien_ = -1;
    protected static int nHbA1CAufenthalte_ = -1;
    protected static int nDiabetesAufenthalte_ = -1;
    protected static int nRelEreignisse_ = 0;
    protected static int nInsulinAnaloga_ = 0;
    protected static int nMetformin_ = 0;
    protected static int nOADMedikation_ = 0;
    protected static int nSchulungEmpfohlen_ = 0;
    protected static int nSchulungVorherWahrgenommen = 0;
    protected static int nDiabetesSchulung_ = 0;
    protected static int nHypertonieSchulung_ = 0;
    protected static int nInfos_ = 0;
    protected static int nZielwertHbA_ = 0;
    protected static int nNetzhautUntersuchung_ = 0;
    protected static int nFusssyndrom_ = 0;
    protected static int nEinweisungStat_ = 0;
    protected static int nIntervall_ = 0;
    protected static int n_eGFR = 0;
    protected static int egfr_count = 0;
    protected static String sFirstParameter_ = "";
    protected static int nInjektionsstellen_ = 0;

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public int countBits(int iValue) throws Exception {
        try {
            int iCount = 0;
            for (int x = 0; x < 16; ++x) {
                if ((iValue & 1) != 0) {
                    ++iCount;
                }
                iValue >>= 1;
            }
            return iCount;
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (countBits)");
            return 0;
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
        try {
            sciphoxFormat_.setLenient(false);
            sFileName_.delete();
            ConfigFile config = (ConfigFile)m_DatenPool.getObject("XPM_CONFIG_FILE");
            if (config != null) {
                File schemaXML;
                File schemaConfig = new File(config.getPruefSchema());
                this.m_sValue = this.m_Element.getAttributeValue("noNamespaceSchemaLocation");
                if (this.m_sValue.length() > 0 && !(schemaXML = new File(this.m_sValue)).getName().toLowerCase().endsWith(schemaConfig.getName().toLowerCase())) {
                    m_MeldungPool.addMeldung("DM2-XMLS", schemaXML.getName(), schemaConfig.getName());
                }
                this.m_sValue = this.m_Element.getAttributeValue("schemaLocation");
                if (this.m_sValue.length() > 0 && !(schemaXML = new File(this.m_sValue)).getName().toLowerCase().endsWith(schemaConfig.getName().toLowerCase())) {
                    m_MeldungPool.addMeldung("DM2-XMLS", schemaXML.getName(), schemaConfig.getName());
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Initialisierung");
        }
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.newGroup(cADMIN_DATEN);
            if (nEinschreibung_ == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cEINSCHREIBUNG);
            } else if ((nEinschreibung_ & 2) == 2 && (nEinschreibung_ & 4) == 4) {
                m_MeldungPool.addMeldung("DM2-A10");
            } else if ((nEinschreibung_ & 8) == 8 && (nEinschreibung_ & 0x10) == 16) {
                m_MeldungPool.addMeldung("DM2-A10a");
            } else if ((nEinschreibung_ & 4) != 4) {
                m_MeldungPool.addMeldung("DM2-A10b");
            } else if ((nEinschreibung_ & 1) == 1 && (nEinschreibung_ & 0x40) == 64) {
                m_MeldungPool.addMeldung("DMP-063", "KHK", "Chronische Herzinsuffizienz");
            }
            if ((nEinschreibung_ & 8) == 8 && m_nPatientenAlter != -1 && m_nPatientenAlter < 1) {
                m_MeldungPool.addMeldung("DMP-071");
            }
            if ((nEinschreibung_ & 0x10) == 16 && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-112");
            }
            if ((nEinschreibung_ & 0x400) == 1024 && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-113");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cANAMNESE);
            if ((double)fKoerperGroesse_ == -1.0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cKOERPER_GROESSE);
            } else if ((double)fKoerperGroesse_ < 0.0 || (double)fKoerperGroesse_ > 2.5) {
                m_MeldungPool.addMeldung("DM2-WERT", cKOERPER_GROESSE, String.valueOf(fKoerperGroesse_), "0 - 2,50");
            }
            if (nKoerperGewicht_ == -1) {
                m_MeldungPool.addMeldung("DM2-FEHL", cKOERPER_GEWICHT);
            } else if (nKoerperGewicht_ < 0 || nKoerperGewicht_ > 300) {
                m_MeldungPool.addMeldung("DM2-WERT", cKOERPER_GEWICHT, String.valueOf(nKoerperGewicht_), "0 - 300");
            }
            if (nBlutdruckSys_ == -1) {
                m_MeldungPool.addMeldung("DM2-FEHL", cBLUTDRUCK_SYS);
            } else if (nBlutdruckSys_ < 50 || nBlutdruckSys_ > 300) {
                m_MeldungPool.addMeldung("DM2-WERT", cBLUTDRUCK_SYS, String.valueOf(nBlutdruckSys_), "50 - 300");
            }
            if (nBlutdruckDias_ == -1) {
                m_MeldungPool.addMeldung("DM2-FEHL", cBLUTDRUCK_DIAS);
            } else if (nBlutdruckDias_ < 30 || nBlutdruckDias_ > 180) {
                m_MeldungPool.addMeldung("DM2-WERT", cBLUTDRUCK_DIAS, String.valueOf(nBlutdruckDias_), "30 - 180");
            }
            if (nBlutdruckSys_ != -1 && nBlutdruckDias_ != -1 && nBlutdruckSys_ <= nBlutdruckDias_) {
                m_MeldungPool.addMeldung("DM2-A15", String.valueOf(nBlutdruckSys_), String.valueOf(nBlutdruckDias_));
            }
            if (nRaucher_ == 0 && b12JahreOderAelter_) {
                m_MeldungPool.addMeldung("DM2-FEHL", cRAUCHER);
            }
            if (this.countBits(nRaucher_) > 1) {
                m_MeldungPool.addMeldung("DM2-WDSP", cRAUCHER);
            }
            if (nBegleitErkrankungen_ == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cBEGLEIT_ERKRANKUNGEN);
            } else if (nBegleitErkrankungen_ > 2) {
                m_MeldungPool.addMeldung("DM2-ERK");
            }
            if ((nEinschreibung_ & 0x200) == 512) {
                if (m_sGeschlecht_.equals("M") && m_nPatientenAlter != -1 && m_nPatientenAlter < 60) {
                    m_MeldungPool.addMeldung("DMP-110");
                }
                if ((m_sGeschlecht_.equals("F") || m_sGeschlecht_.equals("UN") || m_sGeschlecht_.equals("X")) && m_nPatientenAlter != -1 && m_nPatientenAlter < 50) {
                    m_MeldungPool.addMeldung("DMP-111");
                }
            }
            if (egfr_count != 1) {
                m_MeldungPool.addMeldung("DMP-013");
            } else if (n_eGFR < 0 || n_eGFR > 200) {
                m_MeldungPool.addMeldung("DM2-WERT", cEGFR, String.valueOf(n_eGFR), "0 - 200 ml/min/1,73m2KOF");
            }
            if (nInsulinAnaloga_ == 1) {
                if (nInjektionsstellen_ != 0) {
                    m_MeldungPool.addMeldung("DMP-015");
                }
            } else if (nInjektionsstellen_ != 1) {
                m_MeldungPool.addMeldung("DMP-014", cINJEKTIONSSTELLEN);
            }
            if (nIntervall_ == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cINTERVALL);
            } else if (nIntervall_ > 1) {
                m_MeldungPool.addMeldung("DM2-WDSP", cINTERVALL);
            }
            if (hba1cCounter == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cHBA1C);
            }
            if (hba1cMmolCounter > 0 && hba1cProzentCounter > 0) {
                m_MeldungPool.addMeldung("DM2-HBW");
            }
            if (bVollJaehrig_) {
                if (pulsstatusCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cPULSSTATUS);
                }
                if (sensibilitaetspruefungCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cSENSIBILITAET);
                }
                if (ulkusCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cULKUS);
                }
                if (wInfektionCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cWUNDINFEKTION);
                }
                if (nIntervallFu\u00dfinspektionCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cINTERVALLFUSSINSPEKTION);
                }
                if (nPulsstatus_ == 0) {
                    m_MeldungPool.addMeldung("DM2-FEHL", cPULSSTATUS);
                }
                if (nSensibilitaet_ == 0) {
                    m_MeldungPool.addMeldung("DM2-FEHL", cSENSIBILITAET);
                }
                if (nUlkus == 0) {
                    m_MeldungPool.addMeldung("DM2-FEHL", cULKUS);
                }
                if (nWInfekt == 0) {
                    m_MeldungPool.addMeldung("DM2-FEHL", cWUNDINFEKTION);
                }
                if (nIntervallFu\u00dfinspektion == 0) {
                    m_MeldungPool.addMeldung("DM2-FEHL", cINTERVALLFUSSINSPEKTION);
                }
                if (nWRUlcus == 0) {
                    m_MeldungPool.addMeldung("DM2-FEHL", cWRULCUS);
                }
            } else {
                if (pulsstatusCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cPULSSTATUS);
                }
                if (sensibilitaetspruefungCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cSENSIBILITAET);
                }
                if (ulkusCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cULKUS);
                }
                if (wInfektionCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cWUNDINFEKTION);
                }
                if (nIntervallFu\u00dfinspektionCounter > 1) {
                    m_MeldungPool.addMeldung("DM2-WDSP", cINTERVALLFUSSINSPEKTION);
                }
            }
            if (((nWRUlcus & 0x20) == 32 || (nWRUlcus & 0x40) == 64) && ((nWRUlcus & 1) == 1 || (nWRUlcus & 2) == 2 || (nWRUlcus & 4) == 4 || (nWRUlcus & 8) == 8 || (nWRUlcus & 0x10) == 16) || (nWRUlcus & 0x40) == 64 && (nWRUlcus & 0x20) == 32) {
                m_MeldungPool.addMeldung("DM2-WDSP", cWRULCUS);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cREL_EREIGNISSE);
            if (nRelEreignisse_ == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cREL_EREIGNISSE);
            } else if (nRelEreignisse_ > 2) {
                m_MeldungPool.addMeldung("DM2-005");
            }
            if (bVerlaufsDoku_) {
                if (nHypoglykaemien_ == -1) {
                    m_MeldungPool.addMeldung("DM2-FEHL", cHYPOGLYKAEMIEN);
                } else if (nHypoglykaemien_ < 0 || nHypoglykaemien_ > 99) {
                    m_MeldungPool.addMeldung("DM2-WERT", cHYPOGLYKAEMIEN, String.valueOf(nHypoglykaemien_), "0 - 99");
                }
                if (nDiabetesAufenthalte_ == -1) {
                    m_MeldungPool.addMeldung("DM2-FEHL", cDIABETES_AUFENTHALTE);
                } else if (nDiabetesAufenthalte_ < 0 || nDiabetesAufenthalte_ > 99) {
                    m_MeldungPool.addMeldung("DM2-WERT", cDIABETES_AUFENTHALTE, String.valueOf(nDiabetesAufenthalte_), "0 - 99");
                }
            } else {
                if (nHypoglykaemien_ != -1) {
                    m_MeldungPool.addMeldung("DM2-VD", cHYPOGLYKAEMIEN);
                }
                if (nDiabetesAufenthalte_ != -1) {
                    m_MeldungPool.addMeldung("DM2-VD", cDIABETES_AUFENTHALTE);
                }
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cMEDIKAMENTE);
            this.pruefeJaNein(nInsulinAnaloga_, cINSULIN_ANALOGA);
            this.pruefeJaNeinKontra(nMetformin_, cMETFORMIN);
            this.pruefeJaNein(nOADMedikation_, cOAD_MEDIKATION);
            this.pruefeJaNeinKontra(sglt2Inhibitor_, cSGLT2_INHIBITOR);
            this.pruefeJaNeinKontra(glp1Rezeptoragonist_, cGLP1_REZEPTORAGONIST);
            this.pruefeJaNeinKontraAntiko(nTAHemmer_, cTA_HEMMER);
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSCHULUNG);
            if (nSchulungEmpfohlen_ == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cSCHULUNG_EMPFOHLEN);
            } else if ((nSchulungEmpfohlen_ & 1) == 1 && (nSchulungEmpfohlen_ & 2) == 2) {
                m_MeldungPool.addMeldung("DM2-WDSP", cSCHULUNG_EMPFOHLEN);
            }
            if (bVerlaufsDoku_) {
                this.pruefeSchulung(nDiabetesSchulung_, cDIABETES_SCHULUNG);
                this.pruefeSchulung(nHypertonieSchulung_, cHYPERTONIE_SCHULUNG);
                if (nSchulungVorherWahrgenommen != 0) {
                    m_MeldungPool.addMeldung("DM2-ED", cSCHULUNG_VOR_EINSCHREIBUNG_WAHRGENOMMEN);
                }
            } else if (nSchulungVorherWahrgenommen == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cSCHULUNG_VOR_EINSCHREIBUNG_WAHRGENOMMEN);
            } else if ((nSchulungVorherWahrgenommen & 1) == 1 && (nSchulungVorherWahrgenommen & 2) == 2) {
                m_MeldungPool.addMeldung("DM2-WDSP", cSCHULUNG_VOR_EINSCHREIBUNG_WAHRGENOMMEN);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNG);
            if (nZielwertHbA_ == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cZIELWERT_HBA1C);
            } else if (nZielwertHbA_ > 1) {
                m_MeldungPool.addMeldung("DM2-WDSP", cZIELWERT_HBA1C);
            }
            if (nNetzhautUntersuchung_ == 0 && bVerlaufsDoku_) {
                m_MeldungPool.addMeldung("DM2-FEHL", cNETZHAUT_UNTERSUCHUNG);
            } else if ((nNetzhautUntersuchung_ & 1) == 1 && (nNetzhautUntersuchung_ & 2) == 2 && bVerlaufsDoku_) {
                m_MeldungPool.addMeldung("DM2-WDSP", cNETZHAUT_UNTERSUCHUNG);
            }
            if (nNetzhautUntersuchung_ != 0 && !bVerlaufsDoku_) {
                m_MeldungPool.addMeldung("DM2-VD", cNETZHAUT_UNTERSUCHUNG);
            }
            if (nFusssyndrom_ == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cDIABETES_FUSSSYNDROM);
            } else if (nFusssyndrom_ == 3) {
                m_MeldungPool.addMeldung("DM2-WDSP", cDIABETES_FUSSSYNDROM);
            }
            if (nEinweisungStat_ == 0) {
                m_MeldungPool.addMeldung("DM2-FEHL", cDIABETES_STAT_UEBERWEISUNG);
            } else if (nEinweisungStat_ == 3) {
                m_MeldungPool.addMeldung("DM2-WDSP", cDIABETES_STAT_UEBERWEISUNG);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            sValue_ = m_DatenPool.getString("XPM_FILE").toLowerCase();
            String sNamePattern = sFileName_.toString().toLowerCase();
            if (!Pattern.matches("\\d{9}_" + sNamePattern, sValue_) && sNamePattern.lastIndexOf(95) > 0) {
                if (bVerlaufsDoku_) {
                    m_MeldungPool.addMeldung("DM2-KONV", sValue_, "V", sNamePattern);
                } else {
                    m_MeldungPool.addMeldung("DM2-KONV", sValue_, "E", sNamePattern);
                }
            }
            if (sKrankenhausIK_.length() > 0) {
                if (sLANr_.length() == 0 && sBSNr_.length() == 0 && !sValue_.startsWith(sKrankenhausIK_)) {
                    m_MeldungPool.addMeldung("DM2-KONV2", sKrankenhausIK_, sValue_);
                } else if (sPatientenIdRT_.equals(sKrankenhausIK_) && !sValue_.startsWith(sKrankenhausIK_)) {
                    m_MeldungPool.addMeldung("DM2-KONV2", sKrankenhausIK_, sValue_);
                }
            }
            if ((sValue_ = m_DatenPool.getString("XPM_ZIP_DIR")) != null && !sValue_.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("DM2-ZIP", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+DM2_607\\.zip)")) {
                m_MeldungPool.addMeldung("DMP-080F", "DM2_607.zip");
            }
            m_MeldungPool.reportMeldungen();
            this.fillErrorReport();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        nAbschnitt_ = 0;
        dateDoku_ = null;
        dateGeburt_ = null;
        m_sServiceTmr = null;
        m_nPatientenAlter = -1;
        m_sGeschlecht_ = "";
        m_aAbschnitte = new boolean[7];
        sLANr_ = "";
        sBSNr_ = "";
        sKrankenhausIK_ = "";
        sPatientenIdRT_ = "";
        nBegleitErkrankungen_ = 0;
        nEinschreibung_ = 0;
        nModulTeilnahme_ = 0;
        nRaucher_ = 0;
        fKoerperGroesse_ = -1.0f;
        nKoerperGewicht_ = -1;
        m_sKoerpergewicht = new String();
        bVollJaehrig_ = true;
        b12JahreOderAelter_ = false;
        nPulsstatus_ = 0;
        nSensibilitaet_ = 0;
        nWRUlcus = 0;
        nUlkus = 0;
        nWInfekt = 0;
        nIntervallFu\u00dfinspektion = 0;
        nIntervallFu\u00dfinspektionCounter = 0;
        nSpaetfolgen_ = 0;
        nBlutdruckSys_ = -1;
        nBlutdruckDias_ = -1;
        fHbA1C_ = -1.0f;
        hba1cCounter = 0;
        hba1cMmolCounter = 0;
        hba1cProzentCounter = 0;
        pulsstatusCounter = 0;
        sensibilitaetspruefungCounter = 0;
        ulkusCounter = 0;
        wInfektionCounter = 0;
        wrUlcusCounter = 0;
        sglt2Inhibitor_ = 0;
        glp1Rezeptoragonist_ = 0;
        nTAHemmer_ = 0;
        nHypoglykaemien_ = -1;
        nHbA1CAufenthalte_ = -1;
        nDiabetesAufenthalte_ = -1;
        nRelEreignisse_ = 0;
        nInsulinAnaloga_ = 0;
        nMetformin_ = 0;
        nOADMedikation_ = 0;
        nSchulungEmpfohlen_ = 0;
        nSchulungVorherWahrgenommen = 0;
        nDiabetesSchulung_ = 0;
        nHypertonieSchulung_ = 0;
        nInfos_ = 0;
        nZielwertHbA_ = 0;
        nNetzhautUntersuchung_ = 0;
        nFusssyndrom_ = 0;
        nEinweisungStat_ = 0;
        nIntervall_ = 0;
        n_eGFR = 0;
        egfr_count = 0;
        sFirstParameter_ = "";
        nInjektionsstellen_ = 0;
    }
}

