/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.dm2;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.dm2.BeobachtungHandler;
import java.util.regex.Pattern;

public class ErgebniswertHandler
extends BeobachtungHandler {
    protected ErgebniswertHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    @Override
    public void elementStart() throws XPMException {
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            sValue_ = this.m_Element.getAttributeValue("V");
            bErgebnis_ = true;
            switch (nAbschnitt_) {
                case 2: {
                    if (sParameter_.equals("K\u00f6rpergr\u00f6\u00dfe")) {
                        fKoerperGroesse_ = this.getFloat(sValue_, sParameter_);
                        if (sValue_.equals("-1")) {
                            m_MeldungPool.addMeldung("DM2-ZUL2", sValue_, sParameter_);
                        }
                        if (!Pattern.matches(".\\...", sValue_)) {
                            m_MeldungPool.addMeldung("DMP-022");
                        }
                        if (!(sValue_ = this.m_Element.getAttributeValue("U")).equals("m")) {
                            m_MeldungPool.addMeldung("DM2-EINH", sParameter_, sValue_);
                        }
                        break;
                    }
                    if (sParameter_.equals("K\u00f6rpergewicht")) {
                        m_sKoerpergewicht = sValue_;
                        if (m_sKoerpergewicht != null && !m_sKoerpergewicht.matches("^[0-9]{3}$")) {
                            m_MeldungPool.addMeldung("DMP-102", "K\u00f6rpergewicht");
                        }
                        nKoerperGewicht_ = this.getInt(sValue_, sParameter_);
                        if (sValue_.equals("-1")) {
                            m_MeldungPool.addMeldung("DM2-ZUL2", sValue_, sParameter_);
                        }
                        if (!(sValue_ = this.m_Element.getAttributeValue("U")).equals("kg")) {
                            m_MeldungPool.addMeldung("DM2-EINH", sParameter_, sValue_);
                        }
                        break;
                    }
                    if (sParameter_.equals("Blutdruck systolisch")) {
                        nBlutdruckSys_ = this.getInt(sValue_, sParameter_);
                        if (sValue_ != null && !sValue_.matches("^[0-9]{2,3}$")) {
                            m_MeldungPool.addMeldung("DMP-102b", "Blutdruck systolisch");
                        }
                        if (sValue_.equals("-1")) {
                            m_MeldungPool.addMeldung("DM2-ZUL2", sValue_, sParameter_);
                        }
                        if (!(sValue_ = this.m_Element.getAttributeValue("U")).equals("mmHg")) {
                            m_MeldungPool.addMeldung("DM2-EINH", sParameter_, sValue_);
                        }
                        break;
                    }
                    if (sParameter_.equals("Blutdruck diastolisch")) {
                        nBlutdruckDias_ = this.getInt(sValue_, sParameter_);
                        if (sValue_ != null && !sValue_.matches("^[0-9]{2,3}$")) {
                            m_MeldungPool.addMeldung("DMP-102b", "Blutdruck diastolisch");
                        }
                        if (sValue_.equals("-1")) {
                            m_MeldungPool.addMeldung("DM2-ZUL2", sValue_, sParameter_);
                        }
                        if (!(sValue_ = this.m_Element.getAttributeValue("U")).equals("mmHg")) {
                            m_MeldungPool.addMeldung("DM2-EINH", sParameter_, sValue_);
                        }
                        break;
                    }
                    if (sParameter_.equals("eGFR")) {
                        String sEinheit = this.m_Element.getAttributeValue("U");
                        if (sEinheit.equals("ml/min/1,73m2KOF")) {
                            ++egfr_count;
                            if (!sValue_.matches("^[0-9]{1,3}$")) {
                                m_MeldungPool.addMeldung("DMP-103", "eGFR");
                                break;
                            }
                            n_eGFR = this.getInt(sValue_, sParameter_);
                            break;
                        }
                        m_MeldungPool.addMeldung("DM2-ZUL", sEinheit, sParameter_);
                        break;
                    }
                    if (sParameter_.equals("HbA1c")) {
                        String sUnit;
                        if (sValue_.equals("-1")) {
                            m_MeldungPool.addMeldung("DM2-ZUL", sValue_, sParameter_);
                        }
                        if ((sUnit = this.m_Element.getAttributeValue("U")).equals("mmol/mol")) {
                            int intHbA1C = this.getInt(sValue_, sParameter_);
                            if (!Pattern.matches("^[0-9]{1,3}$", sValue_)) {
                                m_MeldungPool.addMeldung("DMP-102e", sParameter_);
                            }
                            if (intHbA1C == -1) {
                                m_MeldungPool.addMeldung("DM2-FEHL", "HbA1c");
                            } else if (intHbA1C < 0 || intHbA1C > 210) {
                                m_MeldungPool.addMeldung("DM2-WERT", "HbA1c", String.valueOf(intHbA1C), "0 - 210");
                            }
                            ++hba1cCounter;
                            ++hba1cMmolCounter;
                        } else if (sUnit.equals("%")) {
                            fHbA1C_ = this.getFloat(sValue_, sParameter_);
                            if (!Pattern.matches("^[0-9]{1,2}\\.[0-9]$", sValue_)) {
                                m_MeldungPool.addMeldung("DMP-102d", sParameter_);
                            }
                            if ((double)fHbA1C_ == -1.0) {
                                m_MeldungPool.addMeldung("DM2-FEHL", "HbA1c");
                            } else if ((double)fHbA1C_ < 0.0 || (double)fHbA1C_ > 21.0) {
                                m_MeldungPool.addMeldung("DM2-WERT", "HbA1c", String.valueOf(fHbA1C_), "0,0 - 21,0");
                            }
                            ++hba1cCounter;
                            ++hba1cProzentCounter;
                        }
                        if (!sUnit.equals("%") && !sUnit.equals("mmol/mol")) {
                            m_MeldungPool.addMeldung("DM2-EINH", sParameter_, sUnit);
                        }
                        break;
                    }
                    m_MeldungPool.addMeldung("DM2-ZUL", sValue_, sParameter_);
                    break;
                }
                case 3: {
                    if (sParameter_.equals("Relevante Ereignisse")) {
                        m_MeldungPool.addMeldung("DM2-ZUL", sValue_, sParameter_);
                        break;
                    }
                    if (sParameter_.equals("Schwere Hypoglyk\u00e4mien seit der letzten Dokumentation")) {
                        nHypoglykaemien_ = this.getInt(sValue_, sParameter_);
                        if (!Pattern.matches("^[0-9]{1,2}$", sValue_)) {
                            m_MeldungPool.addMeldung("DMP-102c", sParameter_);
                        }
                        if (bVerlaufsDoku_ && nHypoglykaemien_ < 0) {
                            m_MeldungPool.addMeldung("DM2-WERT", sParameter_, sValue_, "Zahl gr\u00f6\u00dfer oder gleich 0");
                        }
                        if (!(sValue_ = this.m_Element.getAttributeValue("U")).equals("Anzahl")) {
                            m_MeldungPool.addMeldung("DM2-EINH", sParameter_, sValue_);
                        }
                        break;
                    }
                    if (sParameter_.equals("Station\u00e4re notfallm\u00e4\u00dfige Behandlung wegen Diabetes mellitus seit der letzten Dokumentation")) {
                        nDiabetesAufenthalte_ = this.getInt(sValue_, sParameter_);
                        if (!Pattern.matches("^[0-9]{1,2}$", sValue_)) {
                            m_MeldungPool.addMeldung("DMP-102c", sParameter_);
                        }
                        if (bVerlaufsDoku_ && nDiabetesAufenthalte_ < 0) {
                            m_MeldungPool.addMeldung("DM2-WERT", sParameter_, sValue_, "Zahl gr\u00f6\u00dfer oder gleich 0");
                        } else if (!bVerlaufsDoku_ && nDiabetesAufenthalte_ > 0) {
                            m_MeldungPool.addMeldung("DM2-VD", sParameter_);
                        }
                        sValue_ = this.m_Element.getAttributeValue("U");
                        if (!sValue_.equals("Anzahl")) {
                            m_MeldungPool.addMeldung("DM2-EINH", sParameter_, sValue_);
                        }
                        break;
                    }
                    m_MeldungPool.addMeldung("DM2-ZUL", sValue_, sParameter_);
                    break;
                }
                default: {
                    m_MeldungPool.addMeldung("DM2-ZUL", sValue_, sParameter_);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "ErgebniswertHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
    }
}

