/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.dmp.rheuma;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.modul.dmp.rheuma.XPMEventHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class LeveloneHandler
extends XPMEventHandler {
    protected static final String cZIP_DIR = "Rheumatoide_Arthritis/Dokumentation/";
    protected static String m_sGeschlecht_ = "";
    protected static int m_nArztNr = -1;
    protected static final String cVERTRAGSARZTNUMMER = "Vertragsarztnummer";
    protected static String m_sServiceTmr = "";
    protected static Date m_dateUnterschrift = null;
    protected static Date m_dateKopf = null;
    protected static int m_nPatientenAlter = -1;
    protected static SimpleDateFormat m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
    protected static final String cV = "V";
    protected static StringBuffer m_sFileName = new StringBuffer();
    protected static String m_sDokdatum = new String();
    protected static String m_sParameter = "";
    protected static boolean m_bErgebnis = false;
    protected static int m_nAbschnitt = 0;
    protected static String m_sAbschnitt = new String();
    protected static final int cABSCHNITT_ADMINISTRATIVEDATEN = 1;
    protected static final int cABSCHNITT_ANAMNESE = 2;
    protected static final int cABSCHNITT_MEDIKATION = 3;
    protected static final int cABSCHNITT_SCHULUNGEN = 4;
    protected static final int cABSCHNITT_BEHANDLUNGSPLAN = 5;
    protected static final String cADMINISTRATIVEDATEN = "Administrative Daten";
    protected static final String cANAMNESE = "Anamnese- und Befunddaten";
    protected static final String cMEDIKATION = "Medikament\u00f6se und sonstige Ma\u00dfnahmen";
    protected static final String cSCHULUNGEN = "Schulung";
    protected static final String cBEHANDLUNGSPLAN = "Behandlungsplanung";
    protected static final String cKOERPERGROESSE = "K\u00f6rpergr\u00f6\u00dfe";
    protected static final String cKOERPERGEWICHT = "K\u00f6rpergewicht";
    protected static final String cBLUTDRUCK_SYSTOLISCH = "Blutdruck systolisch";
    protected static final String cBLUTDRUCK_DIASTOLISCH = "Blutdruck diastolisch";
    protected static final String cERKRANKUNGSAKTIVITAET = "Aktuelle Krankheitsaktivit\u00e4t - DAS-28-Wert";
    protected static final String cERKRANKUNGSDAUER = "Erkrankungsdauer der rheumatoiden Arthritis (zum Zeitpunkt der aktuellen Dokumentation)";
    protected static final String cKLINISCHEEINSCHAETZUNG = "Klinische Einsch\u00e4tzung des Osteoporoserisikos durchgef\u00fchrt";
    protected static final String cGLUKOKORTOIDTHERAPIE = "Aktuelle Glukokortikoidtherapie wegen rheumatoider Arthritis";
    protected static final String cDMARDTHERAPIE = "Aktuelle DMARD-Therapie";
    protected static final String cKOERPERLICHEAKTIVITAET = "Regelm\u00e4\u00dfige k\u00f6rperliche Aktivit\u00e4t";
    protected static final String cSCHUUNGVORHERTEILGENOMMEN = "Bereits vor Einschreibung in das DMP an einer Rheuma-Schulung teilgenommen";
    protected static final String cSCHULUNGEMPFOHLEN = "Rheuma-Schulung empfohlen (bei aktueller Dokumentation)";
    protected static final String cSCHULUNGWAHRGENOMMEN = "Rheuma-Schulung wahrgenommen";
    protected static boolean m_bDiagnoseBekanntSeit = false;
    protected static int m_nDiagnoseBekanntSeit = 0;
    protected static double m_dKoerpergroesse = 0.0;
    protected static String m_sKoerpergroesse = new String();
    protected static boolean m_bKoerpergroesse = false;
    protected static int m_nKoerpergewicht = 0;
    protected static boolean m_bKoerpergewicht = false;
    protected static String m_sKoerpergewicht = new String();
    protected static int m_nBlutdruckSystolisch = 0;
    protected static boolean m_bBlutdruckSystolisch = false;
    protected static String m_sBlutdruckSystolisch = new String();
    protected static int m_nBlutdruckDiastolisch = 0;
    protected static boolean m_bBlutdruckDiastolisch = false;
    protected static String m_sBlutdruckDiastolisch = new String();
    protected static int m_nRaucher = 0;
    protected static int m_nEinschreibungWegen = 0;
    protected static double m_dErkrankungsAktivitaet = -1.0;
    protected static String m_sErkrankungsAktivitaet = new String();
    protected static boolean m_bErkrankungsAktivitaet = false;
    protected static int m_nErkrankungsdauer = 0;
    protected static int m_nKlinischeEinschaetzung = 0;
    protected static int m_nGlukokortikoidTherapie = 0;
    protected static int m_nDMARDTherapie = 0;
    protected static int m_KoerperlicheAktivitaet = 0;
    protected static int m_nSchulungVorherWahrgenommen = 0;
    protected static int m_nSchulungEmpfohlen = 0;
    protected static int m_nSchulungWahrgenommen = 0;
    protected static int m_nBegleiterkrankungen = 0;
    protected static int m_nInformationsangebote = 0;
    protected static int m_nIntervall = 0;
    protected static String m_sDokuGeplant = null;
    protected static String m_sId = null;
    protected static String m_sSetId = null;
    protected static String m_sKrankenhausIK = null;
    protected static String m_sProviderIdLANR = null;
    protected static String m_sProviderIdBSNR = null;
    protected static String m_sPatientId = null;
    protected static String m_sPatientIdEX = null;
    protected static String m_sDokumentTyp = null;
    protected static String m_sLastXPath = "";
    protected static String m_sLastParameter = "";

    protected LeveloneHandler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    public void pruefeDokumentation() throws Exception {
        try {
            FehlerListe.newGroup(cADMINISTRATIVEDATEN);
            this.pruefeDokumentTyp(m_sDokumentTyp, m_nEinschreibungWegen, m_sFileName.toString());
            if (m_nEinschreibungWegen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Einschreibung wegen'");
            }
            if (this.testBit(m_nEinschreibungWegen, 2) && this.testBit(m_nEinschreibungWegen, 4)) {
                m_MeldungPool.addMeldung("DMP-063", "Diabetes mellitus Typ 1", "Diabetes mellitus Typ 2");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && this.testBit(m_nEinschreibungWegen, 16)) {
                m_MeldungPool.addMeldung("DMP-063", "Asthma bronchiale", "COPD");
            }
            if (this.testBit(m_nEinschreibungWegen, 1) && this.testBit(m_nEinschreibungWegen, 64)) {
                m_MeldungPool.addMeldung("DMP-063", "KHK", "Chronische Herzinsuffizienz");
            }
            if (this.testBit(m_nEinschreibungWegen, 8) && m_nPatientenAlter != -1 && m_nPatientenAlter < 1) {
                m_MeldungPool.addMeldung("DMP-071");
            }
            if (this.testBit(m_nEinschreibungWegen, 16) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-112");
            }
            if (this.testBit(m_nEinschreibungWegen, 1024) && m_nPatientenAlter != -1 && m_nPatientenAlter < 18) {
                m_MeldungPool.addMeldung("DMP-113");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cANAMNESE);
            this.allgemeineAnamnese("RHEUMA", m_nPatientenAlter, m_bKoerpergroesse, m_bKoerpergewicht, m_dKoerpergroesse, m_nKoerpergewicht, m_sKoerpergroesse, m_bBlutdruckSystolisch, m_bBlutdruckDiastolisch, m_nBlutdruckSystolisch, m_nBlutdruckDiastolisch, m_sBlutdruckSystolisch, m_sBlutdruckDiastolisch, m_nRaucher, m_nBegleiterkrankungen);
            if (this.testBit(m_nEinschreibungWegen, 512)) {
                if (m_sGeschlecht_.equals("M") && m_nPatientenAlter < 60) {
                    m_MeldungPool.addMeldung("DMP-110");
                }
                if ((m_sGeschlecht_.equals("F") || m_sGeschlecht_.equals("UN") || m_sGeschlecht_.equals("X")) && m_nPatientenAlter < 50) {
                    m_MeldungPool.addMeldung("DMP-111");
                }
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 2) && !this.testBit(m_nEinschreibungWegen, 4) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-070");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 1) || m_nPatientenAlter >= 18 || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-072");
            }
            if (!(!this.testBit(m_nEinschreibungWegen, 64) || m_bBlutdruckSystolisch && m_bBlutdruckDiastolisch)) {
                m_MeldungPool.addMeldung("DMP-073");
            }
            if (!m_bErkrankungsAktivitaet) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle Krankheitsaktivit\u00e4t - DAS-28-Wert'");
            } else if (!Pattern.matches(".\\..", m_sErkrankungsAktivitaet)) {
                m_MeldungPool.addMeldung("DMP-122");
            } else if (m_dErkrankungsAktivitaet < 0.0 || m_dErkrankungsAktivitaet > 9.9) {
                m_MeldungPool.addMeldung("DMP-121");
            }
            if (m_nErkrankungsdauer == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Erkrankungsdauer der rheumatoiden Arthritis (zum Zeitpunkt der aktuellen Dokumentation)'");
            }
            if (this.countBits(m_nErkrankungsdauer) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cERKRANKUNGSDAUER);
            }
            if (m_nKlinischeEinschaetzung == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Klinische Einsch\u00e4tzung des Osteoporoserisikos durchgef\u00fchrt'");
            }
            if (this.countBits(m_nKlinischeEinschaetzung) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cKLINISCHEEINSCHAETZUNG);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cMEDIKATION);
            if (m_nGlukokortikoidTherapie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle Glukokortikoidtherapie wegen rheumatoider Arthritis'");
            }
            if (this.countBits(m_nGlukokortikoidTherapie) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cGLUKOKORTOIDTHERAPIE);
            }
            if (m_nDMARDTherapie == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Aktuelle DMARD-Therapie'");
            }
            if (this.countBits(m_nDMARDTherapie) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cDMARDTHERAPIE);
            }
            if (m_KoerperlicheAktivitaet == 0) {
                m_MeldungPool.addMeldung("DMP-002", cKOERPERLICHEAKTIVITAET);
            }
            if (this.testBit(m_KoerperlicheAktivitaet, 1) && this.countBits(m_KoerperlicheAktivitaet) > 1) {
                m_MeldungPool.addMeldung("DMP-123", cKOERPERLICHEAKTIVITAET);
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cSCHULUNGEN);
            if (m_nSchulungEmpfohlen == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Rheuma-Schulung empfohlen (bei aktueller Dokumentation)'");
            }
            if (this.countBits(m_nSchulungEmpfohlen) > 1) {
                m_MeldungPool.addMeldung("DMP-012", cSCHULUNGEMPFOHLEN);
            }
            if (m_bFolgeDoku) {
                if (m_nSchulungVorherWahrgenommen > 0) {
                    m_MeldungPool.addMeldung("DMP-074a");
                }
            } else {
                if (m_nSchulungVorherWahrgenommen == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Rheuma-Schulung schon vor Einschreibung in DMP bereits wahrgenommen'");
                }
                if (this.countBits(m_nSchulungVorherWahrgenommen) > 1) {
                    m_MeldungPool.addMeldung("DMP-012", "Rheuma-Schulung schon vor Einschreibung in DMP bereits wahrgenommen");
                }
            }
            if (!m_bFolgeDoku) {
                if (m_nSchulungWahrgenommen > 0) {
                    m_MeldungPool.addMeldung("DMP-074b");
                }
            } else {
                if (m_nSchulungWahrgenommen == 0) {
                    m_MeldungPool.addMeldung("DMP-002", "'Empfohlene Rheuma-Schulung wahrgenommen'");
                }
                if (this.countBits(m_nSchulungWahrgenommen) > 1) {
                    m_MeldungPool.addMeldung("DMP-012", "Empfohlene Rheuma-Schulung wahrgenommen");
                }
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup(cBEHANDLUNGSPLAN);
            if (m_nIntervall == 0) {
                m_MeldungPool.addMeldung("DMP-002", "'Dokumentationsintervall'");
            }
            if (this.countBits(m_nIntervall) > 1) {
                m_MeldungPool.addMeldung("DMP-012", "Dokumentationsintervall");
            }
            if (this.datumBevor(m_sDokuGeplant, m_sServiceTmr)) {
                m_MeldungPool.addMeldung("DMP-051");
            }
            m_MeldungPool.reportMeldungen();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung (pruefeDokumentation)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        int javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 17) {
            FehlerListe.newGroup("Genereller Hinweis");
            m_MeldungPool.addMeldung("XPM-JAVA-VER");
            m_MeldungPool.reportMeldungen();
        }
        this.checkXMLFileEncoding();
    }

    @Override
    public void elementEnde() throws XPMException {
        try {
            m_MeldungPool.hideLineNumber();
            FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            FehlerListe.addParameter("BSNR", (Object)m_sProviderIdBSNR);
            FehlerListe.newGroup("Header");
            if (m_sProviderIdLANR == null && m_sProviderIdBSNR == null && m_sKrankenhausIK == null) {
                m_MeldungPool.addMeldung("DMP-061");
            }
            if (m_sProviderIdLANR != null && m_sProviderIdBSNR == null || m_sProviderIdLANR == null && m_sProviderIdBSNR != null) {
                m_MeldungPool.addMeldung("DMP-060");
            }
            if (m_sProviderIdLANR != null) {
                FehlerListe.addParameter("ARZT_NR", (Object)m_sProviderIdLANR);
            }
            if (m_sPatientId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/patient/person/id");
            }
            if (m_sId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/id");
            }
            if (m_sSetId == null) {
                m_MeldungPool.addMeldung("DMP-002", "clinical_document_header/set_id");
            }
            if (m_sPatientId != null && m_sId != null) {
                if (!m_sPatientId.equals(m_sId)) {
                    m_MeldungPool.addMeldung("DMP-004", m_sPatientId, m_sId);
                } else {
                    boolean bIdentisch = false;
                    if (m_sProviderIdBSNR != null && m_sId.equals(m_sProviderIdBSNR)) {
                        bIdentisch = true;
                    }
                    if (m_sKrankenhausIK != null && m_sId.equals(m_sKrankenhausIK)) {
                        bIdentisch = true;
                    }
                    if (!bIdentisch) {
                        m_MeldungPool.addMeldung("DMP-068");
                    }
                }
            }
            if (m_sProviderIdLANR != null && m_sProviderIdLANR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "LANR");
            }
            if (m_sKrankenhausIK != null && m_sKrankenhausIK.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "Krankenhaus-IK");
            }
            if (m_sProviderIdBSNR != null && m_sProviderIdBSNR.length() != 9) {
                m_MeldungPool.addMeldung("DMP-006", "BSNR");
            }
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("XML-Schemaname");
            this.pruefeXMLSchemaname();
            m_MeldungPool.reportMeldungen();
            FehlerListe.newGroup("Dateiname");
            boolean bPruefeLang = false;
            if (m_sKrankenhausIK != null && (m_sProviderIdLANR == null && m_sProviderIdLANR == null || m_sKrankenhausIK.equals(m_sPatientId))) {
                m_sFileName.append(m_sKrankenhausIK);
                m_sFileName.append("_");
                bPruefeLang = true;
            }
            m_sFileName.append(m_sPatientIdEX);
            m_sFileName.append("_");
            m_sFileName.append(m_sDokdatum.replaceAll("-", ""));
            if (m_bFolgeDoku) {
                if (m_bASatz) {
                    m_sFileName.append("_a.EVRA");
                } else {
                    m_sFileName.append(".EVRA");
                }
            } else if (m_bASatz) {
                m_sFileName.append("_a.EERA");
            } else {
                m_sFileName.append(".EERA");
            }
            this.m_sValue = m_DatenPool.getString("XPM_FILE");
            String sErwarteterName = m_sFileName.toString();
            String sPattern = m_bFolgeDoku ? (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EVRA" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EVRA") : (m_bASatz ? "AAAAAAAAA_BBBBBBB_JJJJMMTT_a.EERA" : "AAAAAAAAA_BBBBBBB_JJJJMMTT.EERA");
            String sTemp = this.m_sValue.substring(0, 10);
            if (sTemp == null || sTemp.length() < 10 || sTemp.indexOf(95) != 9) {
                m_MeldungPool.addMeldung("DMP-059");
            } else if (bPruefeLang) {
                if (this.m_sValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-005", this.m_sValue, sPattern, sErwarteterName);
                }
            } else {
                String sSubValue = this.m_sValue.substring(10);
                if (sSubValue.compareToIgnoreCase(sErwarteterName) != 0) {
                    m_MeldungPool.addMeldung("DMP-065", this.m_sValue, sPattern, this.m_sValue.substring(0, 10) + sErwarteterName);
                }
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_DIR");
            if (this.m_sValue != null && !this.m_sValue.equals(cZIP_DIR)) {
                m_MeldungPool.addMeldung("DMP-025", cZIP_DIR);
            }
            this.m_sValue = m_DatenPool.getString("XPM_ZIP_FILE");
            if (this.m_sValue != null && !this.m_sValue.matches("(?i:.+RA_100\\.zip)")) {
                m_MeldungPool.addMeldung("DMP-080F", "RA_100.zip");
            }
            this.checkXMLFileEncoding();
            m_MeldungPool.reportMeldungen();
            this.pruefeDokumentation();
            m_MeldungPool.showLineNumber();
        }
        catch (Exception ex) {
            this.catchException(ex, "LeveloneHandler", "Pr\u00fcfung");
        }
    }

    @Override
    public void init() throws XPMException {
        m_sGeschlecht_ = "";
        m_nArztNr = -1;
        m_sServiceTmr = "";
        m_dateUnterschrift = null;
        m_dateKopf = null;
        m_nPatientenAlter = -1;
        m_SciphoxFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        m_sFileName = new StringBuffer();
        m_sDokdatum = new String();
        m_sParameter = "";
        m_bErgebnis = false;
        m_nAbschnitt = 0;
        m_sAbschnitt = new String();
        m_bDiagnoseBekanntSeit = false;
        m_nDiagnoseBekanntSeit = 0;
        m_dKoerpergroesse = 0.0;
        m_sKoerpergroesse = new String();
        m_bKoerpergroesse = false;
        m_nKoerpergewicht = 0;
        m_bKoerpergewicht = false;
        m_sKoerpergewicht = new String();
        m_nBlutdruckSystolisch = 0;
        m_bBlutdruckSystolisch = false;
        m_sBlutdruckSystolisch = new String();
        m_nBlutdruckDiastolisch = 0;
        m_bBlutdruckDiastolisch = false;
        m_sBlutdruckDiastolisch = new String();
        m_nRaucher = 0;
        m_nEinschreibungWegen = 0;
        m_dErkrankungsAktivitaet = -1.0;
        m_sErkrankungsAktivitaet = new String();
        m_bErkrankungsAktivitaet = false;
        m_nErkrankungsdauer = 0;
        m_nKlinischeEinschaetzung = 0;
        m_nGlukokortikoidTherapie = 0;
        m_nDMARDTherapie = 0;
        m_KoerperlicheAktivitaet = 0;
        m_nSchulungEmpfohlen = 0;
        m_nSchulungVorherWahrgenommen = 0;
        m_nSchulungWahrgenommen = 0;
        m_nBegleiterkrankungen = 0;
        m_nInformationsangebote = 0;
        m_nIntervall = 0;
        m_sDokuGeplant = null;
        m_sId = null;
        m_sSetId = null;
        m_sKrankenhausIK = null;
        m_sProviderIdLANR = null;
        m_sProviderIdBSNR = null;
        m_sPatientId = null;
        m_sPatientIdEX = null;
        m_sDokumentTyp = null;
        m_sLastXPath = "";
        m_sLastParameter = "";
    }
}

