/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.hks;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.format.Profile;
import de.kbv.xpm.core.io.AusgabeReport;
import de.kbv.xpm.core.pruefung.PruefEventHandler;
import de.kbv.xpm.core.stamm.EhdHeader;
import de.kbv.xpm.modul.hks.XPMFehlerListe;
import de.kbv.xpm.modul.hks.XPMStatistikListe;
import de.kbv.xpm.modul.hks.stamm.XPMDMPTabelle;
import de.kbv.xpm.modul.hks.stamm.XPMKTStamm;
import de.kbv.xpm.modul.hks.stamm.XPMPersonenGruppeTabelle;
import de.kbv.xpm.modul.hks.stamm.XPMWOPTabelle;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class XPMEventHandler
extends PruefEventHandler {
    protected static XPMKTStamm KTStamm;
    protected static XPMDMPTabelle DMPTabelle;
    protected static XPMPersonenGruppeTabelle PersonenGruppeTabelle;
    protected static XPMWOPTabelle WOPTabelle;
    protected static AusgabeReport FehlerListe;
    protected static XPMStatistikListe StatistikListe;
    protected static final String V = "V";
    protected static final String U = "U";
    protected static final String DN = "DN";
    protected static final String RT = "RT";
    protected static final String EX = "EX";
    protected static final String JA = "Ja";
    protected static final String NEIN = "Nein";
    protected static final String[] aErgebnistext_;
    protected static final SimpleDateFormat bisDatumParse_;
    protected static final SimpleDateFormat sciphoxParse_;
    protected static final SimpleDateFormat sciphoxFormat_;
    protected static final DecimalFormat floatFormat_;
    protected static Date dateNow_;
    protected static boolean bDermatologe_;
    protected static String sValue_;
    protected static Profile m_Profile;

    protected XPMEventHandler(String sXPath) throws XPMException {
        super(sXPath);
    }

    protected XPMEventHandler(String sXPath, Profile profile) throws XPMException {
        super(sXPath);
        m_Profile = profile;
        KTStamm = XPMKTStamm.getInstance();
        DMPTabelle = XPMDMPTabelle.getInstance();
        PersonenGruppeTabelle = XPMPersonenGruppeTabelle.getInstance();
        WOPTabelle = XPMWOPTabelle.getInstance();
        FehlerListe = XPMFehlerListe.getInstance();
        StatistikListe = XPMStatistikListe.getInstance();
    }

    public final void fillErrorReport() throws Exception {
        try {
            EhdHeader header;
            FehlerListe.newGroup("Dokumentationsbogen");
            Object sTitel = null;
            if (bDermatologe_) {
                FehlerListe.addParameter("TITEL", (Object)"Pr\u00fcfprotokoll eDokumentation eHKS - Dermatologe");
            } else {
                FehlerListe.addParameter("TITEL", (Object)"Pr\u00fcfprotokoll eDokumentation eHKS - Nicht-Dermatologe");
            }
            FehlerListe.addParameter("DATEI", (Object)m_DatenPool.getString("XPM_FILE"));
            FehlerListe.addParameter("DATUM", (Object)m_DatenPool.getString("XPM_DATE"));
            FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            FehlerListe.addParameter("ZEIT", (Object)m_DatenPool.getString("XPM_TIME"));
            FehlerListe.addParameter("DATEI_DATUM", (Object)m_DatenPool.getString("XPM_FILE_DATE"));
            FehlerListe.addParameter("PAKET_VERSION", (Object)m_Profile.getPaketVersion());
            FehlerListe.addParameter("XPM_VERSION", (Object)m_DatenPool.getString("XPM_VERSION"));
            FehlerListe.addParameter("KBV_TAB_VERSION", (Object)m_Profile.getPaketInformation());
            if (KTStamm.isValid() && (header = KTStamm.getHeader()) != null) {
                sValue_ = header.getDokumentTyp() + header.getInterfaceVersion() + "/" + header.getQuartal().toString().replaceFirst("/", "") + "/" + header.getProvider() + "/" + header.getDatum();
                FehlerListe.addParameter("KT_VERSION", (Object)sValue_);
            }
            int nReturnCode = Integer.parseInt(m_DatenPool.getString("XPM_RETURN_CODE"));
            FehlerListe.addParameter("ERGEBNIS_TEXT", (Object)aErgebnistext_[nReturnCode]);
            FehlerListe.addParameter("RETURN_CODE", (Object)new Integer(nReturnCode));
            FehlerListe.addParameter("INFOS", (Object)String.valueOf(m_MeldungPool.getInfoCounts()));
            FehlerListe.addParameter("WARNUNGEN", (Object)String.valueOf(m_MeldungPool.getWarningCounts()));
            FehlerListe.addParameter("FEHLER", (Object)String.valueOf(m_MeldungPool.getErrorCounts()));
            FehlerListe.addParameter("ABBRUCH", (Object)String.valueOf(m_MeldungPool.getCancelErrorCounts()));
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (fillErrorReport)");
        }
    }

    public final void fillStatisticReport() throws XPMException {
        try {
            StatistikListe.addParameter("TITEL", "Fehlerstatistik Dokumentation eHKS");
            StatistikListe.addParameter("DATEIEN", m_DatenPool.getString("XPM_FILES"));
            StatistikListe.addParameter("DATUM", m_DatenPool.getString("XPM_DATE"));
            StatistikListe.addParameter("ZEIT", m_DatenPool.getString("XPM_TIME"));
            StatistikListe.addParameter("XPM_VERSION", m_DatenPool.getString("XPM_VERSION"));
            StatistikListe.addParameter("KBV_TAB_VERSION", m_Profile.getPaketVersion());
            StatistikListe.addParameter("INFOS", String.valueOf(m_MeldungPool.getRunInfoCounts()));
            StatistikListe.addParameter("WARNUNGEN", String.valueOf(m_MeldungPool.getRunWarningCounts()));
            StatistikListe.addParameter("FEHLER", String.valueOf(m_MeldungPool.getRunErrorCounts()));
            StatistikListe.addParameter("ABBRUCH", String.valueOf(m_MeldungPool.getRunCancelErrorCounts()));
            String sStatus = String.valueOf(m_MeldungPool.getOkFilesCounts()) + "/" + m_MeldungPool.getWarningFilesCounts() + "/" + m_MeldungPool.getErrorFilesCounts() + "/" + m_MeldungPool.getCancelFilesCounts();
            StatistikListe.addParameter("STATUS", sStatus);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (fillStatisticReport)");
        }
    }

    public final String formatDatum(Date datum) throws Exception {
        try {
            return sciphoxFormat_.format(datum);
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (formatDatum)");
            return null;
        }
    }

    public final Date getBisDatum(String sDatum, String sFeld) throws Exception {
        try {
            try {
                if (sDatum.length() > 0) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(bisDatumParse_.parse(sDatum));
                    cal.add(2, 1);
                    cal.add(5, -1);
                    return cal.getTime();
                }
            }
            catch (ParseException ex) {
                m_MeldungPool.addMeldung("HKS-FRMT", sDatum, sFeld);
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getBisDatum)");
            return null;
        }
    }

    public final Date getDatum(String sDatum, String sFeld) throws Exception {
        try {
            try {
                if (sDatum.length() > 0) {
                    return sciphoxParse_.parse(sDatum);
                }
            }
            catch (ParseException ex) {
                m_MeldungPool.addMeldung("HKS-FRMT", sDatum, sFeld);
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getDatum)");
            return null;
        }
    }

    public final Number getFloat(String sValue, String sFeld) throws Exception {
        try {
            try {
                if (sValue.indexOf(46) != -1) {
                    m_MeldungPool.addMeldung("HKS-FRMT2", sValue, sFeld);
                } else if (sValue.length() > 0) {
                    return floatFormat_.parse(sValue);
                }
            }
            catch (ParseException ex) {
                m_MeldungPool.addMeldung("HKS-FRMT", sValue, sFeld);
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getFloat)");
            return null;
        }
    }

    public final int getInt(String sValue, String sFeld) throws Exception {
        try {
            try {
                if (sValue.length() > 0) {
                    return Integer.parseInt(sValue);
                }
            }
            catch (NumberFormatException ex) {
                m_MeldungPool.addMeldung("HKS-FRMT", sValue, sFeld);
            }
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getInt)");
            return 0;
        }
    }

    public final long getLong(String sValue, String sFeld) throws Exception {
        try {
            try {
                if (sValue.length() > 0) {
                    return Long.parseLong(sValue);
                }
            }
            catch (NumberFormatException ex) {
                m_MeldungPool.addMeldung("HKS-FRMT", sValue, sFeld);
            }
            return 0L;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (getLong)");
            return 0L;
        }
    }

    public final Date pruefeDatum(String sDatum, String sFeld, boolean bWarnung) throws Exception {
        try {
            Date datum = null;
            try {
                if ((m_DatenPool.getString("deactivateSystemDateCheck") == null || m_DatenPool.getString("deactivateSystemDateCheck").equals("false")) && sDatum.length() > 0 && (datum = sciphoxParse_.parse(sDatum)).after(dateNow_)) {
                    if (bWarnung) {
                        m_MeldungPool.addMeldung("HKS-ZEITw", sFeld);
                    } else {
                        m_MeldungPool.addMeldung("HKS-ZEIT", sFeld);
                    }
                }
            }
            catch (ParseException ex) {
                m_MeldungPool.addMeldung("HKS-FRMT", sDatum, sFeld);
            }
            return datum;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeDatum)");
            return null;
        }
    }

    public int codiereJaNein(String sValue, String sFeld) throws Exception {
        try {
            switch (sValue_.hashCode()) {
                case 2424124: {
                    return 1;
                }
                case 2391: {
                    return 2;
                }
            }
            m_MeldungPool.addMeldung("HKS-ZUL", sValue, sFeld);
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (codiereJaNein)");
            return 0;
        }
    }

    public void pruefeJaNein(int nValue, String sFeld, boolean bExistenz) throws Exception {
        try {
            if (bExistenz && nValue == 0) {
                m_MeldungPool.addMeldung("HKS-FEHL", sFeld);
            } else if (nValue > 2) {
                m_MeldungPool.addMeldung("HKS-WDSP", sFeld);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeJaNein)");
        }
    }

    public void pruefeWiderspruch(int nValue, String sFeld) throws Exception {
        try {
            int i = 7;
            int nCount = 0;
            while (i-- > 0) {
                if ((nValue & 1) == 1) {
                    ++nCount;
                }
                nValue >>= 1;
            }
            if (nCount > 1) {
                m_MeldungPool.addMeldung("HKS-WDSP", sFeld);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "XPMEventHandler", "Pr\u00fcfung (pruefeWiderspruch)");
        }
    }

    public void elementStart() throws XPMException {
        this.init();
    }

    public void elementEnde() throws XPMException {
    }

    public void init() throws XPMException {
        dateNow_ = Calendar.getInstance().getTime();
    }

    public static void setIsDermatologe(boolean b) {
        bDermatologe_ = b;
    }

    static {
        aErgebnistext_ = new String[]{"Ok", "Warnung", "Fehlerhaft", "Abbruch"};
        bisDatumParse_ = new SimpleDateFormat("yyyy-MM", Locale.GERMAN);
        sciphoxParse_ = new SimpleDateFormat("yyyy-MM-dd", Locale.GERMAN);
        sciphoxFormat_ = new SimpleDateFormat("dd.MM.yyyy", Locale.GERMAN);
        floatFormat_ = new DecimalFormat("##0.#", new DecimalFormatSymbols(Locale.GERMAN));
        dateNow_ = Calendar.getInstance().getTime();
        bDermatologe_ = true;
        sValue_ = null;
    }
}

