/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.converter.ISO8859_15Encoder;
import de.kbv.xpm.core.format.Util;
import de.kbv.xpm.core.io.AusgabeReport;
import de.kbv.xpm.core.io.ConfigFile;
import de.kbv.xpm.core.meldung.Meldung;
import de.kbv.xpm.core.pruefung.Element;
import de.kbv.xpm.core.stamm.ICD.SatzICD;
import de.kbv.xpm.core.stamm.ICD.StammDaten;
import de.kbv.xpm.core.stamm.KTS.SatzKTS;
import de.kbv.xpm.core.stamm.KV.Feld9460;
import de.kbv.xpm.core.stamm.KV.Satzkvx4;
import de.kbv.xpm.core.stamm.KV.Satzkvx5;
import de.kbv.xpm.core.stamm.KV.Satzkvx6;
import de.kbv.xpm.core.stamm.KV.Satzkvx7;
import de.kbv.xpm.core.util.FileMap;
import de.kbv.xpm.core.util.MultiMap;
import de.kbv.xpm.core.util.Quartal;
import de.kbv.xpm.modul.kvdt.common.AbstractXdtdataHandler;
import de.kbv.xpm.modul.kvdt.common.FallInfo;
import de.kbv.xpm.modul.kvdt.common.GNRInfo;
import de.kbv.xpm.modul.kvdt.common.ScheinInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractScon0Handler
extends AbstractXdtdataHandler {
    protected static final String cZ017 = "Z01.7";
    protected static final String cF5001 = "f5001";
    protected static final int[] m_aKV = new int[]{1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 24, 25, 27, 28, 31, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 78, 79, 80, 81, 83, 85, 86, 87, 88, 89, 90, 91, 93, 94, 95, 96, 98, 99};
    protected static final int[] m_aUKV_OKV = new int[]{1, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 24, 25, 27, 28, 31, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 78, 79, 80, 81, 83, 85, 86, 87, 88, 93, 94, 95, 96, 98, 99};
    protected static final Quartal cQUARTAL_12024 = new Quartal("12024");
    protected static final Quartal cQUARTAL_12025 = new Quartal("12025");
    protected static final Quartal cQUARTAL_12012 = new Quartal("12012");
    protected static final Quartal cQUARTAL_32014 = new Quartal("32014");
    protected static final Quartal cQUARTAL_22016 = new Quartal("22016");
    protected static final Quartal cQUARTAL_22017 = new Quartal("22017");
    protected static final Quartal cQUARTAL_32017 = new Quartal("32017");
    protected static final Quartal cQUARTAL_42017 = new Quartal("42017");
    protected static final Quartal cQUARTAL_12018 = new Quartal("12018");
    protected static final Quartal cQUARTAL_12019 = new Quartal("12019");
    protected static final Quartal cQUARTAL_12020 = new Quartal("12020");
    protected static final Quartal cQUARTAL_32020 = new Quartal("32020");
    protected static String schalterDatenpakete = "alle";
    protected static boolean m_bICDZusatzPruefung = false;
    protected static boolean m_bDokuAbgabe = false;
    protected static boolean m_bKlammern = false;
    protected static boolean m_bPrimaerICD = false;
    protected static boolean m_bUeScheinAbgabe = false;
    protected static boolean m_bUeScheinPlusAbgabe = false;
    protected static Date m_dateGeburt = null;
    protected static Date m_dateLeistung = null;
    protected static int m_nFaelleGesamt = 0;
    protected static int m_nFaelle = 0;
    protected static GNRInfo m_gnrInfo = null;
    protected static int m_nGNrMultiplikator = 1;
    protected static int m_nKlammerSchein = 1;
    protected static int m_nScheineGesamt = 0;
    protected static int m_nScheine = 0;
    protected static int m_nSatzart = 0;
    protected static HashSet<String> m_setBSNr = new HashSet();
    protected static String m_currentBSNr = new String();
    protected static HashSet<String> m_setIK = new HashSet();
    protected static String m_currentIK = new String();
    protected static String m_current0225 = new String();
    protected static HashMap<String, String> m_BSN_KNV = new HashMap();
    protected static HashMap<String, String> m_BSN_ePA0225 = new HashMap();
    protected static HashMap<String, String> m_BSN_ePA0226 = new HashMap();
    protected static HashSet<String> m_setLANr = new HashSet();
    protected static HashSet<String> m_setASVTeamNr = new HashSet();
    protected static HashSet<String> m_setPseudoLANR = new HashSet();
    protected static FileMap m_mapSortierListe = null;
    protected static HashMap<String, Long> m_mapScheine = new HashMap();
    protected static MultiMap m_mapKlammerScheine = new MultiMap();
    protected static Satzkvx4 m_kvx4 = null;
    protected static Satzkvx5 m_kvx5 = null;
    protected static Satzkvx6 m_kvx6 = null;
    protected static Satzkvx7 m_kvx7 = null;
    protected static SatzKTS m_KT = null;
    protected static final TreeMap<String, TreeMap<String, GNRInfo>> m_mapLANR = new TreeMap();
    protected static final TreeMap<String, FallInfo> m_mapFallAmbulant = new TreeMap();
    protected static final TreeMap<String, FallInfo> m_mapFallStationaer = new TreeMap();
    protected static final ScheinInfo m_Schein = new ScheinInfo();
    protected static String m_sAbrA = new String();
    protected static String m_sAbrG = null;
    protected static String m_sGO = null;
    protected static int m_nGO = 0;
    protected static String m_sGeburt = null;
    protected static String m_sGeschlecht = null;
    protected static String m_sKTAB = null;
    protected static String m_sEinlesetag = new String();
    protected static String m_sKVBereich = new String();
    protected static String m_sMFR = new String();
    protected static Element m_eGK = null;
    protected static String m_sName = new String();
    protected static Quartal m_ScheinQuartal = new Quartal();
    protected static String m_sQuartal = new String();
    protected static String m_sSU = new String();
    protected static int m_nSU = 0;
    protected static int m_nSU27_4218 = 0;
    protected static int m_nSU27_4219 = 0;
    protected static int m_nUe_4218 = 0;
    protected static int m_nUe_4219 = 0;
    protected static String m_sVKNR = new String();
    protected static String m_sVorname = new String();
    protected static String m_s0105 = new String();
    protected static String m_s0201 = new String();
    protected static String kvNrFrom0201 = "";
    protected static String m_s0203 = null;
    protected static String m_s3000 = new String();
    protected static String m_s3003 = new String();
    protected static String m_s3006 = new String();
    protected static String m_s4110 = new String();
    protected static String m_s4113 = null;
    protected static String f3010 = "";
    protected static Date date4115 = null;
    protected static Date m_date4133 = null;
    protected static String sGNr_ = null;
    protected static Map<String, String> ablaufdatumKonnektorZertifikat0227 = new HashMap<String, String>();
    protected static long m_n5012 = 0L;
    protected static long m_n5012Value = 0L;
    protected static long m_n5012Nachzuegler = 0L;
    protected static long m_n5012ValueNachzuegler = 0L;
    protected static long m_n5012SummiertMitMultiplikator = 0L;
    protected static long m_n5012NachzueglerSummiertMitMultiplikator = 0L;
    protected static Quartal m_AbrQuartal = new Quartal();
    protected static boolean m_bVorQuartal = false;
    protected static String m_s4242 = null;
    protected static final ArrayList<Meldung> m_aPDTMeldungen = new ArrayList();
    protected static boolean m_bWritePDT = false;
    protected static final HashSet<String> m_a5000er = new HashSet();
    protected static Date f5000oldestValue = null;
    protected static String m_s5099 = null;
    protected static int m_nFK4242Count = 0;
    protected static int m_nFK4242Bad = 0;
    protected static boolean bRVSA_ = false;
    protected static final MultiMap mapRVZ_ = new MultiMap();
    protected static final HashMap<String, String> mapAnalytID_ = new HashMap();
    protected static final SimpleDateFormat m_DateFormatNew = new SimpleDateFormat("yyyyMMdd", Locale.GERMAN);
    protected static String m_sTmp = null;
    protected static boolean leistungsDatumPruefung = true;
    protected static String m_sQuartalKonfig = null;
    protected static int vsdmPruefNwFK3010Counter = 0;
    protected static int vsdmPruefNwFK3010CounterProSatzart = 0;
    protected static String f9103 = "";
    protected static int m_nZaehler0201 = 0;
    protected static int m_nZaehler0213 = 0;
    protected static String f5005 = "";

    public AbstractScon0Handler(String sXPath) throws XPMException {
        super(sXPath);
    }

    public final void addFallAmbulant() throws Exception {
        try {
            this.addFallStatistik(m_mapFallAmbulant);
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (addFallAmbulant)");
        }
    }

    public final void addFallStationaer() throws Exception {
        try {
            this.addFallStatistik(m_mapFallStationaer);
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (addFallStationaer)");
        }
    }

    public final void addFallStatistik(TreeMap<String, FallInfo> faelle) throws Exception {
        try {
            String sKey = m_sBuffer.replace(m_sKTAB).append(m_sVKNR).toString();
            FallInfo fall = faelle.get(sKey);
            if (fall == null) {
                fall = new FallInfo();
                fall.m_sVKNR = m_sVKNR;
                fall.m_sKTAB = m_sKTAB;
                faelle.put(sKey, fall);
            }
            if (m_sMFR != null && m_sMFR.length() > 0) {
                switch (m_sMFR.charAt(0)) {
                    case '1': {
                        ++fall.m_nMStatus;
                        break;
                    }
                    case '3': {
                        ++fall.m_nFStatus;
                        break;
                    }
                    case '5': {
                        ++fall.m_nRStatus;
                    }
                }
            }
            if (m_bVorQuartal) {
                ++fall.m_nVorQuartal;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (addFallStatistik)");
        }
    }

    public final void setGNRMultiplikator() throws Exception {
        try {
            try {
                m_nGNrMultiplikator = Integer.parseInt(this.m_Element.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (m_nGNrMultiplikator < 1) {
                m_nGNrMultiplikator = 1;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (setGNRMultiplikator)");
        }
    }

    public final void addGNRStatistik(String sLANR, String sGNR) throws Exception {
        try {
            TreeMap<String, GNRInfo> map = m_mapLANR.get(sLANR);
            if (map == null) {
                map = new TreeMap();
                m_mapLANR.put(sLANR, map);
            }
            if ((m_gnrInfo = map.get(sGNR)) == null) {
                m_gnrInfo = new GNRInfo();
                AbstractScon0Handler.m_gnrInfo.m_sGNR = sGNR;
                AbstractScon0Handler.m_gnrInfo.m_sLANR = sLANR;
                map.put(sGNR, m_gnrInfo);
            }
            switch (m_nSatzart) {
                case 1: 
                case 9: 
                case 11: {
                    AbstractScon0Handler.m_gnrInfo.m_nSatz0101 += m_nGNrMultiplikator;
                    break;
                }
                case 2: 
                case 12: {
                    AbstractScon0Handler.m_gnrInfo.m_nSatz0102 += m_nGNrMultiplikator;
                    break;
                }
                case 3: 
                case 13: {
                    AbstractScon0Handler.m_gnrInfo.m_nSatz0103 += m_nGNrMultiplikator;
                    break;
                }
                case 4: {
                    AbstractScon0Handler.m_gnrInfo.m_nSatz0104 += m_nGNrMultiplikator;
                }
            }
            if (m_bVorQuartal) {
                AbstractScon0Handler.m_gnrInfo.m_nVorQuartal += m_nGNrMultiplikator;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (addGNRStatistik)");
        }
    }

    public final boolean addListenFall() throws Exception {
        try {
            String datetmp;
            AbstractScon0Handler.m_Schein.m_sSortKey = m_kvx4.getSortKey(m_sKTAB, m_sAbrA, m_sGO, m_sAbrG, m_sVKNR, m_sMFR, this.getSortName(m_sBuffer.replace(m_sName).append(' ').append(m_sVorname).toString()), m_sQuartal, m_bVorQuartal, m_sSU, m_nScheine);
            AbstractScon0Handler.m_Schein.m_sVKNR = m_sVKNR;
            AbstractScon0Handler.m_Schein.m_sKTAB = m_sKTAB;
            m_sBuffer.replace(m_sName);
            AbstractScon0Handler.m_Schein.m_sName = m_sBuffer.append(", ").append(m_sVorname).toString();
            AbstractScon0Handler.m_Schein.m_sNr = m_s3000 == null ? "unbekannt" : m_s3000;
            AbstractScon0Handler.m_Schein.m_sGeburt = m_sGeburt;
            if (m_sQuartal != null) {
                AbstractScon0Handler.m_Schein.m_sQuartal = m_sQuartal.length() == 0 ? m_sQuartal : m_ScheinQuartal.toString();
            }
            AbstractScon0Handler.m_Schein.m_sMFR = this.getStatus(m_sMFR);
            AbstractScon0Handler.m_Schein.m_nSatzart = m_nSatzart;
            AbstractScon0Handler.m_Schein.m_nSU = m_nSU;
            AbstractScon0Handler.m_Schein.m_sEinlesetag = m_sEinlesetag.isEmpty() ? m_sEinlesetag : (datetmp = Util.m_DateFormat.format(Util.m_DateFormatEN8.parse(m_sEinlesetag)));
            AbstractScon0Handler.m_Schein.m_sAbrG = m_sAbrG;
            boolean bl = AbstractScon0Handler.m_Schein.m_bUeSchein = m_nSatzart == 2;
            AbstractScon0Handler.m_Schein.m_bScheinAbgabe = m_nSatzart == 15 || m_nSatzart == 16 || m_nSatzart == 17 ? false : m_nSatzart != 9 && m_nSatzart != 11 && m_nSatzart != 12 && m_nSatzart != 13 && this.scheinAbgabe();
            AbstractScon0Handler.m_Schein.m_bDokuAbgabe = m_bDokuAbgabe;
            if (m_nSatzart > 0 && m_nSatzart < 5 && m_bKlammern) {
                Long klammerPos;
                String sKlammerId = m_kvx6.getKlammerId(this.getSortName(m_sName), this.getSortName(m_sVorname), m_sGeburt, m_sVKNR, m_sKTAB, m_sQuartal, m_sAbrG, m_sMFR, m_sSU);
                if (sKlammerId != null && (klammerPos = m_mapScheine.put(sKlammerId, m_mapSortierListe.getPosition())) != null) {
                    ScheinInfo klammerFall = (ScheinInfo)m_mapSortierListe.get(klammerPos);
                    if (klammerFall.m_nKlammerId == 0) {
                        klammerFall.m_nKlammerId = m_nKlammerSchein++;
                        m_mapSortierListe.replace(klammerFall.m_sSortKey, (Object)klammerFall);
                        m_mapKlammerScheine.put((Object)String.valueOf(klammerFall.m_nKlammerId), (Object)klammerFall);
                    }
                    m_mapScheine.put(sKlammerId, klammerPos);
                    AbstractScon0Handler.m_Schein.m_nKlammerId = klammerFall.m_nKlammerId;
                } else {
                    AbstractScon0Handler.m_Schein.m_nKlammerId = 0;
                }
            } else {
                AbstractScon0Handler.m_Schein.m_nKlammerId = 0;
            }
            if (AbstractScon0Handler.m_Schein.m_nKlammerId == 0 && !hdrg9Exists) {
                m_mapSortierListe.put(AbstractScon0Handler.m_Schein.m_sSortKey, (Object)m_Schein);
            } else {
                m_mapKlammerScheine.put((Object)String.valueOf(AbstractScon0Handler.m_Schein.m_nKlammerId), (Object)m_Schein.copy());
            }
            return AbstractScon0Handler.m_Schein.m_nKlammerId == 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (addListenFall)");
            return false;
        }
    }

    public void clearListen() throws Exception {
        try {
            m_mapFallAmbulant.clear();
            m_mapFallStationaer.clear();
            m_mapLANR.clear();
            m_mapSortierListe.clear();
            m_mapScheine.clear();
            m_mapKlammerScheine.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (clearListen)");
        }
    }

    public final String getAltersgruppe(float fVon, float fBis) throws Exception {
        try {
            m_sBuffer.delete();
            if (fVon < 1.0f) {
                m_sBuffer.append((int)(fVon * 100.0f));
            } else {
                m_sBuffer.append((int)fVon);
            }
            if (fVon < 1.0f && fBis >= 1.0f && fBis < 124.0f) {
                m_sBuffer.append(' ').append("Tage");
            }
            if (fBis == 124.0f) {
                if (fVon < 1.0f) {
                    m_sBuffer.append(' ').append("Tage");
                } else {
                    m_sBuffer.append(' ').append("Jahren");
                }
                if (fVon == 18.0f) {
                    m_sBuffer.append(" (Erwachsene [ab Achtzehnj\u00e4hrige])");
                }
                return "ab einem Alter von " + m_sBuffer.toString();
            }
            m_sBuffer.append(" und ");
            if (fBis < 1.0f) {
                m_sBuffer.append((int)(fBis * 100.0f)).append(' ').append("Tage");
                if (fVon == 0.0f && fBis == 0.0f) {
                    m_sBuffer.append(" (Neugeborene am Tage der Geburt)");
                }
            } else {
                m_sBuffer.append("unter ").append((int)fBis).append(' ').append("Jahren");
            }
            return "in der Altersgruppe zwischen " + m_sBuffer.toString();
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (getAltersgruppe)");
            return null;
        }
    }

    @Override
    public final Date getDate(String sDate) throws Exception {
        try {
            if (sDate != null && sDate.length() > 4) {
                try {
                    return m_DateFormatNew.parse(sDate);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (getDate)");
            return null;
        }
    }

    @Override
    public String formatDate(String sDate) throws Exception {
        try {
            if (sDate != null && sDate.length() == 8) {
                m_sBuffer.replace(sDate.substring(0, 4)).append('.').append(sDate.substring(4, 6)).append('.').append(sDate.substring(6));
                return m_sBuffer.toString();
            }
            return "????.??.??";
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (formatDate)");
            return null;
        }
    }

    public final String getSortName(String sName) throws Exception {
        try {
            m_sBuffer2.delete();
            int nLen = sName.length();
            block8: for (int i = 0; i < nLen; ++i) {
                char ch = Character.toLowerCase(sName.charAt(i));
                switch (ch) {
                    case '\u00e4': {
                        m_sBuffer2.append("ae");
                        continue block8;
                    }
                    case '\u00f6': {
                        m_sBuffer2.append("oe");
                        continue block8;
                    }
                    case '\u00fc': {
                        m_sBuffer2.append("ue");
                        continue block8;
                    }
                    case '\u00df': {
                        m_sBuffer2.append("ss");
                        continue block8;
                    }
                    default: {
                        m_sBuffer2.append(ch);
                    }
                }
            }
            return m_sBuffer2.toString();
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (getSortName)");
            return null;
        }
    }

    public void initSatz() throws Exception {
        try {
            progress_.step();
            m_bDokuAbgabe = false;
            m_bPrimaerICD = false;
            m_dateGeburt = null;
            m_sGeburt = null;
            m_dateLeistung = null;
            m_s3000 = null;
            m_s3003 = null;
            m_s3006 = "";
            m_s4110 = "";
            m_s4113 = "";
            m_s4242 = "";
            m_sAbrG = null;
            m_sGO = null;
            m_nGO = 0;
            m_sGeschlecht = null;
            m_sKTAB = null;
            m_sEinlesetag = "";
            m_sMFR = new String();
            m_eGK = null;
            m_sName = null;
            m_sVorname = null;
            m_sQuartal = null;
            m_ScheinQuartal.reset();
            m_sSU = null;
            m_nSU = 0;
            m_sVKNR = null;
            m_sAbrA = null;
            m_date4133 = null;
            vsdmPruefNwFK3010CounterProSatzart = 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (initSatz)");
        }
    }

    public final int intValue(char c) throws Exception {
        try {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return c - 48;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    return c - 55;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return c - 87;
                }
            }
            return 0;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (intValue)");
            return 0;
        }
    }

    public final void pruefe5000erKennung() throws Exception {
        try {
            String sFK;
            if (!m_a5000er.add(this.m_Element.getName())) {
                sFK = m_MeldungContainer.getDoku(this.m_Element.getName());
                if (sFK == null) {
                    sFK = this.m_Element.getName().substring(1);
                }
                m_MeldungPool.addMeldung("KVDT-FFK", sFK, this.m_Element.getValue());
            }
            if (!m_a5000er.contains(cF5001)) {
                sFK = m_MeldungContainer.getDoku(this.m_Element.getName());
                if (sFK == null) {
                    sFK = this.m_Element.getName().substring(1);
                }
                m_MeldungPool.addMeldung("KVDT-FK5001", sFK, this.m_Element.getValue());
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefe5000erKennung)");
        }
    }

    public final void pruefeGOFormat() throws Exception {
        try {
            switch (m_nGO) {
                case 0: 
                case 1: 
                case 2: {
                    if (this.pruefeGNR_EBM()) break;
                    m_MeldungPool.addMeldung("KVDT-R497", sGNr_);
                    break;
                }
                case 3: {
                    if (m_GNRPattern.matcher(sGNr_).matches()) break;
                    m_MeldungPool.addMeldung("KVDT-R496", sGNr_);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeGOFormat)");
        }
    }

    public final boolean pruefeGNR_EBM() throws Exception {
        try {
            int nLen = sGNr_.length();
            if (nLen == 5 || nLen == 6) {
                for (int i = 0; i < nLen; ++i) {
                    char ch = sGNr_.charAt(i);
                    if (!(i == 5 ? ch < 'A' || ch > 'Z' : ch < '0' || ch > '9')) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeGNR_EBM)");
            return false;
        }
    }

    public final void pruefeICD(boolean bPruefe489, String sAusnahme) throws Exception {
        try {
            if (this.pruefeICDFormat()) {
                if (m_ScheinQuartal.before(cQUARTAL_12025)) {
                    this.pruefeICD(bPruefe489, sAusnahme, ICDStamm2024);
                } else {
                    this.pruefeICD(bPruefe489, sAusnahme, ICDStamm2025);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeICD)");
        }
    }

    public final void pruefeICD(boolean bPruefe489, String sAusnahme, StammDaten icdStamm) throws Exception {
        try {
            if (!icdStamm.isValid()) {
                m_bPrimaerICD = true;
                return;
            }
            SatzICD icd = icdStamm.getICDSatz(sValue_);
            if (icd == null) {
                m_MeldungPool.addMeldung("KVDT-R728", sValue_);
            } else {
                if (!m_bPrimaerICD && icd.isPrimaerCode()) {
                    m_bPrimaerICD = true;
                }
                if (icd.getGeschlecht() != '\u0000') {
                    this.pruefeRegel817_491(icd.getGeschlecht(), icd.getGeschlechtFehlerArt(), sAusnahme);
                }
                if (bPruefe489 && icd.getUntereAltersGrenze() != null) {
                    this.pruefeRegel489(icd.getUntereAltersGrenze().floatValue(), icd.getObereAltersGrenze().floatValue(), icd.getAlterFehlerArt(), sAusnahme);
                }
                this.pruefeRegel490(icd.getSelten());
                this.pruefeRegel492(icd.getMitInhalt());
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeICD)");
        }
    }

    public final boolean pruefeICDFormat() throws Exception {
        try {
            if (sValue_ != null && sValue_.length() > 2 && sValue_.length() < 7) {
                if (this.m_Element.getName().endsWith("6001")) {
                    if (!this.pruefeRegel022(sValue_)) {
                        m_MeldungPool.addMeldung("KVDT-R022", sValue_, "6001");
                        return false;
                    }
                } else if (!this.pruefeRegel022(sValue_)) {
                    m_MeldungPool.addMeldung("KVDT-R022", sValue_, "Dauerdiagnose (FK 3673)");
                    return false;
                }
            }
            return true;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeICDFormat)");
            return false;
        }
    }

    public final boolean pruefeKVSpezifika() throws Exception {
        try {
            if (m_KVStamm == null) {
                m_MeldungPool.addMeldung("XPM-Abbruch", "Die KV-Stammdatei wurde nicht geladen. Bitte \u00fcberpr\u00fcfen Sie das Feld 0201 bzw. 0214 im Betriebsst\u00e4ttensatz (besa) auf eine korrekte Betriebsst\u00e4ttennummer (BSNR)!");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeKVSpezifika)");
            return false;
        }
    }

    public final void pruefePrimaerICD() throws Exception {
        try {
            if (!m_bPrimaerICD) {
                m_MeldungPool.addMeldung("KVDT-R729");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefePrimaerICD)");
        }
    }

    public final void pruefeQuartal() throws Exception {
        try {
            if (m_AbrQuartal.isValid() && m_ScheinQuartal.after(m_AbrQuartal)) {
                m_MeldungPool.addMeldung("KVDT-RQL1");
            }
            m_bVorQuartal = m_AbrQuartal.after(m_ScheinQuartal);
            if (m_AbrQuartal.isValid() && m_ScheinQuartal.isValid() && m_ScheinQuartal.diff(m_AbrQuartal) < -8) {
                m_MeldungPool.addMeldung("KVDT-RQL3", m_ScheinQuartal.toString(), m_AbrQuartal.toString());
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeQuartal)");
        }
    }

    public final void pruefeRegel017() throws Exception {
        try {
            int nLaenge = m_sVKNR.length();
            if (nLaenge != 5) {
                return;
            }
            int nNr = Integer.parseInt(m_sVKNR.substring(0, 2));
            for (int i = 0; i < m_aKV.length; ++i) {
                if (nNr != m_aKV[i]) continue;
                return;
            }
            m_MeldungPool.addMeldung("KVDT-R017", m_sVKNR);
        }
        catch (Exception ex) {
            this.catchException(ex, "AbstractScon0Handler", "Pr\u00fcfung (pruefeRegel017)");
        }
    }

    public final void pruefeRegel212() throws Exception {
        try {
            if ("74799".equals(m_sVKNR)) {
                m_MeldungPool.addMeldung("KVDT-R212");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "AbstractScon0Handler", "Pr\u00fcfung (pruefeRegel212)");
        }
    }

    public final boolean pruefeRegel022(String icd) throws Exception {
        try {
            int nLen = icd.length();
            if (nLen > 2 && nLen < 7) {
                block8: for (int i = 0; i < nLen; ++i) {
                    char ch = icd.charAt(i);
                    switch (i) {
                        case 0: {
                            if (ch >= 'A' && ch <= 'Z') continue block8;
                            return false;
                        }
                        case 5: {
                            if (ch == '-') continue block8;
                        }
                        case 1: 
                        case 2: 
                        case 4: {
                            if (ch >= '0' && ch <= '9') continue block8;
                            return false;
                        }
                        case 3: {
                            if (ch == '.') continue block8;
                            return false;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel022)");
            return false;
        }
    }

    public final void pruefeRegel049(String bsnr) throws Exception {
        try {
            if (bsnr.isEmpty()) {
                return;
            }
            this.pruefeRegel162(bsnr);
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel049)");
        }
    }

    public final boolean pruefeRegel050(String sNr, String sMeldung, String sFeld) throws Exception {
        try {
            if (sNr.length() < 7) {
                return false;
            }
            String lanr = sNr.substring(sNr.length() - 2);
            if (lanr.equals("91")) {
                m_MeldungPool.addMeldung(sMeldung, sNr, sFeld);
                return false;
            }
            if (sNr.equals("888888800")) {
                m_MeldungPool.addMeldung("KVDT-R762");
                return false;
            }
            if (sNr.matches("555555\\d{3}")) {
                m_MeldungPool.addMeldung(sMeldung, sNr, sFeld);
                return false;
            }
            long summe = 0L;
            for (int i = 0; i < 6; ++i) {
                if (i % 2 == 0) {
                    summe += (long)(4 * this.intValue(sNr.charAt(i)));
                    continue;
                }
                summe += (long)(9 * this.intValue(sNr.charAt(i)));
            }
            if ((summe %= 10L) != 0L) {
                summe = 10L - summe;
            }
            if ((long)this.intValue(sNr.charAt(6)) != summe) {
                m_MeldungPool.addMeldung(sMeldung, sNr, sFeld);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel050)");
            return false;
        }
    }

    public final boolean pruefeRegel063_064(String sNr, String sMeldung, String sFeld) throws Exception {
        try {
            if (!sNr.matches("\\d{9}") || sNr.equals("91")) {
                m_MeldungPool.addMeldung(sMeldung, sNr, sFeld);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel063_064)");
            return false;
        }
    }

    public final void pruefeRegel858_862_863(String m_sWerte0225, String m_sBSNR, String m_sIK) throws Exception {
        try {
            if (m_sWerte0225 != null) {
                String[] werte225 = m_sWerte0225.split(":");
                List<String> list225 = Arrays.asList(werte225);
                int count12 = Collections.frequency(list225, "12");
                int count11 = Collections.frequency(list225, "11");
                int count10 = Collections.frequency(list225, "10");
                int count0 = Collections.frequency(list225, "0");
                int count1 = Collections.frequency(list225, "1");
                int count2 = Collections.frequency(list225, "2");
                int count3 = Collections.frequency(list225, "3");
                int count4 = Collections.frequency(list225, "4");
                int count5 = Collections.frequency(list225, "5");
                int count6 = Collections.frequency(list225, "6");
                int count7 = Collections.frequency(list225, "7");
                int count8 = Collections.frequency(list225, "8");
                int count9 = Collections.frequency(list225, "9");
                String m_sBSNR_IK = m_sBSNR;
                if (m_sBSNR.equals("")) {
                    m_sBSNR_IK = m_sIK;
                }
                if (count1 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "1 (eRezept)");
                }
                if (count3 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "3 (NFDM)");
                }
                if (count4 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "4 (eMP)");
                }
                if (count5 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "5 (KIM)");
                }
                if (count6 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "6 (eAu)");
                }
                if (count7 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "7 (eArztbrief)");
                }
                if (count8 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "8 (Kartenterminal)");
                }
                if (count9 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "9 (SMC-B)");
                }
                if (count10 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "10 (eHBA)");
                }
                if (count11 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "11 (ePA Stufe 3)");
                }
                if (count12 != 1) {
                    m_MeldungPool.addMeldung("KVDT-R858", m_sBSNR_IK, "12 (eVDGA)");
                }
                if (count0 > 1 || count1 > 1 || count2 > 1 || count3 > 1 || count4 > 1 || count5 > 1 || count6 > 1 || count7 > 1 || count8 > 1 || count9 > 1 || count10 > 1 || count11 > 1) {
                    Object text = "";
                    if (count0 > 1) {
                        text = "0,";
                    }
                    if (count1 > 1) {
                        text = ((String)text).concat("1,");
                    }
                    if (count2 > 1) {
                        text = ((String)text).concat("2,");
                    }
                    if (count3 > 1) {
                        text = ((String)text).concat("3,");
                    }
                    if (count4 > 1) {
                        text = ((String)text).concat("4,");
                    }
                    if (count5 > 1) {
                        text = ((String)text).concat("5,");
                    }
                    if (count6 > 1) {
                        text = ((String)text).concat("6,");
                    }
                    if (count7 > 1) {
                        text = ((String)text).concat("7,");
                    }
                    if (count8 > 1) {
                        text = ((String)text).concat("8,");
                    }
                    if (count9 > 1) {
                        text = ((String)text).concat("9,");
                    }
                    if (count10 > 1) {
                        text = ((String)text).concat("10,");
                    }
                    if (count11 > 1) {
                        text = ((String)text).concat("11,");
                    }
                    if (count12 > 1) {
                        text = ((String)text).concat("12,");
                    }
                    text = ((String)(text = ((String)text).substring(0, ((String)text).length() - 1))).length() > 2 ? "Folgende Werte existieren mehrfach: " + (String)text : "Folgender Wert existiert mehrfach: " + (String)text;
                    m_MeldungPool.addMeldung("KVDT-R862", m_sBSNR_IK, (String)text);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel858_862_863)");
        }
    }

    public final void pruefeRegel059(String asvTeamValue, String sFeld) throws Exception {
        try {
            char[] asvTeamNrCharArray = asvTeamValue.toCharArray();
            if (asvTeamNrCharArray[0] != '0' || asvTeamNrCharArray[1] != '0') {
                m_MeldungPool.addMeldung("KVDT-R059", asvTeamValue, sFeld);
                return;
            }
            int summe = 0;
            for (int i = 0; i < asvTeamNrCharArray.length - 1; ++i) {
                int asvTeamNrZiffer = Character.getNumericValue(asvTeamNrCharArray[i]);
                int ergebnisZiffer = 0;
                ergebnisZiffer = i % 2 == 0 ? 4 * asvTeamNrZiffer : 9 * asvTeamNrZiffer;
                summe += ergebnisZiffer;
            }
            int pruefziffer = asvTeamNrCharArray[asvTeamNrCharArray.length - 1] - 48;
            int ermitteltePruefziffer = 10 - summe % 10;
            if (ermitteltePruefziffer == 10) {
                ermitteltePruefziffer = 0;
            }
            if (ermitteltePruefziffer != pruefziffer) {
                m_MeldungPool.addMeldung("KVDT-R059", asvTeamValue, sFeld);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel059)");
        }
    }

    public final void pruefeRegel061(String sNr, String sFeld) throws Exception {
        try {
            if (sNr.isEmpty()) {
                return;
            }
            this.pruefeRegel162(sNr);
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel061)");
        }
    }

    public final void pruefeRegel062(String sNr, String sFeld) throws Exception {
        try {
            if (sNr.isEmpty()) {
                return;
            }
            if (sNr.length() >= 7 && !sNr.substring(5, 7).equals("63")) {
                m_MeldungPool.addMeldung("KVDT-R062", sFeld);
            }
            this.pruefeRegel162(sNr);
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel062)");
        }
    }

    public final void pruefeRegel162(String sNr) throws Exception {
        block5: {
            try {
                int nNr;
                if (sNr.length() <= 2) break block5;
                try {
                    nNr = Integer.parseInt(sNr.substring(0, 2));
                }
                catch (NumberFormatException ignore) {
                    return;
                }
                for (int i = 0; i < m_aUKV_OKV.length; ++i) {
                    if (nNr != m_aUKV_OKV[i]) continue;
                    return;
                }
                m_MeldungPool.addMeldung("KVDT-R162", sNr);
            }
            catch (Exception ex) {
                this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel162)");
            }
        }
    }

    public final void pruefeRegel201_202() throws Exception {
        try {
            if (!KTStamm.isValid()) {
                return;
            }
            if (m_KT == null) {
                if (m_sVKNR.length() > 0) {
                    m_MeldungPool.addMeldung("KVDT-R201", m_sVKNR + "/" + m_sKTAB);
                }
            } else {
                if (m_sKTAB.length() > 0) {
                    if (m_KT.getKTABName(m_sKTAB) == null) {
                        m_MeldungPool.addMeldung("KVDT-R201", m_sVKNR + "/" + m_sKTAB);
                    }
                    if (!KTStamm.existIK(this.m_Element.getChildValue("f4111"))) {
                        m_MeldungPool.addMeldung("KVDT-R202", this.m_Element.getChildValue("f4111"));
                    }
                }
                if (!(m_bVorQuartal || m_sAbrG.equals("80") || m_sGO == null || m_sGO.equals(m_KT.getGO()))) {
                    m_MeldungPool.addMeldung("KVDT-R210");
                }
                if (m_KT.isUnzKVGBereich(m_sKVBereich)) {
                    m_MeldungPool.addMeldung("KVDT-R763", m_sKVBereich, m_sVKNR);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel201_202)");
        }
    }

    public final void pruefeRegel304(Date datum, String sFeld) throws Exception {
        try {
            if ((m_DatenPool.getString("deactivateR304") == null || !m_DatenPool.getString("deactivateR304").equalsIgnoreCase("ja")) && datum != null && datum.after(m_dateJetzt)) {
                m_MeldungPool.addMeldung("KVDT-R304", sFeld, m_DateFormat10.format(m_dateJetzt));
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel304)");
        }
    }

    public final void pruefeRegel791() throws Exception {
        try {
            if (!m_sEinlesetag.isEmpty() && (m_s3006.isEmpty() || this.m_Element.getChild("f3119") == null || this.m_Element.getChild("f4133") == null || this.m_Element.getChild("f4134") == null)) {
                m_MeldungPool.addMeldung("KVDT-R791");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel791)");
        }
    }

    public void pruefeRegel307() throws Exception {
        try {
            if (!m_sEinlesetag.isEmpty() && m_eGK != null && this.m_Element.getChild("f3006") == null) {
                switch (m_nSU) {
                    case 21: 
                    case 27: 
                    case 28: {
                        break;
                    }
                    default: {
                        m_MeldungPool.addMeldung("KVDT-R307", ", und sind es keine Auftragsleistungen bzw. Laboratoriumsuntersuchungen als Auftragsleistung bzw. Anforderungsschein f\u00fcr Laboratoriumsuntersuchungen bei Laborgemeinschaften (Scheinuntergruppe Feld 4239 ungleich 21, 27 oder 28)");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel307)");
        }
    }

    public final void pruefeRegel313(Date leistung, Date geburt, String sBezeichnung) throws Exception {
        try {
            if (leistung != null && geburt != null && geburt.compareTo(leistung) > 0) {
                m_MeldungPool.addMeldung("KVDT-R313", sBezeichnung, m_DateFormat10.format(leistung));
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel313)");
        }
    }

    public final void pruefeRegel315() throws Exception {
        try {
            Date gueltigkeit;
            Date leistung = this.getDate(sValue_);
            try {
                gueltigkeit = this.getDate(m_s4110);
            }
            catch (Exception ignore) {
                gueltigkeit = null;
            }
            if (leistung != null && gueltigkeit != null && leistung.compareTo(gueltigkeit) > 0) {
                m_MeldungPool.addMeldung("KVDT-R315");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel315)");
        }
    }

    public final void pruefeRegel357() throws Exception {
    }

    public final void pruefeRegel478_479() throws Exception {
        try {
            String sPLZ = this.m_Element.getChildValue("f3112").trim();
            if (sPLZ.length() > 0 && m_sKTAB.equals("00") && m_sEinlesetag.isEmpty() && PLZStamm.isValid() && PLZStamm.getSatz2150(sPLZ) == null) {
                m_MeldungPool.addMeldung("KVDT-R478", sPLZ);
            }
            String sWOP = this.m_Element.getChildValue("f3114").trim();
            String pwl = this.m_Element.getChildValue("f3124").trim();
            String sPostfachPLZ = this.m_Element.getChildValue("f3121").trim();
            if (((pwl.isEmpty() || pwl.equals("D")) && (sWOP.isEmpty() || sWOP.equals("D")) || m_sEinlesetag.isEmpty()) && sPLZ.isEmpty() && sPostfachPLZ.isEmpty()) {
                m_MeldungPool.addMeldung("KVDT-R479", sPLZ);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel478_479)");
        }
    }

    public final void pruefeRegel817_491(char geschlecht, char fehlerArt, String sAusnahme) throws Exception {
        try {
            if (m_sGeschlecht != null) {
                if (fehlerArt == 'k' && !m_bICDZusatzPruefung) {
                    return;
                }
                if (geschlecht == 'M' || geschlecht == 'm') {
                    if (m_sGeschlecht.equals("W")) {
                        if (fehlerArt == 'm' && sAusnahme != null && sAusnahme.isEmpty()) {
                            m_MeldungPool.addMeldung("KVDT-R491", sValue_, "m\u00e4nnliche");
                        } else if (fehlerArt == 'k' && (sAusnahme == null || sAusnahme.isEmpty())) {
                            m_MeldungPool.addMeldung("KVDT-R817", sValue_, "m\u00e4nnliche");
                        }
                    }
                } else if (m_sGeschlecht.equals("M")) {
                    if (fehlerArt == 'm' && sAusnahme != null && sAusnahme.isEmpty()) {
                        m_MeldungPool.addMeldung("KVDT-R491", sValue_, "weibliche");
                    } else if (fehlerArt == 'k' && (sAusnahme == null || sAusnahme.isEmpty())) {
                        m_MeldungPool.addMeldung("KVDT-R817", sValue_, "weibliche");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel817_491)");
        }
    }

    public final void pruefeRegel489(float fUntereGrenze, float fObereGrenze, char fehlerArt, String sAusnahme) throws Exception {
        try {
            if (fehlerArt == 'k' && !m_bICDZusatzPruefung || m_dateGeburt == null) {
                return;
            }
            if (fObereGrenze >= 1.0f && fObereGrenze < 124.0f) {
                fObereGrenze += 1.0f;
            }
            m_Calendar.setTime(m_dateGeburt);
            if (fUntereGrenze < 1.0f) {
                m_Calendar.add(6, (int)(fUntereGrenze * 100.0f));
            } else {
                m_Calendar.add(1, (int)fUntereGrenze);
            }
            Date dateGrenze = m_Calendar.getTime();
            if (m_sQuartal != null && dateGrenze.after(this.getQuartalEnde(m_sQuartal))) {
                if (fehlerArt == 'm' && sAusnahme != null && sAusnahme.isEmpty()) {
                    m_MeldungPool.addMeldung("KVDT-R489", sValue_, this.getAltersgruppe(fUntereGrenze, fObereGrenze));
                } else if (fehlerArt == 'k') {
                    m_MeldungPool.addMeldung("KVDT-R761", sValue_, this.getAltersgruppe(fUntereGrenze, fObereGrenze));
                }
            }
            if (this.m_Element.getChildValue("f6003").equals("Z")) {
                return;
            }
            m_Calendar.setTime(m_dateGeburt);
            if (fObereGrenze < 1.0f) {
                m_Calendar.add(6, (int)(fObereGrenze * 100.0f));
            } else {
                m_Calendar.add(1, (int)fObereGrenze);
            }
            dateGrenze = m_Calendar.getTime();
            if (m_sQuartal != null && dateGrenze.before(this.getQuartalBeginn(m_sQuartal))) {
                if (fehlerArt == 'm' && sAusnahme != null && sAusnahme.isEmpty()) {
                    m_MeldungPool.addMeldung("KVDT-R489", sValue_, this.getAltersgruppe(fUntereGrenze, fObereGrenze));
                } else if (fehlerArt == 'k') {
                    m_MeldungPool.addMeldung("KVDT-R761", sValue_, this.getAltersgruppe(fUntereGrenze, fObereGrenze));
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel489)");
        }
    }

    public final void pruefeRegel490(String sSelten) throws Exception {
        try {
            if (sSelten == null || !m_bICDZusatzPruefung) {
                return;
            }
            if (sSelten.toUpperCase().equals("J")) {
                m_MeldungPool.addMeldung("KVDT-R490", sValue_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel490)");
        }
    }

    public final void pruefeRegel492(char inhalt) throws Exception {
        try {
            if (inhalt == 'N' || inhalt == 'n') {
                m_MeldungPool.addMeldung("KVDT-R492", sValue_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel492)");
        }
    }

    public void pruefeRegel174_534_530() throws XPMException {
        try {
            String strgF4131 = this.m_Element.getChildValue("f4131");
            String strgF4132 = this.m_Element.getChildValue("f4132");
            if (!strgF4132.matches("00|01|02|03|04|05|06|07|08|09|10|11|12|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58")) {
                m_MeldungPool.addMeldung("KVDT-R536", strgF4132);
            }
            if (m_nSatzart == 9) {
                if (!strgF4131.matches("00|04|")) {
                    m_MeldungPool.addMeldung("KVDT-R530", strgF4131);
                }
            } else if (!strgF4131.matches("00|04|06|07|08|09|")) {
                m_MeldungPool.addMeldung("KVDT-R534", strgF4131);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel174_534_530)");
        }
    }

    public final void pruefeRegel864() throws XPMException {
        try {
            String sf3010 = this.m_Element.findChildValue("s010" + m_nSatzart + "f3010/f3010");
            try {
                if (!sf3010.isEmpty()) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                    if (sf3010.length() > 8) {
                        sf3010 = sf3010.substring(0, 8);
                    }
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    Date f3010 = dateFormat.parse(sf3010);
                    if (m_ScheinQuartal.compareTo(f3010) != 0) {
                        m_MeldungPool.addMeldung("KVDT-R864");
                    }
                }
            }
            catch (ParseException e) {
                logger_.debug(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel864)");
        }
    }

    public final void pruefeRegel710() throws Exception {
        try {
            try {
                if (Long.parseLong(sValue_) > 999999L) {
                    m_MeldungPool.addMeldung("KVDT-R710", sValue_);
                }
            }
            catch (NumberFormatException ex) {
                m_MeldungPool.addMeldung("KVDT-R710", sValue_);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel710)");
        }
    }

    public final void pruefeRegel743() throws Exception {
        try {
            if (m_Datenpakete[1] != -2 && !bRVSA_ && m_s0201 != null && !m_s0201.isEmpty()) {
                m_MeldungPool.addMeldung("KVDT-R743");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel743)");
        }
    }

    public final void pruefeRegel774() throws Exception {
        try {
            int value;
            sValue_ = this.m_Element.getChildValue("f3006");
            if (sValue_.length() > 0 && (value = this.getInt(sValue_.replace(".", ""))) >= 520 && this.m_Element.getChild("f3116") == null) {
                m_MeldungPool.addMeldung("KVDT-R774");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel774)");
        }
    }

    public final void pruefeRegel775() throws Exception {
        try {
            if (this.m_Element.getChild("f3006") != null && this.m_Element.getChild("f4109") != null && this.m_Element.getChild("f4133") == null) {
                m_MeldungPool.addMeldung("KVDT-R775");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel775)");
        }
    }

    public final void pruefeRegel776() throws Exception {
        try {
            boolean f4101Da = true;
            int int4104Stelle3Bis5 = 0;
            try {
                int4104Stelle3Bis5 = this.getInt(this.m_Element.getChildValue("f4104").substring(2));
            }
            catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException e) {
                logger_.debug((Object)e);
                f4101Da = false;
            }
            if (f4101Da && !m_sEinlesetag.isEmpty()) {
                Boolean f3119exists = this.m_Element.getChild("f3119") != null;
                Boolean f3105exists = this.m_Element.getChild("f3105") != null;
                if (int4104Stelle3Bis5 < 800 && !f3119exists.booleanValue()) {
                    m_MeldungPool.addMeldung("KVDT-R776a");
                }
                if (int4104Stelle3Bis5 >= 800 && (!f3105exists.booleanValue() && !f3119exists.booleanValue() || f3105exists.booleanValue() && f3119exists.booleanValue())) {
                    m_MeldungPool.addMeldung("KVDT-R776b");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel776)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void pruefeRegel777() throws Exception {
        try {
            if (m_sEinlesetag.isEmpty()) return;
            switch (m_nSU) {
                case 21: 
                case 27: 
                case 28: {
                    return;
                }
                default: {
                    if (this.m_Element.getChild("f4134") != null) return;
                    m_MeldungPool.addMeldung("KVDT-R777");
                }
            }
            return;
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel777)");
        }
    }

    public final void pruefeRegel778(int value4131) throws Exception {
        try {
            switch (value4131) {
                case 7: 
                case 8: {
                    if (m_sKTAB.matches("01|09")) break;
                    m_MeldungPool.addMeldung("KVDT-R778");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel778)");
        }
    }

    public final void pruefeRegel779(int value4131) throws Exception {
        try {
            if (value4131 == 6 && !m_sKTAB.matches("02|09")) {
                m_MeldungPool.addMeldung("KVDT-R779");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel779)");
        }
    }

    public final void pruefeRegel780(int value4131) throws Exception {
        try {
            if (value4131 == 4 && !m_sKTAB.matches("00|09")) {
                m_MeldungPool.addMeldung("KVDT-R780");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel780)");
        }
    }

    public final void pruefeRegel827() throws Exception {
        try {
            if (!m_sEinlesetag.isEmpty() && "00".equals(this.m_Element.getChildValue("f4131")) && !m_sKTAB.matches("00|09")) {
                m_MeldungPool.addMeldung("KVDT-R827");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel827)");
        }
    }

    public final void pruefeRegel782() throws Exception {
        try {
            Date leistung = this.getDate(sValue_);
            if (m_ScheinQuartal.after(cQUARTAL_32014) && m_date4133 != null && leistung != null && leistung.compareTo(m_date4133) < 0) {
                m_MeldungPool.addMeldung("KVDT-R782");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel782)");
        }
    }

    public final void pruefeRegel783() throws Exception {
        try {
            String postfachPLZ = this.m_Element.getChildValue("f3121").trim();
            if (m_sKTAB.equals("00") && m_sEinlesetag.isEmpty() && !postfachPLZ.isEmpty() && PLZStamm.isValid() && PLZStamm.getSatz2150(postfachPLZ) == null) {
                m_MeldungPool.addMeldung("KVDT-R783");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel783)");
        }
    }

    public final void pruefeRegel784() throws Exception {
        try {
            if (this.m_Element.getChild("f3006") != null && this.m_Element.getChild("f4109") != null && this.m_Element.getChild("f3114") == null && this.m_Element.getChild("f3124") == null) {
                m_MeldungPool.addMeldung("KVDT-R784");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel784)");
        }
    }

    public final void pruefeDMPKennzeichenUndBesonderePersonengruppe(String dmpKennz, String besPersoGruppe) throws Exception {
        try {
            if (m_ScheinQuartal.before(cQUARTAL_32017)) {
                if (dmpKennz != null && !dmpKennz.isEmpty() && !dmpKennz.matches("1|2|3|4|5|6")) {
                    m_MeldungPool.addMeldung("KVDT-DK01");
                }
                if (besPersoGruppe != null && !besPersoGruppe.isEmpty() && !besPersoGruppe.matches("4|6|7|8|9")) {
                    m_MeldungPool.addMeldung("KVDT-BP01");
                }
            } else if (m_ScheinQuartal.after(cQUARTAL_22017) && m_ScheinQuartal.before(cQUARTAL_12018)) {
                if (dmpKennz == null || dmpKennz.isEmpty() || dmpKennz.matches("1|2|3|4|5|6")) {
                    m_MeldungPool.addMeldung("KVDT-DK02");
                }
                if (besPersoGruppe == null || besPersoGruppe.isEmpty() || besPersoGruppe.matches("4|6|7|8|9")) {
                    m_MeldungPool.addMeldung("KVDT-BP02");
                }
            } else if (m_ScheinQuartal.after(cQUARTAL_42017)) {
                if (dmpKennz == null || dmpKennz.isEmpty() || !dmpKennz.matches("00|01|02|03|04|05|06")) {
                    m_MeldungPool.addMeldung("KVDT-DK03");
                }
                if (besPersoGruppe == null || besPersoGruppe.isEmpty() || !besPersoGruppe.matches("00|04|06|07|08|09")) {
                    m_MeldungPool.addMeldung("KVDT-BP03");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeDMPKennzeichenUndBesonderePersonengruppe)");
        }
    }

    public final void pruefeRegel790() throws Exception {
        try {
            int vknrInt;
            if (!m_sEinlesetag.isEmpty() && m_s3006.isEmpty() && m_sVKNR != null && !m_sVKNR.isEmpty() && (vknrInt = this.getInt(m_sVKNR.substring(2, 5))) < 800) {
                m_MeldungPool.addMeldung("KVDT-R790");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel790)");
        }
    }

    public final void pruefeRegel818(int value4131) throws Exception {
        try {
            if (value4131 == 9 && !m_sKTAB.matches("09|00")) {
                m_MeldungPool.addMeldung("KVDT-R818");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel818)");
        }
    }

    public final boolean scheinAbgabe() throws Exception {
        try {
            Satzkvx5.Feld4106 feld4106;
            Satzkvx5.Feld4239 feld4239;
            int i;
            if (!ScheinAbgabeListe.getValid()) {
                return false;
            }
            int nSuchNr = 0;
            try {
                nSuchNr = Integer.parseInt(m_s0201);
            }
            catch (NumberFormatException ex) {
                return false;
            }
            Feld9460[] array9460 = m_kvx5.getFeld9460();
            for (i = 0; i < array9460.length; ++i) {
                Feld9460 feld9460 = array9460[i];
                if (feld9460.getFeld9460() > nSuchNr || nSuchNr > feld9460.getFeld9461() || (feld4239 = feld9460.getFeld4239(m_sSU)) == null || feld4239.getFeld9462() != 1 && (feld4239.getFeld9462() != 2 || !m_sEinlesetag.isEmpty())) continue;
                return true;
            }
            if (m_sVKNR.length() > 2) {
                Satzkvx5.Feld9470[] array9470 = m_kvx5.getFeld9470();
                nSuchNr = Integer.parseInt(m_sVKNR.substring(2));
                for (i = 0; i < array9470.length; ++i) {
                    Satzkvx5.Feld9470 feld9470 = array9470[i];
                    if (feld9470.getFeld9470() > nSuchNr || nSuchNr > feld9470.getFeld9471() || (feld4239 = feld9470.getFeld4239(m_sSU)) == null || feld4239.getFeld9462() != 1 && (feld4239.getFeld9462() != 2 || !m_sEinlesetag.isEmpty())) continue;
                    return true;
                }
            }
            if ((feld4106 = m_kvx5.getFeld4106(m_sKTAB)) != null && (feld4239 = feld4106.getFeld4239(m_sSU)) != null && (feld4239.getFeld9462() == 1 || feld4239.getFeld9462() == 2 && m_sEinlesetag.isEmpty())) {
                return true;
            }
            Satzkvx5.Feld4122 feld4122 = m_kvx5.getFeld4122(m_sAbrG);
            return feld4122 != null && (feld4239 = feld4122.getFeld4239(m_sSU)) != null && (feld4239.getFeld9462() == 1 || feld4239.getFeld9462() == 2 && m_sEinlesetag.length() == 0);
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (scheinAbgabe)");
            return false;
        }
    }

    public final void pruefeRegel849bis852() throws Exception {
        try {
            if (this.m_Element.getChild("f4255") != null && this.m_Element.getChild("f4252") == null) {
                m_MeldungPool.addMeldung("KVDT-R852");
            }
            if (this.m_Element.getChild("s010" + String.valueOf(m_nSatzart) + "f4253") != null ^ this.m_Element.getChild("f4252") != null) {
                m_MeldungPool.addMeldung("KVDT-R850");
            }
            if (this.m_Element.getChild("f4255") != null ^ this.m_Element.getChild("s010" + String.valueOf(m_nSatzart) + "f4256") != null) {
                m_MeldungPool.addMeldung("KVDT-R851");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel849bis852)");
        }
    }

    public final void pruefeRegel895() throws Exception {
        try {
            String f4112 = this.m_Element.findChildValue("f4112");
            if (!StringUtils.isEmpty((CharSequence)f4112)) {
                String f4109 = this.m_Element.findChildValue("f4109");
                String f4108 = this.m_Element.findChildValue("f4108");
                String f3006 = this.m_Element.findChildValue("f3006");
                if (!(StringUtils.isEmpty((CharSequence)f3010) && StringUtils.isEmpty((CharSequence)f4109) && StringUtils.isEmpty((CharSequence)f4108) && StringUtils.isEmpty((CharSequence)f3006))) {
                    if (hdrg0Exists) {
                        m_MeldungPool.addMeldung("KVDT-R895", "");
                    } else {
                        m_MeldungPool.addMeldung("KVDT-R895", "und FK 4108 ");
                    }
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (pruefeRegel895)");
        }
    }

    public final void setReportParameter(AusgabeReport report) throws Exception {
        try {
            report.addParameter("DATEI", (Object)m_DatenPool.getString("XPM_FILE"));
            report.addParameter("DATUM", (Object)m_DatenPool.getString("XPM_DATE"));
            report.addParameter("ZEIT", (Object)m_DatenPool.getString("XPM_TIME"));
            report.addParameter("DATEI_DATUM", (Object)m_DatenPool.getString("XPM_FILE_DATE"));
            report.addParameter("BSNR", (Object)m_s0201);
            report.addParameter("BSNR_BEZ", (Object)m_s0203);
            report.addParameter("VERSION", (Object)cVERSION);
            if (m_AbrQuartal.isValid()) {
                report.addParameter("QUARTAL", (Object)m_AbrQuartal.toString());
            }
            report.addParameter("PRUEF_NR", (Object)m_s0105);
            ConfigFile config = (ConfigFile)m_DatenPool.getObject("XPM_CONFIG_FILE");
            if (config.getSchalter("xmlfehlerliste") != null && config.getSchalter("xmlfehlerliste").equals("ja")) {
                report.setOutputAdditionalXmlFehlerliste(true);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (setReportParameter)");
        }
    }

    public final void setReportParameter(AusgabeReport report, String sTitel) throws Exception {
        try {
            this.setReportParameter(report);
            report.addParameter("TITEL", (Object)sTitel);
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (setReportParameter)");
        }
    }

    public void setValuesHdrg() throws Exception {
        try {
            m_s3006 = this.m_Element.getChildValue("f3006");
            m_sName = ISO8859_15Encoder.toUnicode((String)this.m_Element.getChildValue("f3101"));
            m_sVorname = ISO8859_15Encoder.toUnicode((String)this.m_Element.getChildValue("f3102"));
            m_eGK = this.m_Element.getChild("f3119");
            m_sKTAB = this.m_Element.getChildValue("f4106");
            m_sVKNR = this.m_Element.getChildValue("f4104");
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (setValues)");
        }
    }

    public void setValues() throws Exception {
        try {
            m_s3006 = this.m_Element.getChildValue("f3006");
            m_sName = ISO8859_15Encoder.toUnicode((String)this.m_Element.getChildValue("f3101"));
            m_sVorname = ISO8859_15Encoder.toUnicode((String)this.m_Element.getChildValue("f3102"));
            m_sMFR = this.m_Element.getChildValue("f3108");
            m_eGK = this.m_Element.getChild("f3119");
            m_sKTAB = this.m_Element.getChildValue("f4106");
            m_s4113 = this.m_Element.getChildValue("f4113");
            m_sAbrG = this.m_Element.getChildValue("f4122");
            m_sVKNR = this.m_Element.getChildValue("f4104");
            this.pruefeRegel017();
            this.pruefeRegel212();
            m_KT = KTStamm.getKTSSatz(m_sVKNR);
            if (m_KT != null) {
                while (m_KT.getAufnehmenderKT() != null) {
                    m_KT = m_KT.getAufnehmenderKT();
                }
                if (m_ScheinQuartal.isValid()) {
                    Quartal quartal = m_KT.getGueltigkeitsBeginn();
                    if (quartal != null && quartal.isValid() && m_ScheinQuartal.before(quartal)) {
                        m_MeldungPool.addMeldung("KVDT-RQL2", m_sVKNR + "/" + m_sKTAB, m_ScheinQuartal.toString());
                    }
                    if ((quartal = m_KT.getGueltigkeitsEnde()) != null && quartal.isValid() && m_ScheinQuartal.after(quartal)) {
                        m_MeldungPool.addMeldung("KVDT-RQL2", m_sVKNR + "/" + m_sKTAB, m_ScheinQuartal.toString());
                    }
                }
            }
            m_sAbrA = m_kvx7.getAbrechnungsart(m_sVKNR, m_sKTAB);
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (setValues)");
        }
    }

    public final void writePDTHeader() throws Exception {
        try {
            PDTListe.write(this.getXDTLine("8000", "pro0"));
            PDTListe.write(this.getXDTLine("0201", m_DatenPool.getString("BSNR")));
            PDTListe.write(this.getXDTLine("0203", m_DatenPool.getString("BSNR_BEZ")));
            m_sBuffer.replace(m_DatenPool.getString("XPM_FILE_DATE"));
            m_sBuffer.deleteCharAt(2).deleteCharAt(4);
            PDTListe.write(this.getXDTLine("9103", m_sBuffer.toString()));
            PDTListe.write(this.getXDTLine("9236", m_DatenPool.getString("XPM_FILE")));
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (writePDTHeader)");
        }
    }

    public final void writePDTMeldung(Meldung meldung) throws Exception {
        try {
            PDTListe.write(this.getXDTLine("8000", "prot"));
            PDTListe.write(this.getXDTLine("9420", meldung.getNummer()));
            PDTListe.write(this.getXDTLine("9421", String.valueOf(meldung.getTyp())));
            PDTListe.write(this.getXDTLine("9423", meldung.getText().replace('\n', ' ')));
            String fehlerNr = meldung.getNummer();
            Boolean ausgabePatientendaten = false;
            if (fehlerNr.length() > 13 && fehlerNr.substring(0, 13).equals("Schema-Fehler")) {
                String meldungsText = meldung.getText();
                String satz = "con0";
                if (meldungsText.contains("/scon9")) {
                    satz = "con9";
                }
                if (meldungsText.contains("/sbesa")) {
                    satz = "besa";
                }
                if (meldungsText.contains("/srvsa")) {
                    satz = "rvsa";
                }
                if (meldungsText.contains("/sadt0")) {
                    satz = "adt0";
                }
                if (meldungsText.contains("/sadt9")) {
                    satz = "adt9";
                }
                if (meldungsText.contains("/skad0")) {
                    satz = "kad0";
                }
                if (meldungsText.contains("/skad9")) {
                    satz = "kad9";
                }
                if (meldungsText.contains("/ssad0")) {
                    satz = "sad0";
                }
                if (meldungsText.contains("/ssad9")) {
                    satz = "sad9";
                }
                if (meldungsText.contains("/ssad1")) {
                    satz = "sad1";
                }
                if (meldungsText.contains("/ssad2")) {
                    satz = "sad2";
                }
                if (meldungsText.contains("/ssad3")) {
                    satz = "sad3";
                }
                if (meldungsText.contains("/hdrg1")) {
                    satz = "hdrg1";
                }
                if (meldungsText.contains("/hdrg0")) {
                    satz = "hdrg0";
                }
                if (meldungsText.contains("/hdrg9")) {
                    satz = "hdrg9";
                }
                if (meldungsText.contains("/s0101")) {
                    satz = "0101";
                    ausgabePatientendaten = true;
                }
                if (meldungsText.contains("/s0102")) {
                    satz = "0102";
                    ausgabePatientendaten = true;
                }
                if (meldungsText.contains("/s0103")) {
                    satz = "0103";
                    ausgabePatientendaten = true;
                }
                if (meldungsText.contains("/s0104")) {
                    satz = "0104";
                    ausgabePatientendaten = true;
                }
                if (meldungsText.contains("/s0109")) {
                    satz = "0109";
                    ausgabePatientendaten = true;
                }
                if (meldungsText.contains("/shdrg0")) {
                    satz = "hdrg0";
                    ausgabePatientendaten = true;
                }
                if (meldungsText.contains("/shdrg1")) {
                    satz = "hdrg1";
                    ausgabePatientendaten = true;
                }
                if (meldungsText.contains("/shdrg9")) {
                    satz = "hdrg9";
                    ausgabePatientendaten = true;
                }
                PDTListe.write(this.getXDTLine("9424", satz));
            } else {
                ausgabePatientendaten = true;
                PDTListe.write(this.getXDTLine("9424", this.getSatzart(m_nSatzart)));
            }
            if (ausgabePatientendaten.booleanValue()) {
                if (m_s3000 != null) {
                    PDTListe.write(this.getXDTLine("3000", m_s3000));
                }
                if (m_s3003 != null) {
                    PDTListe.write(this.getXDTLine("3003", m_s3003));
                }
                if (m_sName != null) {
                    PDTListe.write(this.getXDTLine("3101", m_sName));
                }
                if (m_sVorname != null) {
                    PDTListe.write(this.getXDTLine("3102", m_sVorname));
                }
                if (m_sGeburt != null) {
                    PDTListe.write(this.getXDTLine("3103", m_sGeburt.replaceAll("\\.", "")));
                }
                if (m_sVKNR != null) {
                    PDTListe.write(this.getXDTLine("4104", m_sVKNR));
                }
                if (m_sKTAB != null) {
                    PDTListe.write(this.getXDTLine("4106", m_sKTAB));
                }
                if (m_sMFR != null) {
                    PDTListe.write(this.getXDTLine("3108", m_sMFR));
                }
                if (m_sSU != null) {
                    PDTListe.write(this.getXDTLine("4239", m_sSU));
                }
                if (m_sAbrA != null) {
                    PDTListe.write(this.getXDTLine("4114", m_sAbrA));
                }
                if (m_sGO != null) {
                    PDTListe.write(this.getXDTLine("4121", m_sGO));
                }
                if (m_sAbrG != null) {
                    PDTListe.write(this.getXDTLine("4122", m_sAbrG));
                }
                if (m_sQuartal != null) {
                    PDTListe.write(this.getXDTLine("4101", m_sQuartal));
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (writePDTMeldung)");
        }
    }

    public final void hdrgSatzpr\u00fcfung() throws Exception {
        try {
            String schalter = schalterDatenpakete;
            if (hdrg0Exists && besaExists || hdrg0Exists && rvsaExists) {
                m_MeldungPool.addMeldung("KVDT-SATZBESAHDRG");
            }
            if (!(schalter.equals("adt") || hdrg0Exists || besaExists)) {
                m_MeldungPool.addMeldung("KVDT-SATZ", " Es muss mindestens ein Satz der Satzart 'BESA' oder 'HDRG0' vorhanden sein.");
            }
            if (schalter.equals("alle") || schalter.equals("hdrg")) {
                if (hdrg0Exists && !hdrg1Exists) {
                    m_MeldungPool.addMeldung("KVDT-SATZ", " Wenn ein 'HDRG0' Satz existiert muss auch ein 'HDRG1' Satz vorhanden sein.");
                }
                if (!hdrg0Exists && hdrg1Exists) {
                    m_MeldungPool.addMeldung("KVDT-SATZ", " Wenn ein 'HDRG1' Satz existiert muss auch ein 'HDRG0' Satz vorhanden sein.");
                }
                if (hdrg0Exists && !hdrg9Exists || hdrg1Exists && !hdrg9Exists) {
                    m_MeldungPool.addMeldung("KVDT-SATZ", " Es fehlt ein Satz der Satzart 'HDRG9'.");
                }
                if (!hdrg0Exists && !hdrg1Exists && hdrg9Exists) {
                    m_MeldungPool.addMeldung("KVDT-SATZ", " Ein Satz der Satzart 'HDRG9' darf nur vorhanden sein, wenn ein Satz 'HDRG0' existiert.");
                }
            }
            if (schalter.equals("atd")) {
                if (!besaExists) {
                    m_MeldungPool.addMeldung("KVDT-SATZ", " Es muss mindestens ein Satz der Satzart 'BESA' vorhanden sein.");
                }
                if (hdrg0Exists || hdrg1Exists || hdrg9Exists) {
                    m_MeldungPool.addMeldung("KVDT-SATZ", " Ein Satz der Satzart HDRG darf nicht in einer ADT-\u00dcbertragung vorhanden sein.");
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "hdrgSatzPr\u00fcfung");
        }
    }

    public final void writePDTMeldungen() throws Exception {
        try {
            if (m_aPDTMeldungen.isEmpty()) {
                return;
            }
            for (int i = 0; i < m_aPDTMeldungen.size(); ++i) {
                this.writePDTMeldung(m_aPDTMeldungen.get(i));
            }
            m_aPDTMeldungen.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Pr\u00fcfung (writePDTMeldungen)");
        }
    }

    public void elementStart() throws XPMException {
        this.init();
        try {
            m_nSatzart = 0;
            if (m_s0105.length() > 0) {
                m_sGruppe = FehlerListe.newGroup(this.getPaketBezeichnung(0));
                m_sGruppe.append(", Pr\u00fcfnummer: ").append(m_s0105).append('|');
            }
            this.writePDTHeader();
            m_mapSortierListe = new FileMap(new TreeMap());
            m_DateFormat4.set2DigitYearStart(m_DateFormat.parse("01011960"));
            sValue_ = m_DatenPool.getString("icd_zusatz_pruefung");
            m_bICDZusatzPruefung = sValue_ != null && sValue_.equalsIgnoreCase("ja");
            mapAnalytID_.clear();
            sValue_ = m_DatenPool.getString("leistungsDatumPruefung");
            leistungsDatumPruefung = sValue_ != null && sValue_.equalsIgnoreCase("ja");
            String datenpakete = m_DatenPool.getString("datenpakete");
            if (datenpakete != null && ((datenpakete = datenpakete.toLowerCase()).equals("alle") || datenpakete.equals("hdrg") || datenpakete.equals("adt"))) {
                schalterDatenpakete = datenpakete;
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Initialisierung");
        }
    }

    @Override
    public void init(Meldung meldung) throws XPMException {
        try {
            if (m_Datenpakete[m_nDatenpaket] < meldung.getTyp()) {
                AbstractScon0Handler.m_Datenpakete[AbstractScon0Handler.m_nDatenpaket] = meldung.getTyp();
            }
            if (meldung.getTyp() < 1 || !PDTListe.getValid()) {
                return;
            }
            if (m_bWritePDT) {
                this.writePDTMeldung(meldung);
            } else {
                m_aPDTMeldungen.add(meldung);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Scon0Handler", "Meldungspr\u00fcfung");
        }
    }

    public void pruefeR108() throws XPMException {
        String vermittlungsart = this.m_Element.getChildValue("f4103");
        if (!vermittlungsart.matches("1|2|3|4|6")) {
            m_MeldungPool.addMeldung("KVDT-R108", "4103", "1|2|3|4|6");
        }
    }
}

