/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xpm.modul.kvdt.common;

import de.kbv.xpm.core.XPMException;
import de.kbv.xpm.core.meldung.Meldung;
import de.kbv.xpm.core.stamm.EBM.Gnr;
import de.kbv.xpm.core.stamm.KRW.pruefung.ICD;
import de.kbv.xpm.core.stamm.KTS.SatzKTS;
import de.kbv.xpm.core.stamm.keytab.Key;
import de.kbv.xpm.modul.kvdt.common.AbstractScon0Handler;
import de.kbv.xpm.modul.kvdt.common.FallInfo;
import de.kbv.xpm.modul.kvdt.common.ScheinInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Shdrg0Handler
extends AbstractScon0Handler {
    protected static final SimpleDateFormat f4124DateFormat_ = new SimpleDateFormat("ddMMyy");
    protected static final Pattern f4124Pattern2_ = Pattern.compile("[a-zA-Z0-9][0-9]{5}");
    protected static final TreeMap<String, ScheinInfo> m_mapSortierteListe = new TreeMap();
    protected static boolean m_bADTPatientenNr = false;
    protected static boolean m_bScheinNeu = true;
    protected static String m_s4217 = null;
    protected static String m_s4218 = null;
    protected static String m_s4219 = null;
    protected static String m_s4241 = null;
    protected static String s4249 = null;
    protected static String s4226 = null;
    protected static Key m_key = null;
    protected static final HashSet<String> setGNR_ = new HashSet();
    protected static final HashSet<ICD> setICD_ = new HashSet();
    protected static final HashSet<ICD> setICD6001_ = new HashSet();
    protected static final HashSet<String> setBAR_ = new HashSet();
    protected static ICD icd_ = null;
    protected static HashSet<String> setZusatzangabe_ = null;
    protected static TreeMap<String, String[]> mapRVZMeldungen_ = new TreeMap();
    protected static Gnr gnr_ = null;
    protected static boolean bPruefung703_ = false;
    protected static boolean bPruefung704_ = false;
    protected static boolean b010xSatz_ = false;
    protected static boolean regel828 = false;
    protected static boolean regel843 = false;
    protected static boolean regel854 = false;
    protected static boolean regel829 = false;
    protected static boolean regel830 = false;
    protected static HashSet<String> setFK5098 = new HashSet();
    protected static String f9102 = "";
    protected static String f0132 = "";

    public Shdrg0Handler(String sXPath) throws XPMException {
        super(sXPath);
        this.m_bStartEvent = true;
    }

    @Override
    public final void initSatz() throws Exception {
        try {
            super.initSatz();
            s4226 = "";
            s4249 = "";
            m_s4242 = "";
            m_s4241 = "";
            m_s4219 = "";
            m_s4218 = "";
            m_s4217 = "";
            if (m_s0105.length() > 0) {
                m_sGruppe = FehlerListe.newGroup("HDRG-Datenpaket, Pr\u00fcfnummer: ");
                m_sGruppe.append(m_s0105).append('|');
            } else {
                m_sGruppe = FehlerListe.newGroup("HDRG-Datenpaket|");
            }
            setGNR_.clear();
            setICD_.clear();
            setBAR_.clear();
            setICD6001_.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (initSatz)");
        }
    }

    public final void pruefeRegel308() throws Exception {
        block5: {
            try {
                m_sTmp = this.m_Element.getChildValue("f3006");
                if (m_sTmp.length() <= 0) break block5;
                try {
                    int value = Integer.parseInt(m_sTmp.replace(".", ""));
                    if (value < 520) {
                        m_MeldungPool.addMeldung("KVDT-R308");
                    }
                }
                catch (NumberFormatException value) {}
            }
            catch (Exception ex) {
                this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (pruefeRegel308)");
            }
        }
    }

    public final void pruefeRegel537(String f3119) throws Exception {
        try {
            if (f3119.equals("T555558879")) {
                m_MeldungPool.addMeldung("KVDT-R537");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (pruefeRegel537)");
        }
    }

    public final void pruefeRegel734() throws Exception {
        block6: {
            try {
                if (m_KT == null || !m_KT.getKTGruppe().equals("75")) break block6;
                sValue_ = this.m_Element.getChildValue("f4124");
                if (sValue_.length() > 7) {
                    m_sTmp = sValue_.substring(6);
                    try {
                        if (f4124DateFormat_.parse(sValue_.substring(0, 6)) == null || !f4124Pattern2_.matcher(m_sTmp).matches()) {
                            m_MeldungPool.addMeldung("KVDT-R734", this.getRegel734Text());
                        }
                        break block6;
                    }
                    catch (ParseException e) {
                        m_MeldungPool.addMeldung("KVDT-R734", this.getRegel734Text());
                    }
                    break block6;
                }
                m_MeldungPool.addMeldung("KVDT-R734", this.getRegel734Text());
            }
            catch (Exception ex) {
                this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (pruefeRegel734)");
            }
        }
    }

    public final String getRegel734Text() throws Exception {
        try {
            if (!sValue_.isEmpty()) {
                m_sBuffer.replace("Die Personenkennziffer '").append(sValue_);
                m_sBuffer.append("' entspricht nicht dem erwarterten Format 'TTMMJJannnnn'.");
                return m_sBuffer.toString();
            }
            return "Die SKT-Zusatzangabe (Feld 4124) ist leer.";
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (getRegel734Text)");
            return null;
        }
    }

    public final void pruefeRegel876(String f3010, String f4109) throws Exception {
        try {
            if (!StringUtils.isEmpty((CharSequence)f3010) && StringUtils.isEmpty((CharSequence)f4109)) {
                m_MeldungPool.addMeldung("KVDT-R876");
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (pruefeRegel876)");
        }
    }

    public final void checkICDSetForZ01_7(String meldungNr) throws Exception {
        try {
            if (setICD6001_.isEmpty()) {
                m_MeldungPool.addMeldung(meldungNr);
            } else {
                boolean icdOhneZ017gefunden = false;
                for (ICD icd : setICD6001_) {
                    if (icd.getCode().matches("Z01.7")) continue;
                    icdOhneZ017gefunden = true;
                    break;
                }
                if (!icdOhneZ017gefunden) {
                    m_MeldungPool.addMeldung(meldungNr);
                }
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (checkICDSetForZ01_7)");
        }
    }

    public final void setFehlerGruppe() throws Exception {
        try {
            m_sGruppe.append(m_sName).append(", ").append(m_sVorname);
            if (m_sGeburt != null) {
                m_sGruppe.append(", ").append(m_sGeburt);
            }
            m_sGruppe.append(", VKNR/KTAB: ").append(m_sVKNR).append('/').append(m_sKTAB).append(", ").append(this.getSatzBezeichnung(m_nSatzart, m_nSU)).append(", Status: ").append(this.getStatus(m_sMFR));
            if (m_s3000 != null) {
                m_sGruppe.append(", Int.: ").append(m_s3000);
            }
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (setFehlerGruppe)");
        }
    }

    @Override
    public void elementStart() throws XPMException {
        this.init();
        try {
            if (!dateiName.toLowerCase().startsWith("z30")) {
                m_MeldungPool.addMeldung("KVDT-FILEHDRG");
            }
            if (schalterDatenpakete.toLowerCase().equals("adt")) {
                String text = "Das Pr\u00fcfmodul ist derzeit nur f\u00fcr die Pr\u00fcfung von ADT-Datenpaketen konfiguriert. In der Datei ist ein HDRG0-Satz vorhaben, welcher nur bei Hybrid-DRG \u00fcbertragen werden darf. Die Pr\u00fcfung wird deshalb abgebrochen.";
                m_MeldungPool.addMeldung("XPM-Abbruch", text);
                this.writePDTMeldung(new Meldung("XPM-Abbruch", 3, text));
                return;
            }
            m_nSatzart = 15;
            writeKomuSatz = false;
            hdrg0Exists = true;
            f4124DateFormat_.setLenient(false);
            m_nFaelle = 0;
            this.clearListen();
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Initialisierung");
        }
    }

    public void elementEnde() throws XPMException {
        try {
            this.setReportParameter(FehlerListe);
            this.writeFallStatistik();
            m_nFaelleGesamt += m_nFaelle;
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung");
        }
    }

    public final void writeFallStatistik() throws Exception {
        try {
            if (m_mapFallAmbulant.isEmpty()) {
                return;
            }
            progress_.setText("Generiere Fallstatistikliste...");
            this.setReportParameter(FallListe, "KBV-Pr\u00fcfmodul Fallstatistik (KVDT, " + cVERSION + "-Version)");
            for (FallInfo fall : m_mapFallAmbulant.values()) {
                String sName;
                SatzKTS kt = KTStamm.getKTSSatz(fall.m_sVKNR);
                if (kt == null || (sName = kt.getKTABNameNachFusion(fall.m_sKTAB)) == null) {
                    sName = "Fehlerhafter Kostentr\u00e4ger";
                }
                int nSumme = fall.m_nMStatus + fall.m_nFStatus + fall.m_nRStatus;
                m_sBuffer.replace(fall.m_sVKNR);
                m_sBuffer.append('/').append(fall.m_sKTAB);
                FallListe.addData(m_sBuffer.toString(), sName, new Integer(fall.m_nMStatus), new Integer(fall.m_nFStatus), new Integer(fall.m_nRStatus), new Integer(nSumme), new Integer(fall.m_nVorQuartal), "Ambulant");
                m_nFaelle += nSumme;
            }
            FallListe.write();
            m_mapFallAmbulant.clear();
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (writeFallStatistik)");
        }
    }

    public final void writeSortierListe() throws Exception {
        try {
            if (m_mapSortierListe.getMap().isEmpty() || hdrg9Exists) {
                return;
            }
            this.setReportParameter(SortierListe, "KBV-Pr\u00fcfmodul Sortierliste (KVDT, " + cVERSION + "-Version)");
            String sLastKey = "";
            int nCount = 1;
            int nGroupLength = m_kvx4.getSortKeyGroupLength();
            Iterator iter = m_mapSortierListe.values().iterator();
            while (iter.hasNext()) {
                String sName;
                ScheinInfo scheinInfo = (ScheinInfo)m_mapSortierListe.get((Long)iter.next());
                SatzKTS kt = KTStamm.getKTSSatz(scheinInfo.m_sVKNR);
                if (kt == null || (sName = kt.getKTABNameNachFusion(scheinInfo.m_sKTAB)) == null) {
                    sName = "Fehlerhafter Kostentr\u00e4ger";
                }
                if (sLastKey.compareTo(scheinInfo.m_sSortKey.substring(0, nGroupLength)) == 0) {
                    scheinInfo.m_nFallNr = ++nCount;
                } else {
                    scheinInfo.m_nFallNr = 1;
                    nCount = 1;
                    sLastKey = scheinInfo.m_sSortKey.substring(0, nGroupLength);
                }
                Integer count = new Integer(scheinInfo.m_nFallNr);
                m_sBuffer.replace(scheinInfo.m_sVKNR);
                SortierListe.addData(m_sBuffer.append('/').append(scheinInfo.m_sKTAB).toString(), sName, count, scheinInfo.m_sName, scheinInfo.m_sGeburt, scheinInfo.m_sQuartal, scheinInfo.m_sMFR, this.getSatzBezeichnung(scheinInfo.m_nSatzart, scheinInfo.m_nSU), scheinInfo.m_sEinlesetag);
            }
            m_mapSortierListe.close();
            SortierListe.write();
        }
        catch (Exception ex) {
            this.catchException(ex, "Shdrg0Handler", "Pr\u00fcfung (writeSortierListe)");
        }
    }

    @Override
    public void init() throws XPMException {
        m_bADTPatientenNr = false;
        m_bScheinNeu = true;
        m_s4218 = null;
        f0132 = "";
        m_key = null;
        icd_ = null;
        setZusatzangabe_ = null;
        mapRVZMeldungen_ = new TreeMap();
        gnr_ = null;
        b010xSatz_ = false;
        setFK5098 = new HashSet();
        regel828 = false;
        regel843 = false;
        regel829 = false;
        regel830 = false;
        regel854 = false;
        m_mapFallAmbulant.clear();
    }
}

