<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fhir="http://hl7.org/fhir" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns="http://www.w3.org/1999/xhtml" exclude-result-prefixes="fhir xhtml" version="1.0">
	<!-- Stylesheet für eAU Version 1.2 - Stornierung einer Arbeitsunfähigkeitsbescheinigung -->
    <xsl:template match="/">
        <xsl:apply-templates select="/fhir:Bundle"/>
    </xsl:template>
    <xsl:template match="fhir:Bundle[not(ancestor::fhir:Bundle)]">
        <html lang="de" xmlns="http://www.w3.org/1999/xhtml">
            <xsl:call-template name="printHead"/>
            <body>
                <table style="border: 1px solid black; ">
                    <tr>
                        <td>
                            <table style="width: 44em;    border-spacing:0; cellspacing:0; border-collapse:collapse; ">
                                <colgroup>
                                    <col style="width:14em"/>
                                    <col style="width:30em"/>
                                </colgroup>
                                <tbody>
                                    <tr>
                                        <td class="hervorgehoben1" colspan="2">
                                                               Stornierung einer Arbeitsunfähigkeitsbescheinigung
                                                                <br/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="3" style="height: 2em;">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td >Zu stornierende eAU-ID:</td>
                                        <td class="daten" >
                                            <xsl:call-template name="getPrfnr">
                                                <xsl:with-param name="prfnrAdr" select="fhir:entry/fhir:resource/fhir:List/fhir:entry/fhir:item/fhir:identifier/fhir:value/@value"/>
                                                <!--<xsl:with-param name="prfnrAdr" select="fhir:identifier/fhir:value/@value"/>-->
                                            </xsl:call-template>
                                          
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>BSNR:</td>
                                        <td class="daten" >
                                            <xsl:choose>
												<xsl:when test="fhir:entry/fhir:resource/fhir:PractitionerRole/fhir:organization/fhir:identifier[fhir:system/@value='http://fhir.de/NamingSystem/asv/teamnummer']/fhir:value/@value">
													<xsl:value-of select="fhir:entry/fhir:resource/fhir:PractitionerRole/fhir:organization/fhir:identifier[fhir:system/@value='http://fhir.de/NamingSystem/asv/teamnummer']/fhir:value/@value"/>
												</xsl:when>
												<xsl:when test="fhir:entry/fhir:resource/fhir:Organization/fhir:identifier[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_Base_BSNR']/fhir:value/@value">
													<xsl:value-of select="fhir:entry/fhir:resource/fhir:Organization/fhir:identifier[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_Base_BSNR']/fhir:value/@value"/>
												</xsl:when>
												<xsl:when test="fhir:entry/fhir:resource/fhir:Organization/fhir:identifier[fhir:system/@value='http://fhir.de/sid/kzbv/kzvabrechnungsnummer']/fhir:value/@value">
													<xsl:value-of select="fhir:entry/fhir:resource/fhir:Organization/fhir:identifier[fhir:system/@value='http://fhir.de/sid/kzbv/kzvabrechnungsnummer']/fhir:value/@value"/>
												</xsl:when>
												<xsl:when test="fhir:entry/fhir:resource/fhir:Organization/fhir:identifier[fhir:system/@value='http://fhir.de/sid/dkgev/standortnummer']/fhir:value/@value">
													<xsl:value-of select="fhir:entry/fhir:resource/fhir:Organization/fhir:identifier[fhir:system/@value='http://fhir.de/sid/dkgev/standortnummer']/fhir:value/@value"/>
												</xsl:when>
												<xsl:when test="fhir:entry/fhir:resource/fhir:Organization/fhir:identifier[fhir:system/@value='http://fhir.de/sid/arge-ik/iknr']/fhir:value/@value">
													<xsl:value-of select="fhir:entry/fhir:resource/fhir:Organization/fhir:identifier[fhir:system/@value='http://fhir.de/sid/arge-ik/iknr']/fhir:value/@value"/>
												</xsl:when>
												<!-- keine Ausgabe der Telematik-ID, da diese wesentlich länger als 9 Zeichen sein kann -->
												<xsl:otherwise>&#160;</xsl:otherwise>
											</xsl:choose>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>LANR:</td>
                                        <td class="daten">
											<xsl:choose>
												<xsl:when test="count(fhir:entry/fhir:resource/fhir:Practitioner/fhir:identifier/fhir:value/@value)&gt;1">
													<xsl:variable name="author_ref" select="fhir:entry/fhir:resource/fhir:Composition/fhir:author[fhir:type/@value='Practitioner']/fhir:reference/@value"/>
													<xsl:choose>
														<xsl:when test="contains($author_ref,'/') or contains($author_ref,':')">
															<xsl:variable name="returnValue">
																<xsl:choose>
																	<xsl:when test="contains($author_ref,'/')">
																		<xsl:call-template name="substring-after-last">
																			<xsl:with-param name="input" select="$author_ref"/>
																			<xsl:with-param name="substr" select="'/'"/>
																		</xsl:call-template>
																	</xsl:when>
																	<xsl:otherwise>
																		<xsl:call-template name="substring-after-last">
																			<xsl:with-param name="input" select="$author_ref"/>
																			<xsl:with-param name="substr" select="':'"/>
																		</xsl:call-template>
																	</xsl:otherwise>
																</xsl:choose>
															</xsl:variable>
															<xsl:choose>
																<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$returnValue]/fhir:identifier[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR']/fhir:value/@value">
																	<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$returnValue]/fhir:identifier[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR']/fhir:value/@value"/>
																</xsl:when>
																<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$returnValue]/fhir:identifier[fhir:system/@value='http://fhir.de/sid/kzbv/zahnarztnummer']/fhir:value/@value">
																	<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$returnValue]/fhir:identifier[fhir:system/@value='http://fhir.de/sid/kzbv/zahnarztnummer']/fhir:value/@value"/>
																</xsl:when>
																<!-- keine Ausgabe der Telematik-ID, da diese wesentlich länger als 9 Zeichen sein kann -->
																<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$returnValue]/fhir:qualification/fhir:code/fhir:coding[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_FOR_Fachgruppennummer_ASV']/fhir:code/@value">
																	<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$returnValue]/fhir:qualification/fhir:code/fhir:coding[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_FOR_Fachgruppennummer_ASV']/fhir:code/@value"/>
																</xsl:when>
																<xsl:otherwise>&#160;</xsl:otherwise>
															</xsl:choose>
														</xsl:when>
														<xsl:otherwise>
															<xsl:choose>
																<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$author_ref]/fhir:identifier[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR']/fhir:value/@value">
																	<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$author_ref]/fhir:identifier[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR']/fhir:value/@value"/>
																</xsl:when>
																<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$author_ref]/fhir:identifier[fhir:system/@value='http://fhir.de/sid/kzbv/zahnarztnummer']/fhir:value/@value">
																	<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$author_ref]/fhir:identifier[fhir:system/@value='http://fhir.de/sid/kzbv/zahnarztnummer']/fhir:value/@value"/>
																</xsl:when>
																<!-- keine Ausgabe der Telematik-ID, da diese wesentlich länger als 9 Zeichen sein kann -->
																<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$author_ref]/fhir:qualification/fhir:code/fhir:coding[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_FOR_Fachgruppennummer_ASV']/fhir:code/@value">
																	<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner[fhir:id/@value=$author_ref]/fhir:qualification/fhir:code/fhir:coding[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_FOR_Fachgruppennummer_ASV']/fhir:code/@value"/>
																</xsl:when>
																<xsl:otherwise>&#160;</xsl:otherwise>
															</xsl:choose>
														</xsl:otherwise>
													</xsl:choose>
												</xsl:when>
												<xsl:otherwise>
													<xsl:choose>
														<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner/fhir:identifier[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR']/fhir:value/@value">
															<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner/fhir:identifier[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_Base_ANR']/fhir:value/@value"/>
														</xsl:when>
														<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner/fhir:identifier[fhir:system/@value='http://fhir.de/sid/kzbv/zahnarztnummer']/fhir:value/@value">
															<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner/fhir:identifier[fhir:system/@value='http://fhir.de/sid/kzbv/zahnarztnummer']/fhir:value/@value"/>
														</xsl:when>
														<!-- keine Ausgabe der Telematik-ID, da diese wesentlich länger als 9 Zeichen sein kann -->
														<xsl:when test="fhir:entry/fhir:resource/fhir:Practitioner/fhir:qualification/fhir:code/fhir:coding[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_FOR_Fachgruppennummer_ASV']/fhir:code/@value">
															<xsl:value-of select="fhir:entry/fhir:resource/fhir:Practitioner/fhir:qualification/fhir:code/fhir:coding[fhir:system/@value='https://fhir.kbv.de/NamingSystem/KBV_NS_FOR_Fachgruppennummer_ASV']/fhir:code/@value"/>
														</xsl:when>
														<xsl:otherwise>&#160;</xsl:otherwise>
													</xsl:choose>
												</xsl:otherwise>
											</xsl:choose>
										</td>
                                    </tr>
                                    <tr style="height: 5em;">
                                        <td colspan="2">
                                            <br/>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                </table>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="printHead">
        <head>
            <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
            <title>
                Stornierung einer Arbeitsunfähigkeitsbescheinigung
            </title>
            <style type="text/css" media="all">
				html {
					height: 100%;
				}
				body { 
					padding-left:2em;
					margin-top:1em;
					height: 100%;
				}
                p {
					font-family: "Courier New", "Nimbus Mono L", monospace;
					font-size: small;
                }
                .in-black {
					font-size: 7pt;
					color: #000000;
					font-weight: normal;
					font-family: Arial, "Helvetica CY", "Nimbus Sans L", sans-serif;
                }
                .tiny {
					font-size: 7pt;
					color: #000000;
					font-weight: bold;
					font-weight: normal;
					font-family: Arial, "Helvetica CY", "Nimbus Sans L", sans-serif;
                }
                .info {
					font-size: 8pt;
					color: #000000;
					font-weight: normal;
					font-family: Arial, "Helvetica CY", "Nimbus Sans L", sans-serif;
                }
                .stempel {
					font-family: "Courier New", "Nimbus Mono L", monospace;
					font-size: 10pt; 
                }            
				.kursiv {
					color: #000000;
					font-size: 8pt;
					font-style: italic;
					font-family: Arial, "Helvetica CY", "Nimbus Sans L", sans-serif;
                }                  
                .daten {
					font-family: "Courier New", "Nimbus Mono L", monospace;
					font-size: 12pt; 
                }
                .nowrap {
					white-space: nowrap;
                }
                .overflow{
					overflow:hidden
                }
                .thin-space {
					font-size: 12pt;
					font-weight: normal;
					font-family: Arial, "Helvetica CY", "Nimbus Sans L", sans-serif;
                }
                .groesse1 {
					font-size: 16pt;
					color: #000000;
					font-weight: normal;
					font-family: Verdana, "Geneva CY", "DejaVu Sans", sans-serif;               
                }
                .groesse2 { 
					font-size: 14pt;
					color: #000000;
					font-weight: normal;
					font-family: Verdana, "Geneva CY", "DejaVu Sans", sans-serif;
                 }
                .groesse3 { 
					font-size: 10pt;
					color: #000000;
					font-weight: normal;
					font-family: Arial, "Helvetica CY", "Nimbus Sans L", sans-serif;
                }                 
                .hervorgehoben1 {    
					font-size: 16pt;
					color: #000000;
					font-weight: bold;
					font-family: Verdana, "Geneva CY", "DejaVu Sans", sans-serif;
                }       
                .hervorgehoben2 { 
					  font-size: 14pt;
					color: #000000;
					font-weight: bold;
					font-family: Verdana, "Geneva CY", "DejaVu Sans", sans-serif;
                 }
                .hervorgehoben3 { 
					 font-size: 10pt;
					color: #000000;
					font-weight: bold;
					font-family: Arial, "Helvetica CY", "Nimbus Sans L", sans-serif;
                }  
                .hervorgehoben3kursiv { 
					color: #000000;
					font-size: 10pt;
					font-weight: bold;
					font-style: italic;
					font-family: Arial, "Helvetica CY", "Nimbus Sans L", sans-serif;
                }                   
                .status {
					font-family: "Courier New", "Nimbus Mono L", monospace;
					font-size: 9pt;
					word-spacing:"-0.3em"
                }
                .hidden {
					display: none;
                }
				@media print {
					@page {
							size: A5;
							margin: 0;
						}
					body { 
						margin: 0; 
						padding: 0; 
					} 
				}				
            </style>
        </head>
    </xsl:template>
    <xsl:template name="formatDate">
        <xsl:param name="date"/>
        <xsl:variable name="yearNum" select="substring ($date, 1, 4)"/>
        <xsl:variable name="monthNum" select="substring ($date, 6, 2)"/>
        <xsl:variable name="dayNum" select="substring ($date, 9, 2)"/>
        <xsl:choose>
			<xsl:when test="$dayNum">
				<xsl:value-of select="$dayNum"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'00'"/>
			</xsl:otherwise>
		</xsl:choose>
        <xsl:text>.</xsl:text>
        <xsl:choose>
			<xsl:when test="$monthNum">
				<xsl:value-of select="$monthNum"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'00'"/>
			</xsl:otherwise>
		</xsl:choose>
        <xsl:text>.</xsl:text>
        <xsl:choose>
			<xsl:when test="$yearNum">
				<xsl:value-of select="$yearNum"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="'0000'"/>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    <xsl:template name="getPrfnr">
        <xsl:param name="prfnrAdr"/>
        <xsl:variable name="prfnr" select="substring-after($prfnrAdr,'urn:uuid:')"/>
        <xsl:value-of select="$prfnr"/>
    </xsl:template>
    <xsl:template name="substring-after-last">
        <xsl:param name="input"/>
        <xsl:param name="substr"/>
        <xsl:variable name="lastChar" select="substring($input, string-length($input) - string-length($substr) +1)"/>
        <xsl:choose>
            <xsl:when test="$lastChar=$substr">
                <xsl:call-template name="substring-after-last">
                    <xsl:with-param name="input" select="substring($input,1, string-length($input)-1)"/>
                    <xsl:with-param name="substr" select="$substr"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <!-- Extract the string which comes after the first occurence -->
                <xsl:variable name="temp" select="substring-after($input,$substr)"/>
                <xsl:choose>
                    <!-- If it still contains the search string the recursively process -->
                    <xsl:when test="$substr and  contains($temp,$substr)">
                        <xsl:call-template name="substring-after-last">
                            <xsl:with-param name="input" select="$temp"/>
                            <xsl:with-param name="substr" select="$substr"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:if test="contains($temp,'/')">
                            <xsl:call-template name="substring-after-last">
                                <xsl:with-param name="input" select="$temp"/>
                                <xsl:with-param name="substr" select="$substr"/>
                            </xsl:call-template>
                        </xsl:if>
                        <xsl:value-of select="$temp"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="getVersion">
        <xsl:param name="url"/>
        <xsl:variable name="version" select="substring-after($url,'|')"/>
        <font size="0.5">
            <xsl:value-of select="$version"/>
        </font>
    </xsl:template>
</xsl:stylesheet>
