/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.common.zip;

import de.kbv.common.zip.KbvZipFormat;
import de.kbv.common.zip.KbvZipInputStream;
import de.kbv.common.zip.KbvZipOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class KBVGZip {
    protected String sInputFile;
    protected String sOutputFile;
    protected static final int GZIP = 1;
    protected static final int UNGZIP = 2;

    private void usage() {
        System.out.println();
        System.out.println("KBVGZip (c)2007");
        System.out.println("(De)Komprimiert GZip-Dateien");
        System.out.println();
        System.out.println("Aufruf:");
        System.out.println("-z:    GZippen");
        System.out.println("-u:    UnGZippen");
        System.out.println("-i:    Eingabedatei");
        System.out.println();
        System.out.println("Beispiele:");
        System.out.println("KBVGZip -z -ieingabedatei.xml");
        System.out.println("KBVGZip -u -ieingabedatei.xml.gz");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int zipFile() {
        KbvZipOutputStream zos = null;
        FileInputStream fis = null;
        if (this.sOutputFile == null) {
            this.sOutputFile = this.sInputFile + ".gz";
        }
        try {
            KbvZipOutputStream.setAutoSuffix(false);
            zos = new KbvZipOutputStream(this.sOutputFile, null, KbvZipFormat.GZIP);
            fis = new FileInputStream(this.sInputFile);
            byte[] buffer = new byte[10240];
            int nReadBytes = fis.read(buffer);
            while (nReadBytes > 0) {
                zos.write(buffer, 0, nReadBytes);
                nReadBytes = fis.read(buffer);
            }
        }
        catch (Exception e) {
            int n = 3;
            return n;
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unzipFile() {
        KbvZipInputStream zis = null;
        FileOutputStream fos = null;
        if (!this.sInputFile.toLowerCase().endsWith(".gz")) {
            System.out.println("Eingangsdatei muss auf Suffix '.gz' enden");
            return 5;
        }
        this.sOutputFile = this.sInputFile.substring(0, this.sInputFile.length() - 3);
        try {
            zis = new KbvZipInputStream(this.sInputFile);
            fos = new FileOutputStream(this.sOutputFile);
            byte[] buffer = new byte[10240];
            int nReadBytes = zis.read(buffer);
            while (nReadBytes > 0) {
                fos.write(buffer, 0, nReadBytes);
                nReadBytes = zis.read(buffer);
            }
        }
        catch (Exception e) {
            int n = 4;
            return n;
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        int zipperMode = 0;
        KBVGZip kbvGZipper = new KBVGZip();
        int nCounter = 0;
        for (int i = 0; i < args.length; ++i) {
            String s = args[i].toLowerCase();
            if (s.equals("-z")) {
                zipperMode = 1;
                ++nCounter;
                continue;
            }
            if (s.equals("-u")) {
                zipperMode = 2;
                ++nCounter;
                continue;
            }
            if (!s.startsWith("-i")) continue;
            kbvGZipper.sInputFile = s.length() == 2 ? args[++i] : args[i].substring(2);
        }
        if (nCounter != 1 || kbvGZipper.sInputFile == null) {
            kbvGZipper.usage();
            System.exit(1);
        }
        if (!new File(kbvGZipper.sInputFile).exists()) {
            System.out.println("Eingabedatei nicht gefunden");
            System.exit(2);
        }
        int nRC = 0;
        nRC = zipperMode == 1 ? kbvGZipper.zipFile() : kbvGZipper.unzipFile();
        if (nRC != 0) {
            System.out.println("Fehler bei der Verarbeitung: RC=" + nRC);
        } else {
            System.out.println("Datei " + kbvGZipper.sOutputFile + " erzeugt");
        }
        System.exit(nRC);
    }
}

