/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.common.zip;

import de.kbv.common.zip.KbvZipFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class KbvZipFile {
    protected KbvZipFormat kbvZipFormat = KbvZipFormat.NOZIP;
    protected String sZipFilename;
    protected String sFirstFilename;

    public KbvZipFile(String sZipFilename) throws FileNotFoundException {
        InflaterInputStream inputStream = null;
        this.sZipFilename = sZipFilename;
        FileInputStream fis = null;
        if (!new File(sZipFilename).exists()) {
            throw new FileNotFoundException("Datei " + sZipFilename + " nicht gefunden");
        }
        try {
            fis = new FileInputStream(sZipFilename);
            inputStream = new GZIPInputStream(fis);
            this.kbvZipFormat = KbvZipFormat.GZIP;
            this.sFirstFilename = sZipFilename;
            if (this.sFirstFilename.toLowerCase().endsWith(".gz")) {
                this.sFirstFilename = this.sFirstFilename.substring(0, this.sFirstFilename.length() - 3);
                this.sFirstFilename = new File(this.sFirstFilename).getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (fis != null) {
            try {
                fis.close();
                fis = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.kbvZipFormat != KbvZipFormat.GZIP) {
            try {
                fis = new FileInputStream(sZipFilename);
                ZipInputStream zis = new ZipInputStream(fis);
                ZipEntry thisEntry = zis.getNextEntry();
                if (thisEntry != null) {
                    inputStream = zis;
                    this.kbvZipFormat = KbvZipFormat.ZIP;
                    this.sFirstFilename = thisEntry.getName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (fis != null) {
            try {
                fis.close();
                fis = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getFirstFilename() {
        return this.sFirstFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countFiles() {
        if (this.kbvZipFormat == KbvZipFormat.NOZIP) {
            return -1;
        }
        if (this.kbvZipFormat == KbvZipFormat.GZIP) {
            return 1;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.sZipFilename);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            int counter = 0;
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) continue;
                ++counter;
            }
            int n = counter;
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public KbvZipFormat getFormat() {
        return this.kbvZipFormat;
    }

    public boolean isZipFile() {
        return this.kbvZipFormat == KbvZipFormat.ZIP;
    }

    public boolean isGZipFile() {
        return this.kbvZipFormat == KbvZipFormat.GZIP;
    }

    public boolean isCompressedFile() {
        return this.kbvZipFormat != KbvZipFormat.NOZIP;
    }

    public String getSuffix() {
        return this.kbvZipFormat == KbvZipFormat.GZIP ? ".gz" : (this.kbvZipFormat == KbvZipFormat.ZIP ? ".zip" : "");
    }
}

