/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.common.zip;

import de.kbv.common.zip.KbvZipFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class KbvZipInputStream
extends InputStream {
    static final int BUFFERSIZE = 256;
    protected InputStream inputStream = null;
    protected CheckedInputStream checkedInputStream = null;
    protected ZipFile zipFile = null;
    protected long lCrc32 = -1L;
    public KbvZipFormat kbvZipFormat = KbvZipFormat.NOZIP;
    public String sFirstFilename = null;
    protected byte[] bBuffered;
    protected int nIndex = 0;
    protected int nBuffered = 0;

    protected InputStream openGZip(String sFilename) throws FileNotFoundException {
        GZIPInputStream inputStream = null;
        FileInputStream fis = null;
        try {
            this.lCrc32 = -1L;
            fis = new FileInputStream(sFilename);
            inputStream = new GZIPInputStream(fis);
            this.checkedInputStream = new CheckedInputStream(inputStream, new CRC32());
            if (this.sFirstFilename.toLowerCase().endsWith(".gz")) {
                this.sFirstFilename = this.sFirstFilename.substring(0, this.sFirstFilename.length() - 3);
                this.sFirstFilename = new File(this.sFirstFilename).getName();
            }
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (inputStream == null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    protected InputStream openZip(String sFilename) throws FileNotFoundException, IOException {
        InputStream inputStream = null;
        try {
            ZipEntry zipEntry;
            this.zipFile = new ZipFile(sFilename);
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            if (e.hasMoreElements() && (zipEntry = e.nextElement()) != null) {
                this.lCrc32 = zipEntry.getCrc();
                inputStream = this.zipFile.getInputStream(zipEntry);
                this.checkedInputStream = new CheckedInputStream(inputStream, new CRC32());
                this.sFirstFilename = zipEntry.getName();
            }
        }
        catch (ZipException zipException) {
            // empty catch block
        }
        return inputStream;
    }

    public KbvZipInputStream(String sFilename) throws IOException {
        this.sFirstFilename = sFilename;
        this.inputStream = this.openGZip(sFilename);
        if (this.inputStream != null) {
            this.kbvZipFormat = KbvZipFormat.GZIP;
        } else {
            this.inputStream = this.openZip(sFilename);
            if (this.inputStream != null) {
                this.kbvZipFormat = KbvZipFormat.ZIP;
            } else {
                throw new ZipException("Unbekanntes Zip-Format");
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.kbvZipFormat == KbvZipFormat.GZIP) {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        } else if (this.kbvZipFormat == KbvZipFormat.ZIP && this.zipFile != null) {
            this.zipFile.close();
        }
        if (this.lCrc32 != -1L && this.checkedInputStream.getChecksum().getValue() != this.lCrc32) {
            throw new ZipException("Fehlerhafte Checksumme");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.nBuffered <= 0) {
            this.bBuffered = new byte[256];
            this.nBuffered = this.checkedInputStream.read(this.bBuffered);
            this.nIndex = 0;
            if (this.nBuffered <= 0) {
                return this.nBuffered;
            }
        }
        --this.nBuffered;
        byte nReturn = this.bBuffered[this.nIndex];
        ++this.nIndex;
        return nReturn & 0xFF;
    }
}

