/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.splitmodul;

import de.kbv.splitmodul.DiskCopy;
import de.kbv.xkm.Header;
import de.kbv.xkm.gui.XKMGUIThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CopyBack {
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    public static final int COPYBACK_NOERROR = 0;
    public static final int COPYBACK_HEADERERROR = 1;
    public static final int COPYBACK_ZIELVERZEICHNIS = 2;
    public static final int COPYBACK_USERQUIT = 3;
    public static final int COPYBACK_WHILECOPY = 4;
    public static final int COPYBACK_ANYEXCEPTION = 5;
    protected String m_sQuelle;
    protected String m_sZiel;
    protected boolean m_isGUI = true;
    public JFrame parentFrame = null;
    public String sFirstCopied;

    public CopyBack(String sQuelle, String sZiel, boolean bDeleteOriginal, boolean bIsGUI) {
        this.m_sZiel = sZiel;
        this.m_isGUI = bIsGUI;
        this.m_sQuelle = new File(sQuelle).isDirectory() ? sQuelle : new File(sQuelle).getParent();
        if (sQuelle.length() == 2 && sQuelle.charAt(1) == ':') {
            this.m_sQuelle = this.m_sQuelle + "/";
        }
        if (!DiskCopy.isDirectory(this.m_sQuelle) && new File(this.m_sQuelle).isDirectory()) {
            this.m_sQuelle = this.m_sQuelle + "/";
        }
        if (!DiskCopy.isDirectory(this.m_sZiel) && new File(this.m_sZiel).isDirectory()) {
            this.m_sZiel = this.m_sZiel + "/";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int perform(XKMGUIThread m_XKMGUIThread) {
        try {
            File fZiel = new File(this.m_sZiel);
            if (DiskCopy.isDirectory(this.m_sZiel) && !fZiel.isDirectory()) {
                LOG.error("Das Ziel-Verzeichnis " + this.m_sZiel + " existiert nicht");
                return 2;
            }
            this.sFirstCopied = null;
            int nLauf = 1;
            while (true) {
                Header header;
                if (this.m_isGUI) {
                    int nChoice;
                    if (m_XKMGUIThread != null && m_XKMGUIThread.interruptRequested()) {
                        return 3;
                    }
                    if (nLauf > 1 && (nChoice = JOptionPane.showConfirmDialog(this.parentFrame, "Bitte legen Sie die " + nLauf + ". Diskette ins Laufwerk", "Diskette lesen", 2)) == 2) {
                        return 3;
                    }
                } else {
                    LOG.info("\nBitte legen Sie die " + nLauf + ". Diskette ins Laufwerk");
                    LOG.info("und druecken dann die <Return>-Taste");
                    DiskCopy.getch();
                }
                File[] aFiles = null;
                File fQuelle = new File(this.m_sQuelle);
                aFiles = fQuelle.isFile() ? new File[]{fQuelle} : fQuelle.listFiles();
                if (aFiles == null) {
                    if (this.m_isGUI) {
                        JOptionPane.showMessageDialog(this.parentFrame, "Diskette ist nicht lesebereit", "Fehler", 0);
                        continue;
                    }
                    LOG.error("Diskette ist nicht lesebereit\n");
                    continue;
                }
                if (aFiles.length == 0) {
                    if (this.m_isGUI) {
                        JOptionPane.showMessageDialog(this.parentFrame, "Die Diskette ist leer", "Fehler", 0);
                        continue;
                    }
                    LOG.error("Die Diskette ist leer\n");
                    continue;
                }
                if (aFiles.length > 1) {
                    if (this.m_isGUI) {
                        Object[] options = new Object[]{"Fortsetzen", "Abbrechen"};
                        int nChoice = JOptionPane.showOptionDialog(this.parentFrame, "Die Diskette enth\u00e4lt mehr als eine Datei", "Warnung", -1, 2, null, options, options[0]);
                        if (nChoice != 1) continue;
                        return 3;
                    }
                    LOG.error("Die Diskette enthaelt mehr als eine Datei\n");
                    LOG.error("Wollen Sie den Fehler manuell beheben und anschliessend fortsetzen (1) oder abbrechen (2)\n");
                    byte[] buffer = new byte[255];
                    System.in.read(buffer, 0, 255);
                    if (buffer[0] != 50) continue;
                    return 3;
                }
                if (nLauf > 1 && !this.namensAbgleich(this.sFirstCopied, aFiles[0])) {
                    if (this.m_isGUI) {
                        JOptionPane.showMessageDialog(this.parentFrame, "Die Datei gehoert zu einem anderen Paket", "Fehler", 0);
                        continue;
                    }
                    LOG.error("Die Datei gehoert zu einem anderen Paket\n");
                    continue;
                }
                if (nLauf == 1) {
                    this.sFirstCopied = aFiles[0].getAbsolutePath();
                }
                if ((header = new Header()).readHeader(aFiles[0]) != 0) {
                    return 1;
                }
                int nVon = header.getHeaderPaketVon();
                int nBis = header.getHeaderPaketBis();
                if (nVon != nLauf) {
                    if (this.m_isGUI) {
                        JOptionPane.showMessageDialog(this.parentFrame, "Es wird Diskette " + nLauf + "/" + nBis + " erwartet. Dies ist Diskette " + nVon + "/" + nBis, "Fehler", 0);
                        continue;
                    }
                    LOG.error("Es wird Diskette " + nLauf + "/" + nBis + " erwartet.");
                    LOG.error("Dies ist Diskette " + nVon + "/" + nBis + ".");
                    continue;
                }
                BufferedInputStream from = null;
                FilterOutputStream to = null;
                try {
                    from = new BufferedInputStream(new FileInputStream(aFiles[0].getAbsolutePath()));
                    to = new BufferedOutputStream(new FileOutputStream(this.m_sZiel + aFiles[0].getName()));
                    if (!DiskCopy.copyLoop(from, (BufferedOutputStream)to)) {
                        int n = 4;
                        return n;
                    }
                    ++nLauf;
                }
                catch (Exception e) {
                    int n = 4;
                    return n;
                }
                finally {
                    try {
                        if (from != null) {
                            from.close();
                        }
                        if (to != null) {
                            to.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (nVon == nBis) break;
            }
            return 0;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return 5;
        }
    }

    private boolean namensAbgleich(String sFile1, File fNextFile) {
        File f = new File(sFile1);
        sFile1 = f.getName().substring(0, f.getName().length() - 4);
        String sFileN = fNextFile.getName().substring(0, fNextFile.getName().length() - 4);
        return sFile1.equals(sFileN);
    }

    public static void main(String[] args) {
        CopyBack copyBack = new CopyBack("a:\\", "c:\\tmptmp", false, true);
        copyBack.perform(null);
    }
}

