/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.splitmodul;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileSplit {
    protected String m_sFileName;
    protected String m_sZielVerzeichnis;
    protected long m_nSizeQuelle;
    protected long m_nSplitSize;
    protected boolean m_bDeleteSource;
    protected int m_nFileCounter;
    private static Logger LOG = LogManager.getLogger((String)"xkm");

    public FileSplit(String sFileName, String sZielVerzeichnis, long nSplitSize, boolean bDeleteSource) {
        this.m_sFileName = sFileName;
        this.m_sZielVerzeichnis = sZielVerzeichnis;
        this.m_nSplitSize = nSplitSize;
        this.m_bDeleteSource = bDeleteSource;
        this.m_nSizeQuelle = new File(this.m_sFileName).length();
    }

    private long copyLoop(BufferedInputStream from, File ziel, long nSize) throws IOException {
        int nBytesRead;
        boolean bNoSplit;
        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(ziel));
        this.afterOpen(to);
        long nCopied = 0L;
        boolean bl = bNoSplit = nSize <= 0L;
        while ((bNoSplit || nSize > 0L) && (nBytesRead = from.read()) != -1) {
            to.write(nBytesRead);
            --nSize;
            ++nCopied;
        }
        this.beforeClose(to);
        to.close();
        return nCopied;
    }

    protected void afterOpen(BufferedOutputStream to) {
    }

    protected void beforeClose(BufferedOutputStream to) {
    }

    private String createFilename(String baseOfFilename, int nrOfFile) {
        Object sSuffix = "000" + nrOfFile;
        sSuffix = ((String)sSuffix).substring(((String)sSuffix).length() - 3, ((String)sSuffix).length());
        return baseOfFilename + "." + (String)sSuffix;
    }

    public int perform() {
        File quelle = new File(this.m_sFileName);
        File verzeichnis = new File(this.m_sZielVerzeichnis);
        if (quelle.length() <= this.m_nSplitSize) {
            return 0;
        }
        if (this.m_sFileName.endsWith("\\") || this.m_sFileName.endsWith("/")) {
            LOG.error("1. Parameter: Pfadangabe muss eine konkreten Dateinamen beinhalten");
            return 2;
        }
        if (!quelle.isFile()) {
            LOG.error("Die Quelldatei " + quelle.getName() + " existiert nicht");
            return 2;
        }
        if (!quelle.canRead()) {
            LOG.error("Die Quelldatei " + quelle.getName() + " ist nicht lesbar");
            return 3;
        }
        if (verzeichnis.isDirectory() && !verzeichnis.exists()) {
            LOG.error("Das Zielverzeichnis " + verzeichnis + " existiert nicht");
            return 4;
        }
        try {
            File ziel;
            BufferedInputStream from = new BufferedInputStream(new FileInputStream(quelle));
            for (long nRestLen = quelle.length(); nRestLen > 0L && this.m_nFileCounter <= 999; nRestLen -= this.copyLoop(from, ziel, this.m_nSplitSize)) {
                String sFilename;
                String sPath;
                ++this.m_nFileCounter;
                if (verzeichnis.isDirectory()) {
                    sPath = verzeichnis.getPath();
                    sFilename = quelle.getName();
                } else {
                    sPath = verzeichnis.getParent();
                    sFilename = verzeichnis.getName();
                }
                ziel = quelle.length() <= this.m_nSplitSize ? new File(sPath + "/" + sFilename) : new File(sPath + "/" + this.createFilename(sFilename, this.m_nFileCounter));
                if (ziel.exists()) {
                    ziel.delete();
                }
                if (ziel.createNewFile()) continue;
                LOG.error("Fehler beim Erstellen der Datei " + ziel);
                return 5;
            }
            from.close();
            if (this.m_bDeleteSource && !quelle.delete()) {
                return 7;
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            return 6;
        }
        return 0;
    }

    public static void main(String[] args) {
        int nRetCode = 0;
        if (args.length != 3) {
            LOG.error("Aufruf: java FileSplit <EingangsDatei> <Zielverzeichnis> <GroesseSplitDateien>");
            nRetCode = 1;
        } else {
            FileSplit fileSplit = new FileSplit(args[0], args[1], Long.parseLong(args[2]), true);
            nRetCode = fileSplit.perform();
        }
        LOG.info("FileSplit mit Returncode " + nRetCode + " beendet");
        System.exit(nRetCode);
    }
}

