/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.arbeitsmodus;

import de.kbv.xkm.Schalter;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodus;
import de.kbv.xkm.arbeitsmodus.ExternerArbeitsmodus;
import de.kbv.xkm.arbeitsmodus.InternerArbeitsmodus;
import de.kbv.xkm.benutzerschluessel.XKMGUIBenutzerschluessel;
import de.kbv.xkm.krypto.KryptTyp;
import de.kbv.xkm.xml.XMLExterneArbeitsmodi;
import de.kbv.xkm.xml.XMLInterneArbeitsmodi;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class Arbeitsmodi {
    public static final int nVERSCHLUESSELUNG = 1;
    public static final int nENTSCHLUESSELUNG = 2;
    public static final int nDMPVERSCHLUESSELUNG = 3;
    public static final int nDMPENTSCHLUESSELUNG = 4;
    public static final int nKOLOSKOPIEVERSCHLUESSELUNG = 5;
    public static final int nKOLOSKOPIEENTSCHLUESSELUNG = 6;
    public static final int nABRECHNUNGSVERSCHLUESSELUNG = 7;
    public static final int nABRECHNUNGSENTSCHLUESSELUNG = 8;
    public static final int nZERVIXZYTOVERSCHLUESSELUNG = 17;
    public static final int nZERVIXZYTOENTSCHLUESSELUNG = 18;
    public static final int nWTKVerschluesselung = 21;
    public static final int nWTKEntschluesselung = 22;
    public static final int nHDRGVerschluesselung = 35;
    public static final int nHDRGEntschluesselung = 36;
    public static int nExternLfdnrBeginn = 100;
    public static final String cDMPVERSCHLUESSELUNG = "DMP_Verschluesselung";
    public static final String cKOLOSKOPIEVERSCHLUESSELUNG = "Koloskopie_Verschluesselung";
    public static final String cABRECHNUNGSVERSCHLUESSELUNG = "Abrechnungs_Verschluesselung";
    public static final String cVERSCHLUESSELUNG = "Verschluesselung";
    public static final String cDMPENTSCHLUESSELUNG = "DMP_Entschluesselung";
    public static final String cKOLOSKOPIEENTSCHLUESSELUNG = "Koloskopie_Entschluesselung";
    public static final String cABRECHNUNGSENTSCHLUESSELUNG = "Abrechnungs_Entschluesselung";
    public static final String cENTSCHLUESSELUNG = "Entschluesselung";
    public static final String cHDRGVERSCHLUESSELUNG = "HDRG_Verschluesselung";
    public static final String cHDRGENTSCHLUESSELUNG = "HDRG_Entschluesselung";
    private ArrayList m_arrArbeitsmodi = null;
    private Arbeitsmodus m_arbeitsmodus = null;
    private final Schalter m_Schalter;

    public Arbeitsmodi(Schalter schalter) {
        this.m_Schalter = schalter;
    }

    private Arbeitsmodus getArbeitsmodus(int nIndex) {
        if (this.m_arrArbeitsmodi == null) {
            throw new UnsupportedOperationException("Liste der Arbeitsmodi ist nicht initialisiert. Init-Routine aufrufen!");
        }
        for (int i = 0; i < this.m_arrArbeitsmodi.size(); ++i) {
            Arbeitsmodus arbeitsmodus = (Arbeitsmodus)this.m_arrArbeitsmodi.get(i);
            if (arbeitsmodus.m_nIndex != nIndex) continue;
            return arbeitsmodus;
        }
        throw new UnsupportedOperationException("Zugriff auf unbekannten Arbeitsmodus: '" + new Integer(nIndex).toString() + "'");
    }

    private Arbeitsmodus getArbeitsmodus(String sName) {
        if (this.m_arrArbeitsmodi == null) {
            throw new UnsupportedOperationException("Liste der Arbeitsmodi ist nicht initialisiert. Init-Routine aufrufen!");
        }
        for (int i = 0; i < this.m_arrArbeitsmodi.size(); ++i) {
            Arbeitsmodus arbeitsmodus = (Arbeitsmodus)this.m_arrArbeitsmodi.get(i);
            if (!arbeitsmodus.m_sName.equals(sName)) continue;
            return arbeitsmodus;
        }
        throw new UnsupportedOperationException("Zugriff auf unbekannten Arbeitsmodus: '" + sName + "'");
    }

    public Arbeitsmodus getAktuellerArbeitsmodus() {
        if (this.m_arbeitsmodus == null) {
            throw new UnsupportedOperationException("Aktueller Arbeitsmodus unbekannt");
        }
        return this.m_arbeitsmodus;
    }

    public void setArbeitsmodus(int nIndex) {
        this.m_arbeitsmodus = this.getArbeitsmodus(nIndex);
    }

    public void setArbeitsmodus(String sName) {
        this.m_arbeitsmodus = this.getArbeitsmodus(sName);
    }

    public String getModusName() {
        return this.getAktuellerArbeitsmodus().m_sName;
    }

    public String getModusName(int nIndex) {
        return this.getArbeitsmodus((int)nIndex).m_sName;
    }

    public int getModusIndex() {
        return this.getAktuellerArbeitsmodus().m_nIndex;
    }

    public int getModusIndex(String sName) {
        return this.getArbeitsmodus((String)sName).m_nIndex;
    }

    public String getSuffix() {
        return this.getAktuellerArbeitsmodus().m_sSuffix;
    }

    public String getSuffix(int nIndex) {
        return this.getArbeitsmodus((int)nIndex).m_sSuffix;
    }

    public String getSuffix(String sName) {
        return this.getArbeitsmodus((String)sName).m_sSuffix;
    }

    public String getStartpaketSuffix() {
        if (this.getSuffix() == null) {
            return ".XKM.001";
        }
        return this.getSuffix() + ".001";
    }

    public String getSchluesselname() {
        return this.getAktuellerArbeitsmodus().m_sSchluesselname;
    }

    public String getSchluesselname(int nIndex) {
        return this.getArbeitsmodus((int)nIndex).m_sSchluesselname;
    }

    public String getSchluesselname(String sName) {
        return this.getArbeitsmodus((String)sName).m_sSchluesselname;
    }

    public boolean istCryptModus(String sName) {
        return this.getArbeitsmodus((String)sName).m_nAllgemeinerModus == KryptTyp.Verschluesselung;
    }

    public boolean istDecryptModus(String sName) {
        return this.getArbeitsmodus((String)sName).m_nAllgemeinerModus == KryptTyp.Entschluesselung;
    }

    public boolean istDecryptModus(int nIndex) {
        return this.getArbeitsmodus((int)nIndex).m_nAllgemeinerModus == KryptTyp.Entschluesselung;
    }

    public boolean istCryptModus() {
        return this.m_arbeitsmodus != null && this.m_arbeitsmodus.m_nAllgemeinerModus == KryptTyp.Verschluesselung;
    }

    public boolean istDecryptModus() {
        return this.m_arbeitsmodus != null && this.m_arbeitsmodus.m_nAllgemeinerModus == KryptTyp.Entschluesselung;
    }

    public boolean istInternerModus(int index) {
        return this.getArbeitsmodus((int)index).m_bInternFlag;
    }

    public boolean istSystempfad(int index) {
        return this.getArbeitsmodus((int)index).m_bSystempfad;
    }

    public String makeNewFilename(String sOldName) {
        if (this.getAktuellerArbeitsmodus().m_nAllgemeinerModus == KryptTyp.Verschluesselung) {
            return sOldName + ".XKM";
        }
        if (sOldName.endsWith(".001")) {
            sOldName = sOldName.substring(0, sOldName.length() - 4);
        }
        if (sOldName.toLowerCase().endsWith(".xkm")) {
            sOldName = sOldName.substring(0, sOldName.length() - 4);
        }
        return sOldName;
    }

    public void addArbeitsmodus(String sName, KryptTyp nAllgemeinerModus, int nIndex, int nPartnerIndex, String sKeyfile, ArrayList<String> schluesselBund, String sSuffix, boolean bSystempfad, boolean bInternFlag) throws XKMException {
        if (this.m_arrArbeitsmodi == null) {
            throw new UnsupportedOperationException("Liste der Arbeitsmodi ist nicht initialisiert. Init-Routine aufrufen!");
        }
        if (schluesselBund != null && nAllgemeinerModus != KryptTyp.Entschluesselung) {
            throw new XKMException(3, "Arbeitsmodus '" + new Integer(nIndex).toString() + "': Definition mehrerer Schluessel ist nur bei Entschluesselung zulaessig");
        }
        Arbeitsmodus arbeitsmodus = new Arbeitsmodus(sName, nAllgemeinerModus, nIndex, nPartnerIndex, sKeyfile, schluesselBund, sSuffix, bSystempfad, bInternFlag);
        this.m_arrArbeitsmodi.add(arbeitsmodus);
    }

    public ArrayList getArbeitsmodiList() {
        return this.m_arrArbeitsmodi;
    }

    public boolean memberOf(String sArbeitsmodus) {
        assert (this.m_arrArbeitsmodi != null);
        for (int i = 0; i < this.m_arrArbeitsmodi.size(); ++i) {
            Arbeitsmodus am = (Arbeitsmodus)this.m_arrArbeitsmodi.get(i);
            if (!am.m_sName.equals(sArbeitsmodus)) continue;
            return true;
        }
        return false;
    }

    public boolean kompatiblerArbeitsmodus(int nEntschluesselungsmodus, int nVerschluesselungsmodus) {
        return true;
    }

    public void checkConflict() throws XKMException {
        Arbeitsmodus am;
        int i;
        HashMap hashMap = new HashMap();
        for (i = 0; i < this.m_arrArbeitsmodi.size(); ++i) {
            am = (Arbeitsmodus)this.m_arrArbeitsmodi.get(i);
            if (!am.m_bInternFlag) continue;
            hashMap.put(am.m_sName, null);
        }
        for (i = 0; i < this.m_arrArbeitsmodi.size(); ++i) {
            am = (Arbeitsmodus)this.m_arrArbeitsmodi.get(i);
            if (am.m_bInternFlag || !hashMap.containsKey(am.m_sName)) continue;
            throw new XKMException(3, "Arbeitsmodi '" + am.m_sName + "' ist bereits ein definierter Standardmodus. Bitte selbstdefinierten Schl\u00fcssel umbenennen.");
        }
    }

    private void loadExterneArbeitsmodi(String sDateiname) throws XKMException {
        XMLExterneArbeitsmodi xea = new XMLExterneArbeitsmodi(this.m_Schalter);
        xea.load(sDateiname);
        for (int i = 0; i < xea.getProperties().size(); ++i) {
            ExternerArbeitsmodus externerArbeitsmodus = (ExternerArbeitsmodus)xea.getProperties().get(i);
            externerArbeitsmodus.sSchluessel = this.m_Schalter.getSchluesselpfad() + externerArbeitsmodus.sSchluessel;
            this.addArbeitsmodus(externerArbeitsmodus.sName, externerArbeitsmodus.nTyp, nExternLfdnrBeginn++, 0, externerArbeitsmodus.sSchluessel, null, null, false, false);
        }
    }

    private void loadInterneArbeitsmodi(String sDateiname, boolean bAbfrageBenutzerkennung) throws XKMException {
        if (this.m_arrArbeitsmodi != null) {
            throw new UnsupportedOperationException("Initialisierungroutine f\u00fcr interne Arbeitsmodi darf nur einmal aufgerufen werden");
        }
        this.m_arrArbeitsmodi = new ArrayList();
        InputStream interneSchluesselInputStream = null;
        if (!(sDateiname != null && new File(sDateiname).isFile() || (interneSchluesselInputStream = this.getClass().getResourceAsStream("/System/schluesselintern.xml")) != null)) {
            throw new XKMException(3, "Die Datei zur Definition der internen Arbeitsmodi fehlt");
        }
        XMLInterneArbeitsmodi xaf = new XMLInterneArbeitsmodi();
        xaf.load(sDateiname);
        if (bAbfrageBenutzerkennung) {
            XKMGUIBenutzerschluessel initBenutzerschluessel = new XKMGUIBenutzerschluessel(true, this.m_Schalter);
            initBenutzerschluessel.start(xaf);
        }
        for (int i = 0; i < xaf.m_xmlProperties.size(); ++i) {
            InternerArbeitsmodus internerArbeitsmodus = (InternerArbeitsmodus)xaf.m_xmlProperties.get(i);
            this.addArbeitsmodus(internerArbeitsmodus.sName, internerArbeitsmodus.nTyp, internerArbeitsmodus.nLfdNr, internerArbeitsmodus.nPartnerIndex, internerArbeitsmodus.sSchluessel, internerArbeitsmodus.schluesselBund, internerArbeitsmodus.sSuffix, internerArbeitsmodus.bSystempfad, true);
        }
    }

    public void initIntern(String sInterneDatei, boolean bAbfrageBenutzerkennung) throws XKMException {
        this.loadInterneArbeitsmodi(this.m_Schalter.getSystemDir() + sInterneDatei, bAbfrageBenutzerkennung);
    }

    public void initExtern(String sExternDatei) throws XKMException {
        this.loadExterneArbeitsmodi(sExternDatei);
    }
}

