/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.benutzerschluessel;

import de.kbv.xkm.Main;
import de.kbv.xkm.Schalter;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodi;
import de.kbv.xkm.arbeitsmodus.InternerArbeitsmodus;
import de.kbv.xkm.krypto.Crypto;
import de.kbv.xkm.krypto.KryptTyp;
import de.kbv.xkm.protokoll.Protokoll;
import de.kbv.xkm.utils.Tool;
import de.kbv.xkm.xml.XMLInterneArbeitsmodi;
import gnu.getopt.Getopt;
import java.io.File;
import javax.swing.JDialog;

public class XKMBenutzerschluessel {
    private boolean m_bFirstcall = true;
    private boolean m_bDebug = false;
    private Schalter m_Schalter;

    public XKMBenutzerschluessel(Schalter schalter) {
        this.m_Schalter = schalter;
    }

    public void createDefaultSchluessel(JDialog jDialog, XMLInterneArbeitsmodi xia, String sBenutzerkennung, String sSystemverzeichnis, String sSchluesselverzeichnis) {
        String sSystemdatei = sSystemverzeichnis + "/schluesselintern.xml";
        if (xia == null) {
            xia = new XMLInterneArbeitsmodi();
            try {
                xia.load(sSystemdatei);
            }
            catch (XKMException e) {
                Tool.message(jDialog == null, jDialog, "Fehler beim \u00d6ffnen oder Parsen der XML-Datei f\u00fcr interne Arbeitsmodi");
                return;
            }
        }
        if (!xia.enthaeltBenutzermodus()) {
            String sSchluesselVerschluesselung = sBenutzerkennung + "_oeffentlicher_Schluessel.pub";
            String sSchluesselEntschluesselung = sBenutzerkennung + "_privater_Schluessel.NICHT_weitergeben.pfx";
            Tool.message(jDialog == null, null, "Generiere Schl\u00fcssel");
            int rc = new Crypto().generateKeys(sSchluesselverzeichnis, sSystemverzeichnis + "/keys", sSchluesselVerschluesselung, sSchluesselEntschluesselung);
            if (rc != 0) {
                Tool.message(jDialog == null, jDialog, "Fehler bei der Genererierung der neuen Schl\u00fcssel. Crypto-RC: " + rc);
            } else {
                InternerArbeitsmodus ia = new InternerArbeitsmodus();
                ia = new InternerArbeitsmodus();
                ia.nLfdNr = 2;
                ia.nPartnerIndex = 1;
                ia.nTyp = KryptTyp.Entschluesselung;
                ia.sName = "Entschluesselung";
                ia.sSchluessel = sSchluesselEntschluesselung;
                ia.sSuffix = "XKM";
                ia.bSystempfad = true;
                ia.bBenutzermodus = true;
                xia.m_xmlProperties.add(0, ia);
                ia = new InternerArbeitsmodus();
                ia.nLfdNr = 1;
                ia.nPartnerIndex = 2;
                ia.nTyp = KryptTyp.Verschluesselung;
                ia.sName = "Verschluesselung";
                ia.sSchluessel = sSchluesselVerschluesselung;
                ia.sSuffix = null;
                ia.bSystempfad = false;
                ia.bBenutzermodus = true;
                xia.m_xmlProperties.add(0, ia);
                if (!xia.save()) {
                    Tool.message(jDialog == null, jDialog, "Fehler beim Sichern der neuen Arbeitsmodi");
                }
            }
        } else {
            Tool.message(jDialog == null, jDialog, "Allgemeine Schl\u00fcssel bereits vorhanden. Keine Verarbeitung");
        }
    }

    private void monitor(String sFunktion, String sMeldung) {
        String sMonitorFile = "xkminstall.log";
        if (this.m_bDebug) {
            if (this.m_bFirstcall) {
                new File("xkminstall.log").delete();
                this.m_bFirstcall = false;
            }
            Tool.simpleProtocol("xkminstall.log", sFunktion + ": " + sMeldung);
        }
    }

    private void usage(String prog) {
        Tool.message(true, null, "Aufruf:   " + prog + " [Optionen]");
        Tool.message(true, null, "");
        Tool.message(true, null, "      -c        Name der Konfigurationsdatei");
        Tool.message(true, null, "      -z        Alternativer Systempfad");
        Tool.message(true, null, "      -b        Benutzerkennung");
    }

    private Kommandozeile parseKommandozeile(String prog, String[] args) throws XKMException {
        int opt;
        Kommandozeile kommandozeile = new Kommandozeile(null, null, false);
        Getopt g = new Getopt(prog, args, ":hc:b:z:d");
        g.setOpterr(false);
        block7: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 104: {
                    this.usage(prog);
                    System.exit(0);
                    return null;
                }
                case 99: {
                    kommandozeile.m_sConfig = g.getOptarg();
                    continue block7;
                }
                case 122: {
                    kommandozeile.m_sSystem = g.getOptarg();
                    continue block7;
                }
                case 98: {
                    kommandozeile.m_sBenutzerkennung = g.getOptarg();
                    continue block7;
                }
                case 100: {
                    kommandozeile.m_bDebug = true;
                    continue block7;
                }
            }
            Tool.message(true, null, "\nFehlerhafte Kommandozeile: Unbekannte oder falsch verwendete Option \"-" + (char)g.getOptopt() + "\"\n");
            this.usage(prog);
            System.exit(3);
            return null;
        }
        return kommandozeile;
    }

    public int start(String sConfig, String sSystem, String sKennung, boolean bDebug) {
        this.m_bDebug = bDebug;
        try {
            this.m_Schalter.parseKonfigurationsXML(sConfig != null ? sConfig : "Konfig/config.xml");
            this.createDefaultSchluessel(null, null, sKennung, sSystem != null ? sSystem : this.m_Schalter.getSystemPfadXML(), this.m_Schalter.getSchluesselpfadXML());
            return 0;
        }
        catch (XKMException e) {
            Tool.message(true, null, "XKMBenutzerschl\u00fcssel wegen Fehler beendet: " + e.getMessage());
            return 1;
        }
    }

    public static void main(String[] args) {
        int nRetCode = 0;
        Schalter schalter = new Schalter();
        Arbeitsmodi arbeitsmodi = new Arbeitsmodi(schalter);
        schalter.setArbeitsmodi(arbeitsmodi);
        XKMBenutzerschluessel xkmbs = new XKMBenutzerschluessel(new Schalter());
        Tool.message(true, null, "Start XKMBenutzerschl\u00fcssel");
        if (args != null) {
            try {
                int index;
                Kommandozeile kommandozeile = xkmbs.parseKommandozeile("XKMBenutzerschl\u00fcssel", args);
                if (kommandozeile == null) {
                    nRetCode = 1;
                }
                if (kommandozeile.m_sBenutzerkennung == null) {
                    nRetCode = 1;
                    Tool.message(true, null, "Parameter -b (=Benutzerkennung) muss gesetzt werden\n");
                    xkmbs.usage("XKMBenutzerkennung");
                }
                if (nRetCode == 0 && (index = Tool.pruefeDateinamen(kommandozeile.m_sBenutzerkennung)) != -1) {
                    nRetCode = 1;
                    Tool.message(true, null, "Benutzerkennung enth\u00e4lt ung\u00fcltiges Zeichen:'" + kommandozeile.m_sBenutzerkennung.charAt(index) + "'\n");
                }
                if (nRetCode == 0) {
                    xkmbs.monitor("main", "Kommandozeile ausgewertet");
                    nRetCode = xkmbs.start(kommandozeile.m_sConfig, kommandozeile.m_sSystem, kommandozeile.m_sBenutzerkennung, kommandozeile.m_bDebug);
                }
            }
            catch (XKMException e) {
                nRetCode = e.getCode();
                Protokoll protokoll = new Protokoll(schalter, arbeitsmodi);
                protokoll.setException(e.getMessage());
                protokoll.create(nRetCode, "Benutzerkennung mit Fehler " + nRetCode + " beendet\n" + e.getMessage());
                Tool.message(true, null, "Fehlercode: " + nRetCode + ". " + e.getMessage());
            }
        } else {
            xkmbs.usage("XKMBenutzerkennung");
            nRetCode = 1;
        }
        Main.systemExit(nRetCode);
    }

    private class Kommandozeile {
        String m_sConfig;
        String m_sSystem;
        String m_sBenutzerkennung;
        boolean m_bDebug;

        Kommandozeile(String sConfig, String sKennung, boolean bDebug) {
            this.m_sConfig = sConfig;
            this.m_sBenutzerkennung = sKennung;
            this.m_bDebug = bDebug;
        }
    }
}

