/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.extern;

import de.kbv.xkm.Main;
import de.kbv.xkm.Schalter;
import de.kbv.xkm.Steuerung;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodi;
import de.kbv.xkm.protokoll.Protokoll;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XKMEinstieg {
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    private String m_sKonfigDatei = null;
    private String m_sQuelle = null;
    private String m_sArbeitsmodus = null;
    private boolean m_bServer = false;
    private boolean m_bEinzelLaufVerzeichnis = false;
    private boolean m_bLoeschen = false;
    private String m_sSchluesselpfad = null;
    private String m_sProtokolldatei = null;
    private String m_sAusschusspfad = null;
    private String m_sVerschluesseltpfad = null;
    private String m_sEntschluesseltpfad = null;
    private String m_sSystempfad = null;
    private String m_sDiskette = null;
    private String m_sPaketgroesse = null;
    private String m_sProtokollformat = null;
    private boolean m_bDiskettenpruefung = false;
    private String m_sPruefinfo = null;
    private String m_sKonfigDialog = null;
    private String m_sExterneArbeitsmodi = null;
    private Arbeitsmodi m_Arbeitsmodi;

    public XKMEinstieg(String sConfigFile) {
        this.setKonfigurationsdatei(sConfigFile);
    }

    public XKMEinstieg() {
        this.setKonfigurationsdatei("Konfig/config.xml");
    }

    public void setKonfigurationsdatei(String sKonfigDatei) {
        this.m_sKonfigDatei = sKonfigDatei;
    }

    public String getKonfigurationsdatei() {
        return this.m_sKonfigDatei;
    }

    public void setQuelle(String sQuelle) {
        this.m_sQuelle = sQuelle;
    }

    public String getQuelle() {
        return this.m_sQuelle;
    }

    public void setArbeitsmodus(String sArbeitsmodus) {
        this.m_sArbeitsmodus = sArbeitsmodus;
    }

    public void setArbeitsmodus(int nArbeitsmodus) {
        this.m_sArbeitsmodus = this.m_Arbeitsmodi.getModusName(nArbeitsmodus);
    }

    public String getArbeitsmodus() {
        return this.m_sArbeitsmodus;
    }

    public void setServer(boolean bServer) {
        this.m_bServer = bServer;
    }

    public boolean getServer() {
        return this.m_bServer;
    }

    public void setEinzelLaufVerzeichnis(boolean bEinzelLaufVerzeichnis) {
        this.m_bEinzelLaufVerzeichnis = bEinzelLaufVerzeichnis;
    }

    public boolean getEinzelLaufVerzeichnis() {
        return this.m_bEinzelLaufVerzeichnis;
    }

    public void setLoeschen(boolean bLoeschen) {
        this.m_bLoeschen = bLoeschen;
    }

    public boolean getLoeschen() {
        return this.m_bLoeschen;
    }

    public void setSchluesselpfad(String sSchluesselpfad) {
        this.m_sSchluesselpfad = sSchluesselpfad;
    }

    public String getSchluesselpfad() {
        return this.m_sSchluesselpfad;
    }

    public void setProtokolldatei(String sSchluesselpfad) {
        this.m_sProtokolldatei = sSchluesselpfad;
    }

    public String getProtokolldatei() {
        return this.m_sProtokolldatei;
    }

    public void setAusschusspfad(String sAusschusspfad) {
        this.m_sAusschusspfad = sAusschusspfad;
    }

    public String getAusschusspfad() {
        return this.m_sAusschusspfad;
    }

    public void setVerschluesseltpfad(String sVerschluesseltpfad) {
        this.m_sVerschluesseltpfad = sVerschluesseltpfad;
    }

    public String getVerschluesseltpfad() {
        return this.m_sVerschluesseltpfad;
    }

    public void setEntschluesseltpfad(String sEntschluesseltpfad) {
        this.m_sEntschluesseltpfad = sEntschluesseltpfad;
    }

    public String getEntschluesseltpfad() {
        return this.m_sEntschluesseltpfad;
    }

    public void setSystempfad(String sSystempfad) {
        this.m_sSystempfad = sSystempfad;
    }

    public String getSystempfad() {
        return this.m_sSystempfad;
    }

    public void setDiskettenpruefung(boolean bDiskettenpruefung) {
        this.m_bDiskettenpruefung = bDiskettenpruefung;
    }

    public boolean getDiskettenpruefung() {
        return this.m_bDiskettenpruefung;
    }

    public void setDiskette(String sDiskette) {
        this.m_sDiskette = sDiskette;
    }

    public String getDiskette() {
        return this.m_sDiskette;
    }

    public void setPaketgroesse(String sPaketgroesse) {
        this.m_sPaketgroesse = sPaketgroesse;
    }

    public String getPaketgroesse() {
        return this.m_sPaketgroesse;
    }

    public void setProtokollformat(String sProtokollformat) {
        this.m_sProtokollformat = sProtokollformat;
    }

    public String getProtokollformat() {
        return this.m_sProtokollformat;
    }

    public void setPruefinfo(String sPruefinfo) {
        this.m_sPruefinfo = sPruefinfo;
    }

    public String getPruefinfo() {
        return this.m_sPruefinfo;
    }

    public void setKonfigDialog(String sKonfigDialog) {
        this.m_sKonfigDialog = sKonfigDialog;
    }

    public String getKonfigDialog() {
        return this.m_sKonfigDialog;
    }

    public void setExterneArbeitsmodi(String sExterneArbeitsmodi) {
        this.m_sExterneArbeitsmodi = sExterneArbeitsmodi;
    }

    public String getExterneArbeitsmodi() {
        return this.m_sExterneArbeitsmodi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws XKMException {
        int nRetCode = 0;
        Schalter schalter = new Schalter();
        Arbeitsmodi m_Arbeitsmodi = new Arbeitsmodi(schalter);
        schalter.setArbeitsmodi(m_Arbeitsmodi);
        Protokoll protokoll = new Protokoll(schalter, m_Arbeitsmodi);
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            try {
                schalter.setKonfigDatei(this.getKonfigurationsdatei());
                schalter.setQuellpfad(this.getQuelle());
                schalter.setArbeitsModus(this.getArbeitsmodus());
                schalter.setServerModus(this.getServer());
                schalter.setEinzelLaufVerzeichnis(this.getEinzelLaufVerzeichnis());
                schalter.setLoeschModus(this.getLoeschen());
                schalter.setSchluesselpfad(this.getSchluesselpfad());
                schalter.setProtokollDatei(this.getProtokolldatei());
                schalter.setAusschusspfad(this.getAusschusspfad());
                schalter.setVerschluesseltpfad(this.getVerschluesseltpfad());
                schalter.setEntschluesseltpfad(this.getEntschluesseltpfad());
                schalter.setSystempfad(this.getSystempfad());
                schalter.setPaketgroesse(this.getPaketgroesse());
                schalter.setProtokollFormat(this.getProtokollformat());
                schalter.setPruefinfo(this.getPruefinfo());
                schalter.setKonfigDialog(this.getKonfigDialog());
                schalter.setExternArbeitsmodi(this.getExterneArbeitsmodi());
                Main.initXKM(null, schalter, m_Arbeitsmodi, false);
                Steuerung steuerung = new Steuerung();
                nRetCode = steuerung.run(schalter, m_Arbeitsmodi, protokoll);
                protokoll.create(nRetCode, "Kryptomodul mit Returncode " + nRetCode + " beendet");
            }
            catch (XKMException ex) {
                nRetCode = ex.getCode();
                protokoll.create(nRetCode, "Kryptomodul mit Fehler " + nRetCode + " beendet\n" + ex.getMessage());
                throw ex;
            }
        }
        return nRetCode;
    }

    public static void main(String[] args) {
        XKMEinstieg xkm = new XKMEinstieg();
        int nRetCode = 0;
        LOG.info("Kryptomodul ueber XKMEinstieg2 gestartet");
        try {
            xkm.setQuelle("quelle/beispiel_daten.zip");
            xkm.setProtokolldatei("listen/MeinProtokoll");
            xkm.setProtokollformat("XLS");
            xkm.setArbeitsmodus("Verschluesselung");
            nRetCode = xkm.start();
            LOG.info("Kryptomodul mit Returncode " + nRetCode + " beendet");
        }
        catch (XKMException ex) {
            nRetCode = ex.getCode();
            LOG.error("Fehlercode: " + nRetCode + ". " + ex.getMessage());
        }
    }
}

