/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.gui;

import de.kbv.xkm.Main;
import de.kbv.xkm.Schalter;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodi;
import de.kbv.xkm.gui.XKMGUIAbout;
import de.kbv.xkm.gui.XKMGUIOptionen;
import de.kbv.xkm.gui.XKMGUIThread;
import de.kbv.xkm.krypto.Crypto;
import de.kbv.xkm.protokoll.Protokoll;
import de.kbv.xkm.utils.Tool;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XKMGUI
extends JFrame {
    private static Logger LOG = LogManager.getLogger((String)"xkm");
    public String m_sMainInputDir;
    private final XKMGUI thisFrame;
    private final Schalter m_Schalter;
    private final Arbeitsmodi m_Arbeitsmodi;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu jMenuDatei = null;
    private JMenu jMenuEdit = null;
    private JMenu jMenuHelp = null;
    private JMenu jMenuAnsicht = null;
    private JPanel jPanel = null;
    private JMenuItem jMenuItemExit = null;
    private JMenuItem jMenuItemSelect = null;
    private JMenuItem jMenuItemStarten = null;
    private JMenuItem jMenuItemAbbrechen = null;
    private JMenuItem jMenuItemHilfe = null;
    private JMenuItem jMenuItemInfo = null;
    private JMenuItem jMenuItemLizenzvereinbarung = null;
    private JMenuItem jMenuItemOptionen = null;
    private JMenuItem jMenuItemProtokoll = null;
    private JPanel jPanelSelect = null;
    public JTextField jTextField = null;
    private JButton jButtonSelect = null;
    private JPanel jPanelStatus = null;
    private JLabel jLabelStatus = null;
    private JLabel jLabelInfo = null;
    public JLabel jLabelStatus2 = null;
    public JLabel jLabelInfo2 = null;
    private JPanel jPanelAktion = null;
    public JButton jButtonStarten = null;
    private JButton jButtonAbbrechen = null;
    private JLabel jLabelModus = null;
    public JLabel jLabelModus2 = null;
    XKMGUIThread mt;
    String sQuellPfadSave;

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            try {
                this.jJMenuBar = new JMenuBar();
                this.jJMenuBar.add(this.getJMenuDatei());
                this.jJMenuBar.add(this.getJMenuEdit());
                this.jJMenuBar.add(this.getJMenuAnsicht());
                this.jJMenuBar.add(this.getJMenuHelp());
                this.getJMenuDatei().add(this.getJMenuItemExit());
                this.getJMenuEdit().add(this.getJMenuItemSelect());
                this.getJMenuEdit().addSeparator();
                this.getJMenuEdit().add(this.getJMenuItemStarten());
                this.getJMenuEdit().add(this.getJMenuItemAbbrechen());
                this.getJMenuEdit().addSeparator();
                this.getJMenuEdit().add(this.getJMenuItemOptionen());
                this.getJMenuAnsicht().add(this.getJMenuItemProtokoll());
                this.getJMenuHelp().add(this.getJMenuItemHilfe());
                this.getJMenuHelp().add(this.getJMenuItemInfo());
                this.getJMenuHelp().add(this.getJMenuItemLizenzvereinbarung());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jJMenuBar;
    }

    private JMenu getJMenuDatei() {
        if (this.jMenuDatei == null) {
            try {
                this.jMenuDatei = new JMenu();
                this.jMenuDatei.setText("Datei");
                this.jMenuDatei.setMnemonic('D');
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuDatei;
    }

    private JMenu getJMenuEdit() {
        if (this.jMenuEdit == null) {
            try {
                this.jMenuEdit = new JMenu();
                this.jMenuEdit.setText("Bearbeitung");
                this.jMenuEdit.setMnemonic('B');
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuEdit;
    }

    private JMenu getJMenuHelp() {
        if (this.jMenuHelp == null) {
            try {
                this.jMenuHelp = new JMenu();
                this.jMenuHelp.setText("Hilfe");
                this.jMenuHelp.setMnemonic('H');
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuHelp;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            try {
                this.jPanel = new JPanel();
                this.jPanel.setLayout(null);
                this.jPanel.setBorder(new EtchedBorder());
                this.jPanel.setBounds(0, 0, 330, 300);
                this.jPanel.add((Component)this.getJPanelSelect(), null);
                this.jPanel.add((Component)this.getJPanelStatus(), null);
                this.jPanel.add((Component)this.getJPanelAktion(), null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jPanel;
    }

    private JMenuItem getJMenuItemExit() {
        if (this.jMenuItemSelect == null) {
            try {
                this.jMenuItemExit = new JMenuItem();
                this.jMenuItemExit.setText("Beenden");
                this.jMenuItemExit.setMnemonic('B');
                this.jMenuItemExit.setToolTipText("Beendet das KBV-Pr\u00fcfmodul");
                this.jMenuItemExit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Main.systemExit(0);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemExit;
    }

    private JMenuItem getJMenuItemSelect() {
        if (this.jMenuItemSelect == null) {
            try {
                this.jMenuItemSelect = new JMenuItem();
                this.jMenuItemSelect.setText("Datei selektieren...");
                this.jMenuItemSelect.setMnemonic('D');
                this.jMenuItemSelect.setToolTipText("Ausw\u00e4hlen einer Datei");
                this.jMenuItemSelect.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUI.this.actionSelected();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemSelect;
    }

    public JMenuItem getJMenuItemStarten() {
        if (this.jMenuItemStarten == null) {
            try {
                this.jMenuItemStarten = new JMenuItem();
                this.jMenuItemStarten.setText("Starten");
                this.jMenuItemStarten.setMnemonic('S');
                this.jMenuItemStarten.setToolTipText("Starten der Ver-/Entschl\u00fcsselung");
                this.jMenuItemStarten.setEnabled(false);
                this.jMenuItemStarten.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUI.this.actionStarted();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemStarten;
    }

    private JMenuItem getJMenuItemAbbrechen() {
        if (this.jMenuItemAbbrechen == null) {
            try {
                this.jMenuItemAbbrechen = new JMenuItem();
                this.jMenuItemAbbrechen.setText("Abbrechen");
                this.jMenuItemAbbrechen.setMnemonic('A');
                this.jMenuItemAbbrechen.setToolTipText("Bricht die laufende Ver-/Entschl\u00fcsselung ab");
                this.jMenuItemAbbrechen.setEnabled(false);
                this.jMenuItemAbbrechen.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUI.this.actionCanceled();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemAbbrechen;
    }

    private JMenuItem getJMenuItemHilfe() {
        if (this.jMenuItemHilfe == null) {
            try {
                this.jMenuItemHilfe = new JMenuItem();
                this.jMenuItemHilfe.setText("Hilfe");
                this.jMenuItemHilfe.setMnemonic('H');
                this.jMenuItemHilfe.setToolTipText("Zeigt die Hilfe");
                this.jMenuItemHilfe.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUI.this.showPdf("Doku/KBV_ITA_AHEX_Handbuch_Kryptomodul.pdf");
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemHilfe;
    }

    private JMenuItem getJMenuItemInfo() {
        if (this.jMenuItemInfo == null) {
            try {
                this.jMenuItemInfo = new JMenuItem();
                this.jMenuItemInfo.setText("Info");
                this.jMenuItemInfo.setMnemonic('I');
                this.jMenuItemInfo.setToolTipText("Info \u00fcber das KBV Verschl\u00fcsselungsmodul");
                this.jMenuItemInfo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUIAbout guiAbout = new XKMGUIAbout(XKMGUI.this.thisFrame);
                        guiAbout.setVisible(true);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemInfo;
    }

    private JMenuItem getJMenuItemLizenzvereinbarung() {
        if (this.jMenuItemLizenzvereinbarung == null) {
            try {
                this.jMenuItemLizenzvereinbarung = new JMenuItem();
                this.jMenuItemLizenzvereinbarung.setText("Lizenzvereinbarung");
                this.jMenuItemLizenzvereinbarung.setMnemonic('L');
                this.jMenuItemLizenzvereinbarung.setToolTipText("Lizenzvereinbarung der KBV");
                this.jMenuItemLizenzvereinbarung.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUI.this.showPdf("Doku/Lizenzvereinbarung.pdf");
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemLizenzvereinbarung;
    }

    private JPanel getJPanelSelect() {
        if (this.jPanelSelect == null) {
            try {
                this.jPanelSelect = new JPanel();
                this.jPanelSelect.setLayout(null);
                this.jPanelSelect.setBorder(new TitledBorder(new EtchedBorder(), "Datei selektieren", 0, 0, new Font("Dialog", 1, 11)));
                this.jPanelSelect.add((Component)this.getJButtonSelect(), null);
                this.jPanelSelect.setBounds(12, 16, 307, 60);
                this.jPanelSelect.add((Component)this.getJTextField(), null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jPanelSelect;
    }

    private JPanel getJPanelStatus() {
        if (this.jPanelStatus == null) {
            try {
                this.jLabelModus = new JLabel();
                this.jLabelModus.setFont(new Font("Dialog", 0, 12));
                this.jLabelModus.setBounds(15, 23, 58, 16);
                this.jLabelModus.setText("Modus:");
                this.jLabelStatus = new JLabel();
                this.jLabelStatus.setFont(new Font("Dialog", 0, 12));
                this.jLabelStatus.setBounds(15, 50, 58, 16);
                this.jLabelStatus.setText("Status:");
                this.jLabelInfo = new JLabel();
                this.jLabelInfo.setFont(new Font("Dialog", 0, 12));
                this.jLabelInfo.setBounds(15, 77, 58, 16);
                this.jLabelInfo.setText("Info:");
                this.jLabelModus2 = new JLabel();
                this.jLabelModus2.setFont(new Font("Dialog", 0, 12));
                this.jLabelModus2.setBounds(85, 24, 204, 16);
                this.jLabelModus2.setText("");
                this.jLabelStatus2 = new JLabel();
                this.jLabelStatus2.setFont(new Font("Dialog", 0, 12));
                this.jLabelStatus2.setBounds(85, 51, 204, 16);
                this.jLabelStatus2.setText("-");
                this.jLabelInfo2 = new JLabel();
                this.jLabelInfo2.setFont(new Font("Dialog", 0, 12));
                this.jLabelInfo2.setBounds(85, 78, 204, 15);
                this.jLabelInfo2.setText("-");
                this.jPanelStatus = new JPanel();
                this.jPanelStatus.setLayout(null);
                this.jPanelStatus.setBounds(12, 94, 307, 109);
                this.jPanelStatus.setBorder(new TitledBorder(new EtchedBorder(), "Status ", 0, 0, new Font("Status", 1, 11)));
                this.jPanelStatus.add((Component)this.jLabelStatus, null);
                this.jPanelStatus.add((Component)this.jLabelInfo, null);
                this.jPanelStatus.add((Component)this.jLabelInfo2, null);
                this.jPanelStatus.add((Component)this.jLabelModus, null);
                this.jPanelStatus.add((Component)this.jLabelModus2, null);
                this.jPanelStatus.add((Component)this.jLabelStatus2, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jPanelStatus;
    }

    private JPanel getJPanelAktion() {
        if (this.jPanelAktion == null) {
            try {
                this.jPanelAktion = new JPanel();
                this.jPanelAktion.setLayout(null);
                this.jPanelAktion.setBounds(13, 221, 307, 61);
                this.jPanelAktion.setBorder(new TitledBorder(new EtchedBorder(), "Aktion", 0, 0, new Font("Dialog", 1, 11)));
                this.jPanelAktion.add((Component)this.getJButtonStarten(), null);
                this.jPanelAktion.add((Component)this.getJButtonAbbrechen(), null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jPanelAktion;
    }

    private JTextField getJTextField() {
        if (this.jTextField == null) {
            try {
                this.jTextField = new JTextField();
                this.jTextField.setBounds(16, 27, 235, 20);
                this.jTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        XKMGUI.this.jButtonStarten.setEnabled(true);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jTextField;
    }

    private JButton getJButtonSelect() {
        if (this.jButtonSelect == null) {
            try {
                this.jButtonSelect = new JButton();
                this.jButtonSelect.setBounds(256, 26, 34, 21);
                this.jButtonSelect.setText("...");
                this.jButtonSelect.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUI.this.actionSelected();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jButtonSelect;
    }

    private JButton getJButtonStarten() {
        if (this.jButtonStarten == null) {
            try {
                XKMGUI xkmgui = this;
                this.jButtonStarten = new JButton();
                this.jButtonStarten.setEnabled(false);
                this.jButtonStarten.setText("Starten");
                this.jButtonStarten.setBounds(55, 22, 78, 26);
                this.jButtonStarten.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUI.this.actionStarted();
                    }
                });
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return this.jButtonStarten;
    }

    public JButton getJButtonAbbrechen() {
        if (this.jButtonAbbrechen == null) {
            try {
                this.jButtonAbbrechen = new JButton();
                this.jButtonAbbrechen.setEnabled(true);
                this.jButtonAbbrechen.setText("Beenden");
                this.jButtonAbbrechen.setBounds(159, 22, 96, 26);
                this.jButtonAbbrechen.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String s = XKMGUI.this.jButtonAbbrechen.getText();
                        if (s.equalsIgnoreCase("abbrechen")) {
                            XKMGUI.this.actionCanceled();
                        } else {
                            Main.systemExit(0);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jButtonAbbrechen;
    }

    public JMenuItem getJMenuItemOptionen() {
        if (this.jMenuItemOptionen == null) {
            try {
                this.jMenuItemOptionen = new JMenuItem();
                this.jMenuItemOptionen.setEnabled(this.m_Schalter.getKonfigDialogB());
                this.jMenuItemOptionen.setText("Optionen...");
                this.jMenuItemOptionen.setMnemonic('O');
                this.jMenuItemOptionen.setToolTipText("Einstellungen des XKM setzen");
                this.jMenuItemOptionen.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        XKMGUIOptionen guioptio = new XKMGUIOptionen(XKMGUI.this.thisFrame, XKMGUI.this.m_Schalter, XKMGUI.this.m_Arbeitsmodi);
                        guioptio.setVisible(true);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemOptionen;
    }

    private JMenu getJMenuAnsicht() {
        if (this.jMenuAnsicht == null) {
            try {
                this.jMenuAnsicht = new JMenu();
                this.jMenuAnsicht.setText("Ansicht");
                this.jMenuAnsicht.setMnemonic('A');
                this.jMenuAnsicht.addMenuListener(new MenuListener(){

                    @Override
                    public void menuSelected(MenuEvent e) {
                        if (XKMGUI.this.m_Schalter.getProtokollFormat() == null || !XKMGUI.this.m_Schalter.getProtokollFormat().equalsIgnoreCase("PDF")) {
                            XKMGUI.this.getJMenuItemProtokoll().setEnabled(false);
                        }
                    }

                    @Override
                    public void menuDeselected(MenuEvent e) {
                    }

                    @Override
                    public void menuCanceled(MenuEvent e) {
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuAnsicht;
    }

    public JMenuItem getJMenuItemProtokoll() {
        if (this.jMenuItemProtokoll == null) {
            try {
                this.jMenuItemProtokoll = new JMenuItem();
                this.jMenuItemProtokoll.setText("XKM-Bericht");
                this.jMenuItemProtokoll.setSize(new Dimension(93, 21));
                this.jMenuItemProtokoll.setMnemonic('B');
                this.jMenuItemProtokoll.setToolTipText("Protokoll zur letzten Aktion anzeigen");
                this.jMenuItemProtokoll.setEnabled(false);
                this.jMenuItemProtokoll.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (XKMGUI.this.m_Schalter.getProtokollFormat() != null && XKMGUI.this.m_Schalter.getProtokollFormat().equalsIgnoreCase("PDF")) {
                            Object sProtokollname = XKMGUI.this.m_Schalter.getProtokollDatei();
                            if (!Tool.endsWithIgnoreCase((String)sProtokollname, ".pdf")) {
                                sProtokollname = (String)sProtokollname + ".pdf";
                            }
                            if (!new File((String)sProtokollname).exists()) {
                                JOptionPane.showConfirmDialog(XKMGUI.this.thisFrame, "Aktuelles Protokoll in PDF-Format nicht vorhanden", "Kryptomodul", -1, 0);
                            } else {
                                XKMGUI.this.showPdf((String)sProtokollname);
                            }
                        } else {
                            JOptionPane.showConfirmDialog(XKMGUI.this.thisFrame, "PDF-Protokollierung nicht aktiv", "Kryptomodul", -1, 0);
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.jMenuItemProtokoll;
    }

    private void showPdf(String sPath) {
        try {
            Desktop.getDesktop().open(new File(sPath));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            int javaVersion = Runtime.version().version().get(0);
            if (javaVersion < 17) {
                LOG.warn("Auf Ihrem System ist eine Java Version kleiner 17 installiert. In der naechsten Version des Kryptomoduls wird diese Version nicht mehr unterstuetzt und das Kryptomodul wird dann nicht mehr starten.");
            }
        }
        catch (Exception javaVersion) {
            // empty catch block
        }
        XKMGUI xkmgui = new XKMGUI(args);
    }

    public XKMGUI(String[] args) {
        Main.cVERSION = Main.getVersionQuietly(Main.cVERSION);
        this.m_Schalter = new Schalter();
        this.m_Arbeitsmodi = new Arbeitsmodi(this.m_Schalter);
        this.m_Schalter.setArbeitsmodi(this.m_Arbeitsmodi);
        Protokoll protokoll = new Protokoll(this.m_Schalter, this.m_Arbeitsmodi);
        try {
            Main.initXKM(args, this.m_Schalter, this.m_Arbeitsmodi, true);
            if (this.m_Schalter.getServerModus()) {
                throw new XKMException(3, "Servermodus ('-s') und GUI-Betrieb schliessen sich aus");
            }
            Crypto.initBouncyCastle();
        }
        catch (XKMException e) {
            int nRetCode = e.getCode();
            LOG.error(e.getMessage());
            protokoll.setException(e.getMessage());
            protokoll.create(nRetCode, "Kryptomodul mit Returncode " + nRetCode + " beendet");
            Main.systemExit(nRetCode);
        }
        this.thisFrame = this;
        Main.parentFrame = this;
        this.initialize();
        this.m_sMainInputDir = this.m_Arbeitsmodi.istCryptModus() ? this.m_Schalter.getQuelle() : this.m_Schalter.getVerschluesseltpfad();
        this.setVisible(true);
    }

    private void initialize() {
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(337, 351);
        Tool.setLookAndFeel(this);
        Tool.centerFrame(this);
        this.setContentPane(this.getJContentPane());
        this.setTitle("KBV-Kryptomodul XKM " + Main.cVERSION);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.jLabelModus2.setText(this.m_Arbeitsmodi.getModusName());
        if (new File(this.m_Schalter.getQuelle()).isFile()) {
            this.jTextField.setText(this.m_Schalter.getQuelle());
            this.getJButtonStarten().setEnabled(true);
            this.getJMenuItemStarten().setEnabled(true);
        }
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.getJPanel(), null);
        }
        return this.jContentPane;
    }

    void actionSelected() {
        int returnVal;
        MyFileChooser fc = new MyFileChooser(this.m_sMainInputDir);
        if (this.m_Arbeitsmodi.getSuffix() != null) {
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    if (XKMGUI.this.m_Arbeitsmodi.istDecryptModus() && f.getName().toLowerCase().endsWith(XKMGUI.this.m_Arbeitsmodi.getStartpaketSuffix().toLowerCase())) {
                        return true;
                    }
                    return Tool.endsWithIgnoreCase(f.getName().toLowerCase(), XKMGUI.this.m_Arbeitsmodi.getSuffix());
                }

                @Override
                public String getDescription() {
                    if (XKMGUI.this.m_Arbeitsmodi.istCryptModus()) {
                        return "Verschl\u00fcsselbare Dateien   (." + XKMGUI.this.m_Arbeitsmodi.getSuffix() + ")";
                    }
                    return "Entschl\u00fcsselbare Dateien   (." + XKMGUI.this.m_Arbeitsmodi.getSuffix() + " | ." + XKMGUI.this.m_Arbeitsmodi.getStartpaketSuffix() + ")";
                }
            });
        }
        if ((returnVal = fc.showOpenDialog(this)) == 0) {
            File file = fc.getSelectedFile();
            this.jTextField.setText(file.getAbsolutePath());
            this.jLabelStatus2.setText("Noch nicht gelaufen");
            this.jLabelInfo2.setText("-");
            this.getJMenuItemStarten().setEnabled(true);
            this.jButtonStarten.setEnabled(true);
        }
    }

    void actionStarted() {
        this.sQuellPfadSave = this.m_Schalter.getQuelle();
        this.m_Schalter.setQuellpfad(this.jTextField.getText());
        File file = new File(this.m_Schalter.getQuelle());
        if (!file.isFile()) {
            JOptionPane.showMessageDialog(this, "Die Datei ist ung\u00fcltig.\nBitte geben Sie eine g\u00fcltige Datei ein!", "Kryptomodul", 1);
            return;
        }
        this.guiWaehrendBusy();
        this.jLabelInfo2.setText("-");
        this.jLabelStatus2.setText("In Bearbeitung ...");
        this.mt = new XKMGUIThread(this, this.m_Schalter, this.m_Arbeitsmodi, new Protokoll(this.m_Schalter, this.m_Arbeitsmodi));
        this.mt.start();
    }

    void actionCanceled() {
        this.mt.interrupt();
        this.getJMenuItemAbbrechen().setEnabled(false);
    }

    public void guiWaehrendIdle() {
        if (this.m_Schalter.getProtokollFormat() != null && this.m_Schalter.getProtokollFormat().equalsIgnoreCase("PDF")) {
            this.getJMenuItemProtokoll().setEnabled(true);
        }
        this.getJButtonStarten().setEnabled(true);
        this.getJButtonAbbrechen().setText("Beenden");
        this.getJMenuItemStarten().setEnabled(true);
        this.getJMenuItemAbbrechen().setEnabled(false);
        this.getJMenuItemSelect().setEnabled(true);
        this.getJMenuItemOptionen().setEnabled(this.m_Schalter.getKonfigDialogB());
        this.getJButtonSelect().setEnabled(true);
        this.getJTextField().setEnabled(true);
        this.m_Schalter.setQuellpfad(this.sQuellPfadSave);
    }

    public void guiWaehrendBusy() {
        this.getJMenuItemProtokoll().setEnabled(false);
        this.getJButtonStarten().setEnabled(false);
        this.getJButtonAbbrechen().setText("Abbrechen");
        this.getJMenuItemStarten().setEnabled(false);
        this.getJMenuItemAbbrechen().setEnabled(true);
        this.getJMenuItemSelect().setEnabled(false);
        this.getJMenuItemOptionen().setEnabled(false);
        this.getJButtonSelect().setEnabled(false);
        this.getJTextField().setEnabled(false);
    }

    public static boolean istFolgePaket(String sFilename) {
        if ((sFilename = sFilename.toUpperCase()).endsWith(".XKM.001") || sFilename.length() < 8) {
            return false;
        }
        String sRight = Tool.right(sFilename, 8);
        if (!sRight.startsWith(".XKM.")) {
            return false;
        }
        return Character.isDigit((sRight = Tool.right(sRight, 3)).charAt(0)) && Character.isDigit(sRight.charAt(1)) && Character.isDigit(sRight.charAt(2));
    }

    private class MyFileChooser
    extends JFileChooser {
        public MyFileChooser(String baseDir) {
            super(baseDir);
        }

        @Override
        public void approveSelection() {
            int nWahl;
            if (XKMGUI.this.m_Arbeitsmodi.istDecryptModus() && XKMGUI.istFolgePaket(this.getSelectedFile().toString()) && (nWahl = JOptionPane.showConfirmDialog(this, "Es handelt sich bei dieser Datei wahrscheinlich um ein\nFolgepaket, welches nicht einzeln verarbeitet werden kann.\nWollen Sie die Datei trotzdem im gew\u00e4hlten Modus bearbeiten?", "Warnung, Folgepaket!", 2)) != 0) {
                return;
            }
            if (!XKMGUI.this.m_Arbeitsmodi.getModusName().equals("HDRG_Verschluesselung") && XKMGUI.this.m_Arbeitsmodi.memberOf("Abrechnungs_Verschluesselung") && Tool.endsWithIgnoreCase(this.getSelectedFile().toString(), ".con") && !XKMGUI.this.m_Arbeitsmodi.getModusName().equals(XKMGUI.this.m_Arbeitsmodi.getModusName(7)) && (nWahl = JOptionPane.showConfirmDialog(this, "F\u00fcr Dateien mit Endung '-con' existiert ein eigener Modus!\nWollen Sie die Datei trotzdem im gew\u00e4hlten Modus bearbeiten?", "Warnung! Falscher Modus f\u00fcr 'Con'-Datei?", 2)) != 0) {
                return;
            }
            super.approveSelection();
        }
    }
}

