/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.gui;

import de.kbv.xkm.Schalter;
import de.kbv.xkm.Steuerung;
import de.kbv.xkm.XKMException;
import de.kbv.xkm.arbeitsmodus.Arbeitsmodi;
import de.kbv.xkm.gui.XKMGUI;
import de.kbv.xkm.protokoll.Protokoll;
import java.awt.Cursor;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XKMGUIThread
extends Thread {
    public XKMGUI gui;
    boolean bStopped;
    Schalter m_Schalter;
    Arbeitsmodi m_Arbeitsmodi;
    Protokoll m_Protokoll;
    boolean bInterruptRequested;
    private static Logger LOG = LogManager.getLogger((String)"xkm");

    public XKMGUIThread(XKMGUI gui, Schalter schalter, Arbeitsmodi arbeitsmodi, Protokoll protokoll) {
        this.gui = gui;
        this.m_Schalter = schalter;
        this.m_Arbeitsmodi = arbeitsmodi;
        this.m_Protokoll = protokoll;
    }

    private void failureInfo(int nRetCode, String sMessage) {
        this.m_Protokoll.create(nRetCode, "Kryptomodul mit Fehler " + nRetCode + " beendet\n" + sMessage);
        if (sMessage != null) {
            LOG.error("Fehlercode: " + nRetCode + ". " + sMessage);
        }
        String sFehler = XKMException.getErrorText(nRetCode);
        this.setInfo(sFehler + " (" + nRetCode + ")");
        this.setStatus("Fehler");
    }

    private void successInfo(int nRetCode, int nAnzahlPakete) {
        this.m_Protokoll.create(nRetCode, "Kryptomodul mit Returncode " + nRetCode + " beendet");
        this.setInfo("-");
        if (this.m_Arbeitsmodi.istCryptModus()) {
            this.setStatus("Erfolgreich verschl\u00fcsselt");
            if (nAnzahlPakete > 1) {
                this.setInfo("(dabei " + new Integer(nAnzahlPakete).toString() + " Pakete erzeugt)");
            }
        } else {
            this.setStatus("Erfolgreich entschl\u00fcsselt");
            if (nAnzahlPakete > 1) {
                this.setInfo("(dabei " + new Integer(nAnzahlPakete).toString() + " Pakete vereinigt)");
            }
        }
    }

    @Override
    public void run() {
        int nRetCode = 0;
        this.bStopped = false;
        this.bInterruptRequested = false;
        Steuerung steuerung = new Steuerung(this);
        this.gui.setCursor(Cursor.getPredefinedCursor(3));
        try {
            nRetCode = steuerung.run(this.m_Schalter, this.m_Arbeitsmodi, this.m_Protokoll);
            if (nRetCode != 0) {
                this.failureInfo(nRetCode, null);
            } else {
                this.successInfo(0, steuerung.getAnzahlPakete());
            }
        }
        catch (XKMException e) {
            nRetCode = e.getCode();
            if (nRetCode != 5) {
                this.failureInfo(nRetCode, e.getMessage());
            }
            this.gui.jLabelInfo2.setText("Abbruch durch Benutzer");
            this.setStatus("Abgewiesen");
        }
        if (nRetCode != 0 && this.m_Protokoll.getDestination() != null) {
            int nAnzahlPakete = this.m_Protokoll.getSplitzaehler();
            if (nAnzahlPakete > 1 && this.m_Protokoll.getArbeitsmodus().istCryptModus()) {
                for (int i = 1; i <= nAnzahlPakete; ++i) {
                    Object sSuffix = "000" + i;
                    sSuffix = ((String)sSuffix).substring(((String)sSuffix).length() - 3, ((String)sSuffix).length());
                    String sFilename = this.m_Protokoll.getDestination() + "." + (String)sSuffix;
                    File file = new File(sFilename);
                    if (!file.isFile()) continue;
                    file.delete();
                }
            } else {
                File file = new File(this.m_Protokoll.getDestination());
                if (file.isFile()) {
                    file.delete();
                }
            }
        }
        this.bStopped = true;
        this.gui.guiWaehrendIdle();
        this.gui.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setStatus(String sStatus) {
        this.gui.jLabelStatus2.setText(sStatus);
    }

    public void setInfo(String sInfo) {
        this.gui.jLabelInfo2.setText(sInfo);
    }

    public boolean interruptRequested() {
        return this.bInterruptRequested;
    }

    @Override
    public void interrupt() {
        this.setStatus("Verarbeitung wird angehalten ...");
        this.bInterruptRequested = true;
        while (!this.bStopped) {
            try {
                Thread.sleep(125L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_Protokoll.create(5, "Kryptomodul mit Fehler 5 beendet\n Abbruch durch Benutzer");
        this.gui.jLabelInfo2.setText("Abbruch durch Benutzer");
        this.setStatus("Abgewiesen");
        super.interrupt();
    }
}

