/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.utils;

import de.kbv.common.zip.KbvZipFormat;
import de.kbv.common.zip.KbvZipInputStream;
import de.kbv.common.zip.KbvZipOutputStream;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Tool {
    private static Logger LOG = LogManager.getLogger((String)"xkm");

    public static String baseOfFilename(String sFilename) {
        String sTemp = sFilename;
        int n = sTemp.lastIndexOf(".");
        if (n > 0) {
            sTemp = sTemp.substring(0, n);
        }
        return sTemp;
    }

    public static String right(String str, int n) {
        if (str.length() < n) {
            return str;
        }
        return str.substring(str.length() - n, str.length());
    }

    public static boolean outoftime(int day, int month, int year) {
        GregorianCalendar gcHeute = new GregorianCalendar();
        GregorianCalendar gcEnde = new GregorianCalendar(year, month - 1, day);
        return gcHeute.after(gcEnde);
    }

    public static boolean fileAccessable(String sFilename) {
        File file = new File(sFilename);
        if (file.canWrite()) {
            return true;
        }
        try {
            FileWriter fw = new FileWriter(sFilename);
            fw.close();
            File file2 = new File(sFilename);
            boolean b = file2.delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean FileWrite(String sDatei, String sString) {
        FileWriter f = null;
        try {
            f = new FileWriter(sDatei);
            f.write(sString);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (Exception e) {
                LOG.error("Fehler beim Schliessen eines Datenkanals" + e.getMessage());
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean FileCopy(String sQuelle, String sZiel) {
        if (new File((String)sZiel).isDirectory()) {
            if (!Tool.isDirectory((String)sZiel)) {
                sZiel = (String)sZiel + File.separatorChar;
            }
            sZiel = (String)sZiel + new File(sQuelle).getName();
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int nBytesRead;
            from = new FileInputStream(sQuelle);
            to = new FileOutputStream((String)sZiel);
            int nMaxCopy = 262144;
            byte[] arrBytes = new byte[262144];
            while ((nBytesRead = from.read(arrBytes, 0, 262144)) != -1) {
                to.write(arrBytes, 0, nBytesRead);
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (from != null) {
                    from.close();
                }
                if (to != null) {
                    to.close();
                }
            }
            catch (Exception e) {
                LOG.error("Fehler beim Schliessen eines Datenkanals" + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public static boolean FileMove(String sQuelle, String sZiel) {
        if (!Tool.FileCopy(sQuelle, sZiel)) {
            return false;
        }
        return new File(sQuelle).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean FileAppend(String sZiel, String sAnhaengen) {
        RandomAccessFile to = null;
        FileInputStream from = null;
        try {
            int nBytesRead;
            to = new RandomAccessFile(sZiel, "rw");
            to.seek(to.length());
            from = new FileInputStream(sAnhaengen);
            int nMaxCopy = 262144;
            byte[] arrChars = new byte[262144];
            while ((nBytesRead = from.read(arrChars, 0, 262144)) != -1) {
                to.write(arrChars, 0, nBytesRead);
            }
        }
        catch (IOException e) {
            LOG.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (from != null) {
                    from.close();
                }
                if (to != null) {
                    to.close();
                }
            }
            catch (Exception e) {
                LOG.error("Fehler beim Schliessen eines Datenkanals" + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public static String getToday() {
        SimpleDateFormat f = new SimpleDateFormat("dd.MM.yyyy");
        Date d = new Date();
        return f.format((Object)d);
    }

    public static String getNow() {
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
        Date d = new Date();
        return f.format((Object)d);
    }

    public static boolean isDirectory(String sFileOderDir) {
        return sFileOderDir.endsWith("\\") || sFileOderDir.endsWith("/");
    }

    public static String PadRight(String s, int len, char c) {
        Object s2 = s;
        while (((String)s2).length() < len) {
            s2 = (String)s2 + c;
        }
        return s2;
    }

    public static boolean endsWithIgnoreCase(String s, String suff) {
        if (s == null || suff == null) {
            return false;
        }
        s = s.toLowerCase();
        suff = suff.toLowerCase();
        return s.endsWith(suff);
    }

    public static boolean isParsableToInt(String i) {
        try {
            Integer.parseInt(i);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static int atoi(byte[] valIn, int index) {
        int r;
        Object s = "";
        while (index < valIn.length && valIn[index] >= 48 && valIn[index] <= 57) {
            s = (String)s + (valIn[index] - 48);
            ++index;
        }
        try {
            r = Integer.parseInt((String)s, 10);
        }
        catch (Exception e) {
            r = -1;
        }
        return r;
    }

    public static void centerFrame(JFrame jFrame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = jFrame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        jFrame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void centerDialog(JDialog jDialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = jDialog.getSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.width = screenSize.width;
        }
        jDialog.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    public static void centerDialog(JDialog jDialog, int x, int y) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = jDialog.getSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.width = screenSize.width;
        }
        jDialog.setLocation((screenSize.width - dialogSize.width) / 2 + x, (screenSize.height - dialogSize.height) / 2 + y);
    }

    public static boolean isFloppy(String sName) {
        if (sName == null) {
            return false;
        }
        return sName.startsWith("a:") || sName.startsWith("A:") || sName.startsWith("b:") || sName.startsWith("B:");
    }

    public static boolean createDirectory(String sDirectory) {
        File f = new File(sDirectory);
        return f.isDirectory() || f.mkdir();
    }

    public static boolean initDirectory(String sDirectory) {
        File f = new File(sDirectory);
        if (!f.isDirectory() && !f.mkdir()) {
            return false;
        }
        return Tool.purgeDirectory(sDirectory);
    }

    public static boolean purgeDirectory(String sDirectory) {
        File f = new File(sDirectory);
        File[] aFiles = f.listFiles();
        for (int i = 0; i < aFiles.length; ++i) {
            File f2 = aFiles[i];
            if (f2.delete()) continue;
            return false;
        }
        return true;
    }

    public static int pruefeDateinamen(String sDateiname) {
        StringBuffer sb = new StringBuffer(sDateiname);
        for (int i = 0; i < sDateiname.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isDigit(c) || Character.isLetter(c) || c == '-' || c == '_' || c == ' ') continue;
            return i;
        }
        return -1;
    }

    public static String shortenFilename(String sFilename, int nMax) {
        if (sFilename != null && ((String)sFilename).length() > nMax && (sFilename = new File((String)sFilename).getName()) != null && ((String)sFilename).length() > nMax) {
            sFilename = ((String)sFilename).substring(0, nMax - 4) + "...";
        }
        return sFilename;
    }

    public static boolean deleteFile(String sFilename) {
        File f = new File(sFilename);
        if (f.isFile()) {
            return f.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean simpleProtocol(String sFilename, String sLine) {
        FileWriter fw = null;
        boolean bReturn = true;
        try {
            fw = new FileWriter(sFilename, true);
            fw.write(sLine + "\n");
        }
        catch (IOException e1) {
            e1.printStackTrace();
            bReturn = false;
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bReturn;
    }

    public static String ersetzeUmlaute(String sContent) {
        StringBuffer sb = new StringBuffer();
        int nLen = sContent.length();
        for (int i = 0; i < nLen; ++i) {
            char c = sContent.charAt(i);
            if (c == '\u00e4') {
                sb.append("ae");
                continue;
            }
            if (c == '\u00fc') {
                sb.append("ue");
                continue;
            }
            if (c == '\u00f6') {
                sb.append("oe");
                continue;
            }
            if (c == '\u00c4') {
                sb.append("Ae");
                continue;
            }
            if (c == '\u00d6') {
                sb.append("Oe");
                continue;
            }
            if (c == '\u00dc') {
                sb.append("Ue");
                continue;
            }
            if (c == '\u00df') {
                sb.append("ss");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void message(boolean bConsole, Container container, String s, int messageType) {
        if (bConsole) {
            LOG.info(Tool.ersetzeUmlaute(s));
        }
        if (container != null) {
            JOptionPane.showConfirmDialog(container, s, "Kryptomodul", -1, messageType);
        }
    }

    public static void message(boolean bConsole, Container container, String s) {
        Tool.message(bConsole, container, s, 0);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    }

    public static void setLookAndFeel(Component c) {
        String system = System.getProperty("os.name").toLowerCase();
        try {
            if (system.indexOf("windows") != -1) {
                return;
            }
            if (system.indexOf("linux") != -1 || system.indexOf("unix") != -1) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else if (system.indexOf("mac") != -1) {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            } else {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            SwingUtilities.updateComponentTreeUI(c);
        }
        catch (Exception e) {
            LOG.error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zipFile(String sInputFile, String sZippedFile) {
        KbvZipOutputStream zos = null;
        FileInputStream fis = null;
        try {
            KbvZipOutputStream.setAutoSuffix(false);
            zos = new KbvZipOutputStream(sZippedFile, new File(sZippedFile).getName(), KbvZipFormat.ZIP);
            fis = new FileInputStream(sInputFile);
            byte[] buffer = new byte[10240];
            int nReadBytes = fis.read(buffer);
            while (nReadBytes > 0) {
                zos.write(buffer, 0, nReadBytes);
                nReadBytes = fis.read(buffer);
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipFile(String sZippedFile, String sUnzippedFile) {
        KbvZipInputStream zis = null;
        FileOutputStream fos = null;
        try {
            zis = new KbvZipInputStream(sZippedFile);
            fos = new FileOutputStream(sUnzippedFile);
            byte[] buffer = new byte[10240];
            int nReadBytes = zis.read(buffer);
            while (nReadBytes > 0) {
                fos.write(buffer, 0, nReadBytes);
                nReadBytes = zis.read(buffer);
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }
}

