/*
 * Decompiled with CFR 0.152.
 */
package de.kbv.xkm.zip;

import de.kbv.xkm.zip.KbvZipFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class KbvZipOutputStream
extends OutputStream {
    protected OutputStream outputStream;
    protected KbvZipFormat vdxZipFormat;
    protected ZipOutputStream zos;

    public KbvZipOutputStream(String sZipFilename, String sCompressedFilename, KbvZipFormat vdxZipFormat) throws FileNotFoundException, IOException {
        if (vdxZipFormat == KbvZipFormat.GZIP) {
            this.outputStream = new GZIPOutputStream(new FileOutputStream(sZipFilename));
        } else if (vdxZipFormat == KbvZipFormat.ZIP) {
            File zipFile = new File(sZipFilename);
            this.zos = new ZipOutputStream(new FileOutputStream(zipFile));
            this.zos.putNextEntry(new ZipEntry(sCompressedFilename));
            this.outputStream = this.zos;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.vdxZipFormat == KbvZipFormat.ZIP) {
            this.zos.closeEntry();
        }
        this.outputStream.close();
    }

    @Override
    public void write(int arg0) throws IOException {
        this.outputStream.write(arg0);
    }
}

